/*
 * Decompiled with CFR 0.152.
 */
package me.alegian.thavma.impl.common.block;

import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import me.alegian.thavma.impl.common.aspect.AspectHelper;
import me.alegian.thavma.impl.common.aspect.AspectMap;
import me.alegian.thavma.impl.common.aspect.AspectStack;
import me.alegian.thavma.impl.common.block.entity.CrucibleBE;
import me.alegian.thavma.impl.common.data.capability.AspectContainer;
import me.alegian.thavma.impl.common.data.capability.IAspectContainer;
import me.alegian.thavma.impl.common.recipe.CrucibleRecipe;
import me.alegian.thavma.impl.init.registries.T7BlockStateProperties;
import me.alegian.thavma.impl.init.registries.T7Tags;
import me.alegian.thavma.impl.init.registries.deferred.T7BlockEntities;
import me.alegian.thavma.impl.init.registries.deferred.T7Blocks;
import me.alegian.thavma.impl.init.registries.deferred.T7RecipeTypes;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.fluids.FluidUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u00a4\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u0000 @2\u00020\u00012\u00020\u0002:\u0001@B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J(\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0012\u0010\u000f\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0018\u0010\u0012\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\nH\u0016J\u001c\u0010\u0016\u001a\u00020\u00062\u0012\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\f0\u0018H\u0014J\u0018\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000eH\u0014J\u001a\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J:\u0010\u001d\u001a\n\u0012\u0004\u0012\u0002H\u001f\u0018\u00010\u001e\"\n\b\u0000\u0010\u001f*\u0004\u0018\u00010\u001c2\u0006\u0010\u0013\u001a\u00020\b2\u0006\u0010 \u001a\u00020\f2\f\u0010!\u001a\b\u0012\u0004\u0012\u0002H\u001f0\"H\u0016J\u0018\u0010#\u001a\u00020\u001a2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010$\u001a\u00020%H\u0014J8\u0010&\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020\f2\u0006\u0010\u0007\u001a\u00020\u00142\u0006\u0010\t\u001a\u00020\n2\u0006\u0010*\u001a\u00020\nH\u0014J0\u0010+\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010,\u001a\u00020\f2\u0006\u0010-\u001a\u00020\u001aH\u0014J0\u0010.\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010,\u001a\u00020\f2\u0006\u0010-\u001a\u00020\u001aH\u0014J@\u0010/\u001a\u0002002\u0006\u00101\u001a\u0002022\u0006\u0010 \u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\b2\u0006\u00103\u001a\u00020\n2\u0006\u00104\u001a\u0002052\u0006\u00106\u001a\u0002072\u0006\u00108\u001a\u000209H\u0014J \u0010:\u001a\u00020;2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0007\u001a\u00020<2\u0006\u0010\t\u001a\u00020\nH\u0014J(\u0010=\u001a\u00020;2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0007\u001a\u00020<2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020>H\u0014J(\u0010?\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000eH\u0014\u00a8\u0006A"}, d2={"Lme/alegian/thavma/impl/common/block/CrucibleBlock;", "Lnet/minecraft/world/level/block/Block;", "Lnet/minecraft/world/level/block/EntityBlock;", "<init>", "()V", "stepOn", "", "pLevel", "Lnet/minecraft/world/level/Level;", "pPos", "Lnet/minecraft/core/BlockPos;", "pState", "Lnet/minecraft/world/level/block/state/BlockState;", "pEntity", "Lnet/minecraft/world/entity/Entity;", "getStateForPlacement", "pContext", "Lnet/minecraft/world/item/context/BlockPlaceContext;", "stateWithBoiling", "level", "Lnet/minecraft/world/level/LevelAccessor;", "blockPos", "createBlockStateDefinition", "pBuilder", "Lnet/minecraft/world/level/block/state/StateDefinition$Builder;", "isEntityInsideContent", "", "newBlockEntity", "Lnet/minecraft/world/level/block/entity/BlockEntity;", "getTicker", "Lnet/minecraft/world/level/block/entity/BlockEntityTicker;", "T", "state", "type", "Lnet/minecraft/world/level/block/entity/BlockEntityType;", "isPathfindable", "pPathComputationType", "Lnet/minecraft/world/level/pathfinder/PathComputationType;", "updateShape", "pDirection", "Lnet/minecraft/core/Direction;", "pNeighborState", "pNeighborPos", "onPlace", "pOldState", "pIsMoving", "onRemove", "useItemOn", "Lnet/minecraft/world/ItemInteractionResult;", "stack", "Lnet/minecraft/world/item/ItemStack;", "pos", "player", "Lnet/minecraft/world/entity/player/Player;", "hand", "Lnet/minecraft/world/InteractionHand;", "hitResult", "Lnet/minecraft/world/phys/BlockHitResult;", "getInteractionShape", "Lnet/minecraft/world/phys/shapes/VoxelShape;", "Lnet/minecraft/world/level/BlockGetter;", "getShape", "Lnet/minecraft/world/phys/shapes/CollisionContext;", "entityInside", "Companion", "thavma-neoforge"})
public class CrucibleBlock
extends Block
implements EntityBlock {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private static final VoxelShape CRUCIBLE_INSIDE = Block.box((double)2.0, (double)4.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0);
    private static final VoxelShape CRUCIBLE_SHAPE;
    private static final BooleanProperty BOILING;

    public CrucibleBlock() {
        super(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)Blocks.CAULDRON)));
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)BOILING, (Comparable)Boolean.valueOf(false)));
    }

    public void stepOn(@NotNull Level pLevel, @NotNull BlockPos pPos, @NotNull BlockState pState, @NotNull Entity pEntity) {
        Intrinsics.checkNotNullParameter((Object)pLevel, (String)"pLevel");
        Intrinsics.checkNotNullParameter((Object)pPos, (String)"pPos");
        Intrinsics.checkNotNullParameter((Object)pState, (String)"pState");
        Intrinsics.checkNotNullParameter((Object)pEntity, (String)"pEntity");
        if (((Boolean)pState.getValue((Property)BOILING)).booleanValue() && !pEntity.isSteppingCarefully() && pEntity instanceof LivingEntity) {
            ((LivingEntity)pEntity).hurt(pLevel.damageSources().hotFloor(), 1.0f);
        }
        super.stepOn(pLevel, pPos, pState, pEntity);
    }

    @Nullable
    public BlockState getStateForPlacement(@NotNull BlockPlaceContext pContext) {
        Intrinsics.checkNotNullParameter((Object)pContext, (String)"pContext");
        Level level = pContext.getLevel();
        Intrinsics.checkNotNullExpressionValue((Object)level, (String)"getLevel(...)");
        LevelAccessor levelAccessor = (LevelAccessor)level;
        BlockPos blockPos = pContext.getClickedPos();
        Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"getClickedPos(...)");
        return this.stateWithBoiling(levelAccessor, blockPos);
    }

    @NotNull
    public BlockState stateWithBoiling(@NotNull LevelAccessor level, @NotNull BlockPos blockPos) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)blockPos, (String)"blockPos");
        BlockPos below = blockPos.below();
        BlockState blockState = this.defaultBlockState();
        Property property = (Property)BOILING;
        Intrinsics.checkNotNull((Object)below);
        Object object = blockState.setValue(property, (Comparable)Boolean.valueOf(Companion.isHeatSource(level, below)));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"setValue(...)");
        return (BlockState)object;
    }

    protected void createBlockStateDefinition(@NotNull StateDefinition.Builder<Block, BlockState> pBuilder) {
        Intrinsics.checkNotNullParameter(pBuilder, (String)"pBuilder");
        Property[] propertyArray = new Property[]{BOILING};
        pBuilder.add(propertyArray);
    }

    protected boolean isEntityInsideContent(@NotNull BlockPos pPos, @NotNull Entity pEntity) {
        Intrinsics.checkNotNullParameter((Object)pPos, (String)"pPos");
        Intrinsics.checkNotNullParameter((Object)pEntity, (String)"pEntity");
        return pEntity.getY() < (double)pPos.getY() + (double)0.9375f && pEntity.getBoundingBox().maxY > (double)pPos.getY() + 0.25;
    }

    @Nullable
    public BlockEntity newBlockEntity(@NotNull BlockPos pPos, @NotNull BlockState pState) {
        Intrinsics.checkNotNullParameter((Object)pPos, (String)"pPos");
        Intrinsics.checkNotNullParameter((Object)pState, (String)"pState");
        return new CrucibleBE(pPos, pState);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(@NotNull Level level, @NotNull BlockState state, @NotNull BlockEntityType<T> type) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter(type, (String)"type");
        return type == T7BlockEntities.INSTANCE.getCRUCIBLE().get() ? CrucibleBE.Companion::tick : null;
    }

    protected boolean isPathfindable(@NotNull BlockState pState, @NotNull PathComputationType pPathComputationType) {
        Intrinsics.checkNotNullParameter((Object)pState, (String)"pState");
        Intrinsics.checkNotNullParameter((Object)pPathComputationType, (String)"pPathComputationType");
        return false;
    }

    @NotNull
    protected BlockState updateShape(@NotNull BlockState pState, @NotNull Direction pDirection, @NotNull BlockState pNeighborState, @NotNull LevelAccessor pLevel, @NotNull BlockPos pPos, @NotNull BlockPos pNeighborPos) {
        Intrinsics.checkNotNullParameter((Object)pState, (String)"pState");
        Intrinsics.checkNotNullParameter((Object)pDirection, (String)"pDirection");
        Intrinsics.checkNotNullParameter((Object)pNeighborState, (String)"pNeighborState");
        Intrinsics.checkNotNullParameter((Object)pLevel, (String)"pLevel");
        Intrinsics.checkNotNullParameter((Object)pPos, (String)"pPos");
        Intrinsics.checkNotNullParameter((Object)pNeighborPos, (String)"pNeighborPos");
        return this.stateWithBoiling(pLevel, pPos);
    }

    protected void onPlace(@NotNull BlockState pState, @NotNull Level pLevel, @NotNull BlockPos pPos, @NotNull BlockState pOldState, boolean pIsMoving) {
        Intrinsics.checkNotNullParameter((Object)pState, (String)"pState");
        Intrinsics.checkNotNullParameter((Object)pLevel, (String)"pLevel");
        Intrinsics.checkNotNullParameter((Object)pPos, (String)"pPos");
        Intrinsics.checkNotNullParameter((Object)pOldState, (String)"pOldState");
        super.onPlace(pState, pLevel, pPos, pOldState, pIsMoving);
        if (!pOldState.is((Block)this)) {
            pLevel.invalidateCapabilities(pPos);
        }
    }

    protected void onRemove(@NotNull BlockState pState, @NotNull Level pLevel, @NotNull BlockPos pPos, @NotNull BlockState pOldState, boolean pIsMoving) {
        Intrinsics.checkNotNullParameter((Object)pState, (String)"pState");
        Intrinsics.checkNotNullParameter((Object)pLevel, (String)"pLevel");
        Intrinsics.checkNotNullParameter((Object)pPos, (String)"pPos");
        Intrinsics.checkNotNullParameter((Object)pOldState, (String)"pOldState");
        super.onRemove(pState, pLevel, pPos, pOldState, pIsMoving);
        if (!pState.is(pOldState.getBlock())) {
            pLevel.invalidateCapabilities(pPos);
        }
    }

    @NotNull
    protected ItemInteractionResult useItemOn(@NotNull ItemStack stack, @NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull Player player, @NotNull InteractionHand hand, @NotNull BlockHitResult hitResult) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)hand, (String)"hand");
        Intrinsics.checkNotNullParameter((Object)hitResult, (String)"hitResult");
        if (player.getItemInHand(hand).is(Items.WATER_BUCKET) && Companion.fillUp(level, pos)) {
            if (!player.isCreative()) {
                player.setItemInHand(hand, new ItemStack((ItemLike)Items.BUCKET));
            }
            level.playSound(null, pos, SoundEvents.BUCKET_EMPTY, SoundSource.BLOCKS, 1.0f, 1.0f);
            return ItemInteractionResult.SUCCESS;
        }
        if (FluidUtil.interactWithFluidHandler((Player)player, (InteractionHand)hand, (Level)level, (BlockPos)pos, (Direction)hitResult.getDirection())) {
            return ItemInteractionResult.SUCCESS;
        }
        if (Intrinsics.areEqual((Object)stack.getItem(), (Object)T7Blocks.INSTANCE.getSEALING_JAR().asItem())) {
            AspectStack result;
            AspectContainer.Pair pair = AspectContainer.Companion.blockSourceItemSink(level, pos, stack);
            AspectStack aspectStack = result = pair != null ? pair.transferAnyAspect() : null;
            if (result != null) {
                player.playSound(SoundEvents.BUCKET_FILL);
                return ItemInteractionResult.SUCCESS;
            }
        }
        ItemInteractionResult itemInteractionResult = super.useItemOn(stack, state, level, pos, player, hand, hitResult);
        Intrinsics.checkNotNullExpressionValue((Object)itemInteractionResult, (String)"useItemOn(...)");
        return itemInteractionResult;
    }

    @NotNull
    protected VoxelShape getInteractionShape(@NotNull BlockState pState, @NotNull BlockGetter pLevel, @NotNull BlockPos pPos) {
        Intrinsics.checkNotNullParameter((Object)pState, (String)"pState");
        Intrinsics.checkNotNullParameter((Object)pLevel, (String)"pLevel");
        Intrinsics.checkNotNullParameter((Object)pPos, (String)"pPos");
        VoxelShape voxelShape = CRUCIBLE_INSIDE;
        Intrinsics.checkNotNullExpressionValue((Object)voxelShape, (String)"CRUCIBLE_INSIDE");
        return voxelShape;
    }

    @NotNull
    protected VoxelShape getShape(@NotNull BlockState pState, @NotNull BlockGetter pLevel, @NotNull BlockPos pPos, @NotNull CollisionContext pContext) {
        Intrinsics.checkNotNullParameter((Object)pState, (String)"pState");
        Intrinsics.checkNotNullParameter((Object)pLevel, (String)"pLevel");
        Intrinsics.checkNotNullParameter((Object)pPos, (String)"pPos");
        Intrinsics.checkNotNullParameter((Object)pContext, (String)"pContext");
        VoxelShape voxelShape = CRUCIBLE_SHAPE;
        Intrinsics.checkNotNullExpressionValue((Object)voxelShape, (String)"CRUCIBLE_SHAPE");
        return voxelShape;
    }

    protected void entityInside(@NotNull BlockState pState, @NotNull Level level, @NotNull BlockPos pPos, @NotNull Entity pEntity) {
        Intrinsics.checkNotNullParameter((Object)pState, (String)"pState");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pPos, (String)"pPos");
        Intrinsics.checkNotNullParameter((Object)pEntity, (String)"pEntity");
        if (!level.isClientSide && level instanceof ServerLevel && ((Boolean)pState.getValue((Property)BOILING)).booleanValue() && pEntity instanceof ItemEntity && this.isEntityInsideContent(pPos, pEntity) && pEntity.mayInteract(level, pPos)) {
            Companion.meltItem((ServerLevel)level, pPos, (ItemEntity)pEntity);
            ((ServerLevel)level).sendBlockUpdated(pPos, pState, pState, 2);
        }
    }

    static {
        VoxelShape[] voxelShapeArray = new VoxelShape[]{Block.box((double)4.0, (double)0.0, (double)0.0, (double)12.0, (double)3.0, (double)16.0), Block.box((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)3.0, (double)14.0), CRUCIBLE_INSIDE};
        CRUCIBLE_SHAPE = Shapes.join((VoxelShape)Shapes.block(), (VoxelShape)Shapes.or((VoxelShape)Block.box((double)0.0, (double)0.0, (double)4.0, (double)16.0, (double)3.0, (double)12.0), (VoxelShape[])voxelShapeArray), (BooleanOp)BooleanOp.ONLY_FIRST);
        BOILING = T7BlockStateProperties.INSTANCE.getBOILING();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0004J\u0018\u0010\u0017\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0004J\u0018\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0013\u001a\u00020\u0014H\u0004J\u0018\u0010\u001c\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0013\u001a\u00020\u0014H\u0004J\u0018\u0010\u001d\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0013\u001a\u00020\u0014H\u0004J\f\u0010\u001e\u001a\u00020\u0010*\u00020\u0016H\u0004J\u0018\u0010\u001f\u001a\u00020\u00192\u0006\u0010\u0011\u001a\u00020 2\u0006\u0010!\u001a\u00020\u0014H\u0004R\u0019\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0019\u0010\t\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\bR\u0019\u0010\u000b\u001a\n \u0006*\u0004\u0018\u00010\f0\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\""}, d2={"Lme/alegian/thavma/impl/common/block/CrucibleBlock$Companion;", "", "<init>", "()V", "CRUCIBLE_INSIDE", "Lnet/minecraft/world/phys/shapes/VoxelShape;", "kotlin.jvm.PlatformType", "getCRUCIBLE_INSIDE", "()Lnet/minecraft/world/phys/shapes/VoxelShape;", "CRUCIBLE_SHAPE", "getCRUCIBLE_SHAPE", "BOILING", "Lnet/minecraft/world/level/block/state/properties/BooleanProperty;", "getBOILING", "()Lnet/minecraft/world/level/block/state/properties/BooleanProperty;", "meltItem", "", "level", "Lnet/minecraft/server/level/ServerLevel;", "pPos", "Lnet/minecraft/core/BlockPos;", "itemEntity", "Lnet/minecraft/world/entity/item/ItemEntity;", "waterSplash", "tryLowerFillLevel", "", "pLevel", "Lnet/minecraft/world/level/Level;", "hasWater", "fillUp", "shrink", "isHeatSource", "Lnet/minecraft/world/level/LevelAccessor;", "pos", "thavma-neoforge"})
    public static final class Companion {
        private Companion() {
        }

        public final VoxelShape getCRUCIBLE_INSIDE() {
            return CRUCIBLE_INSIDE;
        }

        public final VoxelShape getCRUCIBLE_SHAPE() {
            return CRUCIBLE_SHAPE;
        }

        public final BooleanProperty getBOILING() {
            return BOILING;
        }

        protected final void meltItem(@NotNull ServerLevel level, @NotNull BlockPos pPos, @NotNull ItemEntity itemEntity) {
            AspectMap itemAspects;
            Intrinsics.checkNotNullParameter((Object)level, (String)"level");
            Intrinsics.checkNotNullParameter((Object)pPos, (String)"pPos");
            Intrinsics.checkNotNullParameter((Object)itemEntity, (String)"itemEntity");
            ItemStack thrownStack = itemEntity.getItem();
            if (thrownStack.is(T7Tags.Items.INSTANCE.getCATALYSTS())) {
                boolean success;
                boolean bl;
                CrucibleRecipe recipe;
                Object object = AspectContainer.Companion.at((Level)level, pPos);
                if (object == null || (object = object.getAspects()) == null) {
                    return;
                }
                Object crucibleAspects = object;
                SingleRecipeInput input = new SingleRecipeInput(thrownStack);
                RecipeHolder recipeHolder = level.getRecipeManager().getRecipeFor((RecipeType)T7RecipeTypes.INSTANCE.getCRUCIBLE().get(), (RecipeInput)input, (Level)level).orElse(null);
                CrucibleRecipe it = recipe = recipeHolder != null ? (CrucibleRecipe)recipeHolder.value() : null;
                boolean bl2 = false;
                if (it == null) {
                    bl = false;
                } else if (!Companion.tryLowerFillLevel((Level)level, pPos)) {
                    bl = false;
                } else if (!((AspectMap)crucibleAspects).contains(it.getAspects())) {
                    bl = false;
                } else {
                    Companion.waterSplash(level, pPos);
                    IAspectContainer iAspectContainer = AspectContainer.Companion.at((Level)level, pPos);
                    if (iAspectContainer != null) {
                        iAspectContainer.extract(it.getAspects());
                    }
                    Entity player = itemEntity.getOwner();
                    if (player instanceof ServerPlayer) {
                        ItemEntity itemEntity2 = ((ServerPlayer)player).drop(it.getResult(), true, true);
                        if (itemEntity2 != null) {
                            ItemEntity $this$meltItem_u24lambda_u241_u24lambda_u240 = itemEntity2;
                            boolean bl3 = false;
                            $this$meltItem_u24lambda_u241_u24lambda_u240.setNoPickUpDelay();
                            $this$meltItem_u24lambda_u241_u24lambda_u240.setTarget(((ServerPlayer)player).getUUID());
                            Companion.shrink(itemEntity);
                        }
                    }
                    bl = true;
                }
                if (success = bl) {
                    return;
                }
            }
            if ((itemAspects = AspectHelper.INSTANCE.getAspects((Entity)itemEntity)) == null || !this.hasWater((Level)level, pPos)) {
                return;
            }
            IAspectContainer iAspectContainer = AspectContainer.Companion.at((Level)level, pPos);
            if (iAspectContainer != null) {
                iAspectContainer.insert(itemAspects);
            }
            this.waterSplash(level, pPos);
            itemEntity.discard();
        }

        protected final void waterSplash(@NotNull ServerLevel level, @NotNull BlockPos pPos) {
            Intrinsics.checkNotNullParameter((Object)level, (String)"level");
            Intrinsics.checkNotNullParameter((Object)pPos, (String)"pPos");
            level.playSound(null, pPos, SoundEvents.GENERIC_SPLASH, SoundSource.BLOCKS, 1.0f, 1.0f);
        }

        protected final boolean tryLowerFillLevel(@NotNull Level pLevel, @NotNull BlockPos pPos) {
            Intrinsics.checkNotNullParameter((Object)pLevel, (String)"pLevel");
            Intrinsics.checkNotNullParameter((Object)pPos, (String)"pPos");
            Boolean bl = pLevel.getBlockEntity(pPos, (BlockEntityType)T7BlockEntities.INSTANCE.getCRUCIBLE().get()).map(arg_0 -> Companion.tryLowerFillLevel$lambda$3(Companion::tryLowerFillLevel$lambda$2, arg_0)).orElse(false);
            Intrinsics.checkNotNullExpressionValue((Object)bl, (String)"orElse(...)");
            return bl;
        }

        protected final boolean hasWater(@NotNull Level pLevel, @NotNull BlockPos pPos) {
            Intrinsics.checkNotNullParameter((Object)pLevel, (String)"pLevel");
            Intrinsics.checkNotNullParameter((Object)pPos, (String)"pPos");
            Boolean bl = pLevel.getBlockEntity(pPos, (BlockEntityType)T7BlockEntities.INSTANCE.getCRUCIBLE().get()).map(arg_0 -> Companion.hasWater$lambda$5(Companion::hasWater$lambda$4, arg_0)).orElse(false);
            Intrinsics.checkNotNullExpressionValue((Object)bl, (String)"orElse(...)");
            return bl;
        }

        protected final boolean fillUp(@NotNull Level pLevel, @NotNull BlockPos pPos) {
            Intrinsics.checkNotNullParameter((Object)pLevel, (String)"pLevel");
            Intrinsics.checkNotNullParameter((Object)pPos, (String)"pPos");
            BlockEntity be = pLevel.getBlockEntity(pPos);
            if (be instanceof CrucibleBE) {
                return ((CrucibleBE)be).getFluidHandler().fillUp();
            }
            return false;
        }

        protected final void shrink(@NotNull ItemEntity $this$shrink) {
            Intrinsics.checkNotNullParameter((Object)$this$shrink, (String)"<this>");
            $this$shrink.getItem().shrink(1);
            if ($this$shrink.getItem().isEmpty()) {
                $this$shrink.discard();
            } else {
                $this$shrink.setItem($this$shrink.getItem().copy());
            }
        }

        protected final boolean isHeatSource(@NotNull LevelAccessor level, @NotNull BlockPos pos) {
            Intrinsics.checkNotNullParameter((Object)level, (String)"level");
            Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
            BlockState bs = level.getBlockState(pos);
            boolean bsHeat = bs.is(T7Tags.Blocks.INSTANCE.getCRUCIBLE_HEAT_SOURCES());
            FluidState fs = level.getFluidState(pos);
            boolean fsHeat = fs.is(T7Tags.Fluids.INSTANCE.getCRUCIBLE_HEAT_SOURCES());
            return bsHeat || fsHeat;
        }

        private static final Boolean tryLowerFillLevel$lambda$2(CrucibleBE be) {
            return be.getFluidHandler().catalystDrain();
        }

        private static final Boolean tryLowerFillLevel$lambda$3(Function1 $tmp0, Object p0) {
            return (Boolean)$tmp0.invoke(p0);
        }

        private static final Boolean hasWater$lambda$4(CrucibleBE be) {
            return be.getFluidHandler().getFluidAmount() > 0;
        }

        private static final Boolean hasWater$lambda$5(Function1 $tmp0, Object p0) {
            return (Boolean)$tmp0.invoke(p0);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

