/*
 * Decompiled with CFR 0.152.
 */
package me.alegian.thavma.impl.common.item;

import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import me.alegian.thavma.impl.common.item.WandItem;
import me.alegian.thavma.impl.common.level.Exchanging;
import me.alegian.thavma.impl.init.registries.deferred.T7DataComponents;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"Lme/alegian/thavma/impl/common/item/ExchangeFocus;", "Lnet/minecraft/world/item/Item;", "<init>", "()V", "useOn", "Lnet/minecraft/world/InteractionResult;", "context", "Lnet/minecraft/world/item/context/UseOnContext;", "thavma-neoforge"})
public final class ExchangeFocus
extends Item {
    public ExchangeFocus() {
        super(new Item.Properties().stacksTo(1));
    }

    @NotNull
    public InteractionResult useOn(@NotNull UseOnContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Player player = context.getPlayer();
        if (player == null) {
            return InteractionResult.PASS;
        }
        Player player2 = player;
        if (!(context.getItemInHand().getItem() instanceof WandItem)) {
            return InteractionResult.PASS;
        }
        Level level = context.getLevel();
        BlockPos pos = context.getClickedPos();
        Block oldBlock = level.getBlockState(pos).getBlock();
        if (level.getBlockEntity(pos) != null) {
            return InteractionResult.FAIL;
        }
        if (player2.isShiftKeyDown()) {
            if (level.isClientSide) {
                player2.playSound(SoundEvents.EXPERIENCE_ORB_PICKUP);
            }
            context.getItemInHand().set((Supplier)T7DataComponents.INSTANCE.getEXCHANGE_BLOCK(), (Object)oldBlock);
            return InteractionResult.SUCCESS;
        }
        Block block = (Block)player2.getMainHandItem().get((Supplier)T7DataComponents.INSTANCE.getEXCHANGE_BLOCK());
        if (block == null) {
            return InteractionResult.FAIL;
        }
        Block newBlock = block;
        if (Intrinsics.areEqual((Object)oldBlock, (Object)newBlock)) {
            return InteractionResult.FAIL;
        }
        if (player2 instanceof ServerPlayer) {
            Level level2 = context.getLevel();
            Intrinsics.checkNotNullExpressionValue((Object)level2, (String)"getLevel(...)");
            ServerPlayer serverPlayer = (ServerPlayer)player2;
            Intrinsics.checkNotNull((Object)pos);
            Intrinsics.checkNotNull((Object)oldBlock);
            Exchanging.Companion.exchange(level2, serverPlayer, pos, oldBlock, newBlock);
        }
        return InteractionResult.SUCCESS;
    }
}

