/*
 * Decompiled with CFR 0.152.
 */
package me.alegian.thavma.impl.common.level;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Queue;
import java.util.Set;
import kotlin.Metadata;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.event.tick.LevelTickEvent;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import net.neoforged.neoforge.items.wrapper.PlayerMainInvWrapper;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\r\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u00a2\u0006\u0004\b\f\u0010\rR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\b\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0013R\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006\u0018"}, d2={"Lme/alegian/thavma/impl/common/level/Exchanging;", "", "player", "Lnet/minecraft/server/level/ServerPlayer;", "stack", "Lnet/minecraft/world/item/ItemStack;", "oldBlock", "Lnet/minecraft/world/level/block/Block;", "newBlock", "positions", "Ljava/util/Queue;", "Lnet/minecraft/core/BlockPos;", "<init>", "(Lnet/minecraft/server/level/ServerPlayer;Lnet/minecraft/world/item/ItemStack;Lnet/minecraft/world/level/block/Block;Lnet/minecraft/world/level/block/Block;Ljava/util/Queue;)V", "getPlayer", "()Lnet/minecraft/server/level/ServerPlayer;", "getStack", "()Lnet/minecraft/world/item/ItemStack;", "getOldBlock", "()Lnet/minecraft/world/level/block/Block;", "getNewBlock", "getPositions", "()Ljava/util/Queue;", "Companion", "thavma-neoforge"})
public final class Exchanging {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ServerPlayer player;
    @NotNull
    private final ItemStack stack;
    @NotNull
    private final Block oldBlock;
    @NotNull
    private final Block newBlock;
    @NotNull
    private final Queue<BlockPos> positions;
    @NotNull
    private static final List<Exchanging> instances = new ArrayList();

    public Exchanging(@NotNull ServerPlayer player, @NotNull ItemStack stack, @NotNull Block oldBlock, @NotNull Block newBlock, @NotNull Queue<BlockPos> positions) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter((Object)oldBlock, (String)"oldBlock");
        Intrinsics.checkNotNullParameter((Object)newBlock, (String)"newBlock");
        Intrinsics.checkNotNullParameter(positions, (String)"positions");
        this.player = player;
        this.stack = stack;
        this.oldBlock = oldBlock;
        this.newBlock = newBlock;
        this.positions = positions;
    }

    @NotNull
    public final ServerPlayer getPlayer() {
        return this.player;
    }

    @NotNull
    public final ItemStack getStack() {
        return this.stack;
    }

    @NotNull
    public final Block getOldBlock() {
        return this.oldBlock;
    }

    @NotNull
    public final Block getNewBlock() {
        return this.newBlock;
    }

    @NotNull
    public final Queue<BlockPos> getPositions() {
        return this.positions;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J.\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0010J$\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00132\u0006\u0010\t\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u000e2\u0006\u0010\u0016\u001a\u00020\u0010J\u000e\u0010\u0017\u001a\u00020\b2\u0006\u0010\u0018\u001a\u00020\u0019J\u0018\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\t\u001a\u00020\u00142\u0006\u0010\r\u001a\u00020\u000eH\u0002R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lme/alegian/thavma/impl/common/level/Exchanging$Companion;", "", "<init>", "()V", "instances", "", "Lme/alegian/thavma/impl/common/level/Exchanging;", "exchange", "", "level", "Lnet/minecraft/world/level/Level;", "player", "Lnet/minecraft/server/level/ServerPlayer;", "pos", "Lnet/minecraft/core/BlockPos;", "oldBlock", "Lnet/minecraft/world/level/block/Block;", "newBlock", "exchangingPositions", "Ljava/util/Queue;", "Lnet/minecraft/world/level/LevelAccessor;", "origin", "block", "levelTick", "event", "Lnet/neoforged/neoforge/event/tick/LevelTickEvent$Pre;", "anyAirAround", "", "thavma-neoforge"})
    @SourceDebugExtension(value={"SMAP\nExchanging.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Exchanging.kt\nme/alegian/thavma/impl/common/level/Exchanging$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,113:1\n1869#2,2:114\n1761#2,3:116\n*S KotlinDebug\n*F\n+ 1 Exchanging.kt\nme/alegian/thavma/impl/common/level/Exchanging$Companion\n*L\n95#1:114,2\n111#1:116,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        public final void exchange(@NotNull Level level, @NotNull ServerPlayer player, @NotNull BlockPos pos, @NotNull Block oldBlock, @NotNull Block newBlock) {
            Intrinsics.checkNotNullParameter((Object)level, (String)"level");
            Intrinsics.checkNotNullParameter((Object)player, (String)"player");
            Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
            Intrinsics.checkNotNullParameter((Object)oldBlock, (String)"oldBlock");
            Intrinsics.checkNotNullParameter((Object)newBlock, (String)"newBlock");
            List list = instances;
            ItemStack itemStack = player.getMainHandItem();
            Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"getMainHandItem(...)");
            list.add(new Exchanging(player, itemStack, oldBlock, newBlock, this.exchangingPositions((LevelAccessor)level, pos, oldBlock)));
        }

        @NotNull
        public final Queue<BlockPos> exchangingPositions(@NotNull LevelAccessor level, @NotNull BlockPos origin, @NotNull Block block) {
            Intrinsics.checkNotNullParameter((Object)level, (String)"level");
            Intrinsics.checkNotNullParameter((Object)origin, (String)"origin");
            Intrinsics.checkNotNullParameter((Object)block, (String)"block");
            List checking = new ArrayList();
            checking.add(origin);
            BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();
            Set visited = new LinkedHashSet();
            while (!checking.isEmpty() && visited.size() < 32) {
                Object e = checking.removeFirst();
                Intrinsics.checkNotNullExpressionValue(e, (String)"removeFirst(...)");
                BlockPos currPos = (BlockPos)e;
                visited.add(currPos);
                for (int i = -1; i < 2; ++i) {
                    for (int j = -1; j < 2; ++j) {
                        for (int k = -1; k < 2; ++k) {
                            if (i == 0 && j == 0 && k == 0) continue;
                            mutablePos.set(currPos.getX() + i, currPos.getY() + j, currPos.getZ() + k);
                            if (visited.contains(mutablePos) || !Intrinsics.areEqual((Object)block, (Object)level.getBlockState((BlockPos)mutablePos).getBlock()) || checking.contains(mutablePos) || !this.anyAirAround(level, (BlockPos)mutablePos)) continue;
                            BlockPos blockPos = mutablePos.immutable();
                            Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"immutable(...)");
                            checking.add(blockPos);
                        }
                    }
                }
            }
            return new ArrayDeque(visited);
        }

        public final void levelTick(@NotNull LevelTickEvent.Pre event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            Level level = event.getLevel();
            if (!(level instanceof ServerLevel)) {
                return;
            }
            if (event.getLevel().getGameTime() % (long)3 != 0L) {
                return;
            }
            Iterator instanceIterator = instances.iterator();
            while (instanceIterator.hasNext()) {
                Exchanging instance = (Exchanging)instanceIterator.next();
                if (!Intrinsics.areEqual((Object)instance.getPlayer().level(), (Object)level)) continue;
                if (instance.getPlayer().isRemoved() || instance.getPositions().isEmpty() || !Intrinsics.areEqual((Object)instance.getStack(), (Object)instance.getPlayer().getMainHandItem())) {
                    instanceIterator.remove();
                    continue;
                }
                BlockPos pos = instance.getPositions().remove();
                BlockState oldState = ((ServerLevel)level).getBlockState(pos);
                if (!Intrinsics.areEqual((Object)oldState.getBlock(), (Object)instance.getOldBlock()) || ((ServerLevel)level).getBlockEntity(pos) != null) continue;
                BlockState newState = instance.getNewBlock().defaultBlockState();
                PlayerMainInvWrapper inventory = new PlayerMainInvWrapper(instance.getPlayer().getInventory());
                boolean consumedItem = false;
                int n = inventory.getSlots();
                for (int i = 0; i < n; ++i) {
                    ItemStack extracted;
                    if (!Intrinsics.areEqual((Object)inventory.getStackInSlot(i).getItem(), (Object)instance.getNewBlock().asItem()) || (extracted = inventory.extractItem(i, 1, false)).isEmpty()) continue;
                    consumedItem = true;
                    break;
                }
                if (!consumedItem) {
                    instanceIterator.remove();
                    continue;
                }
                event.getLevel().setBlockAndUpdate(pos, newState);
                List list = Block.getDrops((BlockState)oldState, (ServerLevel)((ServerLevel)level), (BlockPos)pos, null);
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getDrops(...)");
                Iterable $this$forEach$iv = list;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    ItemStack it = (ItemStack)element$iv;
                    boolean bl = false;
                    ItemHandlerHelper.giveItemToPlayer((Player)((Player)instance.getPlayer()), (ItemStack)it);
                }
                SoundType soundType = newState.getSoundType((LevelReader)event.getLevel(), pos, (Entity)instance.getPlayer());
                event.getLevel().playSound(null, pos, soundType.getPlaceSound(), SoundSource.BLOCKS, (soundType.getVolume() + 1.0f) / 2.0f, soundType.getPitch() * 0.8f);
            }
        }

        private final boolean anyAirAround(LevelAccessor level, BlockPos pos) {
            boolean bl;
            block3: {
                Iterable $this$any$iv = (Iterable)EntriesMappings.entries$0;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        Direction it = (Direction)element$iv;
                        boolean bl2 = false;
                        if (!level.getBlockState(pos.relative(it)).isAir()) continue;
                        bl = true;
                        break block3;
                    }
                    bl = false;
                }
            }
            return bl;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 2, 0}, k=3, xi=48)
        public static final class EntriesMappings {
            public static final /* synthetic */ EnumEntries<Direction> entries$0;

            static {
                entries$0 = EnumEntriesKt.enumEntries((Enum[])((Enum[])Direction.values()));
            }
        }
    }
}

