/*
 * Decompiled with CFR 0.152.
 */
package me.alegian.thavma.impl.common.level;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Queue;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import me.alegian.thavma.impl.init.registries.T7Tags;
import net.minecraft.core.BlockPos;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundLevelEventPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.event.level.BlockEvent;
import net.neoforged.neoforge.event.tick.LevelTickEvent;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\f\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\u0004\b\u000b\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006\u0016"}, d2={"Lme/alegian/thavma/impl/common/level/TreeFelling;", "", "player", "Lnet/minecraft/server/level/ServerPlayer;", "stack", "Lnet/minecraft/world/item/ItemStack;", "blockState", "Lnet/minecraft/world/level/block/state/BlockState;", "positions", "Ljava/util/Queue;", "Lnet/minecraft/core/BlockPos;", "<init>", "(Lnet/minecraft/server/level/ServerPlayer;Lnet/minecraft/world/item/ItemStack;Lnet/minecraft/world/level/block/state/BlockState;Ljava/util/Queue;)V", "getPlayer", "()Lnet/minecraft/server/level/ServerPlayer;", "getStack", "()Lnet/minecraft/world/item/ItemStack;", "getBlockState", "()Lnet/minecraft/world/level/block/state/BlockState;", "getPositions", "()Ljava/util/Queue;", "Companion", "thavma-neoforge"})
public final class TreeFelling {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ServerPlayer player;
    @NotNull
    private final ItemStack stack;
    @NotNull
    private final BlockState blockState;
    @NotNull
    private final Queue<BlockPos> positions;
    @NotNull
    private static final List<TreeFelling> instances = new ArrayList();
    private static boolean disableEvents;

    public TreeFelling(@NotNull ServerPlayer player, @NotNull ItemStack stack, @NotNull BlockState blockState, @NotNull Queue<BlockPos> positions) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter((Object)blockState, (String)"blockState");
        Intrinsics.checkNotNullParameter(positions, (String)"positions");
        this.player = player;
        this.stack = stack;
        this.blockState = blockState;
        this.positions = positions;
    }

    @NotNull
    public final ServerPlayer getPlayer() {
        return this.player;
    }

    @NotNull
    public final ItemStack getStack() {
        return this.stack;
    }

    @NotNull
    public final BlockState getBlockState() {
        return this.blockState;
    }

    @NotNull
    public final Queue<BlockPos> getPositions() {
        return this.positions;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012J$\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u00142\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00152\u0006\u0010\u0019\u001a\u00020\u001aJ\u000e\u0010\u001b\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u001cR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000e\u00a8\u0006\u001d"}, d2={"Lme/alegian/thavma/impl/common/level/TreeFelling$Companion;", "", "<init>", "()V", "instances", "", "Lme/alegian/thavma/impl/common/level/TreeFelling;", "getInstances", "()Ljava/util/List;", "disableEvents", "", "getDisableEvents", "()Z", "setDisableEvents", "(Z)V", "blockBreak", "", "event", "Lnet/neoforged/neoforge/event/level/BlockEvent$BreakEvent;", "fellingPositions", "Ljava/util/Queue;", "Lnet/minecraft/core/BlockPos;", "level", "Lnet/minecraft/world/level/LevelAccessor;", "origin", "state", "Lnet/minecraft/world/level/block/state/BlockState;", "levelTick", "Lnet/neoforged/neoforge/event/tick/LevelTickEvent$Pre;", "thavma-neoforge"})
    @SourceDebugExtension(value={"SMAP\nTreeFelling.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TreeFelling.kt\nme/alegian/thavma/impl/common/level/TreeFelling$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,90:1\n1056#2:91\n*S KotlinDebug\n*F\n+ 1 TreeFelling.kt\nme/alegian/thavma/impl/common/level/TreeFelling$Companion\n*L\n61#1:91\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final List<TreeFelling> getInstances() {
            return instances;
        }

        public final boolean getDisableEvents() {
            return disableEvents;
        }

        public final void setDisableEvents(boolean bl) {
            disableEvents = bl;
        }

        public final void blockBreak(@NotNull BlockEvent.BreakEvent event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            if (this.getDisableEvents()) {
                return;
            }
            Player player = event.getPlayer();
            if (!(player instanceof ServerPlayer)) {
                return;
            }
            if (((ServerPlayer)player).isShiftKeyDown()) {
                return;
            }
            if (!((ServerPlayer)player).getMainHandItem().is(T7Tags.Items.INSTANCE.getTREE_FELLING())) {
                return;
            }
            if (!event.getState().is(BlockTags.LOGS)) {
                return;
            }
            boolean canHarvest = event.getState().canHarvestBlock((BlockGetter)event.getLevel(), event.getPos(), player);
            if (!canHarvest) {
                return;
            }
            List<TreeFelling> list = this.getInstances();
            ServerPlayer serverPlayer = (ServerPlayer)player;
            ItemStack itemStack = ((ServerPlayer)player).getMainHandItem();
            Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"getMainHandItem(...)");
            BlockState blockState = event.getState();
            Intrinsics.checkNotNullExpressionValue((Object)blockState, (String)"getState(...)");
            LevelAccessor levelAccessor = event.getLevel();
            Intrinsics.checkNotNullExpressionValue((Object)levelAccessor, (String)"getLevel(...)");
            BlockPos blockPos = event.getPos();
            Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"getPos(...)");
            BlockState blockState2 = event.getState();
            Intrinsics.checkNotNullExpressionValue((Object)blockState2, (String)"getState(...)");
            list.add(new TreeFelling(serverPlayer, itemStack, blockState, this.fellingPositions(levelAccessor, blockPos, blockState2)));
        }

        @NotNull
        public final Queue<BlockPos> fellingPositions(@NotNull LevelAccessor level, @NotNull BlockPos origin, @NotNull BlockState state) {
            Intrinsics.checkNotNullParameter((Object)level, (String)"level");
            Intrinsics.checkNotNullParameter((Object)origin, (String)"origin");
            Intrinsics.checkNotNullParameter((Object)state, (String)"state");
            List checking = new ArrayList();
            checking.add(origin);
            BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();
            Set visited = new LinkedHashSet();
            while (!checking.isEmpty() && visited.size() < 512) {
                Object e = checking.removeFirst();
                Intrinsics.checkNotNullExpressionValue(e, (String)"removeFirst(...)");
                BlockPos currPos = (BlockPos)e;
                visited.add(currPos);
                for (int i = -1; i < 2; ++i) {
                    for (int j = -1; j < 2; ++j) {
                        for (int k = -1; k < 2; ++k) {
                            if (i == 0 && j == 0 && k == 0) continue;
                            mutablePos.set(currPos.getX() + i, currPos.getY() + j, currPos.getZ() + k);
                            if (visited.contains(mutablePos) || !Intrinsics.areEqual((Object)state.getBlock(), (Object)level.getBlockState((BlockPos)mutablePos).getBlock()) || checking.contains(mutablePos)) continue;
                            BlockPos blockPos = mutablePos.immutable();
                            Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"immutable(...)");
                            checking.add(blockPos);
                        }
                    }
                }
            }
            Iterable $this$sortedBy$iv = visited;
            boolean $i$f$sortedBy = false;
            return new ArrayDeque(CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    BlockPos v = (BlockPos)a;
                    boolean bl = false;
                    Comparable comparable = Integer.valueOf(v.getY());
                    v = (BlockPos)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(v.getY()));
                }
            }));
        }

        public final void levelTick(@NotNull LevelTickEvent.Pre event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            if (event.getLevel().isClientSide) {
                return;
            }
            if (event.getLevel().getGameTime() % (long)2 != 0L) {
                return;
            }
            this.setDisableEvents(true);
            Iterator<TreeFelling> instanceIterator = this.getInstances().iterator();
            while (instanceIterator.hasNext()) {
                TreeFelling instance = instanceIterator.next();
                if (!Intrinsics.areEqual((Object)instance.getPlayer().level(), (Object)event.getLevel())) continue;
                if (instance.getPlayer().isRemoved() || instance.getPositions().isEmpty() || !Intrinsics.areEqual((Object)instance.getStack(), (Object)instance.getPlayer().getMainHandItem())) {
                    instanceIterator.remove();
                    continue;
                }
                BlockPos pos = instance.getPositions().remove();
                if (!Intrinsics.areEqual((Object)event.getLevel().getBlockState(pos).getBlock(), (Object)instance.getBlockState().getBlock())) continue;
                instance.getPlayer().gameMode.destroyBlock(pos);
                instance.getPlayer().connection.send((Packet)new ClientboundLevelEventPacket(2001, pos, Block.getId((BlockState)instance.getBlockState()), false));
            }
            this.setDisableEvents(false);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

