/*
 * Decompiled with CFR 0.152.
 */
package me.alegian.thavma.impl.common.scanning;

import com.google.common.primitives.Doubles;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import me.alegian.thavma.impl.common.aspect.Aspect;
import me.alegian.thavma.impl.common.aspect.AspectHelper;
import me.alegian.thavma.impl.common.aspect.AspectMap;
import me.alegian.thavma.impl.common.aspect.AspectStack;
import me.alegian.thavma.impl.common.attachments.ScannedAttachment;
import me.alegian.thavma.impl.common.entity.KnowledgeHelperKt;
import me.alegian.thavma.impl.common.payload.ScanResultPayload;
import me.alegian.thavma.impl.common.scanning.ScanResult;
import me.alegian.thavma.impl.common.util.ResourceKeyExtensionsKt;
import me.alegian.thavma.impl.init.registries.deferred.T7Attachments;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000J\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u0018\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\n\u0010\u0003\u001a\u0006\u0012\u0002\b\u00030\u0004H\u0002\u001a\u0012\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0006\u001a\u0012\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0007\u001a\u00020\b\u001a\u0012\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\t\u001a\u00020\n\u001a\"\u0010\u000b\u001a\u00020\f*\u00020\r2\n\u0010\u0003\u001a\u0006\u0012\u0002\b\u00030\u00042\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0002\u001a\u0012\u0010\u000b\u001a\u00020\f*\u00020\r2\u0006\u0010\u0005\u001a\u00020\u0006\u001a\u0012\u0010\u000b\u001a\u00020\f*\u00020\r2\u0006\u0010\u0007\u001a\u00020\b\u001a*\u0010\u0010\u001a\u0018\u0012\u0014\u0012\u0012\u0012\u0002\b\u0003 \u0012*\b\u0012\u0002\b\u0003\u0018\u00010\u00110\u00110\u00042\n\u0010\u0013\u001a\u0006\u0012\u0002\b\u00030\u0011H\u0002\u001a\u001e\u0010\u0014\u001a\u0010\u0012\f\u0012\n \u0012*\u0004\u0018\u00010\u00150\u00150\u00042\u0006\u0010\u0016\u001a\u00020\u0015H\u0002\u001a\n\u0010\u0017\u001a\u00020\u0018*\u00020\u0002\u00a8\u0006\u0019"}, d2={"hasScanned", "", "Lnet/minecraft/world/entity/player/Player;", "key", "Lnet/minecraft/resources/ResourceKey;", "entity", "Lnet/minecraft/world/entity/Entity;", "blockState", "Lnet/minecraft/world/level/block/state/BlockState;", "itemStack", "Lnet/minecraft/world/item/ItemStack;", "tryScan", "", "Lnet/minecraft/server/level/ServerPlayer;", "aspectMap", "Lme/alegian/thavma/impl/common/aspect/AspectMap;", "entityKey", "Lnet/minecraft/world/entity/EntityType;", "kotlin.jvm.PlatformType", "entityType", "itemKey", "Lnet/minecraft/world/item/Item;", "item", "getScanHitResult", "Lnet/minecraft/world/phys/HitResult;", "thavma-neoforge"})
@SourceDebugExtension(value={"SMAP\nScanHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ScanHelper.kt\nme/alegian/thavma/impl/common/scanning/ScanHelperKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,95:1\n1563#2:96\n1634#2,3:97\n1374#2:100\n1460#2,5:101\n1761#2,3:106\n774#2:109\n865#2,2:110\n1563#2:112\n1634#2,3:113\n*S KotlinDebug\n*F\n+ 1 ScanHelper.kt\nme/alegian/thavma/impl/common/scanning/ScanHelperKt\n*L\n49#1:96\n49#1:97,3\n50#1:100\n50#1:101,5\n50#1:106,3\n54#1:109\n54#1:110,2\n55#1:112\n55#1:113,3\n*E\n"})
public final class ScanHelperKt {
    private static final boolean hasScanned(Player $this$hasScanned, ResourceKey<?> key) {
        return ((ScannedAttachment)$this$hasScanned.getData((Supplier)T7Attachments.INSTANCE.getSCANNED())).getScanned().contains(ResourceKeyExtensionsKt.serialize(key));
    }

    public static final boolean hasScanned(@NotNull Player $this$hasScanned, @NotNull Entity entity) {
        Intrinsics.checkNotNullParameter((Object)$this$hasScanned, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        if (entity instanceof ItemEntity) {
            ItemStack itemStack = ((ItemEntity)entity).getItem();
            Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"getItem(...)");
            return ScanHelperKt.hasScanned($this$hasScanned, itemStack);
        }
        EntityType entityType = entity.getType();
        Intrinsics.checkNotNullExpressionValue((Object)entityType, (String)"getType(...)");
        return ScanHelperKt.hasScanned($this$hasScanned, ScanHelperKt.entityKey(entityType));
    }

    public static final boolean hasScanned(@NotNull Player $this$hasScanned, @NotNull BlockState blockState) {
        Intrinsics.checkNotNullParameter((Object)$this$hasScanned, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)blockState, (String)"blockState");
        Item item = blockState.getBlock().asItem();
        Intrinsics.checkNotNullExpressionValue((Object)item, (String)"asItem(...)");
        return ScanHelperKt.hasScanned($this$hasScanned, ScanHelperKt.itemKey(item));
    }

    public static final boolean hasScanned(@NotNull Player $this$hasScanned, @NotNull ItemStack itemStack) {
        Intrinsics.checkNotNullParameter((Object)$this$hasScanned, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)itemStack, (String)"itemStack");
        Item item = itemStack.getItem();
        Intrinsics.checkNotNullExpressionValue((Object)item, (String)"getItem(...)");
        return ScanHelperKt.hasScanned($this$hasScanned, ScanHelperKt.itemKey(item));
    }

    private static final void tryScan(ServerPlayer $this$tryScan, ResourceKey<?> key, AspectMap aspectMap) {
        ScanResult scanResult = ScanResult.SUCCESS;
        if (aspectMap == null || aspectMap.isEmpty()) {
            scanResult = ScanResult.UNSUPPORTED;
        } else if (ScanHelperKt.hasScanned((Player)$this$tryScan, key)) {
            scanResult = ScanResult.SUCCESS;
        } else {
            boolean bl;
            Iterable $this$any$iv;
            Iterator $this$flatMapTo$iv$iv;
            List aspects;
            Aspect it;
            Collection collection;
            Iterable $this$mapTo$iv$iv;
            Collection destination$iv$iv;
            boolean $i$f$map;
            Iterable $this$map$iv;
            block14: {
                $this$map$iv = aspectMap;
                $i$f$map = false;
                Iterable iterable = $this$map$iv;
                destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    AspectStack aspectStack = (AspectStack)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl2 = false;
                    collection.add(((AspectStack)((Object)it)).getAspect());
                }
                aspects = (List)destination$iv$iv;
                Iterable $this$flatMap$iv = aspects;
                boolean $i$f$flatMap = false;
                $this$mapTo$iv$iv = $this$flatMap$iv;
                destination$iv$iv = new ArrayList();
                boolean $i$f$flatMapTo = false;
                Iterator iterator = $this$flatMapTo$iv$iv.iterator();
                while (iterator.hasNext()) {
                    Object element$iv$iv = iterator.next();
                    it = (Aspect)element$iv$iv;
                    boolean bl3 = false;
                    Iterable list$iv$iv = it.getComponents();
                    CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
                }
                $this$any$iv = (List)destination$iv$iv;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        Supplier it2 = (Supplier)element$iv;
                        boolean bl4 = false;
                        Player player = (Player)$this$tryScan;
                        Object t = it2.get();
                        Intrinsics.checkNotNullExpressionValue(t, (String)"get(...)");
                        if (!(!KnowledgeHelperKt.knowsAspect(player, (Aspect)t))) continue;
                        bl = true;
                        break block14;
                    }
                    bl = false;
                }
            }
            if (bl) {
                scanResult = ScanResult.LOCKED;
            } else {
                Iterable $this$filterTo$iv$iv;
                Iterable $this$filter$iv;
                $this$any$iv = aspects;
                collection = $this$tryScan;
                boolean $i$f$filter = false;
                $this$flatMapTo$iv$iv = $this$filter$iv;
                destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    it = (Aspect)element$iv$iv;
                    boolean bl5 = false;
                    if (!(!KnowledgeHelperKt.knowsAspect((Player)$this$tryScan, it))) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                $this$filter$iv = (List)destination$iv$iv;
                $i$f$map = false;
                $this$filterTo$iv$iv = $this$map$iv;
                destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    it = (Aspect)item$iv$iv;
                    Collection collection2 = destination$iv$iv;
                    boolean bl6 = false;
                    collection2.add(it.getResourceKey());
                }
                KnowledgeHelperKt.addKnowledge((ServerPlayer)collection, (List)destination$iv$iv);
            }
        }
        if (scanResult != ScanResult.SUCCESS) {
            return;
        }
        ScannedAttachment old = (ScannedAttachment)$this$tryScan.getData((Supplier)T7Attachments.INSTANCE.getSCANNED());
        old.getScanned().add(ResourceKeyExtensionsKt.serialize(key));
        $this$tryScan.setData((Supplier)T7Attachments.INSTANCE.getSCANNED(), (Object)old);
        PacketDistributor.sendToPlayer((ServerPlayer)$this$tryScan, (CustomPacketPayload)new ScanResultPayload(scanResult), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public static final void tryScan(@NotNull ServerPlayer $this$tryScan, @NotNull Entity entity) {
        Intrinsics.checkNotNullParameter((Object)$this$tryScan, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        if (entity instanceof ItemEntity) {
            Item item = ((ItemEntity)entity).getItem().getItem();
            Intrinsics.checkNotNullExpressionValue((Object)item, (String)"getItem(...)");
            ResourceKey<Item> resourceKey = ScanHelperKt.itemKey(item);
            ItemStack itemStack = ((ItemEntity)entity).getItem();
            Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"getItem(...)");
            ScanHelperKt.tryScan($this$tryScan, resourceKey, AspectHelper.INSTANCE.getAspects(itemStack));
            return;
        }
        EntityType entityType = entity.getType();
        Intrinsics.checkNotNullExpressionValue((Object)entityType, (String)"getType(...)");
        ScanHelperKt.tryScan($this$tryScan, ScanHelperKt.entityKey(entityType), AspectHelper.INSTANCE.getAspects(entity));
    }

    public static final void tryScan(@NotNull ServerPlayer $this$tryScan, @NotNull BlockState blockState) {
        Intrinsics.checkNotNullParameter((Object)$this$tryScan, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)blockState, (String)"blockState");
        Item item = blockState.getBlock().asItem();
        Intrinsics.checkNotNullExpressionValue((Object)item, (String)"asItem(...)");
        ResourceKey<Item> resourceKey = ScanHelperKt.itemKey(item);
        Block block = blockState.getBlock();
        Intrinsics.checkNotNullExpressionValue((Object)block, (String)"getBlock(...)");
        ScanHelperKt.tryScan($this$tryScan, resourceKey, AspectHelper.INSTANCE.getAspects((ItemLike)block));
    }

    private static final ResourceKey<EntityType<?>> entityKey(EntityType<?> entityType) {
        Object t = BuiltInRegistries.ENTITY_TYPE.getResourceKey(entityType).get();
        Intrinsics.checkNotNullExpressionValue(t, (String)"get(...)");
        return (ResourceKey)t;
    }

    private static final ResourceKey<Item> itemKey(Item item) {
        Object t = BuiltInRegistries.ITEM.getResourceKey((Object)item).get();
        Intrinsics.checkNotNullExpressionValue(t, (String)"get(...)");
        return (ResourceKey)t;
    }

    @NotNull
    public static final HitResult getScanHitResult(@NotNull Player $this$getScanHitResult) {
        HitResult hitResult;
        Intrinsics.checkNotNullParameter((Object)$this$getScanHitResult, (String)"<this>");
        double[] dArray = new double[]{$this$getScanHitResult.blockInteractionRange(), $this$getScanHitResult.entityInteractionRange()};
        Vec3 rayVec = $this$getScanHitResult.getViewVector(0.0f).scale(Doubles.max((double[])dArray));
        Function1 predicate = ScanHelperKt::getScanHitResult$lambda$5;
        HitResult trueHitResult = ProjectileUtil.getHitResult((Vec3)$this$getScanHitResult.getEyePosition(), (Entity)((Entity)$this$getScanHitResult), arg_0 -> ScanHelperKt.getScanHitResult$lambda$6(predicate, arg_0), (Vec3)rayVec, (Level)$this$getScanHitResult.level(), (float)0.0f, (ClipContext.Block)ClipContext.Block.OUTLINE);
        double range = trueHitResult instanceof BlockHitResult ? $this$getScanHitResult.blockInteractionRange() : $this$getScanHitResult.entityInteractionRange();
        boolean valid = trueHitResult.getLocation().closerThan((Position)$this$getScanHitResult.getEyePosition(), range);
        if (valid) {
            Intrinsics.checkNotNull((Object)trueHitResult);
            hitResult = trueHitResult;
        } else {
            BlockHitResult blockHitResult = BlockHitResult.miss((Vec3)$this$getScanHitResult.getEyePosition(), (Direction)$this$getScanHitResult.getDirection(), (BlockPos)$this$getScanHitResult.blockPosition());
            Intrinsics.checkNotNullExpressionValue((Object)blockHitResult, (String)"miss(...)");
            hitResult = (HitResult)blockHitResult;
        }
        return hitResult;
    }

    private static final boolean getScanHitResult$lambda$5(Entity entity) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        return !entity.isSpectator() && (entity.isPickable() || entity instanceof ItemEntity);
    }

    private static final boolean getScanHitResult$lambda$6(Function1 $tmp0, Entity p0) {
        return (Boolean)$tmp0.invoke((Object)p0);
    }
}

