/*
 * Decompiled with CFR 0.152.
 */
package me.alegian.thavma.impl.client.gui.book;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import me.alegian.thavma.impl.client.gui.book.EntryWidget;
import me.alegian.thavma.impl.client.texture.Texture;
import me.alegian.thavma.impl.client.util.GuiGraphicsExtensionsKt;
import me.alegian.thavma.impl.client.util.PoseStackExtensionsKt;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3f;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000:\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\u001a2\u0010\u000e\u001a\u00020\u000f*\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00012\u0006\u0010\u0012\u001a\u00020\u00012\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0016\u001a(\u0010\u0018\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u001c\u001a\u00020\u0016H\u0002\u001a(\u0010\u001d\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0011\u001a\u00020\u001a2\u0006\u0010\u0012\u001a\u00020\u001a2\u0006\u0010\u001e\u001a\u00020\u0016H\u0002\u001a.\u0010\u001f\u001a\u00020\u000f2\u0006\u0010 \u001a\u00020\u00142\u0006\u0010!\u001a\u00020\u001a2\u0006\u0010\"\u001a\u00020\u001a2\u0006\u0010#\u001a\u00020$2\u0006\u0010\u001e\u001a\u00020\u0016\"\u0011\u0010\u0000\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u0003\"\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0011\u0010\b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007\"\u0011\u0010\n\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\u0007\"\u0011\u0010\f\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u0007\u00a8\u0006%"}, d2={"CELL_SIZE", "", "getCELL_SIZE", "()I", "ARROW_HEAD", "Lme/alegian/thavma/impl/client/texture/Texture;", "getARROW_HEAD", "()Lme/alegian/thavma/impl/client/texture/Texture;", "LINE", "getLINE", "CORNER_1X1", "getCORNER_1X1", "CORNER_2X2", "getCORNER_2X2", "renderConnectionRecursive", "", "Lcom/mojang/blaze3d/vertex/PoseStack;", "dx", "dy", "guiGraphics", "Lnet/minecraft/client/gui/GuiGraphics;", "preferX", "", "invert", "renderLine", "signX", "", "signY", "vertical", "renderCorner", "reflect", "renderGridElement", "graphics", "width", "height", "textureLoc", "Lnet/minecraft/resources/ResourceLocation;", "thavma-neoforge"})
public final class GridHelperKt {
    private static final int CELL_SIZE = EntryWidget.Companion.getTEXTURE().getWidth();
    @NotNull
    private static final Texture ARROW_HEAD = new Texture("gui/book/arrow_head", 32, 32);
    @NotNull
    private static final Texture LINE = new Texture("gui/book/line", 32, 32);
    @NotNull
    private static final Texture CORNER_1X1 = new Texture("gui/book/corner_1x1", 32, 32);
    @NotNull
    private static final Texture CORNER_2X2 = new Texture("gui/book/corner_2x2", 96, 96);

    public static final int getCELL_SIZE() {
        return CELL_SIZE;
    }

    @NotNull
    public static final Texture getARROW_HEAD() {
        return ARROW_HEAD;
    }

    @NotNull
    public static final Texture getLINE() {
        return LINE;
    }

    @NotNull
    public static final Texture getCORNER_1X1() {
        return CORNER_1X1;
    }

    @NotNull
    public static final Texture getCORNER_2X2() {
        return CORNER_2X2;
    }

    public static final void renderConnectionRecursive(@NotNull PoseStack $this$renderConnectionRecursive, int dx, int dy, @NotNull GuiGraphics guiGraphics, boolean preferX, boolean invert) {
        float preference;
        Intrinsics.checkNotNullParameter((Object)$this$renderConnectionRecursive, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)guiGraphics, (String)"guiGraphics");
        int absDx = Math.abs(dx);
        int absDy = Math.abs(dy);
        int signX = MathKt.getSign((int)dx);
        int signY = MathKt.getSign((int)dy);
        float inversion = invert ? -1.0f : 1.0f;
        float f = preference = preferX ? -1.0f : 1.0f;
        if ((float)(absDx + absDy) <= 1.0f) {
            return;
        }
        if (absDx > 2 && absDy > 2) {
            throw new IllegalStateException();
        }
        if (!invert && (preferX && absDx > absDy && absDy > 0 || !preferX && absDy > absDx && absDx > 0)) {
            PoseStackExtensionsKt.translateXY($this$renderConnectionRecursive, dx, dy);
            GridHelperKt.renderConnectionRecursive($this$renderConnectionRecursive, -dx, -dy, guiGraphics, preferX, true);
        } else if (absDx == absDy) {
            PoseStackExtensionsKt.translateXY($this$renderConnectionRecursive, Float.valueOf((float)dx / 2.0f), Float.valueOf((float)dy / 2.0f));
            PoseStackExtensionsKt.translateXY($this$renderConnectionRecursive, Float.valueOf(preference * (float)signX * inversion / 2.0f), Float.valueOf(-preference * (float)signY * inversion / 2.0f));
            GridHelperKt.renderCorner(guiGraphics, (float)dx * inversion, (float)dy * inversion, preferX);
        } else if (absDx > absDy) {
            PoseStackExtensionsKt.translateXY($this$renderConnectionRecursive, signX, 0);
            GridHelperKt.renderLine(guiGraphics, (float)signX * inversion, 1.0f, false);
            GridHelperKt.renderConnectionRecursive($this$renderConnectionRecursive, dx - signX, dy, guiGraphics, preferX, invert);
        } else {
            PoseStackExtensionsKt.translateXY($this$renderConnectionRecursive, 0, signY);
            GridHelperKt.renderLine(guiGraphics, 1.0f, (float)signY * inversion, true);
            GridHelperKt.renderConnectionRecursive($this$renderConnectionRecursive, dx, dy - signY, guiGraphics, preferX, invert);
        }
    }

    private static final void renderLine(GuiGraphics guiGraphics, float signX, float signY, boolean vertical) {
        GridHelperKt.renderGridElement(guiGraphics, signX, signY, LINE.getLocation(), vertical);
    }

    private static final void renderCorner(GuiGraphics guiGraphics, float dx, float dy, boolean reflect) {
        ResourceLocation textureLoc = Math.abs(dx) == 1.0f ? CORNER_1X1.getLocation() : CORNER_2X2.getLocation();
        GridHelperKt.renderGridElement(guiGraphics, dx, dy, textureLoc, reflect);
    }

    public static final void renderGridElement(@NotNull GuiGraphics graphics, float width, float height, @NotNull ResourceLocation textureLoc, boolean reflect) {
        Intrinsics.checkNotNullParameter((Object)graphics, (String)"graphics");
        Intrinsics.checkNotNullParameter((Object)textureLoc, (String)"textureLoc");
        GuiGraphicsExtensionsKt.usePose(graphics, (Function1<? super PoseStack, Unit>)((Function1)arg_0 -> GridHelperKt.renderGridElement$lambda$0(reflect, width, height, graphics, textureLoc, arg_0)));
    }

    private static final Unit renderGridElement$lambda$0(boolean $reflect, float $width, float $height, GuiGraphics $graphics, ResourceLocation $textureLoc, PoseStack $this$usePose) {
        Intrinsics.checkNotNullParameter((Object)$this$usePose, (String)"$this$usePose");
        if ($reflect) {
            $this$usePose.mulPose(Axis.of((Vector3f)new Vector3f(Math.signum($width), Math.signum($height), 0.0f)).rotationDegrees(180.0f));
        }
        $this$usePose.scale($width, $height, 1.0f);
        PoseStackExtensionsKt.translateXY($this$usePose, Float.valueOf(-0.5f), Float.valueOf(-0.5f));
        $graphics.blit($textureLoc, 0, 0, 0, 0.0f, 0.0f, 1, 1, 1, 1);
        return Unit.INSTANCE;
    }
}

