/*
 * Decompiled with CFR 0.152.
 */
package me.alegian.thavma.impl.client.gui.book;

import com.mojang.blaze3d.vertex.PoseStack;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import me.alegian.thavma.impl.client.gui.book.BookScreen;
import me.alegian.thavma.impl.client.gui.book.FrameRenderable;
import me.alegian.thavma.impl.client.texture.Texture;
import me.alegian.thavma.impl.client.util.GuiGraphicsExtensionsKt;
import me.alegian.thavma.impl.client.util.PoseStackExtensionsKt;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Renderable;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0006\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0002\u0018\u0000 \u001e2\u00020\u0001:\u0001\u001eB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0016\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\tJ\u000e\u0010\u000f\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\tJ\u0006\u0010\u0015\u001a\u00020\tJ(\u0010\u0016\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001e\u0010\n\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\t@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001e\u0010\r\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\t@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\fR\u000e\u0010\u000f\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lme/alegian/thavma/impl/client/gui/book/TabRenderable;", "Lnet/minecraft/client/gui/components/Renderable;", "screen", "Lme/alegian/thavma/impl/client/gui/book/BookScreen;", "<init>", "(Lme/alegian/thavma/impl/client/gui/book/BookScreen;)V", "getScreen", "()Lme/alegian/thavma/impl/client/gui/book/BookScreen;", "value", "", "scrollX", "getScrollX", "()D", "scrollY", "getScrollY", "zoom", "drag", "", "x", "y", "change", "zoomFactor", "render", "graphics", "Lnet/minecraft/client/gui/GuiGraphics;", "mouseX", "", "mouseY", "tickDelta", "", "Companion", "thavma-neoforge"})
public final class TabRenderable
implements Renderable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final BookScreen screen;
    private double scrollX;
    private double scrollY;
    private double zoom;
    private static final double ZOOM_MULTIPLIER = 1.25;
    private static final double maxScrollX = 300.0;
    private static final double maxScrollY = 300.0;
    private static final double minZoom = 0.0;
    private static final double maxZoom = 5.0;
    @NotNull
    private static final Texture TEXTURE = new Texture("gui/book/tab_bg", 512, 512);

    public TabRenderable(@NotNull BookScreen screen) {
        Intrinsics.checkNotNullParameter((Object)((Object)screen), (String)"screen");
        this.screen = screen;
        this.zoom = 2.0;
    }

    @NotNull
    public final BookScreen getScreen() {
        return this.screen;
    }

    public final double getScrollX() {
        return this.scrollX;
    }

    public final double getScrollY() {
        return this.scrollY;
    }

    public final void drag(double x, double y) {
        double rawScrollX = this.scrollX - this.zoomFactor() * x;
        double rawScrollY = this.scrollY - this.zoomFactor() * y;
        this.scrollX = RangesKt.coerceIn((double)rawScrollX, (double)-300.0, (double)300.0);
        this.scrollY = RangesKt.coerceIn((double)rawScrollY, (double)-300.0, (double)300.0);
    }

    public final void zoom(double change) {
        this.zoom = RangesKt.coerceIn((double)(this.zoom - change), (double)0.0, (double)5.0);
    }

    public final double zoomFactor() {
        return Math.pow(1.25, this.zoom);
    }

    public void render(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float tickDelta) {
        Intrinsics.checkNotNullParameter((Object)graphics, (String)"graphics");
        if (!Intrinsics.areEqual((Object)this.screen.getCurrentTab(), (Object)this)) {
            return;
        }
        Texture corner = FrameRenderable.INSTANCE.getCORNER_TEXTURE();
        Texture edge = FrameRenderable.INSTANCE.getEDGE_TEXTURE();
        GuiGraphicsExtensionsKt.enableCrop(graphics, corner.getWidth() / 2 + edge.getHeight() / 2, corner.getHeight() / 2 + edge.getHeight() / 2);
        GuiGraphicsExtensionsKt.usePose(graphics, (Function1<? super PoseStack, Unit>)((Function1)arg_0 -> TabRenderable.render$lambda$0(graphics, this, arg_0)));
        GuiGraphicsExtensionsKt.disableCrop(graphics);
    }

    private static final Unit render$lambda$0(GuiGraphics $graphics, TabRenderable this$0, PoseStack $this$usePose) {
        Intrinsics.checkNotNullParameter((Object)$this$usePose, (String)"$this$usePose");
        int screenHeight = $graphics.guiHeight();
        int screenWidth = $graphics.guiWidth();
        PoseStackExtensionsKt.translateXY($this$usePose, screenWidth / 2, screenHeight / 2);
        PoseStackExtensionsKt.scaleXY($this$usePose, 1.0 / this$0.zoomFactor());
        $graphics.blit(TEXTURE.getLocation(), -3840, -2160, 0, (float)this$0.scrollX, (float)this$0.scrollY, 7680, 4320, 512, 512);
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u000e"}, d2={"Lme/alegian/thavma/impl/client/gui/book/TabRenderable$Companion;", "", "<init>", "()V", "ZOOM_MULTIPLIER", "", "maxScrollX", "maxScrollY", "minZoom", "maxZoom", "TEXTURE", "Lme/alegian/thavma/impl/client/texture/Texture;", "getTEXTURE", "()Lme/alegian/thavma/impl/client/texture/Texture;", "thavma-neoforge"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Texture getTEXTURE() {
            return TEXTURE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

