/*
 * Decompiled with CFR 0.152.
 */
package me.alegian.thavma.impl.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import me.alegian.thavma.impl.client.T7RenderTypes;
import me.alegian.thavma.impl.client.util.VertexConsumerExtensionsKt;
import me.alegian.thavma.impl.common.infusion.FlyingAspectsHelperKt;
import me.alegian.thavma.impl.common.util.Vec3ExtensionsKt;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000>\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\u001a&\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\u0003H\u0002\u001aV\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u00012\u0006\u0010\u000e\u001a\u00020\u00012\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00012\u0006\u0010\u0016\u001a\u00020\u0003\u001a>\u0010\u0017\u001a\u00020\u000b2\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00012\u0006\u0010\u001a\u001a\u00020\u0003H\u0002\u001a.\u0010\u001b\u001a\u00020\u00032\u0006\u0010\u001c\u001a\u00020\u00012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u001d\u001a\u00020\u0003H\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0003X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"CR0SS_AXIS_RESOLUTION", "", "ENDPOINT_RANGE", "", "trajectory", "", "Lnet/minecraft/world/phys/Vec3;", "start", "end", "height", "renderFlyingAspects", "", "trajectoryHeight", "headIndex", "length", "poseStack", "Lcom/mojang/blaze3d/vertex/PoseStack;", "multiBufferSource", "Lnet/minecraft/client/renderer/MultiBufferSource;", "ticks", "", "color", "radius", "renderVariableRadiusCylinder", "vc", "Lcom/mojang/blaze3d/vertex/VertexConsumer;", "baseRadius", "oscillatingRadius", "i", "scale", "thavma-neoforge"})
@SourceDebugExtension(value={"SMAP\nFlyingAspectsRenderer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FlyingAspectsRenderer.kt\nme/alegian/thavma/impl/client/renderer/FlyingAspectsRendererKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,97:1\n1563#2:98\n1634#2,3:99\n*S KotlinDebug\n*F\n+ 1 FlyingAspectsRenderer.kt\nme/alegian/thavma/impl/client/renderer/FlyingAspectsRendererKt\n*L\n31#1:98\n31#1:99,3\n*E\n"})
public final class FlyingAspectsRendererKt {
    public static final int CR0SS_AXIS_RESOLUTION = 16;
    public static final double ENDPOINT_RANGE = 0.3;

    /*
     * WARNING - void declaration
     */
    private static final List<Vec3> trajectory(Vec3 start, Vec3 end, double height) {
        void $this$mapTo$iv$iv;
        Vec3 diff = Vec3ExtensionsKt.minus(end, start);
        Vec3 vec3 = diff.normalize();
        Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"normalize(...)");
        Vec3 dl = Vec3ExtensionsKt.div(vec3, 32.0);
        int trajectoryLength = FlyingAspectsHelperKt.trajectoryLength(start, end);
        Iterable $this$map$iv = (Iterable)new IntRange(0, trajectoryLength);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            void it;
            int item$iv$iv;
            int n = item$iv$iv = ((IntIterator)iterator).nextInt();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            double t = (double)it / (double)trajectoryLength;
            Vec3 vec32 = Vec3ExtensionsKt.times(new Vec3(0.0, 1.0, 0.0), t);
            Intrinsics.checkNotNullExpressionValue((Object)vec32, (String)"times(...)");
            Vec3 vec33 = Vec3ExtensionsKt.times(vec32, 1.0 - t);
            Intrinsics.checkNotNullExpressionValue((Object)vec33, (String)"times(...)");
            Vec3 vec34 = Vec3ExtensionsKt.times(vec33, 4.0);
            Intrinsics.checkNotNullExpressionValue((Object)vec34, (String)"times(...)");
            Vec3 quadraticYOffset = Vec3ExtensionsKt.times(vec34, height);
            Intrinsics.checkNotNull((Object)dl);
            Vec3 vec35 = Vec3ExtensionsKt.times(dl, (double)it);
            Intrinsics.checkNotNullExpressionValue((Object)vec35, (String)"times(...)");
            Vec3 vec36 = Vec3ExtensionsKt.plus(start, vec35);
            Intrinsics.checkNotNullExpressionValue((Object)vec36, (String)"plus(...)");
            Intrinsics.checkNotNull((Object)quadraticYOffset);
            collection.add(Vec3ExtensionsKt.plus(vec36, quadraticYOffset));
        }
        return (List)destination$iv$iv;
    }

    public static final void renderFlyingAspects(@NotNull Vec3 start, @NotNull Vec3 end, double trajectoryHeight, int headIndex, int length, @NotNull PoseStack poseStack, @NotNull MultiBufferSource multiBufferSource, float ticks, int color, double radius) {
        Intrinsics.checkNotNullParameter((Object)start, (String)"start");
        Intrinsics.checkNotNullParameter((Object)end, (String)"end");
        Intrinsics.checkNotNullParameter((Object)poseStack, (String)"poseStack");
        Intrinsics.checkNotNullParameter((Object)multiBufferSource, (String)"multiBufferSource");
        VertexConsumer vc = multiBufferSource.getBuffer(T7RenderTypes.INSTANCE.getFLYING_ASPECTS());
        List<Vec3> traj = FlyingAspectsRendererKt.trajectory(start, end, trajectoryHeight);
        List<Vec3> list = traj.subList(Math.max(0, headIndex - length), headIndex + 1);
        Intrinsics.checkNotNull((Object)vc);
        FlyingAspectsRendererKt.renderVariableRadiusCylinder(list, vc, poseStack, ticks, color, radius);
    }

    private static final void renderVariableRadiusCylinder(List<? extends Vec3> trajectory, VertexConsumer vc, PoseStack poseStack, float ticks, int color, double baseRadius) {
        Vec3 prevNormal1 = new Vec3(0.0, 1.0, 0.0);
        Vec3 prevNormal2 = new Vec3(1.0, 0.0, 0.0);
        int n = trajectory.size() - 1;
        for (int i = 0; i < n; ++i) {
            Vec3 currentPoint = trajectory.get(i);
            Vec3 nextPoint = trajectory.get(i + 1);
            Vec3 direction = Vec3ExtensionsKt.minus(nextPoint, currentPoint);
            Intrinsics.checkNotNull((Object)direction);
            Vec3 randomOtherDirection = Vec3ExtensionsKt.minus(direction, new Vec3(0.0, 1.0, 0.0));
            Intrinsics.checkNotNull((Object)randomOtherDirection);
            Vec3 normal1 = Vec3ExtensionsKt.cross(direction, randomOtherDirection).normalize();
            Intrinsics.checkNotNull((Object)normal1);
            Vec3 normal2 = Vec3ExtensionsKt.cross(direction, normal1).normalize();
            double radius = FlyingAspectsRendererKt.oscillatingRadius(i, trajectory, ticks, baseRadius);
            double nextRadius = FlyingAspectsRendererKt.oscillatingRadius(i + 1, trajectory, ticks, baseRadius);
            for (int j = 0; j < 16; ++j) {
                double angle = Math.PI * 2 * (double)j / (double)16;
                double nextAngle = Math.PI * 2 * (double)(j + 1) / (double)16;
                Vec3 vec3 = Vec3ExtensionsKt.times(prevNormal1, Math.cos(angle));
                Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"times(...)");
                Vec3 vec32 = Vec3ExtensionsKt.times(prevNormal2, Math.sin(angle));
                Intrinsics.checkNotNullExpressionValue((Object)vec32, (String)"times(...)");
                Vec3 offset1 = Vec3ExtensionsKt.plus(vec3, vec32);
                Vec3 vec33 = Vec3ExtensionsKt.times(prevNormal1, Math.cos(nextAngle));
                Intrinsics.checkNotNullExpressionValue((Object)vec33, (String)"times(...)");
                Vec3 vec34 = Vec3ExtensionsKt.times(prevNormal2, Math.sin(nextAngle));
                Intrinsics.checkNotNullExpressionValue((Object)vec34, (String)"times(...)");
                Vec3 offset2 = Vec3ExtensionsKt.plus(vec33, vec34);
                Vec3 vec35 = Vec3ExtensionsKt.times(normal1, Math.cos(nextAngle));
                Intrinsics.checkNotNullExpressionValue((Object)vec35, (String)"times(...)");
                Intrinsics.checkNotNull((Object)normal2);
                Vec3 vec36 = Vec3ExtensionsKt.times(normal2, Math.sin(nextAngle));
                Intrinsics.checkNotNullExpressionValue((Object)vec36, (String)"times(...)");
                Vec3 offset3 = Vec3ExtensionsKt.plus(vec35, vec36);
                Vec3 vec37 = Vec3ExtensionsKt.times(normal1, Math.cos(angle));
                Intrinsics.checkNotNullExpressionValue((Object)vec37, (String)"times(...)");
                Vec3 vec38 = Vec3ExtensionsKt.times(normal2, Math.sin(angle));
                Intrinsics.checkNotNullExpressionValue((Object)vec38, (String)"times(...)");
                Vec3 offset4 = Vec3ExtensionsKt.plus(vec37, vec38);
                Intrinsics.checkNotNull((Object)offset1);
                Vec3 vec39 = Vec3ExtensionsKt.times(offset1, radius);
                Intrinsics.checkNotNullExpressionValue((Object)vec39, (String)"times(...)");
                Vec3 vec310 = Vec3ExtensionsKt.plus(currentPoint, vec39);
                Intrinsics.checkNotNullExpressionValue((Object)vec310, (String)"plus(...)");
                VertexConsumerExtensionsKt.addVertex(vc, poseStack, vec310).setColor(color);
                Intrinsics.checkNotNull((Object)offset2);
                Vec3 vec311 = Vec3ExtensionsKt.times(offset2, radius);
                Intrinsics.checkNotNullExpressionValue((Object)vec311, (String)"times(...)");
                Vec3 vec312 = Vec3ExtensionsKt.plus(currentPoint, vec311);
                Intrinsics.checkNotNullExpressionValue((Object)vec312, (String)"plus(...)");
                VertexConsumerExtensionsKt.addVertex(vc, poseStack, vec312).setColor(color);
                Intrinsics.checkNotNull((Object)offset3);
                Vec3 vec313 = Vec3ExtensionsKt.times(offset3, nextRadius);
                Intrinsics.checkNotNullExpressionValue((Object)vec313, (String)"times(...)");
                Vec3 vec314 = Vec3ExtensionsKt.plus(nextPoint, vec313);
                Intrinsics.checkNotNullExpressionValue((Object)vec314, (String)"plus(...)");
                VertexConsumerExtensionsKt.addVertex(vc, poseStack, vec314).setColor(color);
                Intrinsics.checkNotNull((Object)offset4);
                Vec3 vec315 = Vec3ExtensionsKt.times(offset4, nextRadius);
                Intrinsics.checkNotNullExpressionValue((Object)vec315, (String)"times(...)");
                Vec3 vec316 = Vec3ExtensionsKt.plus(nextPoint, vec315);
                Intrinsics.checkNotNullExpressionValue((Object)vec316, (String)"plus(...)");
                VertexConsumerExtensionsKt.addVertex(vc, poseStack, vec316).setColor(color);
            }
            prevNormal1 = normal1;
            Intrinsics.checkNotNull((Object)normal2);
            prevNormal2 = normal2;
        }
    }

    private static final double oscillatingRadius(int i, List<? extends Vec3> trajectory, float ticks, double scale) {
        double timePhase = Math.PI * -3 * (double)ticks / (double)20;
        double d = scale + 0.02 * Math.sin((double)(i * 2) * Math.PI / (double)32 + timePhase);
        Vec3 x = trajectory.get(i);
        double distanceToEndpoint = Math.min(x.distanceTo((Vec3)CollectionsKt.first(trajectory)), x.distanceTo((Vec3)CollectionsKt.last(trajectory)));
        double linearFade = RangesKt.coerceIn((double)(distanceToEndpoint / 0.3), (double)0.0, (double)1.0);
        if (distanceToEndpoint < 0.3) {
            return d * Mth.smoothstep((double)linearFade);
        }
        return d;
    }
}

