/*
 * Decompiled with CFR 0.152.
 */
package me.alegian.thavma.impl.common.aspect;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import me.alegian.thavma.impl.common.aspect.AspectMap;
import me.alegian.thavma.impl.init.registries.T7DataMaps;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0015\u0010\u0004\u001a\t\u0018\u00010\u0005\u00a2\u0006\u0002\b\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\t\u001a\u00020\nJ\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u000b\u001a\u00020\f\u00a8\u0006\r"}, d2={"Lme/alegian/thavma/impl/common/aspect/AspectHelper;", "", "<init>", "()V", "getAspects", "Lme/alegian/thavma/impl/common/aspect/AspectMap;", "Lorg/jetbrains/annotations/Nullable;", "itemLike", "Lnet/minecraft/world/level/ItemLike;", "entity", "Lnet/minecraft/world/entity/Entity;", "itemStack", "Lnet/minecraft/world/item/ItemStack;", "thavma-neoforge"})
public final class AspectHelper {
    @NotNull
    public static final AspectHelper INSTANCE = new AspectHelper();

    private AspectHelper() {
    }

    @Nullable
    public final AspectMap getAspects(@NotNull ItemLike itemLike) {
        Intrinsics.checkNotNullParameter((Object)itemLike, (String)"itemLike");
        return (AspectMap)BuiltInRegistries.ITEM.wrapAsHolder((Object)itemLike.asItem()).getData(T7DataMaps.AspectContent.INSTANCE.getITEM());
    }

    @Nullable
    public final AspectMap getAspects(@NotNull Entity entity) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        if (entity instanceof ItemEntity) {
            ItemStack itemStack = ((ItemEntity)entity).getItem();
            Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"getItem(...)");
            return this.getAspects(itemStack);
        }
        return (AspectMap)BuiltInRegistries.ENTITY_TYPE.wrapAsHolder((Object)entity.getType()).getData(T7DataMaps.AspectContent.INSTANCE.getENTITY());
    }

    @Nullable
    public final AspectMap getAspects(@NotNull ItemStack itemStack) {
        Intrinsics.checkNotNullParameter((Object)itemStack, (String)"itemStack");
        Item item = itemStack.getItem();
        Intrinsics.checkNotNullExpressionValue((Object)item, (String)"getItem(...)");
        AspectMap aspectMap = this.getAspects((ItemLike)item);
        return aspectMap != null ? aspectMap.scale(itemStack.getCount()) : null;
    }
}

