/*
 * Decompiled with CFR 0.152.
 */
package me.alegian.thavma.impl.common.block.entity;

import java.util.ArrayList;
import java.util.Objects;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import me.alegian.thavma.impl.client.particle.CrucibleBubbleParticle;
import me.alegian.thavma.impl.common.block.entity.DataComponentBE;
import me.alegian.thavma.impl.common.data.capability.CrucibleFluidHandler;
import me.alegian.thavma.impl.init.registries.T7BlockStateProperties;
import me.alegian.thavma.impl.init.registries.deferred.T7BlockEntities;
import me.alegian.thavma.impl.init.registries.deferred.T7ParticleTypes;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0016\u0018\u0000 &2\u00020\u0001:\u0001&B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0010J\u000e\u0010\u0018\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0010J\b\u0010\u0019\u001a\u00020\u0016H\u0014J \u0010\u001a\u001a\u00020\u00162\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0016J\u0018\u0010!\u001a\u00020\u00162\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020 H\u0014J\u0018\u0010%\u001a\u00020\u00162\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020 H\u0014R\u001b\u0010\b\u001a\u00020\t8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\f\u0010\r\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0011\u001a\u00020\u00128F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006'"}, d2={"Lme/alegian/thavma/impl/common/block/entity/CrucibleBE;", "Lme/alegian/thavma/impl/common/block/entity/DataComponentBE;", "pos", "Lnet/minecraft/core/BlockPos;", "blockState", "Lnet/minecraft/world/level/block/state/BlockState;", "<init>", "(Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;)V", "fluidHandler", "Lme/alegian/thavma/impl/common/data/capability/CrucibleFluidHandler;", "getFluidHandler", "()Lme/alegian/thavma/impl/common/data/capability/CrucibleFluidHandler;", "fluidHandler$delegate", "Lkotlin/Lazy;", "particles", "Ljava/util/ArrayList;", "Lme/alegian/thavma/impl/client/particle/CrucibleBubbleParticle;", "waterHeight", "", "getWaterHeight", "()D", "addParticle", "", "particle", "removeParticle", "clearParticles", "onDataPacket", "net", "Lnet/minecraft/network/Connection;", "pkt", "Lnet/minecraft/network/protocol/game/ClientboundBlockEntityDataPacket;", "lookupProvider", "Lnet/minecraft/core/HolderLookup$Provider;", "loadAdditional", "pTag", "Lnet/minecraft/nbt/CompoundTag;", "pRegistries", "saveAdditional", "Companion", "thavma-neoforge"})
@SourceDebugExtension(value={"SMAP\nCrucibleBE.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CrucibleBE.kt\nme/alegian/thavma/impl/common/block/entity/CrucibleBE\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,87:1\n1869#2,2:88\n*S KotlinDebug\n*F\n+ 1 CrucibleBE.kt\nme/alegian/thavma/impl/common/block/entity/CrucibleBE\n*L\n42#1:88,2\n*E\n"})
public class CrucibleBE
extends DataComponentBE {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Lazy fluidHandler$delegate;
    @NotNull
    private final ArrayList<CrucibleBubbleParticle> particles;

    public CrucibleBE(@NotNull BlockPos pos, @NotNull BlockState blockState) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)blockState, (String)"blockState");
        Object object = T7BlockEntities.INSTANCE.getCRUCIBLE().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        super((BlockEntityType)object, pos, blockState);
        this.fluidHandler$delegate = LazyKt.lazy(() -> CrucibleBE.fluidHandler_delegate$lambda$0(this));
        this.particles = new ArrayList();
    }

    @NotNull
    public final CrucibleFluidHandler getFluidHandler() {
        Lazy lazy = this.fluidHandler$delegate;
        return (CrucibleFluidHandler)((Object)lazy.getValue());
    }

    public final double getWaterHeight() {
        int amount = this.getFluidHandler().getFluidAmount();
        int total = this.getFluidHandler().getCapacity();
        double percent = (double)amount / (double)total;
        return (double)0.1875f + (double)0.75f * percent;
    }

    public final void addParticle(@NotNull CrucibleBubbleParticle particle) {
        Intrinsics.checkNotNullParameter((Object)((Object)particle), (String)"particle");
        this.particles.add(particle);
    }

    public final void removeParticle(@NotNull CrucibleBubbleParticle particle) {
        Intrinsics.checkNotNullParameter((Object)((Object)particle), (String)"particle");
        this.particles.remove((Object)particle);
    }

    protected void clearParticles() {
        Iterable $this$forEach$iv = this.particles;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            CrucibleBubbleParticle p0 = (CrucibleBubbleParticle)((Object)element$iv);
            boolean bl = false;
            p0.scheduleRemove();
        }
    }

    public void onDataPacket(@NotNull Connection net, @NotNull ClientboundBlockEntityDataPacket pkt, @NotNull HolderLookup.Provider lookupProvider) {
        Intrinsics.checkNotNullParameter((Object)net, (String)"net");
        Intrinsics.checkNotNullParameter((Object)pkt, (String)"pkt");
        Intrinsics.checkNotNullParameter((Object)lookupProvider, (String)"lookupProvider");
        CompoundTag compoundTag = Objects.requireNonNull(pkt.getTag());
        Intrinsics.checkNotNullExpressionValue((Object)compoundTag, (String)"requireNonNull(...)");
        this.loadAdditional(compoundTag, lookupProvider);
        this.clearParticles();
    }

    @Override
    protected void loadAdditional(@NotNull CompoundTag pTag, @NotNull HolderLookup.Provider pRegistries) {
        Intrinsics.checkNotNullParameter((Object)pTag, (String)"pTag");
        Intrinsics.checkNotNullParameter((Object)pRegistries, (String)"pRegistries");
        super.loadAdditional(pTag, pRegistries);
        this.getFluidHandler().readFromNBT(pRegistries, pTag);
    }

    @Override
    protected void saveAdditional(@NotNull CompoundTag pTag, @NotNull HolderLookup.Provider pRegistries) {
        Intrinsics.checkNotNullParameter((Object)pTag, (String)"pTag");
        Intrinsics.checkNotNullParameter((Object)pRegistries, (String)"pRegistries");
        super.saveAdditional(pTag, pRegistries);
        this.getFluidHandler().writeToNBT(pRegistries, pTag);
    }

    private static final CrucibleFluidHandler fluidHandler_delegate$lambda$0(CrucibleBE this$0) {
        return new CrucibleFluidHandler(this$0);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J(\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\r\u00a8\u0006\u000e"}, d2={"Lme/alegian/thavma/impl/common/block/entity/CrucibleBE$Companion;", "", "<init>", "()V", "tick", "", "level", "Lnet/minecraft/world/level/Level;", "pos", "Lnet/minecraft/core/BlockPos;", "state", "Lnet/minecraft/world/level/block/state/BlockState;", "blockEntity", "Lnet/minecraft/world/level/block/entity/BlockEntity;", "thavma-neoforge"})
    public static final class Companion {
        private Companion() {
        }

        public final void tick(@NotNull Level level, @NotNull BlockPos pos, @NotNull BlockState state, @Nullable BlockEntity blockEntity) {
            Intrinsics.checkNotNullParameter((Object)level, (String)"level");
            Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
            Intrinsics.checkNotNullParameter((Object)state, (String)"state");
            if (level instanceof ServerLevel && ((Boolean)state.getValue((Property)T7BlockStateProperties.INSTANCE.getBOILING())).booleanValue() && ((ServerLevel)level).getGameTime() % (long)7 == 0L && blockEntity instanceof CrucibleBE && !((CrucibleBE)blockEntity).getFluidHandler().isEmpty()) {
                ((ServerLevel)level).sendParticles((ParticleOptions)T7ParticleTypes.INSTANCE.getCRUCIBLE_BUBBLE().get(), (double)pos.getX() + level.random.nextDouble() * (double)12 / (double)16.0f + (double)0.125f, (double)pos.getY() + ((CrucibleBE)blockEntity).getWaterHeight(), (double)pos.getZ() + level.random.nextDouble() * (double)12 / (double)16.0f + (double)0.125f, 1, 0.0, 0.0, 0.0, 0.0);
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

