/*
 * Decompiled with CFR 0.152.
 */
package me.alegian.thavma.impl.common.block.entity;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import me.alegian.thavma.impl.common.util.LevelExtensionsKt;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.PatchedDataComponentMap;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.common.MutableDataComponentHolder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\b&\u0018\u00002\u00020\u00012\u00020\u0002B#\u0012\n\u0010\u0003\u001a\u0006\u0012\u0002\b\u00030\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0010\u0010\u0015\u001a\n \u0017*\u0004\u0018\u00010\u00160\u0016H\u0016J0\u0010\u0018\u001a\u0004\u0018\u0001H\u0019\"\u0004\b\u0000\u0010\u00192\u000e\u0010\u001a\u001a\n\u0012\u0006\b\u0000\u0012\u0002H\u00190\u001b2\b\u0010\u001c\u001a\u0004\u0018\u0001H\u0019H\u0096\u0002\u00a2\u0006\u0002\u0010\u001dJ%\u0010\u001e\u001a\u0004\u0018\u0001H\u0019\"\u0004\b\u0000\u0010\u00192\u000e\u0010\u001a\u001a\n\u0012\u0006\b\u0001\u0012\u0002H\u00190\u001bH\u0016\u00a2\u0006\u0002\u0010\u001fJ\u0010\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#H\u0016J\u0010\u0010 \u001a\u00020!2\u0006\u0010$\u001a\u00020%H\u0016J\b\u0010&\u001a\u00020\fH\u0016J\u0010\u0010'\u001a\u00020!2\u0006\u0010$\u001a\u00020(H\u0014J\u0010\u0010)\u001a\u00020!2\u0006\u0010*\u001a\u00020+H\u0014J$\u0010,\u001a\u00020!\"\u0004\b\u0000\u0010\u00192\f\u0010-\u001a\b\u0012\u0004\u0012\u0002H\u00190\u001b2\u0006\u0010.\u001a\u00020+H\u0002J\u0018\u0010/\u001a\u00020!2\u0006\u00100\u001a\u00020\u00122\u0006\u00101\u001a\u00020\u0014H\u0014J\u0018\u00102\u001a\u00020!2\u0006\u00100\u001a\u00020\u00122\u0006\u00101\u001a\u00020\u0014H\u0014R\u001a\u0010\u000b\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010\u00a8\u00063"}, d2={"Lme/alegian/thavma/impl/common/block/entity/DataComponentBE;", "Lnet/minecraft/world/level/block/entity/BlockEntity;", "Lnet/neoforged/neoforge/common/MutableDataComponentHolder;", "pType", "Lnet/minecraft/world/level/block/entity/BlockEntityType;", "pPos", "Lnet/minecraft/core/BlockPos;", "pBlockState", "Lnet/minecraft/world/level/block/state/BlockState;", "<init>", "(Lnet/minecraft/world/level/block/entity/BlockEntityType;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;)V", "componentMap", "Lnet/minecraft/core/component/PatchedDataComponentMap;", "getComponentMap", "()Lnet/minecraft/core/component/PatchedDataComponentMap;", "setComponentMap", "(Lnet/minecraft/core/component/PatchedDataComponentMap;)V", "getUpdateTag", "Lnet/minecraft/nbt/CompoundTag;", "lookupProvider", "Lnet/minecraft/core/HolderLookup$Provider;", "getUpdatePacket", "Lnet/minecraft/network/protocol/game/ClientboundBlockEntityDataPacket;", "kotlin.jvm.PlatformType", "set", "T", "componentType", "Lnet/minecraft/core/component/DataComponentType;", "value", "(Lnet/minecraft/core/component/DataComponentType;Ljava/lang/Object;)Ljava/lang/Object;", "remove", "(Lnet/minecraft/core/component/DataComponentType;)Ljava/lang/Object;", "applyComponents", "", "patch", "Lnet/minecraft/core/component/DataComponentPatch;", "components", "Lnet/minecraft/core/component/DataComponentMap;", "getComponents", "collectImplicitComponents", "Lnet/minecraft/core/component/DataComponentMap$Builder;", "applyImplicitComponents", "componentInput", "Lnet/minecraft/world/level/block/entity/BlockEntity$DataComponentInput;", "applyInput", "type", "input", "loadAdditional", "pTag", "pRegistries", "saveAdditional", "thavma-neoforge"})
public abstract class DataComponentBE
extends BlockEntity
implements MutableDataComponentHolder {
    @NotNull
    private PatchedDataComponentMap componentMap;

    public DataComponentBE(@NotNull BlockEntityType<?> pType, @NotNull BlockPos pPos, @NotNull BlockState pBlockState) {
        Intrinsics.checkNotNullParameter(pType, (String)"pType");
        Intrinsics.checkNotNullParameter((Object)pPos, (String)"pPos");
        Intrinsics.checkNotNullParameter((Object)pBlockState, (String)"pBlockState");
        super(pType, pPos, pBlockState);
        this.componentMap = new PatchedDataComponentMap(DataComponentMap.EMPTY);
    }

    @NotNull
    public final PatchedDataComponentMap getComponentMap() {
        return this.componentMap;
    }

    public final void setComponentMap(@NotNull PatchedDataComponentMap patchedDataComponentMap) {
        Intrinsics.checkNotNullParameter((Object)patchedDataComponentMap, (String)"<set-?>");
        this.componentMap = patchedDataComponentMap;
    }

    @NotNull
    public CompoundTag getUpdateTag(@NotNull HolderLookup.Provider lookupProvider) {
        Intrinsics.checkNotNullParameter((Object)lookupProvider, (String)"lookupProvider");
        CompoundTag compoundTag = this.saveWithoutMetadata(lookupProvider);
        Intrinsics.checkNotNullExpressionValue((Object)compoundTag, (String)"saveWithoutMetadata(...)");
        return compoundTag;
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    @Nullable
    public <T> T set(@NotNull DataComponentType<? super T> componentType, @Nullable T value) {
        Intrinsics.checkNotNullParameter(componentType, (String)"componentType");
        this.setChanged();
        return (T)this.componentMap.set(componentType, value);
    }

    @Nullable
    public <T> T remove(@NotNull DataComponentType<? extends T> componentType) {
        Intrinsics.checkNotNullParameter(componentType, (String)"componentType");
        this.setChanged();
        return (T)this.componentMap.remove(componentType);
    }

    public void applyComponents(@NotNull DataComponentPatch patch) {
        Intrinsics.checkNotNullParameter((Object)patch, (String)"patch");
        this.componentMap.applyPatch(patch);
    }

    public void applyComponents(@NotNull DataComponentMap components) {
        Intrinsics.checkNotNullParameter((Object)components, (String)"components");
        this.componentMap.setAll(components);
    }

    @NotNull
    public PatchedDataComponentMap getComponents() {
        return this.componentMap;
    }

    protected void collectImplicitComponents(@NotNull DataComponentMap.Builder components) {
        Intrinsics.checkNotNullParameter((Object)components, (String)"components");
        super.collectImplicitComponents(components);
        components.addAll((DataComponentMap)this.componentMap);
    }

    protected void applyImplicitComponents(@NotNull BlockEntity.DataComponentInput componentInput) {
        Registry registry;
        block4: {
            block3: {
                Intrinsics.checkNotNullParameter((Object)componentInput, (String)"componentInput");
                super.applyImplicitComponents(componentInput);
                registry = this.level;
                if (registry == null) break block3;
                ResourceKey resourceKey = Registries.DATA_COMPONENT_TYPE;
                Intrinsics.checkNotNullExpressionValue((Object)resourceKey, (String)"DATA_COMPONENT_TYPE");
                if ((registry = LevelExtensionsKt.registry((Level)registry, resourceKey)) != null) break block4;
            }
            return;
        }
        Registry componentTypes = registry;
        for (DataComponentType type : componentTypes) {
            Intrinsics.checkNotNull((Object)type);
            this.applyInput(type, componentInput);
        }
    }

    private final <T> void applyInput(DataComponentType<T> type, BlockEntity.DataComponentInput input) {
        Object object = input.get(type);
        if (object == null) {
            return;
        }
        Object value = object;
        this.componentMap.set(type, value);
    }

    protected void loadAdditional(@NotNull CompoundTag pTag, @NotNull HolderLookup.Provider pRegistries) {
        Intrinsics.checkNotNullParameter((Object)pTag, (String)"pTag");
        Intrinsics.checkNotNullParameter((Object)pRegistries, (String)"pRegistries");
        super.loadAdditional(pTag, pRegistries);
        DataComponentPatch patch = (DataComponentPatch)((Pair)DataComponentPatch.CODEC.decode((DynamicOps)NbtOps.INSTANCE, (Object)pTag.get("componentMap")).getOrThrow()).getFirst();
        PatchedDataComponentMap patchedDataComponentMap = PatchedDataComponentMap.fromPatch((DataComponentMap)DataComponentMap.EMPTY, (DataComponentPatch)patch);
        Intrinsics.checkNotNullExpressionValue((Object)patchedDataComponentMap, (String)"fromPatch(...)");
        this.componentMap = patchedDataComponentMap;
    }

    protected void saveAdditional(@NotNull CompoundTag pTag, @NotNull HolderLookup.Provider pRegistries) {
        Intrinsics.checkNotNullParameter((Object)pTag, (String)"pTag");
        Intrinsics.checkNotNullParameter((Object)pRegistries, (String)"pRegistries");
        super.saveAdditional(pTag, pRegistries);
        Tag tag = (Tag)DataComponentPatch.CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)this.componentMap.asPatch()).getOrThrow();
        pTag.put("componentMap", tag);
    }
}

