/*
 * Decompiled with CFR 0.152.
 */
package me.alegian.thavma.impl.common.item;

import java.util.function.Consumer;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import me.alegian.thavma.impl.ThavmaKt;
import me.alegian.thavma.impl.common.item.ArcaneLensItem;
import me.alegian.thavma.impl.common.scanning.ScanHelperKt;
import me.alegian.thavma.impl.init.registries.T7AttributeModifiers;
import me.alegian.thavma.impl.init.registries.deferred.T7Attributes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoItem;
import software.bernie.geckolib.animatable.client.GeoRenderProvider;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.model.DefaultedItemGeoModel;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.renderer.GeoItemRenderer;
import software.bernie.geckolib.util.GeckoLibUtil;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J(\u0010\n\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\f0\u000b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J(\u0010\u0013\u001a\u00020\u00142\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\f2\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\fH\u0016J\u0018\u0010\u001d\u001a\u00020\u00192\u0006\u0010\u001e\u001a\u00020\f2\u0006\u0010\u001f\u001a\u00020\u0016H\u0016J(\u0010 \u001a\u00020\u00142\u0006\u0010\u001c\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010!\u001a\u00020\u00162\u0006\u0010\"\u001a\u00020\u0019H\u0016J\u0012\u0010#\u001a\u00020\u00142\b\u0010$\u001a\u0004\u0018\u00010%H\u0016J\u0010\u0010&\u001a\n \t*\u0004\u0018\u00010\b0\bH\u0016J\u0018\u0010'\u001a\u00020\u00142\u000e\u0010(\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010*0)H\u0016R\u0016\u0010\u0007\u001a\n \t*\u0004\u0018\u00010\b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lme/alegian/thavma/impl/common/item/ArcaneLensItem;", "Lnet/minecraft/world/item/Item;", "Lsoftware/bernie/geckolib/animatable/GeoItem;", "props", "Lnet/minecraft/world/item/Item$Properties;", "<init>", "(Lnet/minecraft/world/item/Item$Properties;)V", "cache", "Lsoftware/bernie/geckolib/animatable/instance/AnimatableInstanceCache;", "kotlin.jvm.PlatformType", "use", "Lnet/minecraft/world/InteractionResultHolder;", "Lnet/minecraft/world/item/ItemStack;", "level", "Lnet/minecraft/world/level/Level;", "player", "Lnet/minecraft/world/entity/player/Player;", "hand", "Lnet/minecraft/world/InteractionHand;", "onUseTick", "", "livingEntity", "Lnet/minecraft/world/entity/LivingEntity;", "stack", "remainingUseDuration", "", "getUseAnimation", "Lnet/minecraft/world/item/UseAnim;", "itemStack", "getUseDuration", "pStack", "pEntity", "releaseUsing", "entity", "timeCharged", "registerControllers", "controllers", "Lsoftware/bernie/geckolib/animation/AnimatableManager$ControllerRegistrar;", "getAnimatableInstanceCache", "createGeoRenderer", "consumer", "Ljava/util/function/Consumer;", "Lsoftware/bernie/geckolib/animatable/client/GeoRenderProvider;", "thavma-neoforge"})
public final class ArcaneLensItem
extends Item
implements GeoItem {
    private final AnimatableInstanceCache cache;

    public ArcaneLensItem(@NotNull Item.Properties props) {
        Intrinsics.checkNotNullParameter((Object)props, (String)"props");
        super(props.attributes(ItemAttributeModifiers.builder().add((Holder)T7Attributes.INSTANCE.getREVEALING(), T7AttributeModifiers.Revealing.INSTANCE.getARCANE_LENS(), EquipmentSlotGroup.MAINHAND).build()).stacksTo(1));
        this.cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)((GeoAnimatable)this));
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(@NotNull Level level, @NotNull Player player, @NotNull InteractionHand hand) {
        boolean hasScanned;
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)hand, (String)"hand");
        HitResult hitResult = ScanHelperKt.getScanHitResult(player);
        if (hitResult.getType() == HitResult.Type.MISS) {
            InteractionResultHolder interactionResultHolder = InteractionResultHolder.pass((Object)player.getItemInHand(hand));
            Intrinsics.checkNotNullExpressionValue((Object)interactionResultHolder, (String)"pass(...)");
            return interactionResultHolder;
        }
        HitResult hitResult2 = hitResult;
        if (hitResult2 instanceof BlockHitResult) {
            BlockState blockState = level.getBlockState(((BlockHitResult)hitResult).getBlockPos());
            Intrinsics.checkNotNullExpressionValue((Object)blockState, (String)"getBlockState(...)");
            v2 = ScanHelperKt.hasScanned(player, blockState);
        } else if (hitResult2 instanceof EntityHitResult) {
            Entity entity = ((EntityHitResult)hitResult).getEntity();
            Intrinsics.checkNotNullExpressionValue((Object)entity, (String)"getEntity(...)");
            v2 = ScanHelperKt.hasScanned(player, entity);
        } else {
            v2 = hasScanned = false;
        }
        if (hasScanned) {
            InteractionResultHolder interactionResultHolder = InteractionResultHolder.pass((Object)player.getItemInHand(hand));
            Intrinsics.checkNotNullExpressionValue((Object)interactionResultHolder, (String)"pass(...)");
            return interactionResultHolder;
        }
        player.startUsingItem(hand);
        InteractionResultHolder interactionResultHolder = InteractionResultHolder.success((Object)player.getItemInHand(hand));
        Intrinsics.checkNotNullExpressionValue((Object)interactionResultHolder, (String)"success(...)");
        return interactionResultHolder;
    }

    public void onUseTick(@NotNull Level level, @NotNull LivingEntity livingEntity, @NotNull ItemStack stack, int remainingUseDuration) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)livingEntity, (String)"livingEntity");
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        if (remainingUseDuration % 3 == 2 && level.isClientSide) {
            level.playSound((Entity)livingEntity, livingEntity.blockPosition(), SoundEvents.COPPER_BULB_TURN_OFF, SoundSource.PLAYERS, 0.4f, 1.0f);
        }
        if (remainingUseDuration == 1) {
            this.releaseUsing(stack, level, livingEntity, this.getUseDuration(stack, livingEntity));
        }
    }

    @NotNull
    public UseAnim getUseAnimation(@NotNull ItemStack itemStack) {
        Intrinsics.checkNotNullParameter((Object)itemStack, (String)"itemStack");
        return UseAnim.CUSTOM;
    }

    public int getUseDuration(@NotNull ItemStack pStack, @NotNull LivingEntity pEntity) {
        Intrinsics.checkNotNullParameter((Object)pStack, (String)"pStack");
        Intrinsics.checkNotNullParameter((Object)pEntity, (String)"pEntity");
        return 32;
    }

    public void releaseUsing(@NotNull ItemStack itemStack, @NotNull Level level, @NotNull LivingEntity entity, int timeCharged) {
        HitResult hitResult;
        Intrinsics.checkNotNullParameter((Object)itemStack, (String)"itemStack");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        if (entity instanceof Player && timeCharged == this.getUseDuration(itemStack, entity) && entity instanceof ServerPlayer && !level.isClientSide && (hitResult = ScanHelperKt.getScanHitResult((Player)entity)).getType() != HitResult.Type.MISS) {
            HitResult hitResult2 = hitResult;
            if (hitResult2 instanceof BlockHitResult) {
                ServerPlayer serverPlayer = (ServerPlayer)entity;
                BlockState blockState = level.getBlockState(((BlockHitResult)hitResult).getBlockPos());
                Intrinsics.checkNotNullExpressionValue((Object)blockState, (String)"getBlockState(...)");
                ScanHelperKt.tryScan(serverPlayer, blockState);
            } else if (hitResult2 instanceof EntityHitResult) {
                ServerPlayer serverPlayer = (ServerPlayer)entity;
                Entity entity2 = ((EntityHitResult)hitResult).getEntity();
                Intrinsics.checkNotNullExpressionValue((Object)entity2, (String)"getEntity(...)");
                ScanHelperKt.tryScan(serverPlayer, entity2);
            }
        }
    }

    public void registerControllers(@Nullable AnimatableManager.ControllerRegistrar controllers) {
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public void createGeoRenderer(@NotNull Consumer<GeoRenderProvider> consumer) {
        Intrinsics.checkNotNullParameter(consumer, (String)"consumer");
        consumer.accept(new GeoRenderProvider(){
            private final Lazy renderer$delegate;
            {
                this.renderer$delegate = LazyKt.lazy(createGeoRenderer.1::renderer_delegate$lambda$0);
            }

            private final GeoItemRenderer<ArcaneLensItem> getRenderer() {
                Lazy lazy = this.renderer$delegate;
                return (GeoItemRenderer)lazy.getValue();
            }

            public GeoItemRenderer<ArcaneLensItem> getGeoItemRenderer() {
                return this.getRenderer();
            }

            private static final GeoItemRenderer renderer_delegate$lambda$0() {
                ResourceLocation resourceLocation = ThavmaKt.rl("arcane_lens");
                return new GeoItemRenderer((GeoModel)new DefaultedItemGeoModel<ArcaneLensItem>(resourceLocation){

                    public RenderType getRenderType(ArcaneLensItem animatable, ResourceLocation texture) {
                        Intrinsics.checkNotNullParameter((Object)((Object)animatable), (String)"animatable");
                        Intrinsics.checkNotNullParameter((Object)texture, (String)"texture");
                        return RenderType.entityTranslucent((ResourceLocation)texture);
                    }
                });
            }
        });
    }
}

