/*
 * Decompiled with CFR 0.152.
 */
package me.alegian.thavma.impl.common.item;

import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Supplier;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import me.alegian.thavma.impl.ThavmaKt;
import me.alegian.thavma.impl.client.renderer.geo.WandRenderer;
import me.alegian.thavma.impl.common.block.AuraNodeBlock;
import me.alegian.thavma.impl.common.block.CrucibleBlock;
import me.alegian.thavma.impl.common.block.TableBlock;
import me.alegian.thavma.impl.common.block.WorkbenchBlock;
import me.alegian.thavma.impl.common.block.entity.AuraNodeBE;
import me.alegian.thavma.impl.common.data.capability.AspectContainer;
import me.alegian.thavma.impl.common.entity.FancyBookEntity;
import me.alegian.thavma.impl.common.entity.VisEntity;
import me.alegian.thavma.impl.common.item.WandItem;
import me.alegian.thavma.impl.common.item.WandItemKt;
import me.alegian.thavma.impl.common.util.LevelExtensionsKt;
import me.alegian.thavma.impl.common.wand.WandCoreMaterial;
import me.alegian.thavma.impl.common.wand.WandPlatingMaterial;
import me.alegian.thavma.impl.init.registries.deferred.T7BlockEntities;
import me.alegian.thavma.impl.init.registries.deferred.T7Blocks;
import me.alegian.thavma.impl.init.registries.deferred.T7DataComponents;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.component.ItemContainerContents;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.common.Tags;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.GeckoLibServices;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoItem;
import software.bernie.geckolib.animatable.client.GeoRenderProvider;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.network.packet.MultiloaderPacket;
import software.bernie.geckolib.network.packet.SingletonAnimTriggerPacket;
import software.bernie.geckolib.util.GeckoLibUtil;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u00a2\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0016\u0018\u0000 E2\u00020\u00012\u00020\u0002:\u0001EB\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J(\u0010\u0016\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00180\u00172\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J(\u0010\u001f\u001a\u00020\u00132\u0006\u0010 \u001a\u00020\u00182\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010!\u001a\u00020\"2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\u0010\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020\u0018H\u0016J\u0018\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020\u00182\u0006\u0010)\u001a\u00020\"H\u0016J \u0010*\u001a\u00020+2\u0006\u0010%\u001a\u00020\u00182\u0006\u0010,\u001a\u00020\"2\u0006\u0010-\u001a\u00020'H\u0016J \u0010.\u001a\u00020/2\u0006\u00100\u001a\u00020\u00182\u0006\u00101\u001a\u00020\u00182\u0006\u00102\u001a\u00020/H\u0016J(\u00103\u001a\u00020+2\u0006\u00104\u001a\u00020/2\u0006\u0010,\u001a\u0002052\u0006\u0010%\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0004J(\u00103\u001a\u00020+2\u0006\u00104\u001a\u00020/2\u0006\u0010,\u001a\u0002052\u0006\u0010%\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u000206H\u0004J\u0010\u00107\u001a\u00020+2\u0006\u00108\u001a\u000209H\u0016J\b\u0010:\u001a\u00020\u0010H\u0016J\u0016\u0010;\u001a\u00020+2\f\u0010<\u001a\b\u0012\u0004\u0012\u00020>0=H\u0016J\b\u0010?\u001a\u00020'H\u0016J\b\u0010D\u001a\u00020AH\u0016R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0016\u0010\u000f\u001a\n \u0011*\u0004\u0018\u00010\u00100\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010@\u001a\u00020A8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\bB\u0010C\u00a8\u0006F"}, d2={"Lme/alegian/thavma/impl/common/item/WandItem;", "Lnet/minecraft/world/item/Item;", "Lsoftware/bernie/geckolib/animatable/GeoItem;", "props", "Lnet/minecraft/world/item/Item$Properties;", "platingMaterial", "Lme/alegian/thavma/impl/common/wand/WandPlatingMaterial;", "coreMaterial", "Lme/alegian/thavma/impl/common/wand/WandCoreMaterial;", "<init>", "(Lnet/minecraft/world/item/Item$Properties;Lme/alegian/thavma/impl/common/wand/WandPlatingMaterial;Lme/alegian/thavma/impl/common/wand/WandCoreMaterial;)V", "getPlatingMaterial", "()Lme/alegian/thavma/impl/common/wand/WandPlatingMaterial;", "getCoreMaterial", "()Lme/alegian/thavma/impl/common/wand/WandCoreMaterial;", "cache", "Lsoftware/bernie/geckolib/animatable/instance/AnimatableInstanceCache;", "kotlin.jvm.PlatformType", "useOn", "Lnet/minecraft/world/InteractionResult;", "context", "Lnet/minecraft/world/item/context/UseOnContext;", "use", "Lnet/minecraft/world/InteractionResultHolder;", "Lnet/minecraft/world/item/ItemStack;", "level", "Lnet/minecraft/world/level/Level;", "player", "Lnet/minecraft/world/entity/player/Player;", "usedHand", "Lnet/minecraft/world/InteractionHand;", "interactLivingEntity", "stack", "interactionTarget", "Lnet/minecraft/world/entity/LivingEntity;", "getUseAnimation", "Lnet/minecraft/world/item/UseAnim;", "itemStack", "getUseDuration", "", "pStack", "pEntity", "onStopUsing", "", "entity", "count", "shouldCauseReequipAnimation", "", "oldStack", "newStack", "slotChanged", "animateCircle", "isCasting", "Lnet/minecraft/world/entity/Entity;", "Lnet/minecraft/server/level/ServerLevel;", "registerControllers", "controllers", "Lsoftware/bernie/geckolib/animation/AnimatableManager$ControllerRegistrar;", "getAnimatableInstanceCache", "createGeoRenderer", "consumer", "Ljava/util/function/Consumer;", "Lsoftware/bernie/geckolib/animatable/client/GeoRenderProvider;", "capacity", "name", "", "getName", "()Ljava/lang/String;", "syncableId", "Companion", "thavma-neoforge"})
public class WandItem
extends Item
implements GeoItem {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final WandPlatingMaterial platingMaterial;
    @NotNull
    private final WandCoreMaterial coreMaterial;
    private final AnimatableInstanceCache cache;

    public WandItem(@NotNull Item.Properties props, @NotNull WandPlatingMaterial platingMaterial, @NotNull WandCoreMaterial coreMaterial) {
        Intrinsics.checkNotNullParameter((Object)props, (String)"props");
        Intrinsics.checkNotNullParameter((Object)platingMaterial, (String)"platingMaterial");
        Intrinsics.checkNotNullParameter((Object)coreMaterial, (String)"coreMaterial");
        super(props.stacksTo(1).rarity(Rarity.UNCOMMON));
        this.platingMaterial = platingMaterial;
        this.coreMaterial = coreMaterial;
        this.cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)((GeoAnimatable)this));
        Map map = GeckoLibUtil.SYNCED_ANIMATABLES;
        Intrinsics.checkNotNullExpressionValue((Object)map, (String)"SYNCED_ANIMATABLES");
        Map map2 = map;
        map2.put(this.syncableId(), this);
    }

    @NotNull
    public final WandPlatingMaterial getPlatingMaterial() {
        return this.platingMaterial;
    }

    @NotNull
    public final WandCoreMaterial getCoreMaterial() {
        return this.coreMaterial;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public InteractionResult useOn(@NotNull UseOnContext context) {
        InteractionResult interactionResult;
        BlockPos blockPos;
        ItemStack focusResult;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        ItemStack itemStack = context.getItemInHand();
        Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"getItemInHand(...)");
        ItemStack itemStack2 = Companion.getEquippedFocus(itemStack);
        if (itemStack2 == null || (itemStack2 = itemStack2.getItem()) == null || (itemStack2 = itemStack2.useOn(context)) == null) {
            itemStack2 = InteractionResult.PASS;
        }
        if ((focusResult = itemStack2) != InteractionResult.PASS) {
            return focusResult;
        }
        Level level = context.getLevel();
        BlockState blockState = level.getBlockState(blockPos = context.getClickedPos());
        Block block = blockState.getBlock();
        if (block instanceof AuraNodeBlock) {
            boolean canTransfer;
            AspectContainer.Pair transferPair;
            Player player = context.getPlayer();
            Intrinsics.checkNotNull((Object)level);
            Intrinsics.checkNotNull((Object)blockPos);
            ItemStack itemStack3 = context.getItemInHand();
            Intrinsics.checkNotNullExpressionValue((Object)itemStack3, (String)"getItemInHand(...)");
            AspectContainer.Pair pair = transferPair = AspectContainer.Companion.blockSourceItemSink(level, blockPos, itemStack3);
            boolean bl = canTransfer = pair != null ? pair.canTransferPrimals() : false;
            if (player != null && canTransfer) {
                player.startUsingItem(context.getHand());
                if (level.isClientSide()) return InteractionResult.CONSUME;
                if (!(level instanceof ServerLevel)) return InteractionResult.CONSUME;
                ((ServerLevel)level).addFreshEntity((Entity)new VisEntity(level, player, blockPos));
                Entity entity = (Entity)player;
                ItemStack itemStack4 = context.getItemInHand();
                Intrinsics.checkNotNullExpressionValue((Object)itemStack4, (String)"getItemInHand(...)");
                this.animateCircle(true, entity, itemStack4, (ServerLevel)level);
                return InteractionResult.CONSUME;
            }
        }
        if (blockState.is(Blocks.CAULDRON)) {
            if (!level.isClientSide()) {
                CrucibleBlock crucibleBlock = (CrucibleBlock)((Object)T7Blocks.INSTANCE.getCRUCIBLE().get());
                Intrinsics.checkNotNull((Object)level);
                LevelAccessor levelAccessor = (LevelAccessor)level;
                Intrinsics.checkNotNull((Object)blockPos);
                level.setBlockAndUpdate(blockPos, crucibleBlock.stateWithBoiling(levelAccessor, blockPos));
            }
            level.playSound(context.getPlayer(), blockPos, SoundEvents.PLAYER_LEVELUP, SoundSource.BLOCKS, 1.0f, 1.0f);
            return InteractionResult.SUCCESS;
        }
        if (blockState.is(Blocks.CRAFTING_TABLE)) {
            if (!level.isClientSide()) {
                level.setBlockAndUpdate(blockPos, ((WorkbenchBlock)((Object)T7Blocks.INSTANCE.getARCANE_WORKBENCH().get())).defaultBlockState());
            }
            level.playSound(context.getPlayer(), blockPos, SoundEvents.PLAYER_LEVELUP, SoundSource.BLOCKS, 1.0f, 1.0f);
            return InteractionResult.SUCCESS;
        }
        if (block instanceof TableBlock && !level.isClientSide() && level instanceof ServerLevel) {
            TableBlock tableBlock = (TableBlock)block;
            ServerLevel serverLevel = (ServerLevel)level;
            Intrinsics.checkNotNull((Object)blockPos);
            Intrinsics.checkNotNull((Object)blockState);
            if (tableBlock.tryConvertToResearchTable(serverLevel, blockPos, blockState)) {
                ((ServerLevel)level).playSound(context.getPlayer(), blockPos, SoundEvents.PLAYER_LEVELUP, SoundSource.BLOCKS, 1.0f, 1.0f);
                return InteractionResult.SUCCESS;
            }
        }
        if (blockState.is(Blocks.BOOKSHELF)) {
            if (!level.isClientSide() && level.removeBlock(blockPos, false)) {
                Intrinsics.checkNotNull((Object)level);
                Intrinsics.checkNotNull((Object)blockPos);
                level.addFreshEntity((Entity)new FancyBookEntity(level, blockPos));
            }
            level.playSound(context.getPlayer(), blockPos, SoundEvents.PLAYER_LEVELUP, SoundSource.BLOCKS, 1.0f, 1.0f);
            return InteractionResult.SUCCESS;
        }
        if (!blockState.is(Tags.Blocks.GLASS_BLOCKS)) return InteractionResult.PASS;
        Direction direction = context.getClickedFace().getOpposite();
        Intrinsics.checkNotNullExpressionValue((Object)direction, (String)"getOpposite(...)");
        Direction direction2 = direction;
        BlockPos blockPos2 = blockPos.relative(direction2, 1);
        Intrinsics.checkNotNullExpressionValue((Object)blockPos2, (String)"relative(...)");
        BlockPos behindPos = blockPos2;
        Intrinsics.checkNotNull((Object)level);
        Object object = T7BlockEntities.INSTANCE.getAURA_NODE().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        AuraNodeBE auraNodeBE = (AuraNodeBE)((Object)LevelExtensionsKt.getBE(level, behindPos, (BlockEntityType)object));
        if (auraNodeBE != null) {
            AuraNodeBE be = auraNodeBE;
            boolean bl = false;
            InteractionResult interactionResult2 = be.jarInteraction() ? InteractionResult.SUCCESS : InteractionResult.FAIL;
            if (interactionResult2 != null) {
                interactionResult = interactionResult2;
                return interactionResult;
            }
        }
        interactionResult = InteractionResult.PASS;
        return interactionResult;
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(@NotNull Level level, @NotNull Player player, @NotNull InteractionHand usedHand) {
        ItemStack focusResult;
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)usedHand, (String)"usedHand");
        ItemStack itemInHand = player.getItemInHand(usedHand);
        Intrinsics.checkNotNull((Object)itemInHand);
        ItemStack itemStack = Companion.getEquippedFocus(itemInHand);
        if (itemStack == null || (itemStack = itemStack.getItem()) == null || (itemStack = itemStack.use(level, player, usedHand)) == null) {
            itemStack = InteractionResultHolder.pass((Object)itemInHand);
        }
        if ((focusResult = itemStack).getResult() != InteractionResult.PASS) {
            Intrinsics.checkNotNull((Object)focusResult);
            return focusResult;
        }
        InteractionResultHolder interactionResultHolder = super.use(level, player, usedHand);
        Intrinsics.checkNotNullExpressionValue((Object)interactionResultHolder, (String)"use(...)");
        return interactionResultHolder;
    }

    @NotNull
    public InteractionResult interactLivingEntity(@NotNull ItemStack stack, @NotNull Player player, @NotNull LivingEntity interactionTarget, @NotNull InteractionHand usedHand) {
        ItemStack focusResult;
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)interactionTarget, (String)"interactionTarget");
        Intrinsics.checkNotNullParameter((Object)usedHand, (String)"usedHand");
        ItemStack itemStack = Companion.getEquippedFocus(stack);
        if (itemStack == null || (itemStack = itemStack.getItem()) == null || (itemStack = itemStack.interactLivingEntity(stack, player, interactionTarget, usedHand)) == null) {
            itemStack = InteractionResult.PASS;
        }
        if ((focusResult = itemStack) != InteractionResult.PASS) {
            return focusResult;
        }
        InteractionResult interactionResult = super.interactLivingEntity(stack, player, interactionTarget, usedHand);
        Intrinsics.checkNotNullExpressionValue((Object)interactionResult, (String)"interactLivingEntity(...)");
        return interactionResult;
    }

    @NotNull
    public UseAnim getUseAnimation(@NotNull ItemStack itemStack) {
        Intrinsics.checkNotNullParameter((Object)itemStack, (String)"itemStack");
        return UseAnim.CUSTOM;
    }

    public int getUseDuration(@NotNull ItemStack pStack, @NotNull LivingEntity pEntity) {
        Intrinsics.checkNotNullParameter((Object)pStack, (String)"pStack");
        Intrinsics.checkNotNullParameter((Object)pEntity, (String)"pEntity");
        return 72000;
    }

    public void onStopUsing(@NotNull ItemStack itemStack, @NotNull LivingEntity entity, int count) {
        Intrinsics.checkNotNullParameter((Object)itemStack, (String)"itemStack");
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        Entity entity2 = (Entity)entity;
        Level level = entity.level();
        Intrinsics.checkNotNullExpressionValue((Object)level, (String)"level(...)");
        this.animateCircle(false, entity2, itemStack, level);
        super.onStopUsing(itemStack, entity, count);
    }

    public boolean shouldCauseReequipAnimation(@NotNull ItemStack oldStack, @NotNull ItemStack newStack, boolean slotChanged) {
        Intrinsics.checkNotNullParameter((Object)oldStack, (String)"oldStack");
        Intrinsics.checkNotNullParameter((Object)newStack, (String)"newStack");
        return !Intrinsics.areEqual((Object)oldStack.getItem(), (Object)newStack.getItem());
    }

    protected final void animateCircle(boolean isCasting, @NotNull Entity entity, @NotNull ItemStack itemStack, @NotNull Level level) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        Intrinsics.checkNotNullParameter((Object)itemStack, (String)"itemStack");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        if (!level.isClientSide() && level instanceof ServerLevel) {
            this.animateCircle(isCasting, entity, itemStack, (ServerLevel)level);
        }
    }

    protected final void animateCircle(boolean isCasting, @NotNull Entity entity, @NotNull ItemStack itemStack, @NotNull ServerLevel level) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        Intrinsics.checkNotNullParameter((Object)itemStack, (String)"itemStack");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        String animationName = isCasting ? "casting" : "idle";
        GeckoLibServices.NETWORK.sendToAllPlayersTrackingEntity((MultiloaderPacket)new SingletonAnimTriggerPacket(this.syncableId(), GeoItem.getOrAssignId((ItemStack)itemStack, (ServerLevel)level), "Casting", animationName), entity);
    }

    public void registerControllers(@NotNull AnimatableManager.ControllerRegistrar controllers) {
        Intrinsics.checkNotNullParameter((Object)controllers, (String)"controllers");
        controllers.add(new AnimationController((GeoAnimatable)this, "Casting", 0, WandItem::registerControllers$lambda$1).triggerableAnim("casting", WandItemKt.access$getCAST_ANIMATION$p()).triggerableAnim("idle", WandItemKt.access$getIDLE_ANIMATION$p()));
    }

    @NotNull
    public AnimatableInstanceCache getAnimatableInstanceCache() {
        AnimatableInstanceCache animatableInstanceCache = this.cache;
        Intrinsics.checkNotNullExpressionValue((Object)animatableInstanceCache, (String)"cache");
        return animatableInstanceCache;
    }

    public void createGeoRenderer(@NotNull Consumer<GeoRenderProvider> consumer) {
        Intrinsics.checkNotNullParameter(consumer, (String)"consumer");
        consumer.accept(new GeoRenderProvider(this){
            private final Lazy renderer$delegate;
            {
                this.renderer$delegate = LazyKt.lazy(() -> createGeoRenderer.1.renderer_delegate$lambda$0($receiver));
            }

            private final WandRenderer getRenderer() {
                Lazy lazy = this.renderer$delegate;
                return (WandRenderer)((Object)lazy.getValue());
            }

            public WandRenderer getGeoItemRenderer() {
                return this.getRenderer();
            }

            private static final WandRenderer renderer_delegate$lambda$0(WandItem this$0) {
                return new WandRenderer(this$0.getPlatingMaterial(), this$0.getCoreMaterial());
            }
        });
    }

    public int capacity() {
        return this.coreMaterial.getCapacity();
    }

    @NotNull
    public String getName() {
        return Companion.name(this.platingMaterial, this.coreMaterial);
    }

    @NotNull
    public String syncableId() {
        ResourceLocation location = ThavmaKt.rl(this.getName());
        String string = location.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    private static final PlayState registerControllers$lambda$1(AnimationState state) {
        AnimationController controller = state.getController();
        if (controller.getCurrentAnimation() == null) {
            controller.setAnimation(WandItemKt.access$getIDLE_ANIMATION$p());
        }
        return PlayState.CONTINUE;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tR\u0017\u0010\n\u001a\u0004\u0018\u00010\u000b*\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\u00a8\u0006\u000e"}, d2={"Lme/alegian/thavma/impl/common/item/WandItem$Companion;", "", "<init>", "()V", "name", "", "platingMaterial", "Lme/alegian/thavma/impl/common/wand/WandPlatingMaterial;", "coreMaterial", "Lme/alegian/thavma/impl/common/wand/WandCoreMaterial;", "equippedFocus", "Lnet/minecraft/world/item/ItemStack;", "getEquippedFocus", "(Lnet/minecraft/world/item/ItemStack;)Lnet/minecraft/world/item/ItemStack;", "thavma-neoforge"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String name(@NotNull WandPlatingMaterial platingMaterial, @NotNull WandCoreMaterial coreMaterial) {
            Intrinsics.checkNotNullParameter((Object)platingMaterial, (String)"platingMaterial");
            Intrinsics.checkNotNullParameter((Object)coreMaterial, (String)"coreMaterial");
            return platingMaterial.getRegisteredName() + "_" + coreMaterial.getRegisteredName() + "_wand";
        }

        @Nullable
        public final ItemStack getEquippedFocus(@NotNull ItemStack $this$equippedFocus) {
            Intrinsics.checkNotNullParameter((Object)$this$equippedFocus, (String)"<this>");
            Object object = (ItemContainerContents)$this$equippedFocus.get((Supplier)T7DataComponents.INSTANCE.getFOCUS());
            return object != null && (object = object.nonEmptyItems()) != null ? (ItemStack)CollectionsKt.firstOrNull((Iterable)object) : null;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

