/*
 * Decompiled with CFR 0.152.
 */
package me.alegian.thavma.impl.common.menu.container;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import me.alegian.thavma.impl.common.menu.Menu;
import me.alegian.thavma.impl.common.menu.container.T7Container;
import me.alegian.thavma.impl.common.menu.slot.SlotRange;
import me.alegian.thavma.impl.common.menu.slot.T7Slot;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u000fH\u0016J\u0018\u0010\u0015\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\u000fH\u0016J\u0010\u0010\u0017\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u000fH\u0016J\u0018\u0010\u0018\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0019\u001a\u00020\u0013H\u0016J\b\u0010\u001a\u001a\u00020\rH\u0016J\u0010\u0010\u001b\u001a\u00020\u00112\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\b\u0010\u001e\u001a\u00020\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u001c\u001a\u00020\u001d8F\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010 \u00a8\u0006!"}, d2={"Lme/alegian/thavma/impl/common/menu/container/T7Inventory;", "Lme/alegian/thavma/impl/common/menu/container/T7Container;", "inventory", "Lnet/minecraft/world/entity/player/Inventory;", "menu", "Lme/alegian/thavma/impl/common/menu/Menu;", "<init>", "(Lnet/minecraft/world/entity/player/Inventory;Lme/alegian/thavma/impl/common/menu/Menu;)V", "range", "Lme/alegian/thavma/impl/common/menu/slot/SlotRange;", "getRange", "()Lme/alegian/thavma/impl/common/menu/slot/SlotRange;", "addSlots", "", "getContainerSize", "", "isEmpty", "", "getItem", "Lnet/minecraft/world/item/ItemStack;", "slot", "removeItem", "amount", "removeItemNoUpdate", "setItem", "stack", "setChanged", "stillValid", "player", "Lnet/minecraft/world/entity/player/Player;", "clearContent", "getPlayer", "()Lnet/minecraft/world/entity/player/Player;", "thavma-neoforge"})
public final class T7Inventory
implements T7Container {
    @NotNull
    private final Inventory inventory;
    @NotNull
    private final Menu menu;
    @NotNull
    private final SlotRange range;

    public T7Inventory(@NotNull Inventory inventory, @NotNull Menu menu) {
        Intrinsics.checkNotNullParameter((Object)inventory, (String)"inventory");
        Intrinsics.checkNotNullParameter((Object)((Object)menu), (String)"menu");
        this.inventory = inventory;
        this.menu = menu;
        this.range = new SlotRange(this.menu);
    }

    @Override
    @NotNull
    public SlotRange getRange() {
        return this.range;
    }

    @Override
    public void addSlots() {
        int i;
        this.getRange().start();
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.menu.addSlot(new T7Slot<Menu>(this, j + i * 9 + 9, this.menu));
            }
        }
        for (i = 0; i < 9; ++i) {
            this.menu.addSlot(new T7Slot<Menu>(this, i, this.menu));
        }
        this.getRange().end();
    }

    public int getContainerSize() {
        return this.inventory.getContainerSize();
    }

    public boolean isEmpty() {
        return this.inventory.isEmpty();
    }

    @NotNull
    public ItemStack getItem(int slot) {
        ItemStack itemStack = this.inventory.getItem(slot);
        Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"getItem(...)");
        return itemStack;
    }

    @NotNull
    public ItemStack removeItem(int slot, int amount) {
        ItemStack itemStack = this.inventory.removeItem(slot, amount);
        Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"removeItem(...)");
        return itemStack;
    }

    @NotNull
    public ItemStack removeItemNoUpdate(int slot) {
        ItemStack itemStack = this.inventory.removeItemNoUpdate(slot);
        Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"removeItemNoUpdate(...)");
        return itemStack;
    }

    public void setItem(int slot, @NotNull ItemStack stack) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        this.inventory.setItem(slot, stack);
    }

    public void setChanged() {
        this.inventory.setChanged();
    }

    public boolean stillValid(@NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        return this.inventory.stillValid(player);
    }

    public void clearContent() {
        this.inventory.clearContent();
    }

    @NotNull
    public final Player getPlayer() {
        Player player = this.inventory.player;
        Intrinsics.checkNotNullExpressionValue((Object)player, (String)"player");
        return player;
    }
}

