/*
 * Decompiled with CFR 0.152.
 */
package me.alegian.thavma.impl.client.gui.layer;

import com.mojang.blaze3d.vertex.PoseStack;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import me.alegian.thavma.impl.client.renderer.AspectRenderer;
import me.alegian.thavma.impl.client.util.GuiGraphicsExtensionsKt;
import me.alegian.thavma.impl.client.util.PoseStackExtensionsKt;
import me.alegian.thavma.impl.common.aspect.AspectHelper;
import me.alegian.thavma.impl.common.aspect.AspectMap;
import me.alegian.thavma.impl.common.item.ArcaneLensItem;
import me.alegian.thavma.impl.common.scanning.ScanHelperKt;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.LayeredDraw;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u000e"}, d2={"Lme/alegian/thavma/impl/client/gui/layer/ArcaneLensLayer;", "Lnet/minecraft/client/gui/LayeredDraw$Layer;", "<init>", "()V", "NO_ASPECTS", "", "getNO_ASPECTS", "()Ljava/lang/String;", "render", "", "graphics", "Lnet/minecraft/client/gui/GuiGraphics;", "deltaTracker", "Lnet/minecraft/client/DeltaTracker;", "thavma-neoforge"})
public final class ArcaneLensLayer
implements LayeredDraw.Layer {
    @NotNull
    public static final ArcaneLensLayer INSTANCE = new ArcaneLensLayer();
    @NotNull
    private static final String NO_ASPECTS = "gui.layer.thavma.arcane_lens.no_aspects";

    private ArcaneLensLayer() {
    }

    @NotNull
    public final String getNO_ASPECTS() {
        return NO_ASPECTS;
    }

    public void render(@NotNull GuiGraphics graphics, @NotNull DeltaTracker deltaTracker) {
        Intrinsics.checkNotNullParameter((Object)graphics, (String)"graphics");
        Intrinsics.checkNotNullParameter((Object)deltaTracker, (String)"deltaTracker");
        int width = graphics.guiWidth();
        int height = graphics.guiHeight();
        Minecraft mc = Minecraft.getInstance();
        ClientLevel clientLevel = mc.level;
        if (clientLevel == null) {
            return;
        }
        ClientLevel level = clientLevel;
        LocalPlayer localPlayer = mc.player;
        if (localPlayer == null) {
            return;
        }
        LocalPlayer player = localPlayer;
        if (!player.isHolding(ArcaneLensLayer::render$lambda$0)) {
            return;
        }
        HitResult hitResult = ScanHelperKt.getScanHitResult((Player)player);
        if (hitResult.getType() == HitResult.Type.MISS) {
            return;
        }
        Component text = null;
        Ref.ObjectRef aspects = new Ref.ObjectRef();
        HitResult hitResult2 = hitResult;
        if (hitResult2 instanceof BlockHitResult) {
            BlockState blockState = level.getBlockState(((BlockHitResult)hitResult).getBlockPos());
            Block block = blockState.getBlock();
            Intrinsics.checkNotNullExpressionValue((Object)block, (String)"getBlock(...)");
            AspectMap blockAspects = AspectHelper.INSTANCE.getAspects((ItemLike)block);
            text = (Component)Component.translatable((String)blockState.getBlock().getDescriptionId());
            Player player2 = (Player)player;
            Intrinsics.checkNotNull((Object)blockState);
            if (!ScanHelperKt.hasScanned(player2, blockState)) {
                if (blockAspects == null || blockAspects.isEmpty()) {
                    text = (Component)Component.translatable((String)NO_ASPECTS);
                }
            } else {
                aspects.element = blockAspects;
            }
        } else if (hitResult2 instanceof EntityHitResult) {
            Entity entity = ((EntityHitResult)hitResult).getEntity();
            Intrinsics.checkNotNull((Object)entity);
            AspectMap entityAspects = AspectHelper.INSTANCE.getAspects(entity);
            text = entity.getName();
            if (!ScanHelperKt.hasScanned((Player)player, entity)) {
                if (entityAspects == null || entityAspects.isEmpty()) {
                    text = (Component)Component.translatable((String)NO_ASPECTS);
                }
            } else {
                aspects.element = entityAspects;
            }
        }
        if (text == null) {
            return;
        }
        graphics.drawCenteredString(mc.font, text, width / 2, 3 * height / 8, 0xFFFFFF);
        if (aspects.element == null) {
            return;
        }
        GuiGraphicsExtensionsKt.usePose(graphics, (Function1<? super PoseStack, Unit>)((Function1)arg_0 -> ArcaneLensLayer.render$lambda$1(width, height, aspects, graphics, arg_0)));
    }

    private static final boolean render$lambda$0(ItemStack stack) {
        return stack.getItem() instanceof ArcaneLensItem;
    }

    private static final Unit render$lambda$1(int $width, int $height, Ref.ObjectRef $aspects, GuiGraphics $graphics, PoseStack $this$usePose) {
        Intrinsics.checkNotNullParameter((Object)$this$usePose, (String)"$this$usePose");
        PoseStackExtensionsKt.translateXY($this$usePose, $width / 2, 5 * $height / 8);
        PoseStackExtensionsKt.scaleXY($this$usePose, 2);
        AspectRenderer.INSTANCE.renderAspectsWrapped((AspectMap)$aspects.element, $graphics);
        return Unit.INSTANCE;
    }
}

