/*
 * Decompiled with CFR 0.152.
 */
package me.alegian.thavma.impl.client.gui.layout;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import me.alegian.thavma.impl.client.gui.layout.Align;
import me.alegian.thavma.impl.client.gui.layout.Alignment;
import me.alegian.thavma.impl.client.gui.layout.Direction;
import me.alegian.thavma.impl.client.gui.layout.LayoutInternalsKt;
import me.alegian.thavma.impl.client.gui.layout.Padding;
import me.alegian.thavma.impl.client.gui.layout.Sizing;
import me.alegian.thavma.impl.client.gui.layout.SizingMode;
import me.alegian.thavma.impl.common.util.Vec2ExtensionsKt;
import net.minecraft.world.phys.Vec2;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010!\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B1\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\r\u00104\u001a\u00020/H\u0000\u00a2\u0006\u0002\b5J\r\u00106\u001a\u00020/H\u0000\u00a2\u0006\u0002\b7J\r\u00108\u001a\u00020/H\u0000\u00a2\u0006\u0002\b9J\r\u0010:\u001a\u00020/H\u0000\u00a2\u0006\u0002\b;J\f\u0010<\u001a\u00020\u0019*\u00020\u0000H\u0002J\u001c\u0010=\u001a\u00020\t*\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010>\u001a\u00020?H\u0002R\u0014\u0010\u0002\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0004\u001a\u00020\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0006\u001a\u00020\u0007X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\b\u001a\u00020\tX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0014\u0010\n\u001a\u00020\u000bX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\"\u0010\u0018\u001a\n \u001a*\u0004\u0018\u00010\u00190\u0019X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u001c\"\u0004\b\u001d\u0010\u001eR\u0017\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00000 \u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"R\u0013\u0010#\u001a\u0004\u0018\u00010\u0000\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010%R\u001a\u0010&\u001a\u00020\u0019X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b'\u0010\u001c\"\u0004\b(\u0010\u001eR\u0014\u0010)\u001a\u00020\u00198@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b*\u0010\u001cR\u0014\u0010+\u001a\u00020\u00198@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b,\u0010\u001cR1\u0010-\u001a\u0019\u0012\u0015\u0012\u0013\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020/0.\u00a2\u0006\u0002\b00 X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b1\u0010\"\"\u0004\b2\u00103\u00a8\u0006@"}, d2={"Lme/alegian/thavma/impl/client/gui/layout/T7LayoutElement;", "", "sizing", "Lme/alegian/thavma/impl/client/gui/layout/Sizing;", "padding", "Lme/alegian/thavma/impl/client/gui/layout/Padding;", "direction", "Lme/alegian/thavma/impl/client/gui/layout/Direction;", "gap", "", "align", "Lme/alegian/thavma/impl/client/gui/layout/Align;", "<init>", "(Lme/alegian/thavma/impl/client/gui/layout/Sizing;Lme/alegian/thavma/impl/client/gui/layout/Padding;Lme/alegian/thavma/impl/client/gui/layout/Direction;FLme/alegian/thavma/impl/client/gui/layout/Align;)V", "getSizing$thavma_neoforge", "()Lme/alegian/thavma/impl/client/gui/layout/Sizing;", "getPadding$thavma_neoforge", "()Lme/alegian/thavma/impl/client/gui/layout/Padding;", "getDirection$thavma_neoforge", "()Lme/alegian/thavma/impl/client/gui/layout/Direction;", "getGap$thavma_neoforge", "()F", "getAlign$thavma_neoforge", "()Lme/alegian/thavma/impl/client/gui/layout/Align;", "position", "Lnet/minecraft/world/phys/Vec2;", "kotlin.jvm.PlatformType", "getPosition", "()Lnet/minecraft/world/phys/Vec2;", "setPosition", "(Lnet/minecraft/world/phys/Vec2;)V", "children", "", "getChildren", "()Ljava/util/List;", "parent", "getParent", "()Lme/alegian/thavma/impl/client/gui/layout/T7LayoutElement;", "size", "getSize", "setSize", "growBasis", "getGrowBasis$thavma_neoforge", "fixedMask", "getFixedMask$thavma_neoforge", "afterLayoutCallbacks", "Lkotlin/Function1;", "", "Lkotlin/ExtensionFunctionType;", "getAfterLayoutCallbacks$thavma_neoforge", "setAfterLayoutCallbacks$thavma_neoforge", "(Ljava/util/List;)V", "calculateInitialSizes", "calculateInitialSizes$thavma_neoforge", "calculateDynamicSizesRecursively", "calculateDynamicSizesRecursively$thavma_neoforge", "calculatePositionsRecursively", "calculatePositionsRecursively$thavma_neoforge", "afterLayoutRecursively", "afterLayoutRecursively$thavma_neoforge", "paddingStart", "select", "isStart", "", "thavma-neoforge"})
@SourceDebugExtension(value={"SMAP\nLayoutInternals.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LayoutInternals.kt\nme/alegian/thavma/impl/client/gui/layout/T7LayoutElement\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,223:1\n1563#2:224\n1634#2,3:225\n*S KotlinDebug\n*F\n+ 1 LayoutInternals.kt\nme/alegian/thavma/impl/client/gui/layout/T7LayoutElement\n*L\n186#1:224\n186#1:225,3\n*E\n"})
public final class T7LayoutElement {
    @NotNull
    private final Sizing sizing;
    @NotNull
    private final Padding padding;
    @NotNull
    private final Direction direction;
    private final float gap;
    @NotNull
    private final Align align;
    private Vec2 position;
    @NotNull
    private final List<T7LayoutElement> children;
    @Nullable
    private final T7LayoutElement parent;
    @NotNull
    private Vec2 size;
    @NotNull
    private List<Function1<T7LayoutElement, Unit>> afterLayoutCallbacks;

    public T7LayoutElement(@NotNull Sizing sizing, @NotNull Padding padding, @NotNull Direction direction, float gap, @NotNull Align align) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)sizing, (String)"sizing");
            Intrinsics.checkNotNullParameter((Object)padding, (String)"padding");
            Intrinsics.checkNotNullParameter((Object)((Object)direction), (String)"direction");
            Intrinsics.checkNotNullParameter((Object)align, (String)"align");
            this.sizing = sizing;
            this.padding = padding;
            this.direction = direction;
            this.gap = gap;
            this.align = align;
            this.position = Vec2.ZERO;
            this.children = new ArrayList();
            this.parent = LayoutInternalsKt.getCurrElement();
            this.size = new Vec2(this.sizing.getX().getValue$thavma_neoforge().floatValue(), this.sizing.getY().getValue$thavma_neoforge().floatValue());
            this.afterLayoutCallbacks = new ArrayList();
            Object object = this.parent;
            if (object == null || (object = ((T7LayoutElement)object).children) == null) break block0;
            object.add(this);
        }
    }

    @NotNull
    public final Sizing getSizing$thavma_neoforge() {
        return this.sizing;
    }

    @NotNull
    public final Padding getPadding$thavma_neoforge() {
        return this.padding;
    }

    @NotNull
    public final Direction getDirection$thavma_neoforge() {
        return this.direction;
    }

    public final float getGap$thavma_neoforge() {
        return this.gap;
    }

    @NotNull
    public final Align getAlign$thavma_neoforge() {
        return this.align;
    }

    public final Vec2 getPosition() {
        return this.position;
    }

    public final void setPosition(Vec2 vec2) {
        this.position = vec2;
    }

    @NotNull
    public final List<T7LayoutElement> getChildren() {
        return this.children;
    }

    @Nullable
    public final T7LayoutElement getParent() {
        return this.parent;
    }

    @NotNull
    public final Vec2 getSize() {
        return this.size;
    }

    public final void setSize(@NotNull Vec2 vec2) {
        Intrinsics.checkNotNullParameter((Object)vec2, (String)"<set-?>");
        this.size = vec2;
    }

    @NotNull
    public final Vec2 getGrowBasis$thavma_neoforge() {
        float growX = 0.0f;
        float growY = 0.0f;
        if (this.sizing.getX().getMode$thavma_neoforge() == SizingMode.GROW) {
            growX = 1.0f;
        }
        if (this.sizing.getY().getMode$thavma_neoforge() == SizingMode.GROW) {
            growY = 1.0f;
        }
        return new Vec2(growX, growY);
    }

    @NotNull
    public final Vec2 getFixedMask$thavma_neoforge() {
        float maskX = 1.0f;
        float maskY = 1.0f;
        if (this.sizing.getX().getMode$thavma_neoforge() == SizingMode.FIXED) {
            maskX = 0.0f;
        }
        if (this.sizing.getY().getMode$thavma_neoforge() == SizingMode.FIXED) {
            maskY = 0.0f;
        }
        return new Vec2(maskX, maskY);
    }

    @NotNull
    public final List<Function1<T7LayoutElement, Unit>> getAfterLayoutCallbacks$thavma_neoforge() {
        return this.afterLayoutCallbacks;
    }

    public final void setAfterLayoutCallbacks$thavma_neoforge(@NotNull List<Function1<T7LayoutElement, Unit>> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        this.afterLayoutCallbacks = list;
    }

    public final void calculateInitialSizes$thavma_neoforge() {
        Vec2 vec2 = Vec2ExtensionsKt.plus(this.size, LayoutInternalsKt.access$getAll(this.padding));
        Intrinsics.checkNotNullExpressionValue((Object)vec2, (String)"plus(...)");
        this.size = vec2;
        float childGaps = this.gap * (float)(this.children.size() - 1);
        Vec2 vec22 = Vec2ExtensionsKt.times(this.direction.getBasis(), Float.valueOf(childGaps));
        Intrinsics.checkNotNullExpressionValue((Object)vec22, (String)"times(...)");
        Vec2 vec23 = Vec2ExtensionsKt.plus(this.size, vec22);
        Intrinsics.checkNotNullExpressionValue((Object)vec23, (String)"plus(...)");
        this.size = vec23;
        if (this.parent == null) {
            return;
        }
        Vec2 mainBasis = this.parent.direction.getBasis();
        T7LayoutElement t7LayoutElement = this.parent;
        Vec2 vec24 = Vec2ExtensionsKt.plus(t7LayoutElement.size, Vec2ExtensionsKt.times(Vec2ExtensionsKt.times(this.size, mainBasis), this.parent.getFixedMask$thavma_neoforge()));
        Intrinsics.checkNotNullExpressionValue((Object)vec24, (String)"plus(...)");
        t7LayoutElement.size = vec24;
        Vec2 crossBasis = this.parent.direction.getCrossBasis();
        this.parent.size = LayoutInternalsKt.access$max(this.parent.size, Vec2ExtensionsKt.times(Vec2ExtensionsKt.times(this.size, crossBasis), this.parent.getFixedMask$thavma_neoforge()));
    }

    public final void calculateDynamicSizesRecursively$thavma_neoforge() {
        boolean canGrow;
        Vec2 mainBasis = this.direction.getBasis();
        Vec2 crossBasis = this.direction.getCrossBasis();
        Vec2 vec2 = Vec2ExtensionsKt.minus(this.size, LayoutInternalsKt.access$getAll(this.padding));
        Intrinsics.checkNotNullExpressionValue((Object)vec2, (String)"minus(...)");
        Vec2 vec22 = Vec2ExtensionsKt.times(mainBasis, Float.valueOf(this.gap * (float)(this.children.size() - 1)));
        Intrinsics.checkNotNullExpressionValue((Object)vec22, (String)"times(...)");
        Vec2 remainingSize = Vec2ExtensionsKt.minus(vec2, vec22);
        List mainGrowables = new ArrayList();
        for (T7LayoutElement child : this.children) {
            boolean bl = canGrow = !(child.getGrowBasis$thavma_neoforge().dot(mainBasis) == 0.0f);
            if (canGrow) {
                mainGrowables.add(child);
                continue;
            }
            Vec2 vec23 = remainingSize;
            Intrinsics.checkNotNull((Object)vec23);
            remainingSize = Vec2ExtensionsKt.minus(vec23, Vec2ExtensionsKt.times(child.size, mainBasis));
        }
        for (T7LayoutElement child : mainGrowables) {
            Vec2 vec24 = remainingSize;
            Intrinsics.checkNotNull((Object)vec24);
            Vec2 vec25 = Vec2ExtensionsKt.div(vec24, Float.valueOf(mainGrowables.size()));
            Intrinsics.checkNotNullExpressionValue((Object)vec25, (String)"div(...)");
            Intrinsics.checkNotNullExpressionValue((Object)Vec2ExtensionsKt.plus(Vec2ExtensionsKt.times(vec25, mainBasis), Vec2ExtensionsKt.times(child.size, crossBasis)), (String)"plus(...)");
            child.size = child.size;
        }
        for (T7LayoutElement child : this.children) {
            canGrow = !(child.getGrowBasis$thavma_neoforge().dot(crossBasis) == 0.0f);
            if (!canGrow) continue;
            Vec2 vec26 = child.size;
            Vec2 vec27 = remainingSize;
            Intrinsics.checkNotNull((Object)vec27);
            Vec2 vec28 = Vec2ExtensionsKt.minus(vec27, child.size);
            Intrinsics.checkNotNullExpressionValue((Object)vec28, (String)"minus(...)");
            Intrinsics.checkNotNullExpressionValue((Object)Vec2ExtensionsKt.plus(vec26, Vec2ExtensionsKt.times(vec28, crossBasis)), (String)"plus(...)");
            child.size = child.size;
        }
        for (T7LayoutElement child : this.children) {
            child.calculateDynamicSizesRecursively$thavma_neoforge();
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void calculatePositionsRecursively$thavma_neoforge() {
        void $this$mapTo$iv$iv;
        Vec2 vec2 = this.position;
        Intrinsics.checkNotNullExpressionValue((Object)vec2, (String)"position");
        Vec2 childPosition = Vec2ExtensionsKt.plus(vec2, Vec2ExtensionsKt.times(this.paddingStart(this), LayoutInternalsKt.access$signs(this.align, this.direction)));
        Iterable $this$map$iv = this.children;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void c;
            T7LayoutElement t7LayoutElement = (T7LayoutElement)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(Float.valueOf(c.size.dot(this.direction.getBasis())));
        }
        float childrenLength = CollectionsKt.sumOfFloat((Iterable)((List)destination$iv$iv));
        float remainingMain = Vec2ExtensionsKt.minus(this.size, LayoutInternalsKt.access$getAll(this.padding)).dot(this.direction.getBasis()) - childrenLength;
        float mainOffset = (float)Math.rint(remainingMain * LayoutInternalsKt.access$getFactor(this.align.getMain()));
        for (T7LayoutElement child : this.children) {
            Vec2 vec22 = Vec2ExtensionsKt.minus(this.size, LayoutInternalsKt.access$getAll(this.padding));
            Intrinsics.checkNotNullExpressionValue((Object)vec22, (String)"minus(...)");
            float remainingCross = Vec2ExtensionsKt.minus(vec22, child.size).dot(this.direction.getCrossBasis());
            float crossOffset = (float)Math.rint(remainingCross * LayoutInternalsKt.access$getFactor(this.align.getCross()));
            Intrinsics.checkNotNull((Object)childPosition);
            Vec2 vec23 = Vec2ExtensionsKt.times(this.direction.getBasis(), Float.valueOf(mainOffset));
            Intrinsics.checkNotNullExpressionValue((Object)vec23, (String)"times(...)");
            Vec2 vec24 = Vec2ExtensionsKt.times(this.direction.getCrossBasis(), Float.valueOf(crossOffset));
            Intrinsics.checkNotNullExpressionValue((Object)vec24, (String)"times(...)");
            Vec2 vec25 = Vec2ExtensionsKt.plus(vec23, vec24);
            Intrinsics.checkNotNullExpressionValue((Object)vec25, (String)"plus(...)");
            child.position = Vec2ExtensionsKt.plus(childPosition, vec25);
            mainOffset += (this.gap + child.size.dot(this.direction.getBasis())) * LayoutInternalsKt.access$getSign(this.align.getMain());
            child.calculatePositionsRecursively$thavma_neoforge();
        }
    }

    public final void afterLayoutRecursively$thavma_neoforge() {
        for (Function1<T7LayoutElement, Unit> callback : this.afterLayoutCallbacks) {
            callback.invoke((Object)this);
        }
        for (T7LayoutElement child : this.children) {
            child.afterLayoutRecursively$thavma_neoforge();
        }
    }

    private final Vec2 paddingStart(T7LayoutElement $this$paddingStart) {
        float mainPadding = $this$paddingStart.select($this$paddingStart.padding, $this$paddingStart.direction, $this$paddingStart.align.getMain() == Alignment.START);
        float crossPadding = $this$paddingStart.select($this$paddingStart.padding, $this$paddingStart.direction.getOpposite(), $this$paddingStart.align.getCross() == Alignment.START);
        Vec2 vec2 = Vec2ExtensionsKt.times($this$paddingStart.direction.getBasis(), Float.valueOf(mainPadding));
        Intrinsics.checkNotNullExpressionValue((Object)vec2, (String)"times(...)");
        Vec2 vec22 = Vec2ExtensionsKt.times($this$paddingStart.direction.getCrossBasis(), Float.valueOf(crossPadding));
        Intrinsics.checkNotNullExpressionValue((Object)vec22, (String)"times(...)");
        Vec2 vec23 = Vec2ExtensionsKt.plus(vec2, vec22);
        Intrinsics.checkNotNullExpressionValue((Object)vec23, (String)"plus(...)");
        return vec23;
    }

    private final float select(Padding $this$select, Direction direction, boolean isStart) {
        return direction == Direction.TOP_BOTTOM ? (isStart ? $this$select.getTop() : $this$select.getBottom()) : (isStart ? $this$select.getLeft() : $this$select.getRight());
    }
}

