/*
 * Decompiled with CFR 0.152.
 */
package me.alegian.thavma.impl.client.renderer.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import me.alegian.thavma.impl.client.renderer.RenderHelperKt;
import me.alegian.thavma.impl.common.util.PoseStackExtensionsKt;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.entity.EnderDragonRenderer;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemEntityRenderer;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.client.extensions.common.IClientItemExtensions;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J8\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00022\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0018\u0010\u0015\u001a\n \u0017*\u0004\u0018\u00010\u00160\u00162\u0006\u0010\u000b\u001a\u00020\u0002H\u0016J0\u0010\u0018\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J(\u0010\u0019\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000e\u001a\u00020\rH\u0002R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lme/alegian/thavma/impl/client/renderer/entity/FancyItemER;", "Lnet/minecraft/client/renderer/entity/EntityRenderer;", "Lnet/minecraft/world/entity/item/ItemEntity;", "pContext", "Lnet/minecraft/client/renderer/entity/EntityRendererProvider$Context;", "<init>", "(Lnet/minecraft/client/renderer/entity/EntityRendererProvider$Context;)V", "random", "Lnet/minecraft/util/RandomSource;", "render", "", "pEntity", "pEntityYaw", "", "pPartialTicks", "pPoseStack", "Lcom/mojang/blaze3d/vertex/PoseStack;", "pBuffer", "Lnet/minecraft/client/renderer/MultiBufferSource;", "pPackedLight", "", "getTextureLocation", "Lnet/minecraft/resources/ResourceLocation;", "kotlin.jvm.PlatformType", "renderItem", "renderEnderDragonRays", "thavma-neoforge"})
public final class FancyItemER
extends EntityRenderer<ItemEntity> {
    @NotNull
    private final RandomSource random;

    public FancyItemER(@NotNull EntityRendererProvider.Context pContext) {
        Intrinsics.checkNotNullParameter((Object)pContext, (String)"pContext");
        super(pContext);
        RandomSource randomSource = RandomSource.create();
        Intrinsics.checkNotNullExpressionValue((Object)randomSource, (String)"create(...)");
        this.random = randomSource;
    }

    public void render(@NotNull ItemEntity pEntity, float pEntityYaw, float pPartialTicks, @NotNull PoseStack pPoseStack, @NotNull MultiBufferSource pBuffer, int pPackedLight) {
        Intrinsics.checkNotNullParameter((Object)pEntity, (String)"pEntity");
        Intrinsics.checkNotNullParameter((Object)pPoseStack, (String)"pPoseStack");
        Intrinsics.checkNotNullParameter((Object)pBuffer, (String)"pBuffer");
        PoseStackExtensionsKt.use(pPoseStack, (Function1<? super PoseStack, Unit>)((Function1)arg_0 -> FancyItemER.render$lambda$0(this, pEntity, pPoseStack, pBuffer, pPartialTicks, pPackedLight, arg_0)));
        super.render((Entity)pEntity, pEntityYaw, pPartialTicks, pPoseStack, pBuffer, pPackedLight);
    }

    public ResourceLocation getTextureLocation(@NotNull ItemEntity pEntity) {
        Intrinsics.checkNotNullParameter((Object)pEntity, (String)"pEntity");
        return InventoryMenu.BLOCK_ATLAS;
    }

    private final void renderItem(ItemEntity pEntity, PoseStack pPoseStack, MultiBufferSource pBuffer, float pPartialTicks, int pPackedLight) {
        ItemRenderer itemRenderer = Minecraft.getInstance().getItemRenderer();
        ItemStack stack = pEntity.getItem();
        this.random.setSeed((long)ItemEntityRenderer.getSeedForItemStack((ItemStack)stack));
        BakedModel bakedModel = itemRenderer.getModel(stack, pEntity.level(), null, pEntity.getId());
        boolean flag = bakedModel.isGui3d();
        boolean shouldBob = IClientItemExtensions.of((ItemStack)stack).shouldBobAsEntity(stack);
        float bobOffset = shouldBob ? Mth.sin((float)(((float)pEntity.getAge() + pPartialTicks) / 10.0f + pEntity.bobOffs)) * 0.1f + 0.1f : 0.0f;
        float scale = ItemTransforms.NO_TRANSFORMS.getTransform((ItemDisplayContext)ItemDisplayContext.GROUND).scale.y();
        pPoseStack.translate(0.0f, bobOffset + 0.25f * scale, 0.0f);
        Vec3 vec3 = pEntity.getEyePosition();
        Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"getEyePosition(...)");
        float angle = RenderHelperKt.calculatePlayerAngle(vec3);
        pPoseStack.mulPose(Axis.YP.rotation(angle));
        ItemEntityRenderer.renderMultipleFromCount((ItemRenderer)itemRenderer, (PoseStack)pPoseStack, (MultiBufferSource)pBuffer, (int)pPackedLight, (ItemStack)stack, (BakedModel)bakedModel, (boolean)flag, (RandomSource)this.random);
        pPoseStack.translate(0.0f, 0.0f, -0.5f);
        pPoseStack.mulPose(Axis.YP.rotation(-angle));
    }

    private final void renderEnderDragonRays(ItemEntity pEntity, PoseStack pPoseStack, MultiBufferSource pBuffer, float pPartialTicks) {
        float spin = pEntity.getSpin(pPartialTicks);
        pPoseStack.mulPose(Axis.YP.rotation(spin));
        pPoseStack.scale(0.1f, 0.1f, 0.1f);
        EnderDragonRenderer.renderRays((PoseStack)pPoseStack, (float)0.7f, (VertexConsumer)pBuffer.getBuffer(RenderType.dragonRays()));
        EnderDragonRenderer.renderRays((PoseStack)pPoseStack, (float)0.7f, (VertexConsumer)pBuffer.getBuffer(RenderType.dragonRaysDepth()));
    }

    private static final Unit render$lambda$0(FancyItemER this$0, ItemEntity $pEntity, PoseStack $pPoseStack, MultiBufferSource $pBuffer, float $pPartialTicks, int $pPackedLight, PoseStack $this$use) {
        Intrinsics.checkNotNullParameter((Object)$this$use, (String)"$this$use");
        this$0.renderItem($pEntity, $pPoseStack, $pBuffer, $pPartialTicks, $pPackedLight);
        this$0.renderEnderDragonRays($pEntity, $pPoseStack, $pBuffer, $pPartialTicks);
        return Unit.INSTANCE;
    }
}

