/*
 * Decompiled with CFR 0.152.
 */
package me.alegian.thavma.impl.common.block;

import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import me.alegian.thavma.impl.common.block.ArcaneLevitatorBlock;
import me.alegian.thavma.impl.common.block.entity.LevitatorColumnBE;
import me.alegian.thavma.impl.common.util.LevelExtensionsKt;
import me.alegian.thavma.impl.init.registries.deferred.T7Attachments;
import me.alegian.thavma.impl.init.registries.deferred.T7BlockEntities;
import me.alegian.thavma.impl.init.registries.deferred.T7Blocks;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 &2\u00020\u00012\u00020\u0002:\u0001&B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J(\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0014J(\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00102\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\u0012H\u0014J \u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00152\u0006\u0010\u000b\u001a\u00020\fH\u0014J8\u0010\u0016\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u001a2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u001b\u001a\u00020\fH\u0014J0\u0010\u001c\u001a\n \u001e*\u0004\u0018\u00010\u001d0\u001d2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u001f2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010 \u001a\u00020!H\u0014J\u0010\u0010\"\u001a\u00020#2\u0006\u0010\u0007\u001a\u00020\bH\u0014J\u0018\u0010$\u001a\u00020%2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006'"}, d2={"Lme/alegian/thavma/impl/common/block/LevitatorColumnBlock;", "Lnet/minecraft/world/level/block/Block;", "Lnet/minecraft/world/level/block/EntityBlock;", "<init>", "()V", "entityInside", "", "state", "Lnet/minecraft/world/level/block/state/BlockState;", "level", "Lnet/minecraft/world/level/Level;", "pos", "Lnet/minecraft/core/BlockPos;", "entity", "Lnet/minecraft/world/entity/Entity;", "tick", "Lnet/minecraft/server/level/ServerLevel;", "random", "Lnet/minecraft/util/RandomSource;", "canSurvive", "", "Lnet/minecraft/world/level/LevelReader;", "updateShape", "direction", "Lnet/minecraft/core/Direction;", "neighborState", "Lnet/minecraft/world/level/LevelAccessor;", "neighborPos", "getShape", "Lnet/minecraft/world/phys/shapes/VoxelShape;", "kotlin.jvm.PlatformType", "Lnet/minecraft/world/level/BlockGetter;", "context", "Lnet/minecraft/world/phys/shapes/CollisionContext;", "getRenderShape", "Lnet/minecraft/world/level/block/RenderShape;", "newBlockEntity", "Lme/alegian/thavma/impl/common/block/entity/LevitatorColumnBE;", "Companion", "thavma-neoforge"})
public final class LevitatorColumnBlock
extends Block
implements EntityBlock {
    @NotNull
    public static final Companion Companion = new Companion(null);

    public LevitatorColumnBlock() {
        super(BlockBehaviour.Properties.of().noCollission().replaceable().noLootTable().pushReaction(PushReaction.DESTROY).sound(SoundType.EMPTY));
    }

    protected void entityInside(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull Entity entity) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        Vec3 oldSpeed = entity.getDeltaMovement();
        double newSpeedY = entity.isCrouching() ? Math.max(-0.4, oldSpeed.y - 0.04) : Math.max(0.4, oldSpeed.y + 0.04);
        entity.setDeltaMovement(oldSpeed.x, newSpeedY, oldSpeed.z);
        entity.setData((Supplier)T7Attachments.INSTANCE.getLEVITATES(), (Object)true);
    }

    protected void tick(@NotNull BlockState state, @NotNull ServerLevel level, @NotNull BlockPos pos, @NotNull RandomSource random) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)state, (String)"state");
            Intrinsics.checkNotNullParameter((Object)level, (String)"level");
            Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
            Intrinsics.checkNotNullParameter((Object)random, (String)"random");
            Level level2 = (Level)level;
            Object object = T7BlockEntities.INSTANCE.getLEVITATOR_COLUMN().get();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
            LevitatorColumnBE levitatorColumnBE = (LevitatorColumnBE)((Object)LevelExtensionsKt.getBE(level2, pos, (BlockEntityType)object));
            if (levitatorColumnBE == null) break block0;
            int it = levitatorColumnBE.getLevitatorY();
            boolean bl = false;
            Companion.setAndExpand(level, pos, it);
        }
    }

    protected boolean canSurvive(@NotNull BlockState state, @NotNull LevelReader level, @NotNull BlockPos pos) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Block belowBlock = level.getBlockState(pos.below()).getBlock();
        return belowBlock instanceof ArcaneLevitatorBlock || belowBlock instanceof LevitatorColumnBlock;
    }

    @NotNull
    protected BlockState updateShape(@NotNull BlockState state, @NotNull Direction direction, @NotNull BlockState neighborState, @NotNull LevelAccessor level, @NotNull BlockPos pos, @NotNull BlockPos neighborPos) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)direction, (String)"direction");
        Intrinsics.checkNotNullParameter((Object)neighborState, (String)"neighborState");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)neighborPos, (String)"neighborPos");
        if (!state.canSurvive((LevelReader)level, pos) || direction == Direction.UP && !(neighborState.getBlock() instanceof LevitatorColumnBlock) && Companion.canExistIn(neighborState)) {
            level.scheduleTick(pos, (Block)this, 5);
        }
        BlockState blockState = super.updateShape(state, direction, neighborState, level, pos, neighborPos);
        Intrinsics.checkNotNullExpressionValue((Object)blockState, (String)"updateShape(...)");
        return blockState;
    }

    protected VoxelShape getShape(@NotNull BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return Shapes.empty();
    }

    @NotNull
    protected RenderShape getRenderShape(@NotNull BlockState state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        return RenderShape.INVISIBLE;
    }

    @NotNull
    public LevitatorColumnBE newBlockEntity(@NotNull BlockPos pos, @NotNull BlockState state) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        return new LevitatorColumnBE(pos, state);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u001e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f\u00a8\u0006\u0010"}, d2={"Lme/alegian/thavma/impl/common/block/LevitatorColumnBlock$Companion;", "", "<init>", "()V", "canExistIn", "", "blockState", "Lnet/minecraft/world/level/block/state/BlockState;", "setAndExpand", "", "level", "Lnet/minecraft/server/level/ServerLevel;", "pos", "Lnet/minecraft/core/BlockPos;", "levitatorY", "", "thavma-neoforge"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean canExistIn(@NotNull BlockState blockState) {
            Intrinsics.checkNotNullParameter((Object)blockState, (String)"blockState");
            return blockState.getBlock() instanceof LevitatorColumnBlock || blockState.isAir();
        }

        public final void setAndExpand(@NotNull ServerLevel level, @NotNull BlockPos pos, int levitatorY) {
            Intrinsics.checkNotNullParameter((Object)level, (String)"level");
            Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
            BlockState currentState = level.getBlockState(pos);
            Intrinsics.checkNotNull((Object)currentState);
            if (this.canExistIn(currentState)) {
                BlockState newState = ((LevitatorColumnBlock)((Object)T7Blocks.INSTANCE.getLEVITATOR_COLUMN().get())).defaultBlockState();
                if (!currentState.canSurvive((LevelReader)level, pos)) {
                    newState = Blocks.AIR.defaultBlockState();
                }
                level.setBlock(pos, newState, 2);
                BlockPos.MutableBlockPos newPos = pos.mutable().move(Direction.UP);
                while (true) {
                    BlockState blockState = level.getBlockState((BlockPos)newPos);
                    Intrinsics.checkNotNullExpressionValue((Object)blockState, (String)"getBlockState(...)");
                    if (!this.canExistIn(blockState) || newPos.getY() - levitatorY > 16) break;
                    level.setBlock((BlockPos)newPos, newState, 2);
                    Level level2 = (Level)level;
                    BlockPos blockPos = (BlockPos)newPos;
                    Object object = T7BlockEntities.INSTANCE.getLEVITATOR_COLUMN().get();
                    Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
                    if ((LevitatorColumnBE)((Object)LevelExtensionsKt.getBE(level2, blockPos, (BlockEntityType)object)) != null) {
                        LevitatorColumnBE it;
                        boolean bl = false;
                        it.setLevitatorY(levitatorY);
                    }
                    newPos.move(Direction.UP);
                }
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

