/*
 * Decompiled with CFR 0.152.
 */
package me.alegian.thavma.impl.common.block.entity;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import me.alegian.thavma.impl.common.aspect.AspectMap;
import me.alegian.thavma.impl.common.aspect.AspectStack;
import me.alegian.thavma.impl.common.block.entity.DataComponentBE;
import me.alegian.thavma.impl.common.data.capability.AspectContainer;
import me.alegian.thavma.impl.common.data.capability.IAspectContainer;
import me.alegian.thavma.impl.common.util.LevelExtensionsKt;
import me.alegian.thavma.impl.init.registries.T7Registries;
import me.alegian.thavma.impl.init.registries.deferred.T7BlockEntities;
import me.alegian.thavma.impl.init.registries.deferred.T7Items;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.SlabType;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.registries.DeferredItem;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aB\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u0013\u001a\u00020\u0012H\u0002J\b\u0010\u0014\u001a\u00020\u0012H\u0002J\u0006\u0010\u0015\u001a\u00020\u0016J\u0006\u0010\u0017\u001a\u00020\u0012J\u0006\u0010\u0018\u001a\u00020\u0012J\u0006\u0010\u0019\u001a\u00020\u0012R\u001e\u0010\b\u001a\u0012\u0012\u0004\u0012\u00020\u00030\tj\b\u0012\u0004\u0012\u00020\u0003`\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u000b\u001a\u0012\u0012\u0004\u0012\u00020\u00030\tj\b\u0012\u0004\u0012\u00020\u0003`\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u000e\u001a\u00020\r2\u0006\u0010\f\u001a\u00020\r@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u001b"}, d2={"Lme/alegian/thavma/impl/common/block/entity/AuraNodeBE;", "Lme/alegian/thavma/impl/common/block/entity/DataComponentBE;", "pos", "Lnet/minecraft/core/BlockPos;", "blockState", "Lnet/minecraft/world/level/block/state/BlockState;", "<init>", "(Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;)V", "glassPositions", "Ljava/util/ArrayList;", "Lkotlin/collections/ArrayList;", "slabPositions", "value", "", "containingCountdown", "getContainingCountdown", "()I", "onLoad", "", "generateGlassPositions", "generateSlabPositions", "jarInteraction", "", "contain", "decrementContainingCountdown", "dropItems", "Companion", "thavma-neoforge"})
@SourceDebugExtension(value={"SMAP\nAuraNodeBE.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AuraNodeBE.kt\nme/alegian/thavma/impl/common/block/entity/AuraNodeBE\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,144:1\n1#2:145\n*E\n"})
public final class AuraNodeBE
extends DataComponentBE {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ArrayList<BlockPos> glassPositions;
    @NotNull
    private final ArrayList<BlockPos> slabPositions;
    private int containingCountdown;
    public static final int MAX_ASPECTS = 32;
    public static final int MAX_COUNTDOWN = 60;

    public AuraNodeBE(@NotNull BlockPos pos, @NotNull BlockState blockState) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)blockState, (String)"blockState");
        Object object = T7BlockEntities.INSTANCE.getAURA_NODE().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        super((BlockEntityType)object, pos, blockState);
        this.glassPositions = new ArrayList();
        this.slabPositions = new ArrayList();
        this.containingCountdown = -1;
        this.generateGlassPositions();
        this.generateSlabPositions();
    }

    public final int getContainingCountdown() {
        return this.containingCountdown;
    }

    public void onLoad() {
        block3: {
            Level level = this.level;
            if (level == null) break block3;
            Level $this$onLoad_u24lambda_u241 = level;
            boolean bl = false;
            if (!$this$onLoad_u24lambda_u241.isClientSide() && $this$onLoad_u24lambda_u241 instanceof ServerLevel) {
                BlockPos blockPos = this.getBlockPos();
                Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"getBlockPos(...)");
                IAspectContainer iAspectContainer = AspectContainer.Companion.at($this$onLoad_u24lambda_u241, blockPos);
                if (iAspectContainer != null) {
                    IAspectContainer $this$onLoad_u24lambda_u241_u24lambda_u240 = iAspectContainer;
                    boolean bl2 = false;
                    if ($this$onLoad_u24lambda_u241_u24lambda_u240.areAspectsNull()) {
                        $this$onLoad_u24lambda_u241_u24lambda_u240.setAspects(AspectMap.Companion.randomPrimals(32));
                    }
                }
                ServerLevel serverLevel = (ServerLevel)$this$onLoad_u24lambda_u241;
                BlockPos blockPos2 = this.getBlockPos();
                Intrinsics.checkNotNullExpressionValue((Object)blockPos2, (String)"getBlockPos(...)");
                LevelExtensionsKt.updateBlockEntityS2C(serverLevel, blockPos2);
            }
        }
    }

    private final void generateGlassPositions() {
        for (int i = -1; i < 2; ++i) {
            for (int j = -1; j < 2; ++j) {
                for (int k = -1; k < 2; ++k) {
                    if (i == 0 && j == 0 && k == 0) continue;
                    this.glassPositions.add(this.getBlockPos().offset(i, j, k));
                }
            }
        }
    }

    private final void generateSlabPositions() {
        for (int i = -1; i < 2; ++i) {
            for (int j = -1; j < 2; ++j) {
                this.slabPositions.add(this.getBlockPos().offset(i, 2, j));
            }
        }
    }

    public final boolean jarInteraction() {
        Level level = this.level;
        if (level != null) {
            BlockPos pos;
            Level level2 = level;
            boolean bl = false;
            Iterator<BlockPos> iterator = this.glassPositions.iterator();
            Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
            Iterator<BlockPos> iterator2 = iterator;
            while (iterator2.hasNext()) {
                pos = iterator2.next();
                if (level2.getBlockState(pos).is(Tags.Blocks.GLASS_BLOCKS)) continue;
                return false;
            }
            Iterator<BlockPos> iterator3 = this.slabPositions.iterator();
            Intrinsics.checkNotNullExpressionValue(iterator3, (String)"iterator(...)");
            iterator2 = iterator3;
            while (iterator2.hasNext()) {
                pos = iterator2.next();
                BlockState blockState = level2.getBlockState(pos);
                if (blockState.is(BlockTags.WOODEN_SLABS) && blockState.getValue((Property)BlockStateProperties.SLAB_TYPE) == SlabType.BOTTOM) continue;
                return false;
            }
            if (!level2.isClientSide() && level2 instanceof ServerLevel) {
                Iterator<BlockPos> iterator4 = this.glassPositions.iterator();
                Intrinsics.checkNotNullExpressionValue(iterator4, (String)"iterator(...)");
                iterator2 = iterator4;
                while (iterator2.hasNext()) {
                    pos = iterator2.next();
                    ((ServerLevel)level2).removeBlock(pos, false);
                }
                Iterator<BlockPos> iterator5 = this.slabPositions.iterator();
                Intrinsics.checkNotNullExpressionValue(iterator5, (String)"iterator(...)");
                iterator2 = iterator5;
                while (iterator2.hasNext()) {
                    pos = iterator2.next();
                    ((ServerLevel)level2).removeBlock(pos, false);
                }
            }
            this.containingCountdown = 60;
            return true;
        }
        return false;
    }

    public final void contain() {
        block1: {
            this.containingCountdown = -1;
            Level level = this.level;
            if (level == null) break block1;
            Level it = level;
            boolean bl = false;
            ItemEntity itemEntity = new ItemEntity(it, (double)this.getBlockPos().getX() + 0.5, (double)this.getBlockPos().getY() + 0.5, (double)this.getBlockPos().getZ() + 0.5, T7Items.INSTANCE.getNODE_JAR().toStack());
            BlockPos blockPos = this.getBlockPos();
            Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"getBlockPos(...)");
            ItemStack itemStack = itemEntity.getItem();
            Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"getItem(...)");
            AspectContainer.Pair pair = AspectContainer.Companion.blockSourceItemSink(it, blockPos, itemStack);
            if (pair != null) {
                pair.transferAllAspects();
            }
            it.removeBlock(this.getBlockPos(), false);
            it.addFreshEntity((Entity)itemEntity);
        }
    }

    public final void decrementContainingCountdown() {
        int n = this.containingCountdown;
        this.containingCountdown = n + -1;
    }

    public final void dropItems() {
        block2: {
            IAspectContainer iAspectContainer = AspectContainer.Companion.from(this);
            if (iAspectContainer == null) break block2;
            IAspectContainer it = iAspectContainer;
            boolean bl = false;
            SimpleContainer container = new SimpleContainer(it.getAspects().getSize());
            for (AspectStack stack : it.getAspects().scale(0.25)) {
                Holder deferredAspect = T7Registries.INSTANCE.getASPECT().wrapAsHolder((Object)stack.getAspect());
                DeferredItem deferredItem = (DeferredItem)((Map)T7Items.INSTANCE.getSHARDS()).get(deferredAspect);
                if (deferredItem == null || (deferredItem = deferredItem.toStack(Math.min(stack.getAmount(), 64))) == null) continue;
                DeferredItem p0 = deferredItem;
                boolean bl2 = false;
                container.addItem((ItemStack)p0);
            }
            Level level = this.level;
            if (level != null) {
                Level it2 = level;
                boolean bl3 = false;
                Containers.dropContents((Level)it2, (BlockPos)this.getBlockPos(), (Container)((Container)container));
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J,\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u0010R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lme/alegian/thavma/impl/common/block/entity/AuraNodeBE$Companion;", "", "<init>", "()V", "MAX_ASPECTS", "", "MAX_COUNTDOWN", "tick", "", "level", "Lnet/minecraft/world/level/Level;", "pos", "Lnet/minecraft/core/BlockPos;", "state", "Lnet/minecraft/world/level/block/state/BlockState;", "blockEntity", "Lme/alegian/thavma/impl/common/block/entity/AuraNodeBE;", "thavma-neoforge"})
    public static final class Companion {
        private Companion() {
        }

        public final void tick(@Nullable Level level, @Nullable BlockPos pos, @Nullable BlockState state, @NotNull AuraNodeBE blockEntity) {
            Intrinsics.checkNotNullParameter((Object)((Object)blockEntity), (String)"blockEntity");
            int countdown = blockEntity.getContainingCountdown();
            if (countdown == 0) {
                blockEntity.contain();
            } else if (countdown > 0) {
                blockEntity.decrementContainingCountdown();
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

