/*
 * Decompiled with CFR 0.152.
 */
package me.alegian.thavma.impl.common.entity;

import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import me.alegian.thavma.impl.common.aspect.AspectStack;
import me.alegian.thavma.impl.common.data.capability.AspectContainer;
import me.alegian.thavma.impl.common.entity.RendererEntity;
import me.alegian.thavma.impl.common.util.LevelExtensionsKt;
import me.alegian.thavma.impl.init.registries.deferred.Aspects;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.server.level.ServerEntity;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\f\u001a\u00020\rH\u0016J\u0012\u0010\u000e\u001a\u00020\r2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0002J\u0010\u0010\u0013\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\u0015H\u0014J\u0010\u0010\u0016\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\u0015H\u0014J\u0010\u0010\u0017\u001a\u00020\r2\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0016\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001b2\u0006\u0010\u0018\u001a\u00020\u001dH\u0016J\u0010\u0010\u001e\u001a\u00020\r2\u0006\u0010\u001f\u001a\u00020 H\u0016R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006!"}, d2={"Lme/alegian/thavma/impl/common/entity/VisEntity;", "Lme/alegian/thavma/impl/common/entity/RendererEntity;", "pLevel", "Lnet/minecraft/world/level/Level;", "player", "Lnet/minecraft/world/entity/player/Player;", "blockPos", "Lnet/minecraft/core/BlockPos;", "<init>", "(Lnet/minecraft/world/level/Level;Lnet/minecraft/world/entity/player/Player;Lnet/minecraft/core/BlockPos;)V", "playerUUID", "Ljava/util/UUID;", "tick", "", "serverTick", "pair", "Lme/alegian/thavma/impl/common/data/capability/AspectContainer$Pair;", "getPlayer", "()Lnet/minecraft/world/entity/player/Player;", "readAdditionalSaveData", "pCompound", "Lnet/minecraft/nbt/CompoundTag;", "addAdditionalSaveData", "restoreFrom", "pEntity", "Lnet/minecraft/world/entity/Entity;", "getAddEntityPacket", "Lnet/minecraft/network/protocol/Packet;", "Lnet/minecraft/network/protocol/game/ClientGamePacketListener;", "Lnet/minecraft/server/level/ServerEntity;", "recreateFromPacket", "pPacket", "Lnet/minecraft/network/protocol/game/ClientboundAddEntityPacket;", "thavma-neoforge"})
@SourceDebugExtension(value={"SMAP\nVisEntity.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VisEntity.kt\nme/alegian/thavma/impl/common/entity/VisEntity\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,88:1\n1#2:89\n*E\n"})
public final class VisEntity
extends RendererEntity {
    @Nullable
    private UUID playerUUID;

    public VisEntity(@NotNull Level pLevel, @Nullable Player player, @NotNull BlockPos blockPos) {
        Intrinsics.checkNotNullParameter((Object)pLevel, (String)"pLevel");
        Intrinsics.checkNotNullParameter((Object)blockPos, (String)"blockPos");
        Vec3 vec3 = blockPos.getCenter();
        Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"getCenter(...)");
        super(pLevel, vec3);
        if (player != null) {
            this.playerUUID = player.getUUID();
        }
    }

    public /* synthetic */ VisEntity(Level level, Player player, BlockPos blockPos, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            blockPos = new BlockPos(0, 0, 0);
        }
        this(level, player, blockPos);
    }

    @Override
    public void tick() {
        if (this.tickCount % 4 != 0) {
            return;
        }
        AspectContainer.Pair transferPair = null;
        Player player = this.getPlayer();
        if (player != null) {
            boolean canTransfer;
            Player it = player;
            boolean bl = false;
            Level level = this.level();
            Intrinsics.checkNotNullExpressionValue((Object)level, (String)"level(...)");
            BlockPos blockPos = this.blockPosition();
            Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"blockPosition(...)");
            ItemStack itemStack = it.getUseItem();
            Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"getUseItem(...)");
            AspectContainer.Pair pair = transferPair = AspectContainer.Companion.blockSourceItemSink(level, blockPos, itemStack);
            boolean bl2 = canTransfer = pair != null ? pair.canTransferPrimals() : false;
            if (!canTransfer) {
                it.stopUsingItem();
            }
        }
        this.serverTick(transferPair);
    }

    private final void serverTick(AspectContainer.Pair pair) {
        Level level = this.level();
        if (level == null) {
            return;
        }
        Level level2 = level;
        if (level2.isClientSide() || !(level2 instanceof ServerLevel)) {
            return;
        }
        Player currPlayer = this.getPlayer();
        if (currPlayer == null || !currPlayer.isUsingItem() || pair == null) {
            this.kill();
            return;
        }
        AspectStack transferred = pair.transferPrimal(this.tickCount / 4 % Aspects.INSTANCE.getPRIMAL_ASPECTS().size(), 1);
        if (transferred != null && transferred.getAmount() > 0) {
            ServerLevel serverLevel = (ServerLevel)level2;
            BlockPos blockPos = this.blockPosition();
            Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"blockPosition(...)");
            LevelExtensionsKt.updateBlockEntityS2C(serverLevel, blockPos);
        }
    }

    @Nullable
    public final Player getPlayer() {
        Player player;
        UUID uUID = this.playerUUID;
        if (uUID != null) {
            UUID it = uUID;
            boolean bl = false;
            player = this.level().getPlayerByUUID(it);
        } else {
            player = null;
        }
        return player;
    }

    protected void readAdditionalSaveData(@NotNull CompoundTag pCompound) {
        Intrinsics.checkNotNullParameter((Object)pCompound, (String)"pCompound");
        if (pCompound.hasUUID("player")) {
            this.playerUUID = pCompound.getUUID("player");
        }
    }

    protected void addAdditionalSaveData(@NotNull CompoundTag pCompound) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)pCompound, (String)"pCompound");
            UUID uUID = this.playerUUID;
            if (uUID == null) break block0;
            UUID it = uUID;
            boolean bl = false;
            pCompound.putUUID("player", it);
        }
    }

    public void restoreFrom(@NotNull Entity pEntity) {
        Intrinsics.checkNotNullParameter((Object)pEntity, (String)"pEntity");
        super.restoreFrom(pEntity);
        this.playerUUID = ((VisEntity)pEntity).playerUUID;
    }

    @NotNull
    public Packet<ClientGamePacketListener> getAddEntityPacket(@NotNull ServerEntity pEntity) {
        Intrinsics.checkNotNullParameter((Object)pEntity, (String)"pEntity");
        Player player = this.getPlayer();
        Player player2 = player;
        return (Packet)new ClientboundAddEntityPacket((Entity)this, pEntity, player2 != null ? player2.getId() : 0);
    }

    public void recreateFromPacket(@NotNull ClientboundAddEntityPacket pPacket) {
        Intrinsics.checkNotNullParameter((Object)pPacket, (String)"pPacket");
        super.recreateFromPacket(pPacket);
        Entity entity = this.level().getEntity(pPacket.getData());
        if (entity instanceof Player) {
            this.playerUUID = ((Player)entity).getUUID();
        }
    }
}

