/*
 * Decompiled with CFR 0.152.
 */
package me.alegian.thavma.impl.common.event;

import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import me.alegian.thavma.impl.common.enchantment.ShriekResistance;
import me.alegian.thavma.impl.common.entity.EntityHelperKt;
import me.alegian.thavma.impl.common.item.EnderpearlFocus;
import me.alegian.thavma.impl.common.level.Exchanging;
import me.alegian.thavma.impl.common.level.TreeFelling;
import me.alegian.thavma.impl.init.registries.T7AttributeModifiers;
import me.alegian.thavma.impl.init.registries.deferred.T7Attachments;
import me.alegian.thavma.impl.init.registries.deferred.T7Items;
import me.alegian.thavma.impl.integration.curios.CuriosIntegration;
import net.minecraft.core.registries.Registries;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;
import net.neoforged.neoforge.event.entity.living.LivingFallEvent;
import net.neoforged.neoforge.event.entity.living.MobEffectEvent;
import net.neoforged.neoforge.event.tick.EntityTickEvent;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000(\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u001a\u0010\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0005H\u0002\u001a\u0010\u0010\u0006\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0007H\u0002\u001a\u0010\u0010\b\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\tH\u0002\u001a\u000e\u0010\n\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u000b\u001a\u0006\u0010\f\u001a\u00020\u0001\u00a8\u0006\r"}, d2={"entityTickPre", "", "event", "Lnet/neoforged/neoforge/event/tick/EntityTickEvent$Pre;", "livingDamagePost", "Lnet/neoforged/neoforge/event/entity/living/LivingDamageEvent$Post;", "mobEffectApplicable", "Lnet/neoforged/neoforge/event/entity/living/MobEffectEvent$Applicable;", "preLivingDamage", "Lnet/neoforged/neoforge/event/entity/living/LivingDamageEvent$Pre;", "entityFall", "Lnet/neoforged/neoforge/event/entity/living/LivingFallEvent;", "registerCommonGameEvents", "thavma-neoforge"})
@SourceDebugExtension(value={"SMAP\nT7CommonGameEvents.kt\nKotlin\n*S Kotlin\n*F\n+ 1 T7CommonGameEvents.kt\nme/alegian/thavma/impl/common/event/T7CommonGameEventsKt\n+ 2 Forge.kt\nthedarkcolour/kotlinforforge/neoforge/forge/ForgeKt\n*L\n1#1,107:1\n17#2:108\n17#2:109\n17#2:110\n17#2:111\n17#2:112\n17#2:113\n17#2:114\n17#2:115\n17#2:116\n*S KotlinDebug\n*F\n+ 1 T7CommonGameEvents.kt\nme/alegian/thavma/impl/common/event/T7CommonGameEventsKt\n*L\n98#1:108\n99#1:109\n100#1:110\n101#1:111\n102#1:112\n103#1:113\n104#1:114\n105#1:115\n106#1:116\n*E\n"})
public final class T7CommonGameEventsKt {
    private static final void entityTickPre(EntityTickEvent.Pre event) {
        boolean hasStepHeightFromOtherModifier;
        Entity livingEntity = event.getEntity();
        if (!(livingEntity instanceof LivingEntity)) {
            return;
        }
        AttributeInstance attributeInstance = ((LivingEntity)livingEntity).getAttribute(Attributes.STEP_HEIGHT);
        if (attributeInstance == null) {
            return;
        }
        AttributeInstance attribute = attributeInstance;
        boolean bl = hasStepHeightFromOtherModifier = attribute.getValue() >= 1.0 && !attribute.hasModifier(T7AttributeModifiers.StepHeight.INSTANCE.getLOCATION());
        if (!EntityHelperKt.isWearingStepHeightBoots((LivingEntity)livingEntity) || hasStepHeightFromOtherModifier || ((LivingEntity)livingEntity).isCrouching()) {
            attribute.removeModifier(T7AttributeModifiers.StepHeight.INSTANCE.getMODIFIER());
        } else {
            attribute.addOrUpdateTransientModifier(T7AttributeModifiers.StepHeight.INSTANCE.getMODIFIER());
        }
    }

    private static final void livingDamagePost(LivingDamageEvent.Post event) {
        ItemStack itemStack = event.getSource().getWeaponItem();
        if (itemStack == null) {
            return;
        }
        ItemStack itemStack2 = itemStack;
        if (!Intrinsics.areEqual((Object)itemStack2.getItem(), (Object)T7Items.INSTANCE.getTHAVMITE_KATANA().get())) {
            return;
        }
        LivingEntity entity = event.getEntity();
        if (entity.getHealth() <= 10.0f) {
            entity.kill();
            Entity serverPlayer = event.getSource().getEntity();
            if (!(serverPlayer instanceof ServerPlayer)) {
                return;
            }
            entity.level().playSound(null, ((ServerPlayer)serverPlayer).blockPosition(), SoundEvents.ENDER_DRAGON_GROWL, SoundSource.PLAYERS, 0.1f, 2.0f);
        }
    }

    private static final void mobEffectApplicable(MobEffectEvent.Applicable event) {
        MobEffectInstance mobEffectInstance = event.getEffectInstance();
        if (mobEffectInstance == null) {
            return;
        }
        MobEffectInstance effectInstance = mobEffectInstance;
        if (effectInstance.getEffect().value() != MobEffects.DARKNESS.value()) {
            return;
        }
        CuriosIntegration curiosIntegration = CuriosIntegration.Companion.get();
        LivingEntity livingEntity = event.getEntity();
        Intrinsics.checkNotNullExpressionValue((Object)livingEntity, (String)"getEntity(...)");
        Object object = T7Items.INSTANCE.getDAWN_CHARM().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        if (!curiosIntegration.isWearingCurio(livingEntity, (Item)object)) {
            return;
        }
        event.setResult(MobEffectEvent.Applicable.Result.DO_NOT_APPLY);
    }

    private static final void preLivingDamage(LivingDamageEvent.Pre event) {
        Level serverLevel = event.getEntity().level();
        if (!(serverLevel instanceof ServerLevel)) {
            return;
        }
        DamageType sonicType = (DamageType)((ServerLevel)serverLevel).registryAccess().registryOrThrow(Registries.DAMAGE_TYPE).get(DamageTypes.SONIC_BOOM);
        if (!Intrinsics.areEqual((Object)event.getSource().type(), (Object)sonicType)) {
            return;
        }
        ServerLevel serverLevel2 = (ServerLevel)serverLevel;
        LivingEntity livingEntity = event.getEntity();
        Intrinsics.checkNotNullExpressionValue((Object)livingEntity, (String)"getEntity(...)");
        DamageSource damageSource = event.getSource();
        Intrinsics.checkNotNullExpressionValue((Object)damageSource, (String)"getSource(...)");
        float damageBlocked = ShriekResistance.INSTANCE.getDamageProtection(serverLevel2, livingEntity, damageSource);
        if (damageBlocked <= 0.0f) {
            return;
        }
        event.getContainer().setNewDamage((float)Math.max(0.0, (double)(event.getNewDamage() - damageBlocked)));
    }

    public static final void entityFall(@NotNull LivingFallEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Boolean levitates = (Boolean)event.getEntity().getData((Supplier)T7Attachments.INSTANCE.getLEVITATES());
        if (!levitates.booleanValue()) {
            return;
        }
        event.setCanceled(true);
        event.getEntity().setData((Supplier)T7Attachments.INSTANCE.getLEVITATES(), (Object)false);
    }

    public static final void registerCommonGameEvents() {
        boolean $i$f$getFORGE_BUS = false;
        IEventBus iEventBus = NeoForge.EVENT_BUS;
        Intrinsics.checkNotNullExpressionValue((Object)iEventBus, (String)"EVENT_BUS");
        iEventBus.addListener(T7CommonGameEventsKt::entityTickPre);
        $i$f$getFORGE_BUS = false;
        IEventBus iEventBus2 = NeoForge.EVENT_BUS;
        Intrinsics.checkNotNullExpressionValue((Object)iEventBus2, (String)"EVENT_BUS");
        iEventBus2.addListener(T7CommonGameEventsKt::livingDamagePost);
        $i$f$getFORGE_BUS = false;
        IEventBus iEventBus3 = NeoForge.EVENT_BUS;
        Intrinsics.checkNotNullExpressionValue((Object)iEventBus3, (String)"EVENT_BUS");
        iEventBus3.addListener(T7CommonGameEventsKt::mobEffectApplicable);
        $i$f$getFORGE_BUS = false;
        IEventBus iEventBus4 = NeoForge.EVENT_BUS;
        Intrinsics.checkNotNullExpressionValue((Object)iEventBus4, (String)"EVENT_BUS");
        iEventBus4.addListener(T7CommonGameEventsKt::preLivingDamage);
        $i$f$getFORGE_BUS = false;
        IEventBus iEventBus5 = NeoForge.EVENT_BUS;
        Intrinsics.checkNotNullExpressionValue((Object)iEventBus5, (String)"EVENT_BUS");
        iEventBus5.addListener(T7CommonGameEventsKt::entityFall);
        $i$f$getFORGE_BUS = false;
        IEventBus iEventBus6 = NeoForge.EVENT_BUS;
        Intrinsics.checkNotNullExpressionValue((Object)iEventBus6, (String)"EVENT_BUS");
        iEventBus6.addListener(TreeFelling.Companion::blockBreak);
        $i$f$getFORGE_BUS = false;
        IEventBus iEventBus7 = NeoForge.EVENT_BUS;
        Intrinsics.checkNotNullExpressionValue((Object)iEventBus7, (String)"EVENT_BUS");
        iEventBus7.addListener(TreeFelling.Companion::levelTick);
        $i$f$getFORGE_BUS = false;
        IEventBus iEventBus8 = NeoForge.EVENT_BUS;
        Intrinsics.checkNotNullExpressionValue((Object)iEventBus8, (String)"EVENT_BUS");
        iEventBus8.addListener(Exchanging.Companion::levelTick);
        $i$f$getFORGE_BUS = false;
        IEventBus iEventBus9 = NeoForge.EVENT_BUS;
        Intrinsics.checkNotNullExpressionValue((Object)iEventBus9, (String)"EVENT_BUS");
        iEventBus9.addListener(EnderpearlFocus.Companion::enderpearlTeleport);
    }
}

