/*
 * Decompiled with CFR 0.152.
 */
package me.alegian.thavma.impl.common.item;

import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.optionals.OptionalsKt;
import me.alegian.thavma.impl.common.entity.KnowledgeHelperKt;
import me.alegian.thavma.impl.common.research.ResearchEntry;
import me.alegian.thavma.impl.common.research.ResearchState;
import me.alegian.thavma.impl.init.registries.deferred.T7DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J&\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J.\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0010\u0010\u0017\u001a\u00020\u00142\u0006\u0010\u000f\u001a\u00020\u0006H\u0016J\u0006\u0010\u0018\u001a\u00020\u0019\u00a8\u0006\u001a"}, d2={"Lme/alegian/thavma/impl/common/item/ResearchScrollItem;", "Lnet/minecraft/world/item/Item;", "<init>", "()V", "use", "Lnet/minecraft/world/InteractionResultHolder;", "Lnet/minecraft/world/item/ItemStack;", "level", "Lnet/minecraft/world/level/Level;", "player", "Lnet/minecraft/world/entity/player/Player;", "usedHand", "Lnet/minecraft/world/InteractionHand;", "appendHoverText", "", "stack", "context", "Lnet/minecraft/world/item/Item$TooltipContext;", "tooltipComponents", "", "Lnet/minecraft/network/chat/Component;", "tooltipFlag", "Lnet/minecraft/world/item/TooltipFlag;", "getName", "completedTranslation", "", "thavma-neoforge"})
public final class ResearchScrollItem
extends Item {
    public ResearchScrollItem() {
        super(new Item.Properties().stacksTo(1));
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(@NotNull Level level, @NotNull Player player, @NotNull InteractionHand usedHand) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)usedHand, (String)"usedHand");
        ItemStack stack = player.getItemInHand(usedHand);
        ResearchState researchState = (ResearchState)stack.get((Supplier)T7DataComponents.INSTANCE.getRESEARCH_STATE());
        if (researchState == null) {
            InteractionResultHolder interactionResultHolder = InteractionResultHolder.pass((Object)stack);
            Intrinsics.checkNotNullExpressionValue((Object)interactionResultHolder, (String)"pass(...)");
            return interactionResultHolder;
        }
        ResearchState state = researchState;
        if (!state.getCompleted()) {
            InteractionResultHolder interactionResultHolder = InteractionResultHolder.pass((Object)stack);
            Intrinsics.checkNotNullExpressionValue((Object)interactionResultHolder, (String)"pass(...)");
            return interactionResultHolder;
        }
        if (player instanceof ServerPlayer) {
            player.setItemInHand(usedHand, ItemStack.EMPTY);
            if (!KnowledgeHelperKt.knowsResearch(player, state.getResearchEntry())) {
                KnowledgeHelperKt.addKnowledge((ServerPlayer)player, CollectionsKt.listOf(state.getResearchEntry().unwrapKey().get()));
            }
        }
        if (level.isClientSide) {
            level.playSound(player, player.blockPosition(), SoundEvents.PLAYER_LEVELUP, SoundSource.PLAYERS, 0.4f, 1.0f);
        }
        InteractionResultHolder interactionResultHolder = InteractionResultHolder.success((Object)stack);
        Intrinsics.checkNotNullExpressionValue((Object)interactionResultHolder, (String)"success(...)");
        return interactionResultHolder;
    }

    public void appendHoverText(@NotNull ItemStack stack, @NotNull Item.TooltipContext context, @NotNull List<Component> tooltipComponents, @NotNull TooltipFlag tooltipFlag) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter(tooltipComponents, (String)"tooltipComponents");
            Intrinsics.checkNotNullParameter((Object)tooltipFlag, (String)"tooltipFlag");
            super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
            ResearchState researchState = (ResearchState)stack.get((Supplier)T7DataComponents.INSTANCE.getRESEARCH_STATE());
            if (researchState == null) {
                return;
            }
            ResearchState state = researchState;
            Optional optional = state.getResearchEntry().unwrapKey();
            Intrinsics.checkNotNullExpressionValue((Object)optional, (String)"unwrapKey(...)");
            ResourceKey resourceKey = (ResourceKey)OptionalsKt.getOrNull((Optional)optional);
            if (resourceKey == null) break block1;
            ResourceKey it = resourceKey;
            boolean bl = false;
            MutableComponent mutableComponent = Component.translatable((String)ResearchEntry.Companion.translationId((ResourceKey<ResearchEntry>)it)).withStyle(Rarity.UNCOMMON.getStyleModifier());
            Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"withStyle(...)");
            tooltipComponents.add((Component)mutableComponent);
        }
    }

    @NotNull
    public Component getName(@NotNull ItemStack stack) {
        ResearchState state;
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        ResearchState researchState = state = (ResearchState)stack.get((Supplier)T7DataComponents.INSTANCE.getRESEARCH_STATE());
        boolean bl = researchState != null ? researchState.getCompleted() : false;
        if (bl) {
            MutableComponent mutableComponent = Component.translatable((String)this.completedTranslation());
            Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"translatable(...)");
            return (Component)mutableComponent;
        }
        Component component = super.getName(stack);
        Intrinsics.checkNotNullExpressionValue((Object)component, (String)"getName(...)");
        return component;
    }

    @NotNull
    public final String completedTranslation() {
        return this.getOrCreateDescriptionId() + ".completed";
    }
}

