/*
 * Decompiled with CFR 0.152.
 */
package me.alegian.thavma.impl.common.menu;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import me.alegian.thavma.impl.common.menu.container.T7Container;
import me.alegian.thavma.impl.common.menu.container.T7Inventory;
import me.alegian.thavma.impl.common.menu.slot.SlotRange;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerListener;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\b&\u0018\u00002\u00020\u00012\u00020\u0002B#\u0012\n\u0010\u0003\u001a\u0006\u0012\u0002\b\u00030\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0004J\u0018\u0010!\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\"\u001a\u00020\u0006H\u0016J \u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020\u00012\u0006\u0010+\u001a\u00020\u00062\u0006\u0010,\u001a\u00020\u0006H\u0016R$\u0010\r\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\f@DX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0018\u001a\u00020\u0019\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0019\u0010\u001c\u001a\n \u001e*\u0004\u0018\u00010\u001d0\u001d\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R\u0018\u0010#\u001a\b\u0012\u0004\u0012\u00020%0$X\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b&\u0010'\u00a8\u0006-"}, d2={"Lme/alegian/thavma/impl/common/menu/Menu;", "Lnet/minecraft/world/inventory/AbstractContainerMenu;", "Lnet/minecraft/world/inventory/ContainerListener;", "menuType", "Lnet/minecraft/world/inventory/MenuType;", "containerId", "", "playerInventory", "Lnet/minecraft/world/entity/player/Inventory;", "<init>", "(Lnet/minecraft/world/inventory/MenuType;ILnet/minecraft/world/entity/player/Inventory;)V", "value", "Lme/alegian/thavma/impl/common/menu/container/T7Inventory;", "inventory", "getInventory", "()Lme/alegian/thavma/impl/common/menu/container/T7Inventory;", "setInventory", "(Lme/alegian/thavma/impl/common/menu/container/T7Inventory;)V", "moveItemStackToRange", "", "slotItem", "Lnet/minecraft/world/item/ItemStack;", "range", "Lme/alegian/thavma/impl/common/menu/slot/SlotRange;", "player", "Lnet/minecraft/world/entity/player/Player;", "getPlayer", "()Lnet/minecraft/world/entity/player/Player;", "level", "Lnet/minecraft/world/level/Level;", "kotlin.jvm.PlatformType", "getLevel", "()Lnet/minecraft/world/level/Level;", "quickMoveStack", "slotIndex", "quickMovePriorities", "", "Lme/alegian/thavma/impl/common/menu/container/T7Container;", "getQuickMovePriorities", "()Ljava/util/List;", "dataChanged", "", "menu", "pDataSlotIndex", "pValue", "thavma-neoforge"})
@SourceDebugExtension(value={"SMAP\nMenu.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Menu.kt\nme/alegian/thavma/impl/common/menu/Menu\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,72:1\n2746#2,3:73\n*S KotlinDebug\n*F\n+ 1 Menu.kt\nme/alegian/thavma/impl/common/menu/Menu\n*L\n47#1:73,3\n*E\n"})
public abstract class Menu
extends AbstractContainerMenu
implements ContainerListener {
    @NotNull
    private T7Inventory inventory;
    @NotNull
    private final Player player;
    private final Level level;

    public Menu(@NotNull MenuType<?> menuType, int containerId, @NotNull Inventory playerInventory) {
        Intrinsics.checkNotNullParameter(menuType, (String)"menuType");
        Intrinsics.checkNotNullParameter((Object)playerInventory, (String)"playerInventory");
        super(menuType, containerId);
        this.inventory = new T7Inventory(playerInventory, this);
        this.player = this.inventory.getPlayer();
        this.level = this.player.level();
    }

    @NotNull
    public final T7Inventory getInventory() {
        return this.inventory;
    }

    protected final void setInventory(@NotNull T7Inventory t7Inventory) {
        Intrinsics.checkNotNullParameter((Object)t7Inventory, (String)"<set-?>");
        this.inventory = t7Inventory;
    }

    protected final boolean moveItemStackToRange(@NotNull ItemStack slotItem, @NotNull SlotRange range) {
        Intrinsics.checkNotNullParameter((Object)slotItem, (String)"slotItem");
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        return this.moveItemStackTo(slotItem, range.getStart(), range.getEnd() + 1, false);
    }

    @NotNull
    public final Player getPlayer() {
        return this.player;
    }

    public final Level getLevel() {
        return this.level;
    }

    @NotNull
    public ItemStack quickMoveStack(@NotNull Player player, int slotIndex) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        ItemStack originalItem = ItemStack.EMPTY;
        Object object = this.slots.get(slotIndex);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        Slot slot = (Slot)object;
        if (slot.hasItem()) {
            ItemStack slotItem = slot.getItem();
            originalItem = slotItem.copy();
            boolean isInventorySlot = this.inventory.getRange().contains(slotIndex);
            if (isInventorySlot) {
                boolean bl;
                block11: {
                    Iterable $this$none$iv = this.getQuickMovePriorities();
                    boolean $i$f$none = false;
                    if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                        bl = true;
                    } else {
                        for (Object element$iv : $this$none$iv) {
                            T7Container container = (T7Container)element$iv;
                            boolean bl2 = false;
                            Intrinsics.checkNotNull((Object)slotItem);
                            if (!this.moveItemStackToRange(slotItem, container.getRange())) continue;
                            bl = false;
                            break block11;
                        }
                        bl = true;
                    }
                }
                if (bl) {
                    ItemStack itemStack = ItemStack.EMPTY;
                    Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"EMPTY");
                    return itemStack;
                }
            } else {
                Intrinsics.checkNotNull((Object)slotItem);
                if (!this.moveItemStackToRange(slotItem, this.inventory.getRange())) {
                    ItemStack itemStack = ItemStack.EMPTY;
                    Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"EMPTY");
                    return itemStack;
                }
            }
            if (slotItem.isEmpty()) {
                slot.set(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
            if (slotItem.getCount() == originalItem.getCount()) {
                ItemStack itemStack = ItemStack.EMPTY;
                Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"EMPTY");
                return itemStack;
            }
            slot.onTake(player, slotItem);
        }
        ItemStack itemStack = originalItem;
        Intrinsics.checkNotNull((Object)itemStack);
        return itemStack;
    }

    @NotNull
    protected abstract List<T7Container> getQuickMovePriorities();

    public void dataChanged(@NotNull AbstractContainerMenu menu, int pDataSlotIndex, int pValue) {
        Intrinsics.checkNotNullParameter((Object)menu, (String)"menu");
    }
}

