/*
 * Decompiled with CFR 0.152.
 */
package me.alegian.thavma.impl.common.menu;

import java.util.List;
import java.util.Optional;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import me.alegian.thavma.impl.common.aspect.AspectMap;
import me.alegian.thavma.impl.common.menu.Menu;
import me.alegian.thavma.impl.common.menu.container.CraftingContainer3x3;
import me.alegian.thavma.impl.common.menu.container.T7Container;
import me.alegian.thavma.impl.common.menu.container.WandContainer;
import me.alegian.thavma.impl.common.menu.container.WorkbenchResultContainer;
import me.alegian.thavma.impl.common.recipe.WorkbenchRecipe;
import me.alegian.thavma.impl.init.registries.deferred.T7Blocks;
import me.alegian.thavma.impl.init.registries.deferred.T7MenuTypes;
import me.alegian.thavma.impl.init.registries.deferred.T7RecipeTypes;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010 \u001a\u00020!H\u0002J\u0010\u0010\"\u001a\u00020!2\u0006\u0010#\u001a\u00020$H\u0016J\u0010\u0010%\u001a\u00020&2\u0006\u0010#\u001a\u00020$H\u0016J \u0010'\u001a\u00020!2\u0006\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020\u00032\u0006\u0010+\u001a\u00020,H\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0017\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00000\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u001e\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0016\u001a\u00020\u0017@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u001a\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001cX\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001f\u00a8\u0006-"}, d2={"Lme/alegian/thavma/impl/common/menu/WorkbenchMenu;", "Lme/alegian/thavma/impl/common/menu/Menu;", "pContainerId", "", "pPlayerInventory", "Lnet/minecraft/world/entity/player/Inventory;", "levelAccess", "Lnet/minecraft/world/inventory/ContainerLevelAccess;", "<init>", "(ILnet/minecraft/world/entity/player/Inventory;Lnet/minecraft/world/inventory/ContainerLevelAccess;)V", "craftingContainer", "Lme/alegian/thavma/impl/common/menu/container/CraftingContainer3x3;", "getCraftingContainer", "()Lme/alegian/thavma/impl/common/menu/container/CraftingContainer3x3;", "wandContainer", "Lme/alegian/thavma/impl/common/menu/container/WandContainer;", "getWandContainer", "()Lme/alegian/thavma/impl/common/menu/container/WandContainer;", "resultContainer", "Lme/alegian/thavma/impl/common/menu/container/WorkbenchResultContainer;", "getResultContainer", "()Lme/alegian/thavma/impl/common/menu/container/WorkbenchResultContainer;", "value", "Lme/alegian/thavma/impl/common/aspect/AspectMap;", "requiredAspects", "getRequiredAspects", "()Lme/alegian/thavma/impl/common/aspect/AspectMap;", "quickMovePriorities", "", "Lme/alegian/thavma/impl/common/menu/container/T7Container;", "getQuickMovePriorities", "()Ljava/util/List;", "refreshRecipeResult", "", "removed", "pPlayer", "Lnet/minecraft/world/entity/player/Player;", "stillValid", "", "slotChanged", "pContainerToSend", "Lnet/minecraft/world/inventory/AbstractContainerMenu;", "pDataSlotIndex", "pStack", "Lnet/minecraft/world/item/ItemStack;", "thavma-neoforge"})
public final class WorkbenchMenu
extends Menu {
    @NotNull
    private final ContainerLevelAccess levelAccess;
    @NotNull
    private final CraftingContainer3x3 craftingContainer;
    @NotNull
    private final WandContainer<WorkbenchMenu> wandContainer;
    @NotNull
    private final WorkbenchResultContainer resultContainer;
    @NotNull
    private AspectMap requiredAspects;
    @NotNull
    private final List<T7Container> quickMovePriorities;

    public WorkbenchMenu(int pContainerId, @NotNull Inventory pPlayerInventory, @NotNull ContainerLevelAccess levelAccess) {
        Intrinsics.checkNotNullParameter((Object)pPlayerInventory, (String)"pPlayerInventory");
        Intrinsics.checkNotNullParameter((Object)levelAccess, (String)"levelAccess");
        Object object = T7MenuTypes.INSTANCE.getWORKBENCH().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        super((MenuType)object, pContainerId, pPlayerInventory);
        this.levelAccess = levelAccess;
        this.craftingContainer = new CraftingContainer3x3(this);
        this.wandContainer = new WandContainer<Menu>(this);
        this.resultContainer = new WorkbenchResultContainer(this);
        this.requiredAspects = new AspectMap(null, 1, null);
        Object[] objectArray = new T7Container[]{this.wandContainer, this.craftingContainer};
        this.quickMovePriorities = CollectionsKt.listOf((Object[])objectArray);
        this.craftingContainer.addSlots();
        this.wandContainer.addSlots();
        this.getInventory().addSlots();
        this.resultContainer.addSlots();
        this.addSlotListener(this);
    }

    public /* synthetic */ WorkbenchMenu(int n, Inventory inventory, ContainerLevelAccess containerLevelAccess, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 4) != 0) {
            ContainerLevelAccess containerLevelAccess2 = ContainerLevelAccess.NULL;
            Intrinsics.checkNotNullExpressionValue((Object)containerLevelAccess2, (String)"NULL");
            containerLevelAccess = containerLevelAccess2;
        }
        this(n, inventory, containerLevelAccess);
    }

    @NotNull
    public final CraftingContainer3x3 getCraftingContainer() {
        return this.craftingContainer;
    }

    @NotNull
    public final WandContainer<WorkbenchMenu> getWandContainer() {
        return this.wandContainer;
    }

    @NotNull
    public final WorkbenchResultContainer getResultContainer() {
        return this.resultContainer;
    }

    @NotNull
    public final AspectMap getRequiredAspects() {
        return this.requiredAspects;
    }

    @Override
    @NotNull
    protected List<T7Container> getQuickMovePriorities() {
        return this.quickMovePriorities;
    }

    private final void refreshRecipeResult() {
        Optional optionalRecipeHolder = this.getLevel().getRecipeManager().getRecipeFor((RecipeType)T7RecipeTypes.INSTANCE.getWORKBENCH().get(), (RecipeInput)this.craftingContainer.asCraftInput(), this.getLevel());
        AspectMap aspectMap = optionalRecipeHolder.map(arg_0 -> WorkbenchMenu.refreshRecipeResult$lambda$1(WorkbenchMenu::refreshRecipeResult$lambda$0, arg_0)).orElse(new AspectMap(null, 1, null));
        Intrinsics.checkNotNullExpressionValue((Object)aspectMap, (String)"orElse(...)");
        this.requiredAspects = aspectMap;
        if (!this.getLevel().isClientSide()) {
            ItemStack resultItem = optionalRecipeHolder.map(arg_0 -> WorkbenchMenu.refreshRecipeResult$lambda$3(WorkbenchMenu::refreshRecipeResult$lambda$2, arg_0)).orElse(ItemStack.EMPTY);
            this.resultContainer.setItem(0, resultItem);
        }
        this.resultContainer.setSlotEnabled(0, this.wandContainer.contains(this.requiredAspects));
    }

    public void removed(@NotNull Player pPlayer) {
        Intrinsics.checkNotNullParameter((Object)pPlayer, (String)"pPlayer");
        super.removed(pPlayer);
        this.levelAccess.execute((arg_0, arg_1) -> WorkbenchMenu.removed$lambda$4(this, pPlayer, arg_0, arg_1));
    }

    public boolean stillValid(@NotNull Player pPlayer) {
        Intrinsics.checkNotNullParameter((Object)pPlayer, (String)"pPlayer");
        return AbstractContainerMenu.stillValid((ContainerLevelAccess)this.levelAccess, (Player)pPlayer, (Block)((Block)T7Blocks.INSTANCE.getARCANE_WORKBENCH().get()));
    }

    public void slotChanged(@NotNull AbstractContainerMenu pContainerToSend, int pDataSlotIndex, @NotNull ItemStack pStack) {
        Intrinsics.checkNotNullParameter((Object)pContainerToSend, (String)"pContainerToSend");
        Intrinsics.checkNotNullParameter((Object)pStack, (String)"pStack");
        this.refreshRecipeResult();
    }

    private static final AspectMap refreshRecipeResult$lambda$0(RecipeHolder r) {
        return ((WorkbenchRecipe)r.value()).getAspects();
    }

    private static final AspectMap refreshRecipeResult$lambda$1(Function1 $tmp0, Object p0) {
        return (AspectMap)$tmp0.invoke(p0);
    }

    private static final ItemStack refreshRecipeResult$lambda$2(RecipeHolder r) {
        return ((WorkbenchRecipe)r.value()).getResult();
    }

    private static final ItemStack refreshRecipeResult$lambda$3(Function1 $tmp0, Object p0) {
        return (ItemStack)$tmp0.invoke(p0);
    }

    private static final void removed$lambda$4(WorkbenchMenu this$0, Player $pPlayer, Level level, BlockPos blockPos) {
        this$0.clearContainer($pPlayer, this$0.craftingContainer);
        this$0.clearContainer($pPlayer, this$0.wandContainer);
    }
}

