package com.provismet.ExtendedEnchanting.mixin;

import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

import com.provismet.ExtendedEnchanting.interfaces.IMixinLivingEntity;
import com.provismet.ExtendedEnchanting.registries.EEParticleTypes;
import com.provismet.ExtendedEnchanting.utility.EEDamageTypes;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_3218;

@Mixin(class_1309.class)
public abstract class LivingEntityMixin extends class_1297 implements IMixinLivingEntity {
    public LivingEntityMixin (class_1299<?> type, class_1937 world) {
        super(type, world);
    }
    
    @Unique
    private int staticTicks = 0;

    @Unique
    private class_243 previousGroundPos = null;

    @Inject(method="tick", at=@At("HEAD"))
    private void applyEffectsOverTime (CallbackInfo info) {
        if (this.staticTicks > 0) {
            --this.staticTicks;
            if (this.field_6012 % 15 == 0 && this.method_73183() instanceof class_3218 serverWorld) {
                serverWorld.method_65096(EEParticleTypes.STATIC_CHARGE, this.method_23317(), (this.method_23318() + this.method_23320()) / 2.0, this.method_23321(), Math.max(1, Math.ceilDiv(this.staticTicks, 15)), 0, 0, 0, 0);
            }
        }
    }

    @Override
    public void extended_Enchanting$applyStatic (int amount) {
        this.staticTicks += amount;
        while (this.staticTicks >= 100) { // TODO: Compare this with an attribute maybe?
            this.staticTicks = Math.max(0, this.staticTicks - 100);
            if (this.method_73183() instanceof class_3218 serverWorld) {
                this.method_64397(serverWorld, EEDamageTypes.STATIC.createDamageSource(this.method_48923()), 6f);
                serverWorld.method_65096(EEParticleTypes.DISCHARGE, this.method_23317(), (this.method_23318() + this.method_23320()) / 2.0, this.method_23321(), 1, 0, 0, 0, 0);
            }
        }
    }

    @Override
    public void extended_Enchanting$setPreviousGroundPos (class_243 position) {
        this.previousGroundPos = position;
    }

    @Override
    public class_243 extended_Enchanting$getPreviousGroundPos () {
        return this.previousGroundPos;
    }
}
