package com.provismet.ExtendedEnchanting.registries;

import com.provismet.CombatPlusCore.enchantment.effect.doubleEntity.ApplyKnockbackEffect;
import com.provismet.CombatPlusCore.enchantment.effect.doubleEntity.ApplyToTargetEntityEffect;
import com.provismet.CombatPlusCore.enchantment.effect.doubleEntity.ApplyToUserEntityEffect;
import com.provismet.CombatPlusCore.enchantment.effect.doubleEntity.CodeExecutionDoubleEntityEffect;
import com.provismet.CombatPlusCore.enchantment.effect.doubleEntity.InvertedEntityEffect;
import com.provismet.CombatPlusCore.enchantment.effect.singleEntity.ApplyVelocityEffect;
import com.provismet.CombatPlusCore.enchantment.effect.singleEntity.CodeExecutionSingleEntityEffect;
import com.provismet.CombatPlusCore.enchantment.effect.singleEntity.DamageEquipmentEffect;
import com.provismet.CombatPlusCore.enchantment.effect.singleEntity.FreezeEffect;
import com.provismet.CombatPlusCore.enchantment.effect.singleEntity.HealEffect;
import com.provismet.CombatPlusCore.enchantment.loot.condition.doubleEntity.ApplyToTargetCondition;
import com.provismet.CombatPlusCore.enchantment.loot.condition.item.ItemLambdaCondition;
import com.provismet.CombatPlusCore.enchantment.loot.condition.singleEntity.ApplyToAttackerCondition;
import com.provismet.CombatPlusCore.enchantment.loot.condition.singleEntity.ApplyToItemCondition;
import com.provismet.CombatPlusCore.enchantment.loot.condition.singleEntity.DimensionCondition;
import com.provismet.CombatPlusCore.enchantment.loot.condition.singleEntity.ExposedToMoonCondition;
import com.provismet.CombatPlusCore.enchantment.loot.condition.singleEntity.ExposedToSunCondition;
import com.provismet.CombatPlusCore.enchantment.loot.condition.singleEntity.RelativeHealthCondition;
import com.provismet.CombatPlusCore.enchantment.loot.condition.singleEntity.TickModuloCondition;
import com.provismet.CombatPlusCore.enchantment.loot.context.CPCLootContext;
import com.provismet.CombatPlusCore.registries.CPCEnchantmentComponentTypes;
import com.provismet.CombatPlusCore.utility.tag.CPCEnchantmentTags;
import com.provismet.CombatPlusCore.utility.tag.CPCItemTags;
import com.provismet.ExtendedEnchanting.ExtendedEnchantingMain;

import com.provismet.ExtendedEnchanting.enchantment.effect.singleEntity.ShockEnchantmentEffect;
import com.provismet.ExtendedEnchanting.utility.tags.EEDamageTypeTags;
import com.provismet.ExtendedEnchanting.utility.tags.EEEnchantmentTags;
import com.provismet.ExtendedEnchanting.utility.tags.EEEntityTypeTags;
import com.provismet.ExtendedEnchanting.utility.tags.EEItemTags;
import com.provismet.lilylib.container.EnchantmentContainer;
import java.util.List;
import net.minecraft.class_1294;
import net.minecraft.class_1304;
import net.minecraft.class_1322;
import net.minecraft.class_1887;
import net.minecraft.class_190;
import net.minecraft.class_2022;
import net.minecraft.class_2040;
import net.minecraft.class_2048;
import net.minecraft.class_2050;
import net.minecraft.class_2073;
import net.minecraft.class_215;
import net.minecraft.class_2960;
import net.minecraft.class_3489;
import net.minecraft.class_3735;
import net.minecraft.class_47;
import net.minecraft.class_5134;
import net.minecraft.class_6885;
import net.minecraft.class_7891;
import net.minecraft.class_8129;
import net.minecraft.class_8548;
import net.minecraft.class_8551;
import net.minecraft.class_9274;
import net.minecraft.class_9636;
import net.minecraft.class_9701;
import net.minecraft.class_9703;
import net.minecraft.class_9704;
import net.minecraft.class_9711;
import net.minecraft.class_9712;
import net.minecraft.class_9716;
import net.minecraft.class_9720;
import net.minecraft.class_9725;

public class EEEnchantments {
    public static final EnchantmentContainer LEECHING_ASPECT = new EnchantmentContainer(
        ExtendedEnchantingMain.identifier("leeching_aspect"),
        (itemLookup, enchantmentLookup, damageLookup, blockLookup, entityLookup) -> class_1887.method_60030(
            class_1887.method_58443(
                itemLookup.method_46735(CPCItemTags.ASPECT_ENCHANTABLE),
                itemLookup.method_46735(CPCItemTags.ASPECT_PRIMARY_ENCHANTABLE),
                3,
                2,
                class_1887.method_58441(10, 20),
                class_1887.method_58441(50, 20),
                6,
                class_9274.field_49217
            )
        ).method_60066(
            CPCEnchantmentComponentTypes.POST_CRITICAL_ATTACK,
            new ApplyToUserEntityEffect(
                new HealEffect(class_9704.method_60194(1))
            )
        ).method_60061(
            enchantmentLookup.method_46735(CPCEnchantmentTags.ASPECT_EXCLUSIVE)
        )
    );
    public static final EnchantmentContainer FROST_ASPECT = new EnchantmentContainer(
        ExtendedEnchantingMain.identifier("frost_aspect"),
        (itemLookup, enchantmentLookup, damageLookup, blockLookup, entityLookup) -> class_1887.method_60030(
            class_1887.method_58443(
                itemLookup.method_46735(CPCItemTags.ASPECT_ENCHANTABLE),
                itemLookup.method_46735(CPCItemTags.ASPECT_PRIMARY_ENCHANTABLE),
                5,
                2,
                class_1887.method_58441(10, 20),
                class_1887.method_58441(25, 20),
                4,
                class_9274.field_49217
            )
        ).method_60066(
            CPCEnchantmentComponentTypes.POST_CHARGED_ATTACK,
            new ApplyToTargetEntityEffect(
                new FreezeEffect(class_9704.method_60194(2.25f))
            )
        ).method_60061(
            enchantmentLookup.method_46735(CPCEnchantmentTags.ASPECT_EXCLUSIVE)
        )
    );
    public static final EnchantmentContainer LIGHTNING_ASPECT = new EnchantmentContainer(
        ExtendedEnchantingMain.identifier("lightning_aspect"),
        (itemLookup, enchantmentLookup, damageLookup, blockLookup, entityLookup) -> class_1887.method_60030(
            class_1887.method_58443(
                itemLookup.method_46735(CPCItemTags.ASPECT_ENCHANTABLE),
                itemLookup.method_46735(CPCItemTags.ASPECT_PRIMARY_ENCHANTABLE),
                3,
                2,
                class_1887.method_58441(20, 10),
                class_1887.method_58441(70, 10),
                4,
                class_9274.field_49217
            )
        ).method_60066(
            CPCEnchantmentComponentTypes.POST_CHARGED_ATTACK,
            new ApplyToTargetEntityEffect(
                new ShockEnchantmentEffect(class_9704.method_60194(22))
            )
        ).method_60061(
            enchantmentLookup.method_46735(CPCEnchantmentTags.ASPECT_EXCLUSIVE)
        )
    );

    public static final EnchantmentContainer INITIATIVE = new EnchantmentContainer(
        ExtendedEnchantingMain.identifier("initiative"),
        (itemLookup, enchantmentLookup, damageLookup, blockLookup, entityLookup) -> class_1887.method_60030(
            class_1887.method_58443(
                itemLookup.method_46735(CPCItemTags.DAMAGE_ENCHANTABLE),
                itemLookup.method_46735(CPCItemTags.DAMAGE_PRIMARY_ENCHANTABLE),
                5,
                5,
                class_1887.method_58441(10, 5),
                class_1887.method_58441(50, 5),
                3,
                class_9274.field_49217
            )
        ).method_60067(
            CPCEnchantmentComponentTypes.GAMERULE_DAMAGE,
            new class_9711(class_9704.method_60194(2.2f)),
            RelativeHealthCondition.builder(CPCLootContext.Comparison.GREATER_THAN_OR_EQUAL_TO, class_9704.method_60186(1))
        ).method_60061(
            enchantmentLookup.method_46735(CPCEnchantmentTags.ADDITION_DAMAGE_EXCLUSIVE)
        )
    );
    public static final EnchantmentContainer GLASS = new EnchantmentContainer(
        ExtendedEnchantingMain.identifier("glass"),
        (itemLookup, enchantmentLookup, damageLookup, blockLookup, entityLookup) -> class_1887.method_60030(
            class_1887.method_58443(
                itemLookup.method_46735(CPCItemTags.DAMAGE_ENCHANTABLE),
                itemLookup.method_46735(CPCItemTags.DAMAGE_PRIMARY_ENCHANTABLE),
                5,
                5,
                class_1887.method_58441(10, 5),
                class_1887.method_58441(50, 5),
                3,
                class_9274.field_49217
            )
        ).method_60067(
            CPCEnchantmentComponentTypes.GAMERULE_DAMAGE,
            new class_9711(class_9704.method_60194(1.8f)),
            ApplyToAttackerCondition.builder(
                RelativeHealthCondition.builder(
                    CPCLootContext.Comparison.GREATER_THAN_OR_EQUAL_TO,
                    class_9704.method_60186(1)
                )
            )
        ).method_60061(
            enchantmentLookup.method_46735(CPCEnchantmentTags.ADDITION_DAMAGE_EXCLUSIVE)
        )
    );
    public static final EnchantmentContainer SOLITUDE = new EnchantmentContainer(
        ExtendedEnchantingMain.identifier("solitude"),
        (itemLookup, enchantmentLookup, damageLookup, blockLookup, entityLookup) -> class_1887.method_60030(
            class_1887.method_58443(
                itemLookup.method_46735(CPCItemTags.DAMAGE_ENCHANTABLE),
                itemLookup.method_46735(CPCItemTags.DAMAGE_PRIMARY_ENCHANTABLE),
                1,
                1,
                class_1887.method_58440(35),
                class_1887.method_58440(75),
                8,
                class_9274.field_49217
            )
        ).method_60067(
            CPCEnchantmentComponentTypes.GAMERULE_DAMAGE,
            new class_9711(class_9704.method_60194(15)),
            ApplyToAttackerCondition.builder(
                ApplyToItemCondition.builder(
                    ItemLambdaCondition.builder(ExtendedEnchantingMain.identifier("one_enchantment"))
                )
            )
        )
    );

    public static final EnchantmentContainer DUAL_STRIKE = new EnchantmentContainer(
        ExtendedEnchantingMain.identifier("dual_strike"),
        (itemLookup, enchantmentLookup, damageLookup, blockLookup, entityLookup) -> class_1887.method_60030(
            class_1887.method_58443(
                itemLookup.method_46735(CPCItemTags.WEAPON_UTILITY_ENCHANTABLE),
                itemLookup.method_46735(CPCItemTags.WEAPON_UTILITY_PRIMARY_ENCHANTABLE),
                5,
                3,
                class_1887.method_58441(10, 5),
                class_1887.method_58441(20, 10),
                4,
                class_9274.field_49217
            )
        ).method_60066(
            CPCEnchantmentComponentTypes.POST_CHARGED_ATTACK,
            new CodeExecutionDoubleEntityEffect(ExtendedEnchantingMain.identifier("dual_strike"))
        ).method_60061(
            enchantmentLookup.method_46735(CPCEnchantmentTags.WEAPON_UTILITY_EXCLUSIVE)
        )
    );
    public static final EnchantmentContainer FEINT = new EnchantmentContainer(
        ExtendedEnchantingMain.identifier("feint"),
        (itemLookup, enchantmentLookup, damageLookup, blockLookup, entityLookup) -> class_1887.method_60030(
            class_1887.method_58443(
                itemLookup.method_46735(CPCItemTags.WEAPON_UTILITY_ENCHANTABLE),
                itemLookup.method_46735(CPCItemTags.WEAPON_UTILITY_PRIMARY_ENCHANTABLE),
                2,
                2,
                class_1887.method_58441(10, 10),
                class_1887.method_58441(50, 10),
                4,
                class_9274.field_49217, class_9274.field_49218
            )
        ).method_60066(
            CPCEnchantmentComponentTypes.POST_CHARGED_ATTACK,
            new InvertedEntityEffect(
                new ApplyKnockbackEffect(
                    class_9704.method_60187(1, 0.5f),
                    false
                )
            )
        ).method_60061(
            enchantmentLookup.method_46735(CPCEnchantmentTags.WEAPON_UTILITY_OFFHAND_EXCLUSIVE)
        )
    );
    public static final EnchantmentContainer RAMPAGE = new EnchantmentContainer(
        ExtendedEnchantingMain.identifier("rampage"),
        (itemLookup, enchantmentLookup, damageLookup, blockLookup, entityLookup) -> class_1887.method_60030(
            class_1887.method_58443(
                itemLookup.method_46735(CPCItemTags.WEAPON_UTILITY_ENCHANTABLE),
                itemLookup.method_46735(CPCItemTags.WEAPON_UTILITY_PRIMARY_ENCHANTABLE),
                5,
                3,
                class_1887.method_58441(5, 10),
                class_1887.method_58441(55, 10),
                3,
                class_9274.field_49217
            )
        ).method_60066(
            CPCEnchantmentComponentTypes.POST_KILL,
            new ApplyToUserEntityEffect(
                class_9712.method_60216(
                    new class_9716(
                        class_6885.method_40246(class_1294.field_5910),
                        class_9704.method_60194(1.25f),
                        class_9704.method_60194(1.25f),
                        class_9704.method_60186(0),
                        class_9704.method_60186(0)
                    ),
                    new class_9716(
                        class_6885.method_40246(class_1294.field_5904),
                        class_9704.method_60194(1.25f),
                        class_9704.method_60194(1.25f),
                        class_9704.method_60186(0),
                        class_9704.method_60186(0)
                    )
                )
            )
        ).method_60061(
            enchantmentLookup.method_46735(CPCEnchantmentTags.WEAPON_UTILITY_EXCLUSIVE)
        )
    );

    public static final EnchantmentContainer LAUNCH = new EnchantmentContainer(
        ExtendedEnchantingMain.identifier("launch"),
        (itemLookup, enchantmentLookup, damageLookup, blockLookup, entityLookup) -> class_1887.method_60030(
            class_1887.method_58442(
                itemLookup.method_46735(class_3489.field_48304),
                5,
                2,
                class_1887.method_58441(5, 20),
                class_1887.method_58441(50, 20),
                2,
                class_9274.field_49217
            )
        ).method_60067(
            CPCEnchantmentComponentTypes.POST_CHARGED_ATTACK,
            new ApplyToTargetEntityEffect(
                new ApplyVelocityEffect(
                    0, 0.15, 0,
                    class_9704.method_60194(1),
                    true
                )
            ),
            ApplyToTargetCondition.builder(
                class_215.method_27865(
                    class_47.class_50.field_935,
                    class_2048.class_2049.method_8916().method_8917(class_2050.method_8926(entityLookup, EEEntityTypeTags.NO_LAUNCH)).method_8920()
                ).method_16780()
            )
        ).method_60061(
            enchantmentLookup.method_46735(EEEnchantmentTags.LAUNCH_EXCLUSIVE)
        )
    );

    public static final EnchantmentContainer WEAPON_PROTECTION = new EnchantmentContainer(
        ExtendedEnchantingMain.identifier("weapon_protection"),
        (itemLookup, enchantmentLookup, damageLookup, blockLookup, entityLookup) -> class_1887.method_60030(
            class_1887.method_58442(
                itemLookup.method_46735(class_3489.field_48303),
                1,
                4,
                class_1887.method_58441(10, 5),
                class_1887.method_58441(20, 5),
                4,
                class_9274.field_49224
            )
        ).method_60067(
            class_9701.field_51659,
            new class_9711(
                class_9704.method_60194(1.5f)
            ),
            class_8551.method_51727(
                class_190.method_837(
                    class_2022.class_2023.method_8855()
                        .method_48785(class_8129.method_48965(EEDamageTypeTags.MELEE_STRIKE))
                        .method_60488(true)
                ),
                class_190.method_837(
                    class_2022.class_2023.method_8855()
                        .method_8854(
                            class_2048.class_2049.method_8916().method_53141(
                                class_3735.class_5278.method_27965().method_35195(
                                    class_2073.class_2074.method_8973().method_8975(itemLookup, CPCItemTags.MELEE_WEAPON)
                                )
                            )
                        )
                        .method_60488(true)
                ),
                class_190.method_837(
                    class_2022.class_2023.method_8855()
                        .method_8854(
                            class_2048.class_2049.method_8916().method_8917(class_2050.method_8926(entityLookup, EEEntityTypeTags.HAS_WEAPON))
                        )
                        .method_60488(true)
                )
            )
        ).method_60061(
            enchantmentLookup.method_46735(class_9636.field_51538)
        )
    );
    public static final EnchantmentContainer COMBUSTION_PROTECTION = new EnchantmentContainer(
        ExtendedEnchantingMain.identifier("combustion_protection"),
        (itemLookup, enchantmentLookup, damageLookup, blockLookup, entityLookup) -> class_1887.method_60030(
            class_1887.method_58442(
                itemLookup.method_46735(class_3489.field_48303),
                1,
                4,
                class_1887.method_58441(10, 5),
                class_1887.method_58441(20, 5),
                4,
                class_9274.field_49224
            )
        ).method_60067(
            class_9701.field_51659,
            new class_9711(
                class_9704.method_60194(1.35f)
            ),
            class_190.method_837(
                class_2022.class_2023.method_8855()
                    .method_48785(class_8129.method_48965(EEDamageTypeTags.COMBUSTION))
            )
        ).method_60061(
            enchantmentLookup.method_46735(class_9636.field_51538)
        )
    );

    public static final EnchantmentContainer SUN_HEART = new EnchantmentContainer(
        ExtendedEnchantingMain.identifier("sun_heart"),
        (itemLookup, enchantmentLookup, damageLookup, blockLookup, entityLookup) -> class_1887.method_60030(
            class_1887.method_58442(
                itemLookup.method_46735(class_3489.field_48301),
                1,
                1,
                class_1887.method_58440(50),
                class_1887.method_58440(75),
                8,
                class_9274.field_49222
            )
        ).method_60067(
            class_9701.field_51671,
            class_9712.method_60216(
                new HealEffect(
                    class_9704.method_60186(2)
                ),
                new DamageEquipmentEffect(
                    List.of(class_1304.field_6174),
                    class_9704.method_60186(10)
                )
            ),
            class_8548.method_51723(
                TickModuloCondition.builder(class_9704.method_60186(40)),
                ExposedToSunCondition.builder(),
                RelativeHealthCondition.builder(CPCLootContext.Comparison.LESS_THAN, class_9704.method_60186(1))
            )
        ).method_60064(
            class_9701.field_51665,
            class_9703.field_51685,
            class_9703.field_51683,
            new class_9725(class_9704.method_60186(3)),
            class_8548.method_51723(
                ExposedToSunCondition.builder(),
                class_190.method_837(
                    class_2022.class_2023.method_8855().method_60488(true)
                )
            )
        ).method_60064(
            class_9701.field_51665,
            class_9703.field_51685,
            class_9703.field_51685,
            new DamageEquipmentEffect(
                List.of(class_1304.field_6174),
                class_9704.method_60186(2)
            ),
            class_8548.method_51723(
                ExposedToSunCondition.builder(),
                class_190.method_837(
                    class_2022.class_2023.method_8855().method_60488(true)
                )
            )
        ).method_60061(
            enchantmentLookup.method_46735(EEEnchantmentTags.HEART_EXCLUSIVE)
        )
    );
    public static final EnchantmentContainer MOON_HEART = new EnchantmentContainer(
        ExtendedEnchantingMain.identifier("moon_heart"),
        (itemLookup, enchantmentLookup, damageLookup, blockLookup, entityLookup) -> class_1887.method_60030(
            class_1887.method_58442(
                itemLookup.method_46735(class_3489.field_48301),
                1,
                1,
                class_1887.method_58440(50),
                class_1887.method_58440(75),
                8,
                class_9274.field_49222
            )
        ).method_60064(
            class_9701.field_51665,
            class_9703.field_51685,
            class_9703.field_51683,
            new class_9716(
                class_6885.method_40246(class_1294.field_5909),
                class_9704.method_60186(1),
                class_9704.method_60186(1),
                class_9704.method_60186(0),
                class_9704.method_60186(0)
            ),
            class_8548.method_51723(
                ExposedToMoonCondition.builder(),
                class_190.method_837(
                    class_2022.class_2023.method_8855().method_60488(true)
                )
            )
        ).method_60064(
            class_9701.field_51665,
            class_9703.field_51685,
            class_9703.field_51685,
            new DamageEquipmentEffect(
                List.of(class_1304.field_6174),
                class_9704.method_60186(5)
            ),
            class_8548.method_51723(
                ExposedToMoonCondition.builder(),
                class_190.method_837(
                    class_2022.class_2023.method_8855().method_60488(true)
                )
            )
        ).method_60067(
            class_9701.field_51671,
            new CodeExecutionSingleEntityEffect(ExtendedEnchantingMain.identifier("reset_insomnia")),
            ExposedToMoonCondition.builder()
        ).method_60061(
            enchantmentLookup.method_46735(EEEnchantmentTags.HEART_EXCLUSIVE)
        )
    );
    public static final EnchantmentContainer BRIMSTONE_HEART = new EnchantmentContainer(
        ExtendedEnchantingMain.identifier("brimstone_heart"),
        (itemLookup, enchantmentLookup, damageLookup, blockLookup, entityLookup) -> class_1887.method_60030(
            class_1887.method_58442(
                itemLookup.method_46735(class_3489.field_48301),
                1,
                1,
                class_1887.method_58440(50),
                class_1887.method_58440(75),
                8,
                class_9274.field_49222
            )
        ).method_60067(
            class_9701.field_51670,
            new class_9720(
                ExtendedEnchantingMain.identifier("lava_speed"),
                class_5134.field_23719,
                class_9704.method_60186(0.03f),
                class_1322.class_1323.field_6328
            ),
            class_8548.method_51723(
                DimensionCondition.builder(class_2960.method_60656("the_nether")),
                class_215.method_917(
                    class_47.class_50.field_935,
                    class_2048.class_2049.method_8916().method_8919(class_2040.class_2041.method_8897().method_8898(true))
                )
            )
        ).method_60067(
            class_9701.field_51671,
            class_9712.method_60216(
                new HealEffect(class_9704.method_60186(4)),
                new DamageEquipmentEffect(List.of(class_1304.field_6174), class_9704.method_60186(2))
            ),
            class_8548.method_51723(
                TickModuloCondition.builder(class_9704.method_60186(20)),
                DimensionCondition.builder(class_2960.method_60656("the_nether")),
                class_215.method_917(
                    class_47.class_50.field_935,
                    class_2048.class_2049.method_8916().method_8919(class_2040.class_2041.method_8897().method_8898(true))
                ),
                RelativeHealthCondition.builder(CPCLootContext.Comparison.LESS_THAN, class_9704.method_60186(1))
            )
        ).method_60061(
            enchantmentLookup.method_46735(EEEnchantmentTags.HEART_EXCLUSIVE)
        )
    );
    public static final EnchantmentContainer VOID_HEART = new EnchantmentContainer(
        ExtendedEnchantingMain.identifier("void_heart"),
        (itemLookup, enchantmentLookup, damageLookup, blockLookup, entityLookup) -> class_1887.method_60030(
            class_1887.method_58442(
                itemLookup.method_46735(class_3489.field_48301),
                1,
                1,
                class_1887.method_58440(50),
                class_1887.method_58440(75),
                8,
                class_9274.field_49222
            )
        ).method_60066(
            class_9701.field_51671,
            new CodeExecutionSingleEntityEffect(ExtendedEnchantingMain.identifier("void_heart"))
        ).method_60061(
            enchantmentLookup.method_46735(EEEnchantmentTags.HEART_EXCLUSIVE)
        )
    );

    public static final EnchantmentContainer REPLANT = new EnchantmentContainer(
        ExtendedEnchantingMain.identifier("replanting"),
        (itemLookup, enchantmentLookup, damageLookup, blockLookup, entityLookup) -> class_1887.method_60030(
            class_1887.method_58442(
                itemLookup.method_46735(EEItemTags.HOE_ENCHANTABLE),
                1,
                1,
                class_1887.method_58440(20),
                class_1887.method_58440(75),
                8,
                class_9274.field_49217
            )
        ).method_60062(
            EEEnchantmentComponentTypes.REPLANT
        )
    );
    public static final EnchantmentContainer SOIL_WALKER = new EnchantmentContainer(
        ExtendedEnchantingMain.identifier("soil_walker"),
        (itemLookup, enchantmentLookup, damageLookup, blockLookup, entityLookup) -> class_1887.method_60030(
            class_1887.method_58442(
                itemLookup.method_46735(class_3489.field_48299),
                2,
                1,
                class_1887.method_58440(15),
                class_1887.method_58440(50),
                8,
                class_9274.field_49220
            )
        ).method_60062(
            EEEnchantmentComponentTypes.SOIL_STEP
        ).method_60061(
            enchantmentLookup.method_46735(class_9636.field_51539)
        )
    );

    public static final EnchantmentContainer CHORUS_CURSE = new EnchantmentContainer(
        ExtendedEnchantingMain.identifier("chorus_curse"),
        (itemLookup, enchantmentLookup, damageLookup, blockLookup, entityLookup) -> class_1887.method_60030(
            class_1887.method_58442(
                itemLookup.method_46735(class_3489.field_48301),
                2,
                1,
                class_1887.method_58440(25),
                class_1887.method_58440(75),
                4,
                class_9274.field_49222
            )
        ).method_60063(
            class_9701.field_51665,
            class_9703.field_51685,
            class_9703.field_51685,
            new CodeExecutionSingleEntityEffect(ExtendedEnchantingMain.identifier("chorus_teleport"))
        )
    );

    public static void bootstrap (class_7891<class_1887> registerable) {
        register(registerable, LEECHING_ASPECT);
        register(registerable, FROST_ASPECT);
        register(registerable, LIGHTNING_ASPECT);
        register(registerable, INITIATIVE);
        register(registerable, GLASS);
        register(registerable, SOLITUDE);
        register(registerable, DUAL_STRIKE);
        register(registerable, FEINT);
        register(registerable, RAMPAGE);
        register(registerable, LAUNCH);
        register(registerable, WEAPON_PROTECTION);
        register(registerable, COMBUSTION_PROTECTION);
        register(registerable, SUN_HEART);
        register(registerable, MOON_HEART);
        register(registerable, BRIMSTONE_HEART);
        register(registerable, VOID_HEART);
        register(registerable, REPLANT);
        register(registerable, SOIL_WALKER);
        register(registerable, CHORUS_CURSE);
    }

    private static void register (class_7891<class_1887> registry, EnchantmentContainer container) {
        registry.method_46838(container.getKey(), container.getBuilder(registry).method_60060(container.getKey().method_29177()));
    }
}
