/*
 * Decompiled with CFR 0.152.
 */
package com.tiomadre.foragersinsight.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.tiomadre.foragersinsight.common.block.entity.DiffuserBlockEntity;
import com.tiomadre.foragersinsight.common.diffuser.DiffuserScent;
import com.tiomadre.foragersinsight.common.gui.DiffuserMenu;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import org.jetbrains.annotations.NotNull;

public class DiffuserScreen
extends AbstractContainerScreen<DiffuserMenu> {
    private static final ResourceLocation UNLIT_TEXTURE = new ResourceLocation("foragersinsight", "textures/gui/diffuser.png");
    private static final ResourceLocation LIT_TEXTURE = new ResourceLocation("foragersinsight", "textures/gui/diffuser_lit.png");
    private static final int ARROW_U = 177;
    private static final int ARROW_V = 0;
    private static final int ARROW_HEIGHT = 16;
    private static final int ARROW_WIDTH = 22;
    private static final int ARROW_X = 125;
    private static final int ARROW_Y = 33;
    private static final int EXTINGUISH_BUTTON_SIZE = 6;
    private static final int EXTINGUISH_BUTTON_X = 131;
    private static final int EXTINGUISH_BUTTON_Y = 61;
    private static final int SCENT_CLOUD_Y = 24;
    private static final int SCENT_CLOUD_SIZE = 16;
    private static final int ICON_SIZE = 16;
    private Button extinguishButton;

    public DiffuserScreen(DiffuserMenu menu, Inventory inv, Component title) {
        super((AbstractContainerMenu)menu, inv, title);
        this.f_97726_ = 176;
        this.f_97727_ = 166;
        this.f_97728_ = 8;
        this.f_97729_ = 6;
        this.f_97730_ = 8;
        this.f_97731_ = this.f_97727_ - 96 + 2;
    }

    protected void m_7856_() {
        super.m_7856_();
        int buttonX = this.f_97735_ + 131;
        int buttonY = this.f_97736_ + 61;
        this.extinguishButton = Button.m_253074_((Component)Component.m_237119_(), this::onExtinguishPressed).m_252987_(buttonX, buttonY, 6, 6).m_253136_();
        this.extinguishButton.m_93650_(0.0f);
        this.extinguishButton.m_257544_(Tooltip.m_257550_((Component)Component.m_237115_((String)"gui.foragersinsight.diffuser.extinguish")));
        this.m_142416_((GuiEventListener)this.extinguishButton);
        this.updateButtonState();
    }

    private void updateButtonState() {
        if (this.extinguishButton != null) {
            this.extinguishButton.f_93623_ = ((DiffuserMenu)this.f_97732_).getActiveScent().isPresent();
        }
    }

    private void onExtinguishPressed(Button button) {
        if (this.f_96541_ == null || this.f_96541_.f_91072_ == null) {
            return;
        }
        if (((DiffuserMenu)this.f_97732_).getActiveScent().isEmpty()) {
            return;
        }
        this.f_96541_.f_91072_.m_105208_(((DiffuserMenu)this.f_97732_).f_38840_, 0);
    }

    protected void m_181908_() {
        super.m_181908_();
        this.updateButtonState();
    }

    protected void m_7286_(@NotNull GuiGraphics gui, float partialTicks, int mouseX, int mouseY) {
        ResourceLocation background = ((DiffuserMenu)this.f_97732_).isLit() ? LIT_TEXTURE : UNLIT_TEXTURE;
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)background);
        int left = (this.f_96543_ - this.f_97726_) / 2;
        int top = (this.f_96544_ - this.f_97727_) / 2;
        gui.m_280218_(background, left, top, 0, 0, this.f_97726_, this.f_97727_);
        int progress = Math.min(((DiffuserMenu)this.f_97732_).getCraftProgress(), 22);
        if (progress > 0) {
            gui.m_280218_(background, left + 125, top + 33, 177, 0, progress, 16);
        }
        this.renderScentIcon(gui, left, top);
    }

    public void m_88315_(@NotNull GuiGraphics gui, int mouseX, int mouseY, float partialTicks) {
        this.m_280273_(gui);
        super.m_88315_(gui, mouseX, mouseY, partialTicks);
        this.m_280072_(gui, mouseX, mouseY);
        this.renderScentTooltip(gui, mouseX, mouseY);
        this.renderScentCloudTooltip(gui, mouseX, mouseY);
    }

    private void renderScentIcon(GuiGraphics gui, int left, int top) {
        Optional<DiffuserScent> scent = ((DiffuserMenu)this.f_97732_).getActiveScent();
        if (scent.isEmpty()) {
            return;
        }
        Slot slot = ((DiffuserMenu)this.f_97732_).m_38853_(4);
        int iconX = left + slot.f_40220_;
        int iconY = top + slot.f_40221_;
        gui.m_280163_(scent.get().icon(), iconX, iconY, 0.0f, 0.0f, 16, 16, 16, 16);
    }

    private void renderScentTooltip(GuiGraphics gui, int mouseX, int mouseY) {
        Optional<DiffuserScent> scent = ((DiffuserMenu)this.f_97732_).getActiveScent();
        if (scent.isEmpty()) {
            return;
        }
        Slot slot = ((DiffuserMenu)this.f_97732_).m_38853_(4);
        int left = (this.f_96543_ - this.f_97726_) / 2;
        int top = (this.f_96544_ - this.f_97727_) / 2;
        int iconX = left + slot.f_40220_;
        int iconY = top + slot.f_40221_;
        if (mouseX >= iconX && mouseX < iconX + 16 && mouseY >= iconY && mouseY < iconY + 16) {
            gui.m_280666_(this.f_96547_, scent.get().tooltip(), mouseX, mouseY);
        }
    }

    private void renderScentCloudTooltip(GuiGraphics gui, int mouseX, int mouseY) {
        if (!((DiffuserMenu)this.f_97732_).isLit()) {
            return;
        }
        Optional<DiffuserScent> scent = ((DiffuserMenu)this.f_97732_).getActiveScent();
        if (scent.isEmpty()) {
            return;
        }
        Slot slot = ((DiffuserMenu)this.f_97732_).m_38853_(4);
        int left = (this.f_96543_ - this.f_97726_) / 2;
        int top = (this.f_96544_ - this.f_97727_) / 2;
        int infoX = left + slot.f_40220_;
        int infoY = top + slot.f_40221_ - 24;
        if (mouseX < infoX || mouseX >= infoX + 16 || mouseY < infoY || mouseY >= infoY + 16) {
            return;
        }
        double radius = ((DiffuserMenu)this.f_97732_).getEffectiveRadius();
        int durationSeconds = (int)Math.round((double)Math.max(((DiffuserMenu)this.f_97732_).getRemainingDuration(), 0) / 20.0);
        ArrayList<MutableComponent> tooltip = new ArrayList<MutableComponent>(3);
        tooltip.add(Component.m_237110_((String)"gui.foragersinsight.diffuser.tooltip.radius", (Object[])new Object[]{String.format(Locale.ROOT, "%.1f", radius)}).m_130940_(ChatFormatting.WHITE));
        tooltip.add(Component.m_237110_((String)"gui.foragersinsight.diffuser.tooltip.duration", (Object[])new Object[]{durationSeconds}).m_130940_(ChatFormatting.WHITE));
        DiffuserBlockEntity.Enhancement enhancement = ((DiffuserMenu)this.f_97732_).getActiveEnhancement();
        if (enhancement == DiffuserBlockEntity.Enhancement.RADIUS) {
            tooltip.add(Component.m_237115_((String)"gui.foragersinsight.diffuser.tooltip.enhanced_radius").m_130938_(style -> style.m_131148_(DiffuserScent.RADIUS_ACCENT_COLOR)));
        } else if (enhancement == DiffuserBlockEntity.Enhancement.DURATION) {
            tooltip.add(Component.m_237115_((String)"gui.foragersinsight.diffuser.tooltip.enhanced_duration").m_130938_(style -> style.m_131148_(DiffuserScent.DURATION_ACCENT_COLOR)));
        }
        gui.m_280666_(this.f_96547_, tooltip, mouseX, mouseY);
    }
}

