/*
 * Decompiled with CFR 0.152.
 */
package com.tiomadre.foragersinsight.common.block;

import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.common.ToolActions;
import org.jetbrains.annotations.NotNull;

public class BountifulLeavesBlock
extends LeavesBlock
implements BonemealableBlock {
    private final Supplier<Item> bounty;
    public static final int MAX_AGE = 3;
    public static final IntegerProperty AGE = IntegerProperty.m_61631_((String)"age", (int)0, (int)3);

    public BountifulLeavesBlock(BlockBehaviour.Properties props, Supplier<Item> bounty) {
        super(props);
        this.bounty = bounty;
        this.m_49959_((BlockState)super.m_49966_().m_61124_((Property)AGE, (Comparable)Integer.valueOf(0)));
    }

    public boolean m_6724_(@NotNull BlockState state) {
        return super.m_6724_(state) || this.canGrow(state);
    }

    public void m_213898_(@NotNull BlockState state, @NotNull ServerLevel level, @NotNull BlockPos pos, @NotNull RandomSource rand) {
        super.m_213898_(state, level, pos, rand);
        if (rand.m_188503_(256) == 0) {
            if (!level.isAreaLoaded(pos, 1)) {
                return;
            }
            if (level.m_45524_(pos, 0) < 9) {
                return;
            }
            this.mature((Level)level, pos, state);
            for (Direction dir : Direction.values()) {
                BlockState relativeState = level.m_8055_(pos.m_121945_(dir));
                if (!(relativeState.m_60734_() instanceof BountifulLeavesBlock)) continue;
                this.mature((Level)level, pos.m_121945_(dir), level.m_8055_(pos.m_121945_(dir)));
            }
        }
    }

    private void mature(Level level, BlockPos pos, BlockState state) {
        if (this.canGrow(state)) {
            int newAge = this.getAge(state) + 1;
            level.m_7731_(pos, (BlockState)state.m_61124_((Property)AGE, (Comparable)Integer.valueOf(newAge)), 2);
        }
    }

    public int getAge(@NotNull BlockState state) {
        return (Integer)state.m_61143_((Property)AGE);
    }

    public boolean canGrow(BlockState state) {
        if (this.getAge(state) >= 3) {
            return false;
        }
        return (Integer)state.m_61143_((Property)LeavesBlock.f_54418_) < 7;
    }

    @NotNull
    public InteractionResult m_6227_(BlockState pState, @NotNull Level pLevel, @NotNull BlockPos pPos, @NotNull Player pPlayer, @NotNull InteractionHand pHand, @NotNull BlockHitResult pHit) {
        int age = (Integer)pState.m_61143_((Property)AGE);
        boolean isFullGrown = age == 3;
        boolean playerHasShears = pPlayer.m_21120_(pHand).canPerformAction(ToolActions.SHEARS_HARVEST);
        if (!isFullGrown && pPlayer.m_21120_(pHand).m_150930_(Items.f_42499_)) {
            return InteractionResult.PASS;
        }
        if (isFullGrown && !playerHasShears) {
            BountifulLeavesBlock.m_49840_((Level)pLevel, (BlockPos)pPos, (ItemStack)new ItemStack((ItemLike)this.bounty.get()));
            pLevel.m_5594_(null, pPos, SoundEvents.f_12457_, SoundSource.BLOCKS, 1.0f, 0.8f + pLevel.f_46441_.m_188501_() * 0.4f);
            BlockState blockstate = (BlockState)pState.m_61124_((Property)AGE, (Comparable)Integer.valueOf(0));
            pLevel.m_7731_(pPos, blockstate, 2);
            pLevel.m_220407_(GameEvent.f_157792_, pPos, GameEvent.Context.m_223719_((Entity)pPlayer, (BlockState)blockstate));
            return InteractionResult.m_19078_((boolean)pLevel.f_46443_);
        }
        return super.m_6227_(pState, pLevel, pPos, pPlayer, pHand, pHit);
    }

    protected void m_7926_(@NotNull StateDefinition.Builder<Block, BlockState> pBuilder) {
        super.m_7926_(pBuilder);
        pBuilder.m_61104_(new Property[]{AGE});
    }

    public boolean m_7370_(@NotNull LevelReader pLevel, @NotNull BlockPos pPos, @NotNull BlockState state, boolean pIsClient) {
        return this.getAge(state) != 3;
    }

    public boolean m_214167_(@NotNull Level level, @NotNull RandomSource random, @NotNull BlockPos pPos, @NotNull BlockState pState) {
        return random.m_188503_(2) == 0;
    }

    public void m_214148_(@NotNull ServerLevel level, @NotNull RandomSource pRandom, @NotNull BlockPos pos, @NotNull BlockState state) {
        int aNewAgeArrives = this.getAge(state) + 1;
        level.m_7731_(pos, (BlockState)state.m_61124_((Property)AGE, (Comparable)Integer.valueOf(aNewAgeArrives)), 3);
    }

    public Item getBounty() {
        return this.bounty.get();
    }
}

