/*
 * Decompiled with CFR 0.152.
 */
package com.tiomadre.foragersinsight.common.block;

import com.tiomadre.foragersinsight.common.block.entity.DiffuserBlockEntity;
import com.tiomadre.foragersinsight.common.diffuser.DiffuserScent;
import com.tiomadre.foragersinsight.core.registry.FIBlockEntityTypes;
import com.tiomadre.foragersinsight.core.registry.FIParticleTypes;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DiffuserBlock
extends BaseEntityBlock
implements SimpleWaterloggedBlock {
    public static final BooleanProperty LIT = BlockStateProperties.f_61443_;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    private static final VoxelShape SHAPE = Shapes.m_83124_((VoxelShape)Block.m_49796_((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)12.0, (double)12.0), (VoxelShape[])new VoxelShape[]{Block.m_49796_((double)9.0, (double)12.0, (double)6.0, (double)10.0, (double)14.0, (double)10.0), Block.m_49796_((double)6.0, (double)12.0, (double)6.0, (double)7.0, (double)14.0, (double)10.0), Block.m_49796_((double)7.0, (double)12.0, (double)6.0, (double)9.0, (double)14.0, (double)7.0), Block.m_49796_((double)7.0, (double)12.0, (double)9.0, (double)9.0, (double)14.0, (double)10.0)});

    public DiffuserBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)LIT, (Comparable)Boolean.valueOf(false))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    @Nullable
    public BlockEntity m_142194_(@NotNull BlockPos pos, @NotNull BlockState state) {
        return new DiffuserBlockEntity(pos, state);
    }

    @NotNull
    public InteractionResult m_6227_(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull Player player, @NotNull InteractionHand hand, @NotNull BlockHitResult hit) {
        ItemStack held = player.m_21120_(hand);
        boolean flintAndSteel = held.m_150930_(Items.f_42409_);
        BlockEntity entity = level.m_7702_(pos);
        if (!(entity instanceof DiffuserBlockEntity)) {
            return InteractionResult.m_19078_((boolean)level.f_46443_);
        }
        DiffuserBlockEntity diffuser = (DiffuserBlockEntity)entity;
        if (!level.f_46443_) {
            if (flintAndSteel && diffuser.tryStartDiffusion()) {
                held.m_41622_(1, (LivingEntity)player, p -> p.m_21190_(hand));
                level.m_5594_(null, pos, SoundEvents.f_11942_, SoundSource.BLOCKS, 1.0f, level.f_46441_.m_188501_() * 0.4f + 0.8f);
                return InteractionResult.CONSUME;
            }
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                NetworkHooks.openScreen((ServerPlayer)serverPlayer, (MenuProvider)diffuser, (BlockPos)pos);
            }
        }
        return InteractionResult.m_19078_((boolean)level.f_46443_);
    }

    public void m_6402_(@NotNull Level level, @NotNull BlockPos pos, @NotNull BlockState state, @Nullable LivingEntity placer, @NotNull ItemStack stack) {
        super.m_6402_(level, pos, state, placer, stack);
    }

    @NotNull
    public VoxelShape m_5940_(@NotNull BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        return SHAPE;
    }

    public boolean m_7898_(@NotNull BlockState state, @NotNull LevelReader level, @NotNull BlockPos pos) {
        BlockPos belowPos = pos.m_7495_();
        BlockState belowState = level.m_8055_(belowPos);
        return belowState.m_60783_((BlockGetter)level, belowPos, Direction.UP) || Block.m_49918_((VoxelShape)belowState.m_60812_((BlockGetter)level, belowPos), (Direction)Direction.UP);
    }

    @NotNull
    public BlockState m_7417_(@NotNull BlockState state, @NotNull Direction direction, @NotNull BlockState neighborState, @NotNull LevelAccessor level, @NotNull BlockPos currentPos, @NotNull BlockPos neighborPos) {
        if (direction == Direction.DOWN && !this.m_7898_(state, (LevelReader)level, currentPos)) {
            return Blocks.f_50016_.m_49966_();
        }
        if (((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            level.m_186469_(currentPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)level));
        }
        return super.m_7417_(state, direction, neighborState, level, currentPos, neighborPos);
    }

    @NotNull
    public RenderShape m_7514_(@NotNull BlockState state) {
        return RenderShape.MODEL;
    }

    public BlockState m_5573_(@NotNull BlockPlaceContext context) {
        FluidState fluidState = context.m_43725_().m_6425_(context.m_8083_());
        return (BlockState)this.m_49966_().m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidState.m_205070_(FluidTags.f_13131_)));
    }

    public void m_6810_(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull BlockState newState, boolean isMoving) {
        BlockEntity entity;
        if (!state.m_60713_(newState.m_60734_()) && (entity = level.m_7702_(pos)) instanceof DiffuserBlockEntity) {
            DiffuserBlockEntity diffuser = (DiffuserBlockEntity)entity;
            Containers.m_19002_((Level)level, (BlockPos)pos, (Container)diffuser);
            level.m_46717_(pos, (Block)this);
        }
        super.m_6810_(state, level, pos, newState, isMoving);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(@NotNull Level level, @NotNull BlockState state, @NotNull BlockEntityType<T> type) {
        return level.f_46443_ ? null : DiffuserBlock.m_152132_(type, (BlockEntityType)((BlockEntityType)FIBlockEntityTypes.DIFFUSER.get()), DiffuserBlockEntity::serverTick);
    }

    public void m_214162_(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull RandomSource random) {
        BlockEntity entity;
        if (!((Boolean)state.m_61143_((Property)LIT)).booleanValue()) {
            return;
        }
        double x = (double)pos.m_123341_() + 0.5;
        double y = (double)pos.m_123342_() + 1.0;
        double z = (double)pos.m_123343_() + 0.5;
        double offsetX = (random.m_188500_() - 0.5) * 0.1;
        double offsetZ = (random.m_188500_() - 0.5) * 0.1;
        boolean submerged = this.isSubmergedInWater(level, pos, state);
        if (!submerged && random.m_188503_(4) == 0) {
            level.m_7106_((ParticleOptions)ParticleTypes.f_123777_, x, y, z, offsetX * 0.6, 0.07, offsetZ * 0.6);
        } else if (submerged && random.m_188503_(4) == 0) {
            double bubbleX = x + (random.m_188500_() - 0.5) * 0.3;
            double bubbleY = y + random.m_188500_() * 0.2;
            double bubbleZ = z + (random.m_188500_() - 0.5) * 0.3;
            level.m_7106_((ParticleOptions)ParticleTypes.f_123795_, bubbleX, bubbleY, bubbleZ, 0.0, 0.05 + random.m_188500_() * 0.02, 0.0);
        }
        if (random.m_188503_(10) == 0) {
            if (submerged) {
                level.m_7785_(x, y, z, SoundEvents.f_11774_, SoundSource.BLOCKS, 0.4f, 0.6f, false);
            } else {
                level.m_7785_(x, y, z, SoundEvents.f_11784_, SoundSource.BLOCKS, 0.4f, 0.4f, false);
            }
        }
        if (random.m_188503_(5) == 0 && (entity = level.m_7702_(pos)) instanceof DiffuserBlockEntity) {
            DiffuserBlockEntity diffuser = (DiffuserBlockEntity)entity;
            diffuser.getActiveScent().ifPresent(scent -> {
                double scentX = x + (random.m_188500_() - 0.5) * 0.3;
                double scentY = y + 0.2 + random.m_188500_() * 0.2;
                double scentZ = z + (random.m_188500_() - 0.5) * 0.3;
                this.spawnScentParticle(level, random, scentX, scentY, scentZ, (DiffuserScent)scent);
            });
        }
    }

    private void spawnScentParticle(Level level, RandomSource random, double x, double y, double z, DiffuserScent scent) {
        SimpleParticleType particle = this.getScentParticleType(scent);
        if (particle == null) {
            return;
        }
        double driftX = (random.m_188500_() - 0.5) * 0.08;
        double driftY = 0.03 + random.m_188500_() * 0.02;
        double driftZ = (random.m_188500_() - 0.5) * 0.08;
        level.m_7106_((ParticleOptions)particle, x, y, z, driftX, driftY, driftZ);
    }

    @Nullable
    private SimpleParticleType getScentParticleType(DiffuserScent scent) {
        if (scent == DiffuserScent.ROSEY.get()) {
            return (SimpleParticleType)FIParticleTypes.ROSE_SCENT.get();
        }
        if (scent == DiffuserScent.CONIFEROUS.get()) {
            return (SimpleParticleType)FIParticleTypes.CONIFEROUS_SCENT.get();
        }
        if (scent == DiffuserScent.FLORAL.get()) {
            return (SimpleParticleType)FIParticleTypes.FLORAL_SCENT.get();
        }
        if (scent == DiffuserScent.FOUL.get()) {
            return (SimpleParticleType)FIParticleTypes.FOUL_SCENT.get();
        }
        return null;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{LIT, WATERLOGGED});
    }

    private boolean isSubmergedInWater(Level level, BlockPos pos, BlockState state) {
        if (((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            return true;
        }
        FluidState currentState = level.m_6425_(pos);
        if (currentState.m_205070_(FluidTags.f_13131_)) {
            return true;
        }
        FluidState aboveState = level.m_6425_(pos.m_7494_());
        return aboveState.m_205070_(FluidTags.f_13131_);
    }

    @NotNull
    public FluidState m_5888_(BlockState state) {
        if (((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            return Fluids.f_76193_.m_76068_(false);
        }
        return super.m_5888_(state);
    }
}

