/*
 * Decompiled with CFR 0.152.
 */
package com.tiomadre.foragersinsight.common.block;

import com.tiomadre.foragersinsight.core.registry.FIItems;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.ForgeHooks;
import org.jetbrains.annotations.NotNull;

public class RoseCropBlock
extends CropBlock
implements BonemealableBlock {
    public static final int MAX_AGE = 4;
    private static final VoxelShape[] SHAPE_BY_AGE = new VoxelShape[]{Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)5.0, (double)16.0), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)9.0, (double)16.0), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)13.0, (double)16.0), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)6.0, (double)16.0), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0)};
    public static final EnumProperty<DoubleBlockHalf> HALF = EnumProperty.m_61587_((String)"half", DoubleBlockHalf.class);
    public static final IntegerProperty AGE = IntegerProperty.m_61631_((String)"age", (int)0, (int)4);
    public final int isDoubleAfterAge;

    public RoseCropBlock(BlockBehaviour.Properties props, int isDoubleAfterAge) {
        super(props);
        this.isDoubleAfterAge = isDoubleAfterAge;
        this.m_49959_((BlockState)((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_(HALF, (Comparable)DoubleBlockHalf.LOWER)).m_61124_((Property)AGE, (Comparable)Integer.valueOf(0)));
    }

    public boolean isDouble(BlockState state) {
        return this.m_52305_(state) >= this.isDoubleAfterAge;
    }

    public boolean isDouble(int age) {
        return age >= this.isDoubleAfterAge;
    }

    public DoubleBlockHalf getHalf(BlockState state) {
        return (DoubleBlockHalf)state.m_61143_(HALF);
    }

    public boolean m_6724_(@NotNull BlockState state) {
        return super.m_6724_(state) && this.getHalf(state) == DoubleBlockHalf.LOWER;
    }

    public void m_213898_(@NotNull BlockState state, @NotNull ServerLevel level, @NotNull BlockPos pos, @NotNull RandomSource rand) {
        if (this.m_52307_(state) || !level.isAreaLoaded(pos, 1) || level.m_45524_(pos, 0) < 9) {
            return;
        }
        float growthSpeed = RoseCropBlock.m_52272_((Block)this, (BlockGetter)level, (BlockPos)pos);
        if (ForgeHooks.onCropsGrowPre((Level)level, (BlockPos)pos, (BlockState)state, (rand.m_188503_((int)(25.0f / growthSpeed)) == 0 ? 1 : 0) != 0)) {
            this.mature((Level)level, state, pos);
            ForgeHooks.onCropsGrowPost((Level)level, (BlockPos)pos, (BlockState)state);
        }
    }

    private void mature(int stages, Level level, BlockState state, BlockPos pos) {
        if (this.m_52307_(state)) {
            return;
        }
        if (!this.canGrow(level, pos) && this.isDouble(this.m_52305_(state) + stages)) {
            int index = this.stagesBeforeDouble(state);
            if (index != 0) {
                this.mature(index, level, state, pos);
            }
            return;
        }
        if (this.getHalf(state) == DoubleBlockHalf.UPPER) {
            if (level.m_8055_(pos.m_7495_()).m_60713_((Block)this)) {
                this.mature(stages, level, level.m_8055_(pos.m_7495_()), pos.m_7495_());
            }
            return;
        }
        int newAge = Math.min(this.m_52305_(state) + stages, 4);
        if (this.isDouble(newAge)) {
            level.m_7731_(pos, this.m_52289_(newAge), 2);
            level.m_7731_(pos.m_7494_(), (BlockState)this.m_52289_(newAge).m_61124_(HALF, (Comparable)DoubleBlockHalf.UPPER), 2);
        } else {
            level.m_7731_(pos, this.m_52289_(newAge), 2);
        }
    }

    private void mature(Level level, BlockState state, BlockPos pos) {
        this.mature(1, level, state, pos);
    }

    @NotNull
    protected IntegerProperty m_7959_() {
        return AGE;
    }

    public int m_7419_() {
        return 4;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> stateDef) {
        stateDef.m_61104_(new Property[]{HALF, AGE});
    }

    public static boolean isIllegalState(BlockState state) {
        Block block = state.m_60734_();
        if (block instanceof RoseCropBlock) {
            RoseCropBlock crop = (RoseCropBlock)block;
            return (Integer)state.m_61143_((Property)AGE) < crop.isDoubleAfterAge && state.m_61143_(HALF) == DoubleBlockHalf.UPPER;
        }
        return false;
    }

    protected int getBonemealAgeIncrease(Level level, BlockPos pos, BlockState state) {
        if (this.canGrow(level, pos)) {
            return level.m_213780_().m_216339_(1, 3);
        }
        return Math.min(this.stagesBeforeDouble(state), level.m_213780_().m_216339_(1, 3));
    }

    public void m_52263_(@NotNull Level level, @NotNull BlockPos pos, @NotNull BlockState state) {
        this.mature(this.getBonemealAgeIncrease(level, pos, state), level, state, pos);
    }

    @NotNull
    public VoxelShape m_5940_(@NotNull BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        int age = this.m_52305_(state);
        if (this.isDouble(age) && state.m_61143_(HALF) == DoubleBlockHalf.LOWER) {
            return Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
        }
        return SHAPE_BY_AGE[age];
    }

    @NotNull
    public BlockState m_7417_(@NotNull BlockState state, @NotNull Direction direction, @NotNull BlockState updatedState, @NotNull LevelAccessor level, @NotNull BlockPos pos, @NotNull BlockPos updatePos) {
        if (!this.isDouble(state)) {
            return super.m_7417_(state, direction, updatedState, level, pos, updatePos);
        }
        if ((Integer)state.m_61143_((Property)AGE) == 0 && state.m_61143_(HALF) == DoubleBlockHalf.LOWER) {
            return state;
        }
        DoubleBlockHalf thisHalf = (DoubleBlockHalf)state.m_61143_(HALF);
        if (direction.m_122434_() != Direction.Axis.Y || thisHalf == DoubleBlockHalf.LOWER != (direction == Direction.UP) || updatedState.m_60713_((Block)this) && updatedState.m_61143_(HALF) != thisHalf) {
            return thisHalf == DoubleBlockHalf.LOWER && direction == Direction.DOWN && !state.m_60710_((LevelReader)level, pos) ? Blocks.f_50016_.m_49966_() : super.m_7417_(state, direction, updatedState, level, pos, updatePos);
        }
        return Blocks.f_50016_.m_49966_();
    }

    @NotNull
    protected ItemLike m_6404_() {
        return (ItemLike)FIItems.ROSE_HIP.get();
    }

    public boolean m_7898_(BlockState state, @NotNull LevelReader level, @NotNull BlockPos pos) {
        if (state.m_61143_(HALF) != DoubleBlockHalf.UPPER) {
            return super.m_7898_(state, level, pos);
        }
        BlockState lower = level.m_8055_(pos.m_7495_());
        if (lower.m_60734_() == this && lower.m_61138_((Property)AGE) && (Integer)lower.m_61143_((Property)AGE) == 0) {
            return false;
        }
        if (state.m_60734_() != this) {
            return super.m_7898_(state, level, pos);
        }
        return lower.m_60713_((Block)this) && lower.m_61143_(HALF) == DoubleBlockHalf.LOWER;
    }

    public boolean canGrow(Level level, BlockPos pos) {
        BlockState aboveState = level.m_8055_(pos.m_7494_());
        return aboveState.m_204336_(BlockTags.f_278394_) || aboveState.m_60713_((Block)this);
    }

    public int stagesBeforeDouble(BlockState state) {
        return this.isDoubleAfterAge - 1 - this.m_52305_(state);
    }
}

