/*
 * Decompiled with CFR 0.152.
 */
package com.tiomadre.foragersinsight.common.block;

import com.tiomadre.foragersinsight.core.registry.FIBlocks;
import com.tiomadre.foragersinsight.core.registry.FIItems;
import com.tiomadre.foragersinsight.core.registry.FIParticleTypes;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TapperBlock
extends HorizontalDirectionalBlock {
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.f_54117_;
    public static final BooleanProperty HAS_TAPPER = BooleanProperty.m_61465_((String)"has_tapper");
    public static final IntegerProperty FILL = IntegerProperty.m_61631_((String)"fill", (int)0, (int)4);
    private static final VoxelShape NORTH_SHAPE = Stream.of(Block.m_49796_((double)7.5, (double)12.0, (double)0.0, (double)8.5, (double)15.0, (double)6.0), Block.m_49796_((double)7.5, (double)13.0, (double)6.0, (double)8.5, (double)15.0, (double)11.0), Block.m_49796_((double)3.5, (double)2.0, (double)1.0, (double)12.5, (double)11.0, (double)10.0), Block.m_49796_((double)11.5, (double)11.0, (double)5.0, (double)11.5, (double)15.0, (double)6.0), Block.m_49796_((double)4.5, (double)11.0, (double)5.0, (double)4.5, (double)15.0, (double)6.0), Block.m_49796_((double)4.5, (double)15.0, (double)5.0, (double)11.5, (double)15.0, (double)6.0)).reduce(Shapes.m_83040_(), Shapes::m_83110_);
    private static final VoxelShape EAST_SHAPE = TapperBlock.rotateShape(Direction.EAST);
    private static final VoxelShape SOUTH_SHAPE = TapperBlock.rotateShape(Direction.SOUTH);
    private static final VoxelShape WEST_SHAPE = TapperBlock.rotateShape(Direction.WEST);

    public TapperBlock(BlockBehaviour.Properties props) {
        super(props);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)HAS_TAPPER, (Comparable)Boolean.valueOf(false))).m_61124_((Property)FILL, (Comparable)Integer.valueOf(0)));
    }

    @NotNull
    public ItemStack m_7397_(@NotNull BlockGetter level, @NotNull BlockPos pos, @NotNull BlockState state) {
        return new ItemStack((ItemLike)FIItems.TAPPER.get());
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, FILL, HAS_TAPPER});
    }

    @NotNull
    public VoxelShape m_5940_(@NotNull BlockState state, @NotNull BlockGetter world, @NotNull BlockPos pos, @NotNull CollisionContext ctx) {
        return switch ((Direction)state.m_61143_((Property)FACING)) {
            case Direction.EAST -> WEST_SHAPE;
            case Direction.SOUTH -> NORTH_SHAPE;
            case Direction.WEST -> EAST_SHAPE;
            default -> SOUTH_SHAPE;
        };
    }

    private static VoxelShape rotateShape(Direction to) {
        if (Direction.NORTH == to) {
            return NORTH_SHAPE;
        }
        VoxelShape[] buffer = new VoxelShape[]{NORTH_SHAPE, Shapes.m_83040_()};
        int rotations = (to.m_122416_() - Direction.NORTH.m_122416_() + 4) % 4;
        for (int i = 0; i < rotations; ++i) {
            buffer[0].m_83286_((minX, minY, minZ, maxX, maxY, maxZ) -> {
                buffer[1] = Shapes.m_83110_((VoxelShape)buffer[1], (VoxelShape)Shapes.m_83048_((double)(1.0 - maxZ), (double)minY, (double)minX, (double)(1.0 - minZ), (double)maxY, (double)maxX));
            });
            buffer[0] = buffer[1];
            buffer[1] = Shapes.m_83040_();
        }
        return buffer[0];
    }

    @Nullable
    public BlockState m_5573_(@NotNull BlockPlaceContext context) {
        BlockPos logPos;
        Direction face = context.m_43719_();
        if (face.m_122434_().m_122478_()) {
            return null;
        }
        Level level = context.m_43725_();
        BlockState logState = level.m_8055_(logPos = context.m_8083_().m_121945_(face.m_122424_()));
        if (!logState.m_60713_((Block)FIBlocks.SAPPY_BIRCH_LOG.get()) || logState.m_61143_((Property)RotatedPillarBlock.f_55923_) != Direction.Axis.Y) {
            return null;
        }
        return (BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)face)).m_61124_((Property)HAS_TAPPER, (Comparable)Boolean.valueOf(true))).m_61124_((Property)FILL, (Comparable)Integer.valueOf(0));
    }

    public boolean m_7898_(@NotNull BlockState state, @NotNull LevelReader world, @NotNull BlockPos pos) {
        Direction attachDir = ((Direction)state.m_61143_((Property)FACING)).m_122424_();
        BlockState logState = world.m_8055_(pos.m_121945_(attachDir));
        return logState.m_60713_((Block)FIBlocks.SAPPY_BIRCH_LOG.get()) && logState.m_61143_((Property)RotatedPillarBlock.f_55923_) == Direction.Axis.Y;
    }

    @NotNull
    public BlockState m_7417_(@NotNull BlockState state, @NotNull Direction direction, @NotNull BlockState neighborState, @NotNull LevelAccessor level, @NotNull BlockPos currentPos, @NotNull BlockPos neighborPos) {
        Direction attachDir = ((Direction)state.m_61143_((Property)FACING)).m_122424_();
        if (direction == attachDir && !this.m_7898_(state, (LevelReader)level, currentPos)) {
            return Blocks.f_50016_.m_49966_();
        }
        return super.m_7417_(state, direction, neighborState, level, currentPos, neighborPos);
    }

    public boolean m_6724_(@NotNull BlockState state) {
        return (Boolean)state.m_61143_((Property)HAS_TAPPER) != false && (Integer)state.m_61143_((Property)FILL) < 4;
    }

    public void m_213898_(@NotNull BlockState state, @NotNull ServerLevel level, @NotNull BlockPos pos, @NotNull RandomSource random) {
        level.m_7731_(pos, (BlockState)state.m_61124_((Property)FILL, (Comparable)Integer.valueOf((Integer)state.m_61143_((Property)FILL) + 1)), 2);
    }

    public void m_214162_(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull RandomSource random) {
        if (!((Boolean)state.m_61143_((Property)HAS_TAPPER)).booleanValue()) {
            return;
        }
        if (random.m_188503_(10) == 0) {
            Direction facing = (Direction)state.m_61143_((Property)FACING);
            double x = (double)pos.m_123341_() + 0.5;
            double y = (double)pos.m_123342_() + 0.8;
            double z = (double)pos.m_123343_() + 0.5;
            double inwardOffset = 0.25;
            level.m_7106_((ParticleOptions)FIParticleTypes.DRIPPING_SAP.get(), x -= (double)facing.m_122429_() * inwardOffset, y, z -= (double)facing.m_122431_() * inwardOffset, 0.0, -0.005, 0.0);
            level.m_7785_(x, y, z, SoundEvents.f_11694_, SoundSource.BLOCKS, 0.6f, 1.0E-4f, false);
        }
    }

    @NotNull
    public InteractionResult m_6227_(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull Player player, @NotNull InteractionHand hand, @NotNull BlockHitResult hit) {
        ItemStack held = player.m_21120_(hand);
        if (((Boolean)state.m_61143_((Property)HAS_TAPPER)).booleanValue() && (Integer)state.m_61143_((Property)FILL) == 4 && held.m_150930_(Items.f_42446_)) {
            if (!level.f_46443_) {
                ItemStack sap = new ItemStack((ItemLike)FIItems.BIRCH_SAP_BUCKET.get());
                if (!player.m_36356_(sap)) {
                    player.m_36176_(sap, false);
                }
                level.m_7731_(pos, (BlockState)((BlockState)state.m_61124_((Property)FILL, (Comparable)Integer.valueOf(0))).m_61124_((Property)HAS_TAPPER, (Comparable)Boolean.valueOf(true)), 3);
                level.m_5594_(null, pos, SoundEvents.f_11781_, SoundSource.BLOCKS, 0.9f, 0.9f);
                level.m_5594_(null, pos, SoundEvents.f_11694_, SoundSource.BLOCKS, 1.1f, 1.0E-4f);
                if (!player.m_150110_().f_35937_) {
                    held.m_41774_(1);
                }
            }
            return InteractionResult.m_19078_((boolean)level.f_46443_);
        }
        return InteractionResult.PASS;
    }

    public void m_6810_(@NotNull BlockState oldState, @NotNull Level level, @NotNull BlockPos pos, @NotNull BlockState newState, boolean isMoving) {
        super.m_6810_(oldState, level, pos, newState, isMoving);
    }
}

