/*
 * Decompiled with CFR 0.152.
 */
package com.tiomadre.foragersinsight.common.block.entity;

import com.tiomadre.foragersinsight.common.block.DiffuserBlock;
import com.tiomadre.foragersinsight.common.diffuser.DiffuserScent;
import com.tiomadre.foragersinsight.common.gui.DiffuserMenu;
import com.tiomadre.foragersinsight.core.registry.FIBlockEntityTypes;
import com.tiomadre.foragersinsight.core.registry.FIItems;
import com.tiomadre.foragersinsight.data.server.tags.FITags;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.Containers;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BaseContainerBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.NotNull;

public class DiffuserBlockEntity
extends BaseContainerBlockEntity {
    public static final int INPUT_SLOT_COUNT = 3;
    public static final int ENHANCEMENT_SLOT_INDEX = 3;
    public static final int RESULT_SLOT_INDEX = 4;
    private static final int SLOT_COUNT = 5;
    private static final int DATA_COUNT = 4;
    private static final int DEFAULT_DIFFUSION_TIME = 12000;
    private static final int EFFECT_APPLY_INTERVAL = 40;
    private NonNullList<ItemStack> items = NonNullList.m_122780_((int)5, (Object)ItemStack.f_41583_);
    private int litTime;
    private int litDuration;
    private int craftProgress;
    private int craftTimeTotal = 12000;
    private DiffuserScent activeScent;
    private int effectTickCounter;
    private Enhancement activeEnhancement = Enhancement.NONE;
    private int respirationLevel;
    private final ContainerData dataAccess = new ContainerData(){

        public int m_6413_(int index) {
            return switch (index) {
                case 0 -> DiffuserBlockEntity.this.litTime;
                case 1 -> DiffuserBlockEntity.this.litDuration;
                case 2 -> DiffuserBlockEntity.this.craftProgress;
                case 3 -> DiffuserBlockEntity.this.craftTimeTotal;
                default -> 0;
            };
        }

        public void m_8050_(int index, int value) {
            switch (index) {
                case 0: {
                    DiffuserBlockEntity.this.litTime = value;
                    break;
                }
                case 1: {
                    DiffuserBlockEntity.this.litDuration = value;
                    break;
                }
                case 2: {
                    DiffuserBlockEntity.this.craftProgress = value;
                    break;
                }
                case 3: {
                    DiffuserBlockEntity.this.craftTimeTotal = value;
                }
            }
        }

        public int m_6499_() {
            return 4;
        }
    };

    public DiffuserBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)FIBlockEntityTypes.DIFFUSER.get(), pos, state);
    }

    public static void serverTick(Level level, BlockPos pos, BlockState state, DiffuserBlockEntity blockEntity) {
        boolean wasLit = blockEntity.isLit();
        boolean changed = false;
        if (blockEntity.litTime > 0) {
            --blockEntity.litTime;
        }
        if (blockEntity.isLit()) {
            blockEntity.craftProgress = Mth.m_14045_((int)(blockEntity.craftProgress + 1), (int)0, (int)blockEntity.craftTimeTotal);
            if (!level.f_46443_) {
                ++blockEntity.effectTickCounter;
                if (blockEntity.effectTickCounter >= 40) {
                    blockEntity.effectTickCounter = 0;
                    blockEntity.applyActiveScentEffects();
                }
            }
        } else if (blockEntity.craftProgress != 0) {
            blockEntity.craftProgress = 0;
            changed = true;
            blockEntity.effectTickCounter = 0;
        }
        if (!level.f_46443_ && !blockEntity.isLit() && blockEntity.activeScent != null) {
            blockEntity.clearActiveScent();
            changed = true;
        }
        if (wasLit != blockEntity.isLit()) {
            state = (BlockState)state.m_61124_((Property)DiffuserBlock.LIT, (Comparable)Boolean.valueOf(blockEntity.isLit()));
            level.m_7731_(pos, state, 3);
            changed = true;
        }
        if (changed) {
            blockEntity.m_6596_();
        }
    }

    private void startCycle(DiffuserScent scent) {
        int enhancedDuration;
        this.activeScent = scent;
        this.activeEnhancement = this.consumeEnhancement();
        this.litDuration = enhancedDuration = (int)Math.round(12000.0 * this.activeEnhancement.durationMultiplier());
        this.craftTimeTotal = enhancedDuration;
        this.litTime = this.litDuration;
        this.craftProgress = 0;
        this.effectTickCounter = 0;
    }

    private void consumeIngredients(DiffuserScent scent) {
        for (DiffuserScent.IngredientCount ingredient : scent.ingredients()) {
            int remaining = ingredient.count();
            for (int slot = 0; slot < 3 && remaining > 0; ++slot) {
                ItemStack stack = (ItemStack)this.items.get(slot);
                if (stack.m_41619_() || !ingredient.ingredient().test(stack)) continue;
                int removed = Math.min(stack.m_41613_(), remaining);
                stack.m_41774_(removed);
                remaining -= removed;
                if (!stack.m_41619_()) continue;
                this.items.set(slot, (Object)ItemStack.f_41583_);
            }
        }
    }

    private Optional<DiffuserScent> findMatchingScent() {
        ArrayList<ItemStack> inputs = new ArrayList<ItemStack>(3);
        for (int slot = 0; slot < 3; ++slot) {
            inputs.add((ItemStack)this.items.get(slot));
        }
        return DiffuserScent.findMatch(inputs);
    }

    private void clearActiveScent() {
        this.activeScent = null;
        this.effectTickCounter = 0;
        this.activeEnhancement = Enhancement.NONE;
    }

    public Optional<DiffuserScent> getActiveScent() {
        if (this.activeScent != null) {
            return Optional.of(this.activeScent);
        }
        return this.findMatchingScent();
    }

    public boolean tryStartDiffusion() {
        if (this.f_58857_ == null || this.isLit()) {
            return false;
        }
        Optional<DiffuserScent> match = this.findMatchingScent();
        if (match.isEmpty()) {
            return false;
        }
        DiffuserScent scent = match.get();
        this.consumeIngredients(scent);
        this.startCycle(scent);
        this.m_6596_();
        BlockState state = this.m_58900_();
        if (!((Boolean)state.m_61143_((Property)DiffuserBlock.LIT)).booleanValue()) {
            this.f_58857_.m_7731_(this.f_58858_, (BlockState)state.m_61124_((Property)DiffuserBlock.LIT, (Comparable)Boolean.valueOf(true)), 3);
        } else {
            this.f_58857_.m_7260_(this.f_58858_, state, state, 3);
        }
        return true;
    }

    public boolean isLit() {
        return this.litTime > 0;
    }

    @NotNull
    protected Component m_6820_() {
        return Component.m_237115_((String)"container.foragersinsight.diffuser");
    }

    @NotNull
    protected AbstractContainerMenu m_6555_(int id, @NotNull Inventory inventory) {
        return new DiffuserMenu(id, inventory, this);
    }

    public int m_6643_() {
        return 5;
    }

    public boolean m_7983_() {
        for (int slot = 0; slot < 3; ++slot) {
            if (((ItemStack)this.items.get(slot)).m_41619_()) continue;
            return false;
        }
        return true;
    }

    @NotNull
    public ItemStack m_8020_(int pSlot) {
        return (ItemStack)this.items.get(pSlot);
    }

    @NotNull
    public ItemStack m_7407_(int pSlot, int pAmount) {
        if (this.hasActiveScent()) {
            return ItemStack.f_41583_;
        }
        ItemStack result = ContainerHelper.m_18969_(this.items, (int)pSlot, (int)pAmount);
        if (!result.m_41619_()) {
            if (this.activeScent != null && !this.isLit()) {
                this.clearActiveScent();
            }
            this.m_6596_();
        }
        return result;
    }

    @NotNull
    public ItemStack m_8016_(int pSlot) {
        if (this.hasActiveScent()) {
            return ItemStack.f_41583_;
        }
        ItemStack result = ContainerHelper.m_18966_(this.items, (int)pSlot);
        if (!result.m_41619_()) {
            if (this.activeScent != null && !this.isLit()) {
                this.clearActiveScent();
            }
            this.m_6596_();
        }
        return result;
    }

    public void m_6836_(int pSlot, @NotNull ItemStack pStack) {
        if (pSlot < 0 || pSlot >= this.items.size()) {
            return;
        }
        if (pSlot == 4) {
            return;
        }
        if (this.hasActiveScent()) {
            return;
        }
        this.items.set(pSlot, (Object)pStack);
        if ((pSlot < 3 || pSlot == 3) && pStack.m_41613_() > 1) {
            pStack.m_41764_(1);
        } else if (pStack.m_41613_() > this.m_6893_()) {
            pStack.m_41764_(this.m_6893_());
        }
        if (this.activeScent != null && !this.isLit()) {
            this.clearActiveScent();
        }
        this.m_6596_();
    }

    public void extinguish() {
        boolean wasLit = this.isLit();
        boolean hadActiveScent = this.activeScent != null;
        this.litTime = 0;
        this.litDuration = 0;
        this.craftProgress = 0;
        this.effectTickCounter = 0;
        if (this.activeScent != null) {
            this.clearActiveScent();
        }
        if (this.f_58857_ != null) {
            BlockState state = this.m_58900_();
            boolean blockLit = (Boolean)state.m_61143_((Property)DiffuserBlock.LIT);
            if (blockLit != this.isLit()) {
                this.f_58857_.m_7731_(this.f_58858_, (BlockState)state.m_61124_((Property)DiffuserBlock.LIT, (Comparable)Boolean.valueOf(false)), 3);
            } else if (wasLit || hadActiveScent) {
                this.f_58857_.m_7260_(this.f_58858_, state, state, 3);
            }
        }
        this.m_6596_();
    }

    public boolean m_6542_(@NotNull Player pPlayer) {
        if (this.f_58857_ == null) {
            return false;
        }
        if (this.f_58857_.m_7702_(this.f_58858_) != this) {
            return false;
        }
        return pPlayer.m_20275_((double)this.f_58858_.m_123341_() + 0.5, (double)this.f_58858_.m_123342_() + 0.5, (double)this.f_58858_.m_123343_() + 0.5) <= 64.0;
    }

    public boolean m_7013_(int slot, @NotNull ItemStack stack) {
        if (slot < 3) {
            return stack.m_204117_(FITags.ItemTag.AROMATICS) && !this.hasActiveScent();
        }
        if (slot == 3) {
            return DiffuserBlockEntity.isEnhancementItem(stack) && !this.hasActiveScent();
        }
        return false;
    }

    public void m_6211_() {
        this.items = NonNullList.m_122780_((int)5, (Object)ItemStack.f_41583_);
        this.clearActiveScent();
    }

    public void m_142466_(@NotNull CompoundTag tag) {
        super.m_142466_(tag);
        this.items = NonNullList.m_122780_((int)this.m_6643_(), (Object)ItemStack.f_41583_);
        ContainerHelper.m_18980_((CompoundTag)tag, this.items);
        for (int slot = 0; slot < 3; ++slot) {
            ItemStack enhancement;
            ItemStack stack = (ItemStack)this.items.get(slot);
            if (!stack.m_41619_() && stack.m_41613_() > 1) {
                stack.m_41764_(1);
            }
            if ((enhancement = (ItemStack)this.items.get(3)).m_41619_() || enhancement.m_41613_() <= 1) continue;
            enhancement.m_41764_(1);
        }
        this.litTime = tag.m_128451_("LitTime");
        this.litDuration = tag.m_128451_("LitDuration");
        this.craftProgress = tag.m_128451_("CraftProgress");
        this.craftTimeTotal = Math.max(12000, tag.m_128451_("CraftTimeTotal"));
        this.effectTickCounter = 0;
        this.activeScent = null;
        this.activeEnhancement = Enhancement.NONE;
        if (tag.m_128425_("ActiveScent", 8)) {
            DiffuserScent.byId(new ResourceLocation(tag.m_128461_("ActiveScent"))).ifPresent(scent -> {
                this.activeScent = scent;
            });
        } else if (tag.m_128425_("ActiveScentId", 3)) {
            DiffuserScent.byNetworkId(tag.m_128451_("ActiveScentId")).ifPresent(scent -> {
                this.activeScent = scent;
            });
        }
        if (tag.m_128425_("ActiveEnhancement", 8)) {
            this.activeEnhancement = Enhancement.byName(tag.m_128461_("ActiveEnhancement"));
        }
        this.respirationLevel = Mth.m_14045_((int)tag.m_128451_("RespirationLevel"), (int)0, (int)3);
    }

    protected void m_183515_(@NotNull CompoundTag tag) {
        super.m_183515_(tag);
        ContainerHelper.m_18973_((CompoundTag)tag, this.items);
        tag.m_128405_("LitTime", this.litTime);
        tag.m_128405_("LitDuration", this.litDuration);
        tag.m_128405_("CraftProgress", this.craftProgress);
        tag.m_128405_("CraftTimeTotal", this.craftTimeTotal);
        if (this.activeScent != null) {
            tag.m_128359_("ActiveScent", this.activeScent.id().toString());
            tag.m_128405_("ActiveScentId", this.activeScent.networkId());
        }
        tag.m_128359_("ActiveEnhancement", this.activeEnhancement.getSerializedName());
        tag.m_128405_("RespirationLevel", this.respirationLevel);
    }

    public boolean hasActiveScent() {
        return this.activeScent != null;
    }

    @NotNull
    public CompoundTag m_5995_() {
        return this.m_187482_();
    }

    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public ContainerData getDataAccess() {
        return this.dataAccess;
    }

    private void applyActiveScentEffects() {
        if (this.f_58857_ == null || this.activeScent == null) {
            return;
        }
        AABB area = new AABB(this.f_58858_).m_82400_(this.getEffectiveRadius());
        List entities = this.f_58857_.m_45976_(LivingEntity.class, area);
        this.activeScent.createEffectInstance().ifPresent(template -> {
            for (LivingEntity entity : entities) {
                MobEffectInstance instance = new MobEffectInstance(template.m_19544_(), template.m_19557_(), template.m_19564_(), template.m_19571_(), template.m_19572_(), template.m_19575_());
                entity.m_7292_(instance);
            }
        });
        if (this.shouldRestoreBreath()) {
            this.restoreBreath(entities);
        }
    }

    private void restoreBreath(List<LivingEntity> entities) {
        for (LivingEntity entity : entities) {
            if (!this.needsBreath(entity)) continue;
            this.slowlyRestoreBreath(entity);
        }
    }

    private void slowlyRestoreBreath(LivingEntity entity) {
        int maxAir = entity.m_6062_();
        int currentAir = entity.m_20146_();
        int restoreAmount = Math.max(1, maxAir / 10);
        entity.m_20301_(Math.min(currentAir + restoreAmount, maxAir));
    }

    private boolean needsBreath(LivingEntity entity) {
        return entity.m_20146_() < entity.m_6062_() && entity.m_204029_(FluidTags.f_13131_);
    }

    private boolean shouldRestoreBreath() {
        return this.isSubmergedInWater();
    }

    private boolean isSubmergedInWater() {
        if (this.f_58857_ == null) {
            return false;
        }
        return this.f_58857_.m_6425_(this.f_58858_).m_205070_(FluidTags.f_13131_) || this.f_58857_.m_6425_(this.f_58858_.m_7494_()).m_205070_(FluidTags.f_13131_);
    }

    public Enhancement getActiveEnhancement() {
        return this.activeEnhancement;
    }

    public double getEffectiveRadius() {
        if (this.activeScent == null) {
            return 0.0;
        }
        return this.activeScent.radius() * this.activeEnhancement.radiusMultiplier();
    }

    public int getRemainingDuration() {
        return this.litTime;
    }

    private Enhancement consumeEnhancement() {
        ItemStack stack = (ItemStack)this.items.get(3);
        if (stack.m_41619_()) {
            return Enhancement.NONE;
        }
        Enhancement enhancement = Enhancement.fromStack(stack);
        if (enhancement == Enhancement.NONE) {
            return Enhancement.NONE;
        }
        stack.m_41774_(1);
        if (stack.m_41619_()) {
            this.items.set(3, (Object)ItemStack.f_41583_);
        }
        if (enhancement == Enhancement.DURATION && this.f_58857_ != null && !this.f_58857_.f_46443_) {
            ItemStack emptyBottle = new ItemStack((ItemLike)Items.f_42590_);
            Containers.m_18992_((Level)this.f_58857_, (double)((double)this.f_58858_.m_123341_() + 0.5), (double)((double)this.f_58858_.m_123342_() + 1.0), (double)((double)this.f_58858_.m_123343_() + 0.5), (ItemStack)emptyBottle);
        }
        return enhancement;
    }

    private static boolean isEnhancementItem(ItemStack stack) {
        return Enhancement.fromStack(stack) != Enhancement.NONE;
    }

    public static enum Enhancement {
        NONE(1.0, 1.0, "none"),
        RADIUS(1.2, 1.0, "honeycomb"),
        DURATION(1.0, 1.2, "birch_sap_bottle");

        private final double radiusMultiplier;
        private final double durationMultiplier;
        private final String serializedName;

        private Enhancement(double radiusMultiplier, double durationMultiplier, String serializedName) {
            this.radiusMultiplier = radiusMultiplier;
            this.durationMultiplier = durationMultiplier;
            this.serializedName = serializedName;
        }

        public double radiusMultiplier() {
            return this.radiusMultiplier;
        }

        public double durationMultiplier() {
            return this.durationMultiplier;
        }

        public String getSerializedName() {
            return this.serializedName;
        }

        public static Enhancement fromStack(ItemStack stack) {
            if (stack.m_150930_(Items.f_42784_)) {
                return RADIUS;
            }
            if (stack.m_150930_((Item)FIItems.BIRCH_SAP_BOTTLE.get())) {
                return DURATION;
            }
            return NONE;
        }

        public static Enhancement byName(String name) {
            for (Enhancement enhancement : Enhancement.values()) {
                if (!enhancement.serializedName.equals(name)) continue;
                return enhancement;
            }
            return NONE;
        }
    }
}

