/*
 * Decompiled with CFR 0.152.
 */
package com.tiomadre.foragersinsight.common.diffuser;

import com.google.common.base.Suppliers;
import com.tiomadre.foragersinsight.core.registry.FIItems;
import com.tiomadre.foragersinsight.core.registry.FIMobEffects;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextColor;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import vectorwing.farmersdelight.common.registry.ModItems;

public final class DiffuserScent {
    public static final int STANDARD_DURATION = 12000;
    public static final TextColor RADIUS_ACCENT_COLOR = TextColor.m_131266_((int)16432937);
    public static final TextColor DURATION_ACCENT_COLOR = TextColor.m_131266_((int)12769967);
    private static final List<DiffuserScent> ALL = new ArrayList<DiffuserScent>();
    private static final Map<ResourceLocation, DiffuserScent> BY_ID = new ConcurrentHashMap<ResourceLocation, DiffuserScent>();
    public static final Supplier<DiffuserScent> ROSEY = Suppliers.memoize(() -> new DiffuserScent(new ResourceLocation("foragersinsight", "rosey"), List.of(IngredientCount.of(Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)FIItems.ROSE_PETALS.get()}), 3)), new ResourceLocation("foragersinsight", "textures/scents/rosey.png"), "foragersinsight.diffuser.rosey", "foragersinsight.diffuser.rosey.description", 8.0, () -> new MobEffectInstance(MobEffects.f_19605_, 200, 0), 0));
    public static final Supplier<DiffuserScent> CONIFEROUS = Suppliers.memoize(() -> new DiffuserScent(new ResourceLocation("foragersinsight", "coniferous"), List.of(IngredientCount.of(Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)FIItems.SPRUCE_TIPS.get()}), 3)), new ResourceLocation("foragersinsight", "textures/scents/coniferous.png"), "foragersinsight.diffuser.coniferous", "foragersinsight.diffuser.coniferous.description", 8.0, () -> new MobEffectInstance(MobEffects.f_19606_, 500, 0), 1));
    public static final Supplier<DiffuserScent> FLORAL = Suppliers.memoize(() -> new DiffuserScent(new ResourceLocation("foragersinsight", "floral"), List.of(IngredientCount.of(Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)FIItems.ROSELLE_PETALS.get()}), 1), IngredientCount.of(Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)FIItems.ROSE_PETALS.get()}), 1), IngredientCount.of(Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42207_}), 1)), new ResourceLocation("foragersinsight", "textures/scents/floral.png"), "foragersinsight.diffuser.floral", "foragersinsight.diffuser.floral.description", 8.0, () -> new MobEffectInstance((MobEffect)FIMobEffects.BLOOM.get(), 1200, 0), 0));
    public static final Supplier<DiffuserScent> FOUL = Suppliers.memoize(() -> new DiffuserScent(new ResourceLocation("foragersinsight", "foul"), List.of(IngredientCount.of(Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ModItems.ORGANIC_COMPOST.get()}), 3)), new ResourceLocation("foragersinsight", "textures/scents/foul.png"), "foragersinsight.diffuser.foul", "foragersinsight.diffuser.foul.description", 8.0, () -> new MobEffectInstance((MobEffect)FIMobEffects.ODOROUS.get(), 1200, 0), 3));
    private final ResourceLocation id;
    private final List<IngredientCount> ingredients;
    private final ResourceLocation icon;
    private final int totalItemCount;
    private final String translationKey;
    private final String descriptionKey;
    private final double radius;
    private final Supplier<MobEffectInstance> effectSupplier;
    private final int networkId;

    public static void bootstrap() {
        ROSEY.get();
        CONIFEROUS.get();
        FLORAL.get();
        FOUL.get();
    }

    private DiffuserScent(ResourceLocation id, List<IngredientCount> ingredients, ResourceLocation icon, String translationKey, String descriptionKey, double radius, Supplier<MobEffectInstance> effectSupplier, int networkId) {
        this.id = Objects.requireNonNull(id, "id");
        this.ingredients = List.copyOf(ingredients);
        this.icon = Objects.requireNonNull(icon, "icon");
        this.totalItemCount = this.ingredients.stream().mapToInt(IngredientCount::count).sum();
        this.translationKey = Objects.requireNonNull(translationKey, "translationKey");
        this.descriptionKey = Objects.requireNonNull(descriptionKey, "descriptionKey");
        this.radius = radius;
        this.effectSupplier = Objects.requireNonNull(effectSupplier, "effectSupplier");
        this.networkId = networkId;
        ALL.add(this);
        BY_ID.put(this.id, this);
    }

    public ResourceLocation id() {
        return this.id;
    }

    public List<IngredientCount> ingredients() {
        return this.ingredients;
    }

    public ResourceLocation icon() {
        return this.icon;
    }

    public static Optional<DiffuserScent> byId(ResourceLocation id) {
        return Optional.ofNullable(BY_ID.get(id));
    }

    public int networkId() {
        return this.networkId;
    }

    public static Optional<DiffuserScent> byNetworkId(int networkId) {
        if (networkId < 0 || networkId >= ALL.size()) {
            return Optional.empty();
        }
        return Optional.ofNullable(ALL.get(networkId));
    }

    public Component displayName() {
        return Component.m_237115_((String)this.translationKey);
    }

    public Component description() {
        return Component.m_237115_((String)this.descriptionKey).m_130940_(ChatFormatting.GRAY);
    }

    public List<Component> tooltip() {
        ArrayList<Component> tooltip = new ArrayList<Component>(2);
        tooltip.add((Component)this.displayName().m_6881_().m_130938_(style -> style.m_131140_(ChatFormatting.WHITE).m_131162_(Boolean.valueOf(true))));
        tooltip.add(this.description());
        return tooltip;
    }

    public Optional<MobEffectInstance> createEffectInstance() {
        MobEffectInstance effect = this.effectSupplier.get();
        return Optional.ofNullable(effect);
    }

    public double radius() {
        return this.radius;
    }

    public boolean matches(List<ItemStack> stacks) {
        if (this.ingredients.isEmpty()) {
            return false;
        }
        int[] remaining = new int[this.ingredients.size()];
        for (int i = 0; i < this.ingredients.size(); ++i) {
            remaining[i] = this.ingredients.get(i).count();
        }
        int totalItems = 0;
        for (ItemStack stack : stacks) {
            if (stack.m_41619_()) continue;
            totalItems += stack.m_41613_();
            boolean matched = false;
            for (int i = 0; i < this.ingredients.size(); ++i) {
                IngredientCount ingredient = this.ingredients.get(i);
                if (!ingredient.ingredient().test(stack)) continue;
                int n = i;
                remaining[n] = remaining[n] - stack.m_41613_();
                if (remaining[i] < 0) {
                    return false;
                }
                matched = true;
                break;
            }
            if (matched) continue;
            return false;
        }
        return totalItems == this.totalItemCount && Arrays.stream(remaining).allMatch(r -> r == 0);
    }

    public static Optional<DiffuserScent> findMatch(List<ItemStack> stacks) {
        if (stacks == null || stacks.isEmpty()) {
            return Optional.empty();
        }
        for (DiffuserScent scent : ALL) {
            if (!scent.matches(stacks)) continue;
            return Optional.of(scent);
        }
        return Optional.empty();
    }

    public static final class IngredientCount {
        private final Supplier<Ingredient> ingredientSupplier;
        private Ingredient ingredient;
        private final int count;

        private IngredientCount(Supplier<Ingredient> ingredientSupplier, int count) {
            this.ingredientSupplier = ingredientSupplier;
            this.count = count;
        }

        public static IngredientCount of(Ingredient ingredient, int count) {
            return new IngredientCount(() -> ingredient, count);
        }

        public static IngredientCount of(ItemLike item, int count) {
            return new IngredientCount(() -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{item}), count);
        }

        public static IngredientCount of(Supplier<? extends ItemLike> item, int count) {
            return new IngredientCount(() -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)item.get()}), count);
        }

        public Ingredient ingredient() {
            if (this.ingredient == null) {
                this.ingredient = Objects.requireNonNull(this.ingredientSupplier.get(), "ingredient");
            }
            return this.ingredient;
        }

        public int count() {
            return this.count;
        }

        public boolean matches(ItemStack stack) {
            return this.ingredient().test(stack) && stack.m_41613_() >= this.count;
        }

        public String toString() {
            return "IngredientCount[" + String.valueOf(this.ingredient()) + " x" + this.count + "]";
        }
    }
}

