/*
 * Decompiled with CFR 0.152.
 */
package com.tiomadre.foragersinsight.common.gui;

import com.tiomadre.foragersinsight.common.block.entity.DiffuserBlockEntity;
import com.tiomadre.foragersinsight.common.diffuser.DiffuserScent;
import com.tiomadre.foragersinsight.core.registry.FIBlocks;
import com.tiomadre.foragersinsight.core.registry.FIItems;
import com.tiomadre.foragersinsight.core.registry.FIMenuTypes;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.NotNull;

public class DiffuserMenu
extends AbstractContainerMenu {
    private static final int INPUT_SLOT_COUNT = 3;
    private static final int ENHANCEMENT_SLOT_INDEX = 3;
    private static final int RESULT_SLOT_INDEX = 4;
    private static final int DIFFUSER_SLOT_COUNT = 5;
    private static final int PLAYER_INVENTORY_ROWS = 3;
    private static final int PLAYER_INVENTORY_COLUMNS = 9;
    private static final int DATA_PROGRESS = 2;
    private static final int DATA_TOTAL = 3;
    public static final int BUTTON_EXTINGUISH = 0;
    private static final int SLOT_SIZE = 18;
    private static final int SLOT_SPACING = 18;
    private static final int INPUT_SLOT_Y = 41;
    private static final int INPUT_SLOT_START_X = 34;
    private static final int ENHANCEMENT_SLOT_X = 52;
    private static final int ENHANCEMENT_SLOT_Y = 21;
    private static final int RESULT_SLOT_X = 126;
    private static final int RESULT_SLOT_Y = 37;
    private static final int INV_START_X = 8;
    private static final int INV_START_Y = 89;
    private static final int HOTBAR_Y = 147;
    private static final int ARROW_PROGRESS_PIXELS = 22;
    private final Container diffuserContainer;
    private final DiffuserBlockEntity diffuser;
    private final ContainerLevelAccess access;
    private final ContainerData dataAccess;

    public DiffuserMenu(int containerId, Inventory playerInventory, FriendlyByteBuf buffer) {
        this(containerId, playerInventory, DiffuserMenu.resolveBlockEntity(playerInventory, buffer));
    }

    public DiffuserMenu(int containerId, Inventory playerInventory, DiffuserBlockEntity diffuser) {
        super((MenuType)FIMenuTypes.DIFFUSER_MENU.get(), containerId);
        this.diffuser = Objects.requireNonNull(diffuser, "diffuser");
        this.diffuserContainer = this.diffuser;
        Level level = this.diffuser.m_58904_();
        this.access = level != null ? ContainerLevelAccess.m_39289_((Level)level, (BlockPos)this.diffuser.m_58899_()) : ContainerLevelAccess.f_39287_;
        this.dataAccess = this.diffuser.getDataAccess();
        DiffuserMenu.m_38869_((Container)this.diffuserContainer, (int)5);
        this.diffuserContainer.m_5856_(playerInventory.f_35978_);
        this.addDiffuserSlots();
        this.addPlayerInventorySlots(playerInventory);
        this.m_38884_(this.dataAccess);
    }

    private static DiffuserBlockEntity resolveBlockEntity(Inventory playerInventory, FriendlyByteBuf buffer) {
        Objects.requireNonNull(playerInventory, "playerInventory");
        Objects.requireNonNull(buffer, "buffer");
        BlockPos pos = buffer.m_130135_();
        Level level = playerInventory.f_35978_.m_9236_();
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof DiffuserBlockEntity) {
            DiffuserBlockEntity diffuser = (DiffuserBlockEntity)blockEntity;
            return diffuser;
        }
        return null;
    }

    private void addDiffuserSlots() {
        for (int slot = 0; slot < 3; ++slot) {
            int x = 34 + slot * 18;
            this.m_38897_(new Slot(this.diffuserContainer, slot, x, 41){

                public boolean m_5857_(@NotNull ItemStack stack) {
                    if (DiffuserMenu.this.diffuser.hasActiveScent()) {
                        return false;
                    }
                    return super.m_5857_(stack);
                }

                public int m_6641_() {
                    return 1;
                }
            });
        }
        this.m_38897_(new Slot(this.diffuserContainer, 3, 52, 21){

            public boolean m_5857_(@NotNull ItemStack stack) {
                if (DiffuserMenu.this.diffuser.hasActiveScent()) {
                    return false;
                }
                return stack.m_150930_(Items.f_42784_) || stack.m_150930_((Item)FIItems.BIRCH_SAP_BOTTLE.get());
            }

            public int m_6641_() {
                return 1;
            }
        });
        this.m_38897_(new Slot(this.diffuserContainer, 4, 126, 37){

            public boolean m_5857_(@NotNull ItemStack stack) {
                return false;
            }

            public boolean m_8010_(@NotNull Player player) {
                return false;
            }
        });
    }

    private void addPlayerInventorySlots(Inventory playerInventory) {
        for (int row = 0; row < 3; ++row) {
            for (int column = 0; column < 9; ++column) {
                int slotIndex = column + row * 9 + 9;
                int x = 8 + column * 18;
                int y = 89 + row * 18;
                this.m_38897_(new Slot((Container)playerInventory, slotIndex, x, y));
            }
        }
        for (int column = 0; column < 9; ++column) {
            int x = 8 + column * 18;
            this.m_38897_(new Slot((Container)playerInventory, column, x, 147));
        }
    }

    @NotNull
    public ItemStack m_7648_(@NotNull Player player, int index) {
        Slot sourceSlot = (Slot)this.f_38839_.get(index);
        if (!sourceSlot.m_6657_()) {
            return ItemStack.f_41583_;
        }
        ItemStack sourceStack = sourceSlot.m_7993_();
        ItemStack copy = sourceStack.m_41777_();
        if (index < 5 ? !this.m_38903_(sourceStack, 5, this.f_38839_.size(), true) : (sourceStack.m_150930_(Items.f_42784_) || sourceStack.m_150930_((Item)FIItems.BIRCH_SAP_BOTTLE.get()) ? !this.m_38903_(sourceStack, 3, 4, false) : !this.m_38903_(sourceStack, 0, 3, false))) {
            return ItemStack.f_41583_;
        }
        if (sourceStack.m_41619_()) {
            sourceSlot.m_5852_(ItemStack.f_41583_);
        } else {
            sourceSlot.m_6654_();
        }
        return copy;
    }

    public int getCraftProgress() {
        int progress = this.dataAccess.m_6413_(2);
        int total = this.dataAccess.m_6413_(3);
        if (total <= 0) {
            return 0;
        }
        return Mth.m_14045_((int)((int)((long)progress * 22L / (long)total)), (int)0, (int)22);
    }

    public Optional<DiffuserScent> getActiveScent() {
        return this.diffuser.getActiveScent();
    }

    public boolean isLit() {
        return this.dataAccess.m_6413_(0) > 0;
    }

    public double getEffectiveRadius() {
        return this.diffuser.getEffectiveRadius();
    }

    public int getRemainingDuration() {
        return this.diffuser.getRemainingDuration();
    }

    public DiffuserBlockEntity.Enhancement getActiveEnhancement() {
        return this.diffuser.getActiveEnhancement();
    }

    public boolean m_6875_(@NotNull Player player) {
        return DiffuserMenu.m_38889_((ContainerLevelAccess)this.access, (Player)player, (Block)((Block)FIBlocks.DIFFUSER.get()));
    }

    public boolean m_6366_(@NotNull Player player, int id) {
        if (id == 0) {
            this.access.m_39292_((level, pos) -> {
                BlockEntity blockEntity = level.m_7702_(pos);
                if (blockEntity instanceof DiffuserBlockEntity) {
                    DiffuserBlockEntity diffuser = (DiffuserBlockEntity)blockEntity;
                    diffuser.extinguish();
                }
            });
            return true;
        }
        return super.m_6366_(player, id);
    }

    public void m_6877_(@NotNull Player player) {
        super.m_6877_(player);
        this.diffuserContainer.m_5785_(player);
    }
}

