/*
 * Decompiled with CFR 0.152.
 */
package com.tiomadre.foragersinsight.common.gui;

import com.tiomadre.foragersinsight.core.registry.FIMenuTypes;
import com.tiomadre.foragersinsight.data.server.tags.FITags;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.SlotItemHandler;
import org.jetbrains.annotations.NotNull;

public class HandbasketMenu
extends AbstractContainerMenu {
    private final IItemHandler basketInv;
    private final ItemStack basketStack;
    private final int basketSlotIndex;
    private static final int SLOT_SIZE = 18;
    private static final int GUI_WIDTH = 176;
    private static final int DISPLAY_Y = 17;
    private static final int SHIFT_X = 1;
    private static final int SHIFT_Y = -3;
    private static final int BASKET_COLS = 5;
    private static final int BASKET_ROWS = 2;
    private static final int BASKET_START_X = 43;
    private static final int BASKET_START_Y = 39;
    private static final int INV_START_X = 8;
    private static final int INV_START_Y = 84;
    private static final int HOTBAR_Y = 142;

    public HandbasketMenu(int id, Inventory playerInv, ItemStack basketStack, int basketSlotIndex) {
        super((MenuType)FIMenuTypes.HANDBASKET_MENU.get(), id);
        int y;
        int x;
        int col;
        int row;
        this.basketStack = basketStack;
        this.basketInv = (IItemHandler)basketStack.getCapability(ForgeCapabilities.ITEM_HANDLER).orElseThrow(() -> new IllegalStateException("Missing handler"));
        this.basketSlotIndex = basketSlotIndex;
        for (row = 0; row < 2; ++row) {
            for (col = 0; col < 5; ++col) {
                int index = col + row * 5;
                x = 43 + col * 18 + 1;
                y = 39 + row * 18 + -3;
                this.m_38897_((Slot)new SlotItemHandler(this.basketInv, index, x, y){

                    public boolean m_5857_(@NotNull ItemStack stack) {
                        return stack.m_204117_(FITags.ItemTag.HANDBASKET_ALLOWED);
                    }
                });
            }
        }
        for (row = 0; row < 3; ++row) {
            for (col = 0; col < 9; ++col) {
                int slotIndex = col + row * 9 + 9;
                x = 8 + col * 18;
                y = 84 + row * 18;
                this.m_38897_(this.createPlayerSlot(playerInv, slotIndex, x, y));
            }
        }
        for (int col2 = 0; col2 < 9; ++col2) {
            int x2 = 8 + col2 * 18;
            this.m_38897_(this.createPlayerSlot(playerInv, col2, x2, 142));
        }
    }

    public HandbasketMenu(int id, Inventory inv, FriendlyByteBuf buf) {
        this(id, inv, buf.m_130267_(), buf.m_130242_());
    }

    @NotNull
    public ItemStack m_7648_(@NotNull Player player, int index) {
        Slot sourceSlot = (Slot)this.f_38839_.get(index);
        if (!sourceSlot.m_6657_()) {
            return ItemStack.f_41583_;
        }
        ItemStack sourceStack = sourceSlot.m_7993_();
        ItemStack copyOfSourceStack = sourceStack.m_41777_();
        if (ItemStack.m_150942_((ItemStack)sourceStack, (ItemStack)this.basketStack)) {
            return ItemStack.f_41583_;
        }
        if (index < 10) {
            if (!sourceStack.m_204117_(FITags.ItemTag.HANDBASKET_ALLOWED)) {
                return ItemStack.f_41583_;
            }
            if (!this.m_38903_(sourceStack, 10, this.f_38839_.size(), true)) {
                return ItemStack.f_41583_;
            }
        } else if (!sourceStack.m_204117_(FITags.ItemTag.HANDBASKET_ALLOWED) || !this.m_38903_(sourceStack, 0, 10, false)) {
            return ItemStack.f_41583_;
        }
        if (sourceStack.m_41619_()) {
            sourceSlot.m_5852_(ItemStack.f_41583_);
        } else {
            sourceSlot.m_6654_();
        }
        return copyOfSourceStack;
    }

    public boolean m_6875_(@NotNull Player player) {
        return true;
    }

    public void m_150399_(int slotId, int dragType, @NotNull ClickType clickType, @NotNull Player player) {
        if (slotId == this.basketSlotId()) {
            return;
        }
        super.m_150399_(slotId, dragType, clickType, player);
    }

    private int basketSlotId() {
        int offset = 10;
        return this.basketSlotIndex < 9 ? offset + 27 + this.basketSlotIndex : offset + this.basketSlotIndex - 9;
    }

    private Slot createPlayerSlot(Inventory playerInv, int index, int x, int y) {
        return new Slot((Container)playerInv, index, x, y){

            public boolean m_8010_(@NotNull Player player) {
                if (this.f_40219_ == HandbasketMenu.this.basketSlotIndex) {
                    return false;
                }
                return super.m_8010_(player);
            }

            public boolean m_5857_(@NotNull ItemStack stack) {
                if (this.f_40219_ == HandbasketMenu.this.basketSlotIndex) {
                    return false;
                }
                return super.m_5857_(stack);
            }
        };
    }
}

