/*
 * Decompiled with CFR 0.152.
 */
package com.tiomadre.foragersinsight.common.item;

import com.tiomadre.foragersinsight.common.gui.HandbasketMenu;
import com.tiomadre.foragersinsight.data.server.tags.FITags;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HandbasketItem
extends Item {
    public HandbasketItem(Item.Properties properties) {
        super(properties);
    }

    public ICapabilitySerializable<CompoundTag> initCapabilities(ItemStack stack, final @Nullable CompoundTag nbt) {
        return new ICapabilitySerializable<CompoundTag>(){
            private final ItemStackHandler handler = new ItemStackHandler(10){
                {
                    if (nbt != null && nbt.m_128441_("HandbasketInv")) {
                        this.deserializeNBT(nbt.m_128469_("HandbasketInv"));
                    }
                }

                @NotNull
                public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
                    if (stack.m_41720_() instanceof HandbasketItem) {
                        return stack;
                    }
                    if (!this.isItemAllowed(stack)) {
                        return stack;
                    }
                    return super.insertItem(slot, stack, simulate);
                }

                private boolean isItemAllowed(ItemStack stack) {
                    return stack.m_204117_(FITags.ItemTag.HANDBASKET_ALLOWED);
                }
            };
            private final LazyOptional<IItemHandler> optional = LazyOptional.of(() -> this.handler);

            @NotNull
            public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
                return cap == ForgeCapabilities.ITEM_HANDLER ? this.optional.cast() : LazyOptional.empty();
            }

            public CompoundTag serializeNBT() {
                CompoundTag tag = new CompoundTag();
                tag.m_128365_("HandbasketInv", (Tag)this.handler.serializeNBT());
                return tag;
            }

            public void deserializeNBT(CompoundTag tag) {
                this.handler.deserializeNBT(tag.m_128469_("HandbasketInv"));
            }
        };
    }

    @Nullable
    public CompoundTag getShareTag(ItemStack stack) {
        CompoundTag tag = super.getShareTag(stack);
        if (tag == null) {
            tag = new CompoundTag();
        }
        CompoundTag finalTag = tag;
        stack.getCapability(ForgeCapabilities.ITEM_HANDLER).ifPresent(cap -> {
            if (cap instanceof ItemStackHandler) {
                ItemStackHandler handler = (ItemStackHandler)cap;
                finalTag.m_128365_("HandbasketInv", (Tag)handler.serializeNBT());
            }
        });
        return tag;
    }

    public void readShareTag(ItemStack stack, @Nullable CompoundTag tag) {
        super.readShareTag(stack, tag);
        if (tag != null && tag.m_128441_("HandbasketInv")) {
            stack.getCapability(ForgeCapabilities.ITEM_HANDLER).ifPresent(cap -> {
                if (cap instanceof ItemStackHandler) {
                    ItemStackHandler handler = (ItemStackHandler)cap;
                    handler.deserializeNBT(tag.m_128469_("HandbasketInv"));
                }
            });
        }
    }

    @NotNull
    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, @NotNull InteractionHand hand) {
        ItemStack held = player.m_21120_(hand);
        if (!world.m_5776_() && player instanceof ServerPlayer) {
            ServerPlayer server = (ServerPlayer)player;
            int slotIndex = hand == InteractionHand.MAIN_HAND ? player.m_150109_().f_35977_ : 40;
            NetworkHooks.openScreen((ServerPlayer)server, (MenuProvider)new SimpleMenuProvider((id, inv, p) -> new HandbasketMenu(id, inv, held, slotIndex), (Component)Component.m_237115_((String)"container.foragersinsight.handbasket")), buf -> {
                buf.m_130055_(held);
                buf.m_130130_(slotIndex);
            });
        }
        return InteractionResultHolder.m_19092_((Object)held, (boolean)world.m_5776_());
    }
}

