/*
 * Decompiled with CFR 0.152.
 */
package com.tiomadre.foragersinsight.common.item;

import com.tiomadre.foragersinsight.common.utility.TextUtils;
import com.tiomadre.foragersinsight.core.other.toolevents.ShearsSnipInteractions;
import com.tiomadre.foragersinsight.core.registry.FIItems;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.PickaxeItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CocoaBlock;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;

public class MalletItem
extends PickaxeItem {
    private static final Map<Block, CrushResult> CRUSH_RESULTS = new HashMap<Block, CrushResult>();

    private static void addCrushResult(Block block, ItemLike item, int baseAmount) {
        CRUSH_RESULTS.put(block, new CrushResult(item, baseAmount));
    }

    public MalletItem(Tier tier, int attackDamageModifier, float attackSpeedModifier, Item.Properties properties) {
        super(tier, attackDamageModifier, attackSpeedModifier, properties);
    }

    @NotNull
    public InteractionResult m_6225_(UseOnContext context) {
        int age;
        Level level = context.m_43725_();
        if (level.f_46443_) {
            return InteractionResult.SUCCESS;
        }
        BlockPos pos = context.m_8083_();
        BlockState state = level.m_8055_(pos);
        Block block = state.m_60734_();
        Player player = context.m_43723_();
        ItemStack stack = context.m_43722_();
        if ((block == Blocks.f_50322_ || block == Blocks.f_50323_ || block == Blocks.f_50324_) && player != null && player.m_6144_() && EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44962_, (ItemStack)stack) > 0) {
            if (block == Blocks.f_50322_) {
                player.m_5661_((Component)TextUtils.getTranslation("tool_interaction.mallet.anvil_no_repairs", new Object[0]), true);
                return InteractionResult.FAIL;
            }
            stack.m_41622_(20, (LivingEntity)player, p -> p.m_21190_(context.m_43724_()));
            BlockState repairedState = block == Blocks.f_50323_ ? Blocks.f_50322_.m_49966_() : Blocks.f_50323_.m_49966_();
            repairedState = (BlockState)repairedState.m_61124_((Property)HorizontalDirectionalBlock.f_54117_, (Comparable)((Direction)state.m_61143_((Property)HorizontalDirectionalBlock.f_54117_)));
            level.m_7731_(pos, repairedState, 3);
            level.m_5594_(null, pos, SoundEvents.f_11671_, SoundSource.BLOCKS, 1.0f, 1.0f);
            return InteractionResult.SUCCESS;
        }
        if (player != null) {
            if (block == Blocks.f_50224_) {
                stack.m_41622_(2, (LivingEntity)player, p -> p.m_21190_(context.m_43724_()));
                level.m_7731_(pos, Blocks.f_50222_.m_49966_(), 3);
                level.m_5594_(null, pos, SoundEvents.f_12447_, SoundSource.BLOCKS, 1.0f, 1.0f);
                return InteractionResult.SUCCESS;
            }
            if (block == Blocks.f_152594_) {
                stack.m_41622_(2, (LivingEntity)player, p -> p.m_21190_(context.m_43724_()));
                level.m_7731_(pos, Blocks.f_152589_.m_49966_(), 3);
                level.m_5594_(null, pos, SoundEvents.f_12447_, SoundSource.BLOCKS, 1.0f, 1.0f);
                return InteractionResult.SUCCESS;
            }
            if (block == Blocks.f_50713_) {
                stack.m_41622_(2, (LivingEntity)player, p -> p.m_21190_(context.m_43724_()));
                level.m_7731_(pos, Blocks.f_50197_.m_49966_(), 3);
                level.m_5594_(null, pos, SoundEvents.f_12447_, SoundSource.BLOCKS, 1.0f, 1.0f);
                return InteractionResult.SUCCESS;
            }
            if (block == Blocks.f_50736_) {
                stack.m_41622_(2, (LivingEntity)player, p -> p.m_21190_(context.m_43724_()));
                level.m_7731_(pos, Blocks.f_50735_.m_49966_(), 3);
                level.m_5594_(null, pos, SoundEvents.f_12447_, SoundSource.BLOCKS, 1.0f, 1.0f);
                return InteractionResult.SUCCESS;
            }
            if (block == Blocks.f_152595_) {
                stack.m_41622_(2, (LivingEntity)player, p -> p.m_21190_(context.m_43724_()));
                level.m_7731_(pos, Blocks.f_152559_.m_49966_(), 3);
                level.m_5594_(null, pos, SoundEvents.f_12447_, SoundSource.BLOCKS, 1.0f, 1.0f);
                return InteractionResult.SUCCESS;
            }
        }
        if (block == Blocks.f_50130_) {
            while (level.m_8055_(pos.m_7494_()).m_60734_() == Blocks.f_50130_) {
                pos = pos.m_7494_();
            }
            if (player == null) {
                return InteractionResult.PASS;
            }
            stack.m_41622_(2, (LivingEntity)player, p -> p.m_21190_(context.m_43724_()));
            level.m_7731_(pos, Blocks.f_50016_.m_49966_(), 3);
            ShearsSnipInteractions.dropItemInFront(level, player, new ItemStack((ItemLike)Items.f_42501_, 2));
            level.m_5594_(null, pos, SoundEvents.f_11838_, SoundSource.BLOCKS, 1.0f, 1.0f);
            return InteractionResult.SUCCESS;
        }
        if (block == Blocks.f_50262_ && (age = ((Integer)state.m_61143_((Property)CocoaBlock.f_51736_)).intValue()) < 2) {
            return super.m_6225_(context);
        }
        if (block == Blocks.f_50092_ && (age = ((Integer)state.m_61143_((Property)CropBlock.f_52244_)).intValue()) < 7) {
            return super.m_6225_(context);
        }
        CrushResult crushResult = CRUSH_RESULTS.get(block);
        if (crushResult != null) {
            if (player == null) {
                return InteractionResult.PASS;
            }
            stack.m_41622_(2, (LivingEntity)player, p -> p.m_21190_(context.m_43724_()));
            if (block == Blocks.f_50133_ || block == Blocks.f_50186_ || block == Blocks.f_50143_ || block == Blocks.f_50262_) {
                level.m_5594_(null, pos, SoundEvents.f_12388_, SoundSource.BLOCKS, 1.0f, 1.0f);
            } else if (block == Blocks.f_50092_) {
                level.m_5594_(null, pos, SoundEvents.f_11838_, SoundSource.BLOCKS, 1.0f, 1.0f);
            }
            float hardness = state.m_60800_((BlockGetter)level, pos);
            int baseTicks = (int)(hardness * 1.5f * 20.0f);
            int crushTicks = Math.max(1, (int)((float)baseTicks * 0.6f));
            player.m_36335_().m_41524_((Item)this, crushTicks);
            level.m_46961_(pos, false);
            ItemLike resultItem = crushResult.item();
            int baseAmount = crushResult.baseAmount();
            int fortuneLevel = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44987_, (ItemStack)stack);
            int extraAmount = MalletItem.calculateFortuneBonus(fortuneLevel, level.m_213780_());
            int totalAmount = baseAmount + extraAmount;
            ShearsSnipInteractions.dropItemInFront(level, player, new ItemStack(resultItem, totalAmount));
            return InteractionResult.SUCCESS;
        }
        return super.m_6225_(context);
    }

    private static int calculateFortuneBonus(int fortuneLevel, RandomSource random) {
        if (fortuneLevel <= 0) {
            return 0;
        }
        int bonus = 0;
        for (int i = 0; i < fortuneLevel; ++i) {
            if (!(random.m_188501_() < 0.2f)) continue;
            ++bonus;
        }
        return bonus;
    }

    static {
        MalletItem.addCrushResult(Blocks.f_50568_, (ItemLike)Blocks.f_50354_, 1);
        MalletItem.addCrushResult(Blocks.f_50354_, (ItemLike)Blocks.f_50126_, 1);
        MalletItem.addCrushResult(Blocks.f_50126_, (ItemLike)FIItems.CRUSHED_ICE.get(), 2);
        MalletItem.addCrushResult(Blocks.f_50652_, (ItemLike)Blocks.f_49994_, 1);
        MalletItem.addCrushResult(Blocks.f_49994_, (ItemLike)Items.f_42484_, 1);
        MalletItem.addCrushResult(Blocks.f_50058_, (ItemLike)Blocks.f_49992_, 1);
        MalletItem.addCrushResult(Blocks.f_50062_, (ItemLike)Blocks.f_49992_, 1);
        MalletItem.addCrushResult(Blocks.f_50069_, (ItemLike)Blocks.f_50652_, 1);
        MalletItem.addCrushResult(Blocks.f_50222_, (ItemLike)Blocks.f_50224_, 1);
        MalletItem.addCrushResult(Blocks.f_152589_, (ItemLike)Blocks.f_152594_, 1);
        MalletItem.addCrushResult(Blocks.f_50197_, (ItemLike)Blocks.f_50713_, 1);
        MalletItem.addCrushResult(Blocks.f_50735_, (ItemLike)Blocks.f_50736_, 1);
        MalletItem.addCrushResult(Blocks.f_152559_, (ItemLike)Blocks.f_152595_, 1);
        MalletItem.addCrushResult(Blocks.f_50133_, (ItemLike)Items.f_42577_, 2);
        MalletItem.addCrushResult(Blocks.f_50186_, (ItemLike)Items.f_42578_, 2);
        MalletItem.addCrushResult(Blocks.f_50143_, (ItemLike)Items.f_42577_, 1);
        MalletItem.addCrushResult(Blocks.f_50262_, (ItemLike)FIItems.COCOA_POWDER.get(), 2);
        MalletItem.addCrushResult(Blocks.f_50092_, (ItemLike)FIItems.WHEAT_FLOUR.get(), 2);
    }

    private record CrushResult(ItemLike item, int baseAmount) {
    }
}

