/*
 * Decompiled with CFR 0.152.
 */
package com.tiomadre.foragersinsight.common.serializeable.loot;

import com.google.common.base.Suppliers;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.function.Supplier;
import net.minecraft.util.Mth;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraftforge.common.loot.IGlobalLootModifier;
import net.minecraftforge.common.loot.LootModifier;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;

public class ReplaceItemModifier
extends LootModifier {
    public static final Supplier<Codec<ReplaceItemModifier>> CODEC = Suppliers.memoize(() -> RecordCodecBuilder.create(inst -> ReplaceItemModifier.codecStart((RecordCodecBuilder.Instance)inst).and((App)ForgeRegistries.ITEMS.getCodec().fieldOf("new").forGetter(m -> m.newItem)).and((App)ForgeRegistries.ITEMS.getCodec().fieldOf("replace").forGetter(m -> m.replaceItem)).and((App)Codec.FLOAT.optionalFieldOf("chance", (Object)Float.valueOf(1.0f)).forGetter(m -> Float.valueOf(m.chance))).and((App)Codec.BOOL.optionalFieldOf("destroy_on_fail", (Object)false).forGetter(m -> m.destroyOnFail)).apply((Applicative)inst, ReplaceItemModifier::new)));
    private final Item newItem;
    private final Item replaceItem;
    private final float chance;
    private final boolean destroyOnFail;

    protected ReplaceItemModifier(LootItemCondition[] conditionsIn, Item item, Item replaceItem, float chance, boolean destroyOnFail) {
        super(conditionsIn);
        this.newItem = item;
        this.replaceItem = replaceItem;
        this.chance = Mth.m_14036_((float)chance, (float)0.0f, (float)1.0f);
        this.destroyOnFail = destroyOnFail;
    }

    @NotNull
    protected ObjectArrayList<ItemStack> doApply(ObjectArrayList<ItemStack> loot, LootContext lootContext) {
        ObjectArrayList modifiedLoot = new ObjectArrayList(loot.size());
        Boolean shouldReplace = null;
        for (ItemStack stack : loot) {
            if (stack.m_150930_(this.replaceItem)) {
                if (shouldReplace == null) {
                    shouldReplace = this.chance >= 1.0f || this.chance > 0.0f && lootContext.m_230907_().m_188501_() < this.chance;
                }
                if (shouldReplace.booleanValue()) {
                    modifiedLoot.add((Object)new ItemStack((ItemLike)this.newItem, stack.m_41613_()));
                    continue;
                }
                if (this.destroyOnFail) continue;
                modifiedLoot.add((Object)stack);
                continue;
            }
            modifiedLoot.add((Object)stack);
        }
        return modifiedLoot;
    }

    public Codec<? extends IGlobalLootModifier> codec() {
        return CODEC.get();
    }
}

