/*
 * Decompiled with CFR 0.152.
 */
package com.tiomadre.foragersinsight.common.worldgen.trees.decorator;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.tiomadre.foragersinsight.core.registry.FIBlocks;
import com.tiomadre.foragersinsight.core.registry.FITreeDecoratorTypes;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecorator;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecoratorType;
import org.jetbrains.annotations.NotNull;

public class SappyBirchLogDecorator
extends TreeDecorator {
    public static final Codec<SappyBirchLogDecorator> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.FLOAT.fieldOf("probability").forGetter(d -> Float.valueOf(d.probability))).apply((Applicative)instance, SappyBirchLogDecorator::new));
    private final float probability;

    public SappyBirchLogDecorator(float probability) {
        this.probability = probability;
    }

    @NotNull
    protected TreeDecoratorType<?> m_6663_() {
        return (TreeDecoratorType)FITreeDecoratorTypes.SAPPY_BIRCH_LOG_DECORATOR.get();
    }

    public void m_214187_(TreeDecorator.Context context) {
        RandomSource random = context.m_226067_();
        if (random.m_188501_() >= this.probability) {
            return;
        }
        ObjectArrayList logs = context.m_226068_();
        if (logs.isEmpty()) {
            return;
        }
        HashMap<BlockPos, List> columns = new HashMap<BlockPos, List>();
        for (BlockPos pos : logs) {
            BlockPos columnPos = new BlockPos(pos.m_123341_(), 0, pos.m_123343_());
            columns.computeIfAbsent(columnPos, ignored -> new ArrayList()).add(pos);
        }
        List trunkColumn = columns.values().stream().max(Comparator.comparingInt(List::size)).orElse(null);
        if (trunkColumn == null || trunkColumn.size() <= 1) {
            return;
        }
        trunkColumn.sort(Comparator.comparingInt(Vec3i::m_123342_));
        BlockPos base = (BlockPos)trunkColumn.get(0);
        ArrayList<BlockPos> trunk = new ArrayList<BlockPos>();
        for (BlockPos pos : trunkColumn) {
            if (pos.m_123342_() <= base.m_123342_()) continue;
            trunk.add(pos);
            if (trunk.size() < 2) continue;
            break;
        }
        if (trunk.isEmpty()) {
            return;
        }
        BlockPos chosen = (BlockPos)trunk.get(random.m_188503_(trunk.size()));
        BlockState state = ((Block)FIBlocks.SAPPY_BIRCH_LOG.get()).m_49966_();
        context.m_226061_(chosen, state);
    }
}

