/*
 * Decompiled with CFR 0.152.
 */
package com.tiomadre.foragersinsight.common.worldgen.trees.foliage;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.tiomadre.foragersinsight.core.registry.FIBlocks;
import com.tiomadre.foragersinsight.core.registry.FIFoliagePlacerType;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.TreeFeature;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacerType;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import org.jetbrains.annotations.NotNull;

public class AcornTreeFoliagePlacer
extends FoliagePlacer {
    protected final int height;
    public static final Codec<AcornTreeFoliagePlacer> CODEC = RecordCodecBuilder.create(instance -> AcornTreeFoliagePlacer.m_68573_((RecordCodecBuilder.Instance)instance).and((App)Codec.intRange((int)0, (int)16).fieldOf("height").forGetter(fp -> fp.height)).apply((Applicative)instance, AcornTreeFoliagePlacer::new));

    public AcornTreeFoliagePlacer(IntProvider pRadius, IntProvider pOffset, int height) {
        super(pRadius, pOffset);
        this.height = height;
    }

    @NotNull
    protected FoliagePlacerType<?> m_5897_() {
        return (FoliagePlacerType)FIFoliagePlacerType.ACORN_FOLIAGE_PLACER.get();
    }

    protected void m_213633_(@NotNull LevelSimulatedReader level, @NotNull FoliagePlacer.FoliageSetter blockSetter, @NotNull RandomSource rand, @NotNull TreeConfiguration config, int pMaxFreeTreeHeight, @NotNull FoliagePlacer.FoliageAttachment attachment, int height, int radius, int offset) {
        for (int i = offset; i >= offset - height; --i) {
            int j = Math.max(radius + attachment.m_68589_() - 1 - i / 2, 0);
            this.m_225628_(level, blockSetter, rand, config, attachment.m_161451_(), j, i, attachment.m_68590_());
        }
    }

    protected void m_225628_(@NotNull LevelSimulatedReader pLevel, // Could not load outer class - annotation placement on inner may be incorrect
    @NotNull FoliagePlacer.FoliageSetter pFoliageSetter, @NotNull RandomSource pRandom, @NotNull TreeConfiguration pTreeConfiguration, @NotNull BlockPos pPos, int pRange, int pLocalY, boolean pLarge) {
        int i = pLarge ? 1 : 0;
        BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
        for (int j = -pRange; j <= pRange + i; ++j) {
            for (int k = -pRange; k <= pRange + i; ++k) {
                if (this.m_214202_(pRandom, j, pLocalY, k, pRange, pLarge)) continue;
                blockpos$mutableblockpos.m_122154_((Vec3i)pPos, j, pLocalY, k);
                AcornTreeFoliagePlacer.tryPlaceLeaf(pLevel, pFoliageSetter, pRandom, pTreeConfiguration, (BlockPos)blockpos$mutableblockpos);
            }
        }
    }

    public int m_214116_(@NotNull RandomSource pRandom, int pHeight, @NotNull TreeConfiguration pConfig) {
        return this.height;
    }

    protected boolean m_214203_(@NotNull RandomSource pRandom, int pLocalX, int pLocalY, int pLocalZ, int pRange, boolean pLarge) {
        return pLocalX == pRange && pLocalZ == pRange && (pRandom.m_188503_(2) == 0 || pLocalY == 0);
    }

    protected static boolean tryPlaceLeaf(LevelSimulatedReader pLevel, // Could not load outer class - annotation placement on inner may be incorrect
    @NotNull FoliagePlacer.FoliageSetter pFoliageSetter, @NotNull RandomSource pRandom, @NotNull TreeConfiguration pTreeConfiguration, @NotNull BlockPos pPos) {
        BlockState blockstate;
        if (!TreeFeature.m_67272_((LevelSimulatedReader)pLevel, (BlockPos)pPos)) {
            return false;
        }
        BlockState blockState = blockstate = pRandom.m_188499_() ? Blocks.f_50055_.m_49966_() : ((Block)FIBlocks.BOUNTIFUL_DARK_OAK_LEAVES.get()).m_49966_();
        if (blockstate.m_61138_((Property)BlockStateProperties.f_61362_)) {
            blockstate = (BlockState)blockstate.m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(pLevel.m_142433_(pPos, fluidState -> fluidState.m_164512_((Fluid)Fluids.f_76193_))));
        }
        pFoliageSetter.m_271838_(pPos, blockstate);
        return true;
    }
}

