/*
 * Decompiled with CFR 0.152.
 */
package com.tiomadre.foragersinsight.common.worldgen.trees.foliage;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.tiomadre.foragersinsight.core.registry.FIBlocks;
import com.tiomadre.foragersinsight.core.registry.FIFoliagePlacerType;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.TreeFeature;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacerType;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import org.jetbrains.annotations.NotNull;

public class SpruceTipTreeFoliagePlacer
extends FoliagePlacer {
    protected final int height;
    private transient int bottomRowY = Integer.MAX_VALUE;
    public static final Codec<SpruceTipTreeFoliagePlacer> CODEC = RecordCodecBuilder.create(instance -> SpruceTipTreeFoliagePlacer.m_68573_((RecordCodecBuilder.Instance)instance).and((App)Codec.intRange((int)0, (int)16).fieldOf("height").forGetter(fp -> fp.height)).apply((Applicative)instance, SpruceTipTreeFoliagePlacer::new));

    public SpruceTipTreeFoliagePlacer(IntProvider radius, IntProvider offset, int height) {
        super(radius, offset);
        this.height = height;
    }

    @NotNull
    protected FoliagePlacerType<?> m_5897_() {
        return (FoliagePlacerType)FIFoliagePlacerType.SPRUCE_TIP_FOLIAGE_PLACER.get();
    }

    protected void m_213633_(@NotNull LevelSimulatedReader level, @NotNull FoliagePlacer.FoliageSetter blockSetter, @NotNull RandomSource rand, @NotNull TreeConfiguration config, int pMaxFreeTreeHeight, @NotNull FoliagePlacer.FoliageAttachment attachment, int height, int radius, int offset) {
        int bottom = offset - height;
        if (bottom < this.bottomRowY) {
            this.bottomRowY = bottom;
        }
        for (int i = offset; i >= bottom; --i) {
            int j = Math.max(radius + attachment.m_68589_() - 1 - i / 2, 0);
            this.m_225628_(level, blockSetter, rand, config, attachment.m_161451_(), j, i, attachment.m_68590_());
        }
    }

    protected void m_225628_(@NotNull LevelSimulatedReader level, @NotNull FoliagePlacer.FoliageSetter setter, @NotNull RandomSource rand, @NotNull TreeConfiguration config, @NotNull BlockPos pos, int range, int localY, boolean large) {
        int i = large ? 1 : 0;
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
        for (int j = -range; j <= range + i; ++j) {
            for (int k = -range; k <= range + i; ++k) {
                if (this.m_214202_(rand, j, localY, k, range, large)) continue;
                mutable.m_122154_((Vec3i)pos, j, localY, k);
                boolean bottom = localY == this.bottomRowY;
                SpruceTipTreeFoliagePlacer.tryPlaceLeaf(level, setter, rand, config, (BlockPos)mutable, bottom);
            }
        }
    }

    public int m_214116_(@NotNull RandomSource rand, int height, @NotNull TreeConfiguration config) {
        return this.height;
    }

    protected boolean m_214203_(@NotNull RandomSource rand, int localX, int localY, int localZ, int range, boolean large) {
        return localX == range && localZ == range && (rand.m_188503_(2) == 0 || localY == 0);
    }

    protected static boolean tryPlaceLeaf(LevelSimulatedReader level, @NotNull FoliagePlacer.FoliageSetter setter, @NotNull RandomSource rand, @NotNull TreeConfiguration config, @NotNull BlockPos pos, boolean bottom) {
        if (!TreeFeature.m_67272_((LevelSimulatedReader)level, (BlockPos)pos)) {
            return false;
        }
        BlockState blockstate = bottom ? (rand.m_188499_() ? ((Block)FIBlocks.BOUNTIFUL_SPRUCE_LEAVES.get()).m_49966_() : Blocks.f_50051_.m_49966_()) : Blocks.f_50051_.m_49966_();
        if (blockstate.m_61138_((Property)BlockStateProperties.f_61362_)) {
            blockstate = (BlockState)blockstate.m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(level.m_142433_(pos, f -> f.m_164512_((Fluid)Fluids.f_76193_))));
        }
        setter.m_271838_(pos, blockstate);
        return true;
    }
}

