/*
 * Decompiled with CFR 0.152.
 */
package com.tiomadre.foragersinsight.core;

import com.teamabnormals.blueprint.core.util.registry.RegistryHelper;
import com.tiomadre.foragersinsight.common.diffuser.DiffuserScent;
import com.tiomadre.foragersinsight.core.other.FIClientCompat;
import com.tiomadre.foragersinsight.core.other.FICompostable;
import com.tiomadre.foragersinsight.core.registry.FIBlockEntityTypes;
import com.tiomadre.foragersinsight.core.registry.FIConfig;
import com.tiomadre.foragersinsight.core.registry.FIEnchantments;
import com.tiomadre.foragersinsight.core.registry.FIFoliagePlacerType;
import com.tiomadre.foragersinsight.core.registry.FILootModifiers;
import com.tiomadre.foragersinsight.core.registry.FIMenuTypes;
import com.tiomadre.foragersinsight.core.registry.FIMobEffects;
import com.tiomadre.foragersinsight.core.registry.FIParticleTypes;
import com.tiomadre.foragersinsight.core.registry.FITabs;
import com.tiomadre.foragersinsight.core.registry.FITreeDecoratorTypes;
import com.tiomadre.foragersinsight.data.client.FIBlockStates;
import com.tiomadre.foragersinsight.data.client.FIItemModels;
import com.tiomadre.foragersinsight.data.client.FIParticles;
import com.tiomadre.foragersinsight.data.server.FIAdvancements;
import com.tiomadre.foragersinsight.data.server.FILoot;
import com.tiomadre.foragersinsight.data.server.FIWorldgen;
import com.tiomadre.foragersinsight.data.server.recipes.FICraftingRecipes;
import com.tiomadre.foragersinsight.data.server.tags.FIBiomeTags;
import com.tiomadre.foragersinsight.data.server.tags.FIBlockTags;
import com.tiomadre.foragersinsight.data.server.tags.FIItemTags;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;

@Mod(value="foragersinsight")
public class ForagersInsight {
    public static final String MOD_ID = "foragersinsight";
    public static final RegistryHelper REGISTRY_HELPER = new RegistryHelper("foragersinsight");

    public ForagersInsight() {
        ModLoadingContext context = ModLoadingContext.get();
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        MinecraftForge.EVENT_BUS.register((Object)this);
        REGISTRY_HELPER.register(bus);
        FIEnchantments.register();
        FIBlockEntityTypes.register(bus);
        FIFoliagePlacerType.FOLIAGE_PLACER_TYPE.register(bus);
        FILootModifiers.LOOT_MODIFIERS.register(bus);
        FIMenuTypes.MENUS.register(bus);
        FIMobEffects.MOB_EFFECTS.register(bus);
        FIParticleTypes.PARTICLES.register(bus);
        FITabs.TABS.register(bus);
        FITreeDecoratorTypes.TREE_DECORATOR_TYPES.register(bus);
        bus.addListener(this::commonSetup);
        bus.addListener(this::clientSetup);
        bus.addListener(this::dataSetup);
        context.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)FIConfig.COMMON_SPEC);
    }

    public static ResourceLocation rl(String namespace) {
        return new ResourceLocation(MOD_ID, namespace);
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            FICompostable.registerCompat();
            DiffuserScent.bootstrap();
        });
    }

    private void clientSetup(FMLClientSetupEvent event) {
        event.enqueueWork(FIClientCompat::registerCompat);
    }

    private void dataSetup(GatherDataEvent event) {
        DataGenerator gen = event.getGenerator();
        boolean server = event.includeServer();
        FIBlockTags blockTags = new FIBlockTags(event);
        gen.addProvider(server, (DataProvider)blockTags);
        gen.addProvider(server, (DataProvider)new FIBiomeTags(event));
        gen.addProvider(server, (DataProvider)new FIItemTags(event, blockTags));
        gen.addProvider(server, (DataProvider)new FILoot(event));
        gen.addProvider(server, (DataProvider)new FICraftingRecipes(event));
        gen.addProvider(server, (DataProvider)new FIWorldgen(event));
        gen.addProvider(server, (DataProvider)new FIAdvancements(event));
        boolean client = event.includeClient();
        gen.addProvider(client, (DataProvider)new FIBlockStates(event));
        gen.addProvider(client, (DataProvider)new FIItemModels(event));
        gen.addProvider(client, (DataProvider)new FIParticles(event));
    }
}

