/*
 * Decompiled with CFR 0.152.
 */
package com.tiomadre.foragersinsight.core.other;

import com.tiomadre.foragersinsight.core.other.OdorousAvoidance;
import com.tiomadre.foragersinsight.core.registry.FIEnchantments;
import com.tiomadre.foragersinsight.core.registry.FIMobEffects;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.WrappedGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.living.LivingChangeTargetEvent;
import net.minecraftforge.event.entity.player.PlayerXpEvent;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="foragersinsight")
public class FIEvents {
    @SubscribeEvent
    public static void onMobJoin(EntityJoinLevelEvent event) {
        if (event.getLevel().m_5776_()) {
            return;
        }
        Entity entity = event.getEntity();
        if (!(entity instanceof PathfinderMob)) {
            return;
        }
        PathfinderMob mob = (PathfinderMob)entity;
        boolean alreadyPresent = mob.f_21345_.m_148105_().stream().map(WrappedGoal::m_26015_).anyMatch(goal -> goal instanceof OdorousAvoidance);
        if (alreadyPresent) {
            return;
        }
        mob.f_21345_.m_25352_(3, (Goal)new OdorousAvoidance(mob, 1.1, 1.25));
    }

    @SubscribeEvent
    public static void onMobTargetChange(LivingChangeTargetEvent event) {
        LivingEntity attacker = event.getEntity();
        LivingEntity newTarget = event.getNewTarget();
        if (!(attacker instanceof Monster)) {
            return;
        }
        Monster monster = (Monster)attacker;
        if (!(newTarget instanceof Player)) {
            return;
        }
        Player player = (Player)newTarget;
        if (!player.m_21023_((MobEffect)FIMobEffects.ODOROUS.get())) {
            return;
        }
        event.setNewTarget(null);
        monster.m_6710_(null);
    }

    @SubscribeEvent
    public static void onBlockBreak(BlockEvent.BreakEvent event) {
        Player player = event.getPlayer();
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player2 = (ServerPlayer)player;
        ItemStack tool = player2.m_21205_();
        int level = EnchantmentHelper.m_44843_((Enchantment)((Enchantment)FIEnchantments.FARMHAND.get()), (ItemStack)tool);
        if (level <= 0) {
            return;
        }
        ServerLevel levelWorld = (ServerLevel)event.getLevel();
        BlockPos pos = event.getPos();
        BlockState state = event.getState();
        BlockEntity blockEntity = levelWorld.m_7702_(pos);
        event.setCanceled(true);
        levelWorld.m_7731_(pos, state.m_60819_().m_76188_(), 3);
        List drops = Block.m_49874_((BlockState)state, (ServerLevel)levelWorld, (BlockPos)pos, (BlockEntity)blockEntity, (Entity)player2, (ItemStack)tool);
        for (ItemStack drop : drops) {
            if (player2.m_150109_().m_36054_(drop)) continue;
            player2.m_36176_(drop, false);
        }
        tool.m_41622_(1, (LivingEntity)player2, p -> p.m_21190_(player2.m_7655_()));
    }

    @SubscribeEvent
    public static void onXpChange(PlayerXpEvent.XpChange event) {
        Player player = event.getEntity();
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player2 = (ServerPlayer)player;
        if (!player2.m_21023_((MobEffect)FIMobEffects.BLOOM.get())) {
            return;
        }
        int amount = event.getAmount();
        if (amount > 0) {
            amount = Math.round((float)amount * 1.2f);
        } else if (amount < 0) {
            amount = Math.round((float)amount * 0.8f);
        }
        event.setAmount(amount);
    }

    @SubscribeEvent
    public static void onXpLevelChange(PlayerXpEvent.LevelChange event) {
        Player player = event.getEntity();
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player2 = (ServerPlayer)player;
        if (!player2.m_21023_((MobEffect)FIMobEffects.BLOOM.get())) {
            return;
        }
        int levels = event.getLevels();
        if (levels > 0) {
            levels = Math.round((float)levels * 1.2f);
        } else if (levels < 0) {
            levels = Math.round((float)levels * 0.8f);
        }
        event.setLevels(levels);
    }
}

