/*
 * Decompiled with CFR 0.152.
 */
package com.tiomadre.foragersinsight.core.other;

import com.tiomadre.foragersinsight.common.block.BountifulLeavesBlock;
import com.tiomadre.foragersinsight.common.block.SpruceTipBlock;
import com.tiomadre.foragersinsight.common.block.TapperBlock;
import com.tiomadre.foragersinsight.core.registry.FIMobEffects;
import com.tiomadre.foragersinsight.data.server.tags.FITags;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.animal.Chicken;
import net.minecraft.world.entity.animal.Sheep;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.ShearsItem;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.AttachedStemBlock;
import net.minecraft.world.level.block.BeehiveBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.StemBlock;
import net.minecraft.world.level.block.StemGrownBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import vectorwing.farmersdelight.common.block.MushroomColonyBlock;
import vectorwing.farmersdelight.common.block.TomatoVineBlock;
import vectorwing.farmersdelight.common.item.KnifeItem;

@Mod.EventBusSubscriber(modid="foragersinsight")
public class FarmingXPEvents {
    private static final Map<ResourceKey<Level>, Map<BlockPos, PendingForage>> PENDING_FORAGING_DROPS = new HashMap<ResourceKey<Level>, Map<BlockPos, PendingForage>>();
    private static final int FORAGING_DROP_TIMEOUT_TICKS = 20;

    @SubscribeEvent
    public static void onKnifeHarvest(BlockEvent.BreakEvent event) {
        Player player = event.getPlayer();
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player2 = (ServerPlayer)player;
        LevelAccessor levelAccessor = event.getLevel();
        if (!(levelAccessor instanceof ServerLevel)) {
            return;
        }
        ServerLevel level = (ServerLevel)levelAccessor;
        ItemStack tool = player2.m_21205_();
        if (!(tool.m_41720_() instanceof KnifeItem)) {
            return;
        }
        BlockState state = event.getState();
        if (state.m_204336_(FITags.BlockTag.FORAGING)) {
            FarmingXPEvents.trackPotentialForageDrop(level, event.getPos(), state, player2);
        }
    }

    @SubscribeEvent
    public static void onForageDrop(EntityJoinLevelEvent event) {
        Level level = event.getLevel();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel level2 = (ServerLevel)level;
        Entity entity = event.getEntity();
        if (!(entity instanceof ItemEntity)) {
            return;
        }
        ItemEntity item = (ItemEntity)entity;
        PendingForage pending = FarmingXPEvents.popPendingForageNear(level2, item.m_20183_());
        if (pending == null) {
            return;
        }
        if (pending.player.m_9236_() != level2) {
            return;
        }
        if (item.m_32055_().m_41619_()) {
            return;
        }
        FarmingXPEvents.awardRandomXP(level2, pending.player, 0, 2, true);
    }

    @SubscribeEvent
    public static void onCropHarvest(BlockEvent.BreakEvent event) {
        Player player = event.getPlayer();
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player2 = (ServerPlayer)player;
        LevelAccessor levelAccessor = event.getLevel();
        if (!(levelAccessor instanceof ServerLevel)) {
            return;
        }
        ServerLevel level = (ServerLevel)levelAccessor;
        BlockPos pos = event.getPos();
        BlockState state = event.getState();
        Block block = state.m_60734_();
        if (block instanceof StemGrownBlock) {
            boolean connectedToStem = FarmingXPEvents.isConnectedToStem((Level)level, pos);
            FarmingXPEvents.awardRandomXP(level, player2, connectedToStem ? 1 : 0, 2);
            return;
        }
        Optional<IntegerProperty> ageProp = FarmingXPEvents.getAgeProp(state);
        if (ageProp.isPresent() && FarmingXPEvents.isMature(state, ageProp.get())) {
            if (!FarmingXPEvents.isIntactDoublePlant((Level)level, pos, state)) {
                return;
            }
            FarmingXPEvents.awardRandomXP(level, player2, 1, 3);
        }
    }

    @SubscribeEvent
    public static void onRightClickHarvest(PlayerInteractEvent.RightClickBlock event) {
        int before;
        Player player = event.getEntity();
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player2 = (ServerPlayer)player;
        Level level = event.getLevel();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel level2 = (ServerLevel)level;
        BlockPos pos = event.getPos();
        ItemStack held = player2.m_21120_(event.getHand());
        BlockState state = level2.m_8055_(pos);
        Block block = state.m_60734_();
        if (block instanceof BeehiveBlock && (Integer)state.m_61143_((Property)BeehiveBlock.f_49564_) >= 5 && (held.m_41720_() instanceof ShearsItem || held.m_150930_(Items.f_42590_))) {
            FarmingXPEvents.awardRandomXP(level2, player2, 2, 4);
            return;
        }
        if (block instanceof TapperBlock && ((Boolean)state.m_61143_((Property)TapperBlock.HAS_TAPPER)).booleanValue() && (Integer)state.m_61143_((Property)TapperBlock.FILL) == 4 && held.m_150930_(Items.f_42446_)) {
            FarmingXPEvents.awardRandomXP(level2, player2, 1, 3);
            return;
        }
        if (block instanceof MushroomColonyBlock && (before = ((Integer)state.m_61143_((Property)MushroomColonyBlock.COLONY_AGE)).intValue()) > 0) {
            FarmingXPEvents.defer(level2, () -> {
                BlockState afterState = level2.m_8055_(pos);
                if (!(afterState.m_60734_() instanceof MushroomColonyBlock)) {
                    return;
                }
                int after = (Integer)afterState.m_61143_((Property)MushroomColonyBlock.COLONY_AGE);
                if (after < before) {
                    FarmingXPEvents.awardRandomXP(level2, player2, 0, 2, true);
                }
            });
            return;
        }
        if (block instanceof TomatoVineBlock) {
            TomatoVineBlock vine = (TomatoVineBlock)block;
            int current = (Integer)state.m_61143_((Property)TomatoVineBlock.VINE_AGE);
            if (current >= vine.m_7419_() && (held.m_41619_() || held.m_41720_() instanceof ShearsItem)) {
                FarmingXPEvents.defer(level2, () -> {
                    BlockState after = level2.m_8055_(pos);
                    if (!(after.m_60734_() instanceof TomatoVineBlock)) {
                        return;
                    }
                    if ((Integer)after.m_61143_((Property)TomatoVineBlock.VINE_AGE) < current) {
                        FarmingXPEvents.awardRandomXP(level2, player2, 1, 3);
                    }
                });
                return;
            }
        }
        if (block instanceof BonemealableBlock && !(block instanceof CropBlock) && !(block instanceof StemBlock) && !(block instanceof AttachedStemBlock)) {
            Optional<IntegerProperty> ageProp = FarmingXPEvents.getAgeProp(state);
            if (ageProp.isEmpty()) {
                return;
            }
            IntegerProperty age = ageProp.get();
            int current = (Integer)state.m_61143_((Property)age);
            if (!FarmingXPEvents.isMature(state, age)) {
                return;
            }
            FarmingXPEvents.defer(level2, () -> {
                boolean harvested;
                BlockState updated = level2.m_8055_(pos);
                boolean bl = harvested = !updated.m_60713_(state.m_60734_()) || updated.m_61138_((Property)age) && (Integer)updated.m_61143_((Property)age) < current;
                if (harvested) {
                    boolean leavesOrTips = state.m_60734_() instanceof BountifulLeavesBlock || state.m_60734_() instanceof SpruceTipBlock;
                    FarmingXPEvents.awardRandomXP(level2, player2, leavesOrTips ? 0 : 1, 2 + (leavesOrTips ? 0 : 1), true);
                }
            });
        }
    }

    @SubscribeEvent
    public static void onAnimalShear(PlayerInteractEvent.EntityInteract event) {
        long last;
        long now;
        Chicken chicken;
        Player player = event.getEntity();
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player2 = (ServerPlayer)player;
        Level lvl = event.getLevel();
        if (lvl.m_5776_()) {
            return;
        }
        ItemStack tool = player2.m_21120_(event.getHand());
        if (!(tool.m_41720_() instanceof ShearsItem)) {
            return;
        }
        Entity entity = event.getTarget();
        if (entity instanceof Sheep) {
            Sheep sheep = (Sheep)entity;
            if (!sheep.m_6162_() && !sheep.m_29875_()) {
                FarmingXPEvents.awardRandomXP((ServerLevel)lvl, player2, 1, 3);
            }
            return;
        }
        entity = event.getTarget();
        if (entity instanceof Chicken && !(chicken = (Chicken)entity).m_6162_() && (now = lvl.m_46467_()) - (last = chicken.getPersistentData().m_128454_("ShearFeatherTime")) >= 2400L) {
            FarmingXPEvents.awardRandomXP((ServerLevel)lvl, player2, 1, 3);
        }
    }

    private static void awardRandomXP(ServerLevel level, ServerPlayer player, int minInclusive, int maxExclusive) {
        FarmingXPEvents.awardRandomXP(level, player, minInclusive, maxExclusive, false);
    }

    private static void awardRandomXP(ServerLevel level, ServerPlayer player, int minInclusive, int maxExclusive, boolean isForaging) {
        int val;
        int delta = Math.max(0, maxExclusive - minInclusive);
        int n = val = delta == 0 ? minInclusive : minInclusive + player.m_217043_().m_188503_(delta);
        if (isForaging && player.m_21023_((MobEffect)FIMobEffects.BLOOM.get())) {
            val = Math.max(val, 1);
        }
        FarmingXPEvents.awardXPIfPositive(level, player, val);
    }

    private static void awardXPIfPositive(ServerLevel level, ServerPlayer player, int xp) {
        if (xp > 0) {
            ExperienceOrb.m_147082_((ServerLevel)level, (Vec3)player.m_20182_(), (int)xp);
        }
    }

    private static Optional<IntegerProperty> getAgeProp(BlockState state) {
        return state.m_61147_().stream().filter(p -> p instanceof IntegerProperty && p.m_61708_().equals("age")).map(p -> (IntegerProperty)p).findFirst();
    }

    private static boolean isMature(BlockState state, IntegerProperty age) {
        int max;
        int cur = (Integer)state.m_61143_((Property)age);
        return cur >= (max = age.m_6908_().stream().mapToInt(i -> i).max().orElse(cur));
    }

    private static boolean isIntactDoublePlant(Level level, BlockPos pos, BlockState state) {
        if (state.m_61138_((Property)BlockStateProperties.f_61401_)) {
            DoubleBlockHalf half = (DoubleBlockHalf)state.m_61143_((Property)BlockStateProperties.f_61401_);
            BlockPos counterpart = half == DoubleBlockHalf.UPPER ? pos.m_7495_() : pos.m_7494_();
            return level.m_8055_(counterpart).m_60713_(state.m_60734_());
        }
        for (Property prop : state.m_61147_()) {
            EnumProperty ep;
            Comparable val;
            if (!"half".equals(prop.m_61708_()) || !(prop instanceof EnumProperty) || !((val = state.m_61143_((Property)(ep = (EnumProperty)prop))) instanceof DoubleBlockHalf)) continue;
            DoubleBlockHalf half = (DoubleBlockHalf)val;
            BlockPos counterpart = half == DoubleBlockHalf.UPPER ? pos.m_7495_() : pos.m_7494_();
            return level.m_8055_(counterpart).m_60713_(state.m_60734_());
        }
        return true;
    }

    private static void defer(ServerLevel level, Runnable r) {
        level.m_7654_().execute(r);
    }

    private static void trackPotentialForageDrop(ServerLevel level, BlockPos pos, BlockState state, ServerPlayer player) {
        ResourceKey dim = level.m_46472_();
        Map map = PENDING_FORAGING_DROPS.computeIfAbsent((ResourceKey<Level>)dim, d -> new HashMap());
        long now = level.m_46467_();
        FarmingXPEvents.cleanupExpiredEntries(map, now);
        BlockPos trackAt = FarmingXPEvents.adjustTrackedPosition(state, pos).m_7949_();
        map.put(trackAt, new PendingForage(player, now + 20L));
    }

    private static PendingForage popPendingForageNear(ServerLevel level, BlockPos itemPos) {
        ResourceKey dim = level.m_46472_();
        Map<BlockPos, PendingForage> map = PENDING_FORAGING_DROPS.get(dim);
        if (map == null || map.isEmpty()) {
            return null;
        }
        long now = level.m_46467_();
        FarmingXPEvents.cleanupExpiredEntries(map, now);
        for (BlockPos probe : new BlockPos[]{itemPos, itemPos.m_7495_(), itemPos.m_7494_()}) {
            PendingForage got = map.remove(probe);
            if (got == null) continue;
            if (map.isEmpty()) {
                PENDING_FORAGING_DROPS.remove(dim);
            }
            return got.isExpired(now) ? null : got;
        }
        if (map.isEmpty()) {
            PENDING_FORAGING_DROPS.remove(dim);
        }
        return null;
    }

    private static void cleanupExpiredEntries(Map<BlockPos, PendingForage> entries, long now) {
        entries.entrySet().removeIf(e -> ((PendingForage)e.getValue()).isExpired(now));
    }

    private static BlockPos adjustTrackedPosition(BlockState state, BlockPos pos) {
        if (state.m_61138_((Property)BlockStateProperties.f_61401_) && state.m_61143_((Property)BlockStateProperties.f_61401_) == DoubleBlockHalf.UPPER) {
            return pos.m_7495_();
        }
        return pos;
    }

    private static boolean isConnectedToStem(Level level, BlockPos pos) {
        for (Direction dir : Direction.Plane.HORIZONTAL) {
            BlockPos n = pos.m_121945_(dir);
            BlockState s = level.m_8055_(n);
            Block b = s.m_60734_();
            if (b instanceof StemBlock) {
                return true;
            }
            if (!(b instanceof AttachedStemBlock) || !s.m_61138_((Property)AttachedStemBlock.f_48830_) || s.m_61143_((Property)AttachedStemBlock.f_48830_) != dir.m_122424_()) continue;
            return true;
        }
        return false;
    }

    private record PendingForage(ServerPlayer player, long expiryTick) {
        boolean isExpired(long now) {
            return now > this.expiryTick || !this.player.m_6084_();
        }
    }
}

