/*
 * Decompiled with CFR 0.152.
 */
package com.tiomadre.foragersinsight.core.other.enchantmentevents;

import com.tiomadre.foragersinsight.common.item.MalletItem;
import com.tiomadre.foragersinsight.core.registry.FIEnchantments;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ShovelItem;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.CriticalHitEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="foragersinsight", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class ConcussiveEnchantmentHandler {
    private static final String TAG_LAST_STUN = "ConcussiveLastStun";
    private static final float DAMAGE_MULTIPLIER = 1.1f;
    private static final int BASE_COOLDOWN_SEC = 12;
    private static final int BASE_STUN_TICKS = 40;
    private static final int STUN_PER_LEVEL_TICKS = 10;

    @SubscribeEvent
    public static void onCriticalHit(CriticalHitEvent event) {
        Player player = event.getEntity();
        ItemStack stack = player.m_6844_(EquipmentSlot.MAINHAND);
        if (!(stack.m_41720_() instanceof MalletItem) && !(stack.m_41720_() instanceof ShovelItem)) {
            return;
        }
        int level = EnchantmentHelper.m_44843_((Enchantment)((Enchantment)FIEnchantments.CONCUSSIVE.get()), (ItemStack)stack);
        if (level <= 0) {
            return;
        }
        event.setDamageModifier(event.getDamageModifier() * 1.1f);
    }

    @SubscribeEvent
    public static void onLivingHurt(LivingHurtEvent event) {
        long cooldownTicks;
        CompoundTag data;
        long last;
        DamageSource src = event.getSource();
        Entity attacker = src.m_7639_();
        if (!(attacker instanceof Player)) {
            return;
        }
        Player player = (Player)attacker;
        ItemStack stack = player.m_6844_(EquipmentSlot.MAINHAND);
        if (!(stack.m_41720_() instanceof MalletItem) && !(stack.m_41720_() instanceof ShovelItem)) {
            return;
        }
        int level = EnchantmentHelper.m_44843_((Enchantment)((Enchantment)FIEnchantments.CONCUSSIVE.get()), (ItemStack)stack);
        if (level <= 0) {
            return;
        }
        LivingEntity target = event.getEntity();
        long now = target.m_9236_().m_46467_();
        if (now - (last = (data = target.getPersistentData()).m_128454_(TAG_LAST_STUN)) < (cooldownTicks = (long)(12 - (level - 1)) * 20L)) {
            return;
        }
        int stunTicks = 40 + (level - 1) * 10;
        target.m_7292_(new MobEffectInstance(MobEffects.f_19597_, stunTicks, 255, false, false, true));
        target.m_7292_(new MobEffectInstance(MobEffects.f_19610_, stunTicks, 0, false, false, true));
        data.m_128356_(TAG_LAST_STUN, now);
    }
}

