/*
 * Decompiled with CFR 0.152.
 */
package com.tiomadre.foragersinsight.core.other.enchantmentevents.farmhand;

import com.tiomadre.foragersinsight.core.registry.FIEnchantments;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Sheep;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.ShearsItem;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="foragersinsight", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class FarmhandEntityEvents {
    @SubscribeEvent
    public static void onEntityShear(PlayerInteractEvent.EntityInteractSpecific event) {
        InteractionHand hand;
        Level level = event.getLevel();
        if (level.m_5776_()) {
            return;
        }
        Player player = event.getEntity();
        ItemStack tool = player.m_21120_(hand = event.getHand());
        if (!(tool.m_41720_() instanceof ShearsItem)) {
            return;
        }
        if (tool.getEnchantmentLevel((Enchantment)FIEnchantments.FARMHAND.get()) <= 0) {
            return;
        }
        Entity target = event.getTarget();
        if (target instanceof Sheep) {
            Sheep sheep = (Sheep)target;
            if (sheep.m_29875_() || sheep.m_6162_()) {
                return;
            }
            event.setCanceled(true);
            sheep.m_29878_(true);
            int woolCount = 1 + level.f_46441_.m_188503_(3);
            DyeColor color = sheep.m_29874_();
            Item woolItem = FarmhandEntityEvents.getWoolForColor(color);
            for (int i = 0; i < woolCount; ++i) {
                ItemStack wool = new ItemStack((ItemLike)woolItem);
                if (player.m_150109_().m_36054_(wool)) continue;
                player.m_36176_(wool, false);
            }
            BlockPos pos = sheep.m_20183_();
            level.m_5594_(null, pos, SoundEvents.f_12344_, SoundSource.PLAYERS, 1.0f, 1.0f);
            tool.m_41622_(1, (LivingEntity)player, p -> p.m_21190_(hand));
        }
    }

    private static Item getWoolForColor(DyeColor color) {
        return switch (color) {
            case DyeColor.ORANGE -> Items.f_41871_;
            case DyeColor.MAGENTA -> Items.f_41872_;
            case DyeColor.LIGHT_BLUE -> Items.f_41873_;
            case DyeColor.YELLOW -> Items.f_41874_;
            case DyeColor.LIME -> Items.f_41875_;
            case DyeColor.PINK -> Items.f_41876_;
            case DyeColor.GRAY -> Items.f_41877_;
            case DyeColor.LIGHT_GRAY -> Items.f_41878_;
            case DyeColor.CYAN -> Items.f_41932_;
            case DyeColor.PURPLE -> Items.f_41933_;
            case DyeColor.BLUE -> Items.f_41934_;
            case DyeColor.BROWN -> Items.f_41935_;
            case DyeColor.GREEN -> Items.f_41936_;
            case DyeColor.RED -> Items.f_41937_;
            case DyeColor.BLACK -> Items.f_41938_;
            default -> Items.f_41870_;
        };
    }
}

