/*
 * Decompiled with CFR 0.152.
 */
package com.tiomadre.foragersinsight.core.other.enchantmentevents.farmhand;

import com.tiomadre.foragersinsight.common.block.BountifulLeavesBlock;
import com.tiomadre.foragersinsight.common.block.RoseCropBlock;
import com.tiomadre.foragersinsight.common.item.HandbasketItem;
import com.tiomadre.foragersinsight.core.registry.FIEnchantments;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.ShearsItem;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BeehiveBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CarvedPumpkinBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.IForgeShearable;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.items.IItemHandler;
import vectorwing.farmersdelight.common.block.MushroomColonyBlock;

@Mod.EventBusSubscriber(modid="foragersinsight", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class FarmhandEvents {
    private static boolean tryInsertToHandbasket(Player player, ItemStack drop) {
        for (ItemStack invStack : player.m_150109_().f_35974_) {
            LazyOptional cap;
            Optional resolved;
            if (!(invStack.m_41720_() instanceof HandbasketItem) || !(resolved = (cap = invStack.getCapability(ForgeCapabilities.ITEM_HANDLER)).resolve()).isPresent()) continue;
            IItemHandler handler = (IItemHandler)resolved.get();
            ItemStack remainder = drop.m_41777_();
            for (int slot = 0; slot < handler.getSlots() && !(remainder = handler.insertItem(slot, remainder, true)).m_41619_(); ++slot) {
            }
            if (!remainder.m_41619_()) continue;
            ItemStack toInsert = drop.m_41777_();
            for (int slot = 0; slot < handler.getSlots() && !(toInsert = handler.insertItem(slot, toInsert, false)).m_41619_(); ++slot) {
            }
            return true;
        }
        return false;
    }

    @SubscribeEvent
    public static void onCropBreak(BlockEvent.BreakEvent event) {
        BlockState replanted;
        Set possibleAges;
        int maxAge;
        Level level = event.getLevel() instanceof Level ? (Level)event.getLevel() : null;
        Player player = event.getPlayer();
        if (level == null || level.m_5776_() || player == null) {
            return;
        }
        ItemStack tool = player.m_21205_();
        if (tool.getEnchantmentLevel((Enchantment)FIEnchantments.FARMHAND.get()) <= 0) {
            return;
        }
        BlockPos pos = event.getPos();
        BlockState state = level.m_8055_(pos);
        Optional<IntegerProperty> agePropOpt = state.m_61147_().stream().filter(p -> p.m_61708_().equals("age") && p instanceof IntegerProperty).map(p -> (IntegerProperty)p).findFirst();
        if (agePropOpt.isEmpty()) {
            return;
        }
        IntegerProperty ageProp = agePropOpt.get();
        int currentAge = (Integer)state.m_61143_((Property)ageProp);
        if (currentAge < (maxAge = (possibleAges = (Set)ageProp.m_6908_()).stream().max(Integer::compareTo).orElse(currentAge).intValue())) {
            return;
        }
        event.setCanceled(true);
        ServerLevel server = (ServerLevel)level;
        List drops = Block.m_49869_((BlockState)state, (ServerLevel)server, (BlockPos)pos, (BlockEntity)server.m_7702_(pos));
        for (ItemStack drop : drops) {
            if (FarmhandEvents.tryInsertToHandbasket(player, drop) || player.m_150109_().m_36054_(drop)) continue;
            player.m_36176_(drop, false);
        }
        Block block = state.m_60734_();
        if (block instanceof RoseCropBlock) {
            replanted = (BlockState)((RoseCropBlock)block).m_52289_(0).m_61124_(RoseCropBlock.HALF, (Comparable)DoubleBlockHalf.LOWER);
        } else {
            replanted = (BlockState)state.m_61124_((Property)ageProp, (Comparable)Integer.valueOf(0));
            if (replanted.m_61138_((Property)BlockStateProperties.f_61401_)) {
                replanted = (BlockState)replanted.m_61124_((Property)BlockStateProperties.f_61401_, (Comparable)DoubleBlockHalf.LOWER);
            }
        }
        level.m_7731_(pos, replanted, 3);
        tool.m_41622_(1, (LivingEntity)player, p -> p.m_21190_(InteractionHand.MAIN_HAND));
    }

    @SubscribeEvent
    public static void onShearLeft(PlayerInteractEvent.LeftClickBlock event) {
        Player player = event.getEntity();
        ItemStack tool = player.m_21205_();
        if (!(tool.m_41720_() instanceof ShearsItem)) {
            return;
        }
        if (tool.getEnchantmentLevel((Enchantment)FIEnchantments.FARMHAND.get()) <= 0) {
            return;
        }
        Level level = event.getLevel();
        if (level.m_5776_()) {
            return;
        }
        BlockPos pos = event.getPos();
        BlockState state = level.m_8055_(pos);
        Block block = state.m_60734_();
        if (!(block instanceof IForgeShearable)) {
            return;
        }
        IForgeShearable shearable = (IForgeShearable)block;
        if (!shearable.isShearable(tool, level, pos)) {
            return;
        }
        event.setCanceled(true);
        ServerLevel server = (ServerLevel)level;
        List drops = shearable.onSheared(player, tool, (Level)server, pos, 0);
        server.m_46961_(pos, false);
        for (ItemStack drop : drops) {
            if (FarmhandEvents.tryInsertToHandbasket(player, drop) || player.m_150109_().m_36054_(drop)) continue;
            player.m_36176_(drop, false);
        }
        level.m_5594_(null, pos, SoundEvents.f_12344_, SoundSource.PLAYERS, 1.0f, 1.0f);
        tool.m_41622_(1, (LivingEntity)player, p -> p.m_21190_(InteractionHand.MAIN_HAND));
    }

    @SubscribeEvent
    public static void onShearRight(PlayerInteractEvent.RightClickBlock event) {
        ResourceLocation id;
        Player player = event.getEntity();
        ItemStack tool = player.m_21205_();
        if (!(tool.m_41720_() instanceof ShearsItem)) {
            return;
        }
        if (tool.getEnchantmentLevel((Enchantment)FIEnchantments.FARMHAND.get()) <= 0) {
            return;
        }
        Level level = event.getLevel();
        if (level.m_5776_()) {
            return;
        }
        BlockPos pos = event.getPos();
        BlockState state = level.m_8055_(pos);
        Block block = state.m_60734_();
        if (block instanceof BountifulLeavesBlock) {
            BountifulLeavesBlock bountiful = (BountifulLeavesBlock)block;
            if ((Integer)state.m_61143_((Property)BountifulLeavesBlock.AGE) >= 3) {
                event.setCanceled(true);
                ItemStack drop = new ItemStack((ItemLike)bountiful.getBounty());
                if (!FarmhandEvents.tryInsertToHandbasket(player, drop)) {
                    player.m_36176_(drop, false);
                }
                level.m_5594_(null, pos, SoundEvents.f_12457_, SoundSource.BLOCKS, 1.0f, 1.0f);
                level.m_7731_(pos, (BlockState)state.m_61124_((Property)BountifulLeavesBlock.AGE, (Comparable)Integer.valueOf(0)), 3);
                tool.m_41622_(1, (LivingEntity)player, p -> p.m_21190_(InteractionHand.MAIN_HAND));
                return;
            }
        }
        if ((id = BuiltInRegistries.f_256975_.m_7981_((Object)block)) != null && id.m_135815_().equals("pumpkin")) {
            event.setCanceled(true);
            Direction face = event.getFace() != null ? event.getFace() : Direction.NORTH;
            level.m_7731_(pos, (BlockState)Blocks.f_50143_.m_49966_().m_61124_((Property)CarvedPumpkinBlock.f_51367_, (Comparable)face), 3);
            ItemStack seeds = new ItemStack((ItemLike)Items.f_42577_, 4);
            if (!FarmhandEvents.tryInsertToHandbasket(player, seeds)) {
                player.m_36176_(seeds, false);
            }
            level.m_5594_(null, pos, SoundEvents.f_12344_, SoundSource.BLOCKS, 1.0f, 1.0f);
            tool.m_41622_(1, (LivingEntity)player, p -> p.m_21190_(InteractionHand.MAIN_HAND));
            return;
        }
        if (state.m_61138_((Property)BeehiveBlock.f_49564_) && (Integer)state.m_61143_((Property)BeehiveBlock.f_49564_) >= 5) {
            event.setCanceled(true);
            ItemStack honey = new ItemStack((ItemLike)Items.f_42784_, 3);
            if (!FarmhandEvents.tryInsertToHandbasket(player, honey)) {
                player.m_36176_(honey, false);
            }
            level.m_5594_(null, pos, SoundEvents.f_11697_, SoundSource.BLOCKS, 1.0f, 1.0f);
            level.m_7731_(pos, (BlockState)state.m_61124_((Property)BeehiveBlock.f_49564_, (Comparable)Integer.valueOf(0)), 3);
            tool.m_41622_(1, (LivingEntity)player, p -> p.m_21190_(InteractionHand.MAIN_HAND));
            return;
        }
        if (block instanceof MushroomColonyBlock) {
            MushroomColonyBlock colony = (MushroomColonyBlock)block;
            if ((Integer)state.m_61143_((Property)MushroomColonyBlock.COLONY_AGE) > 0) {
                event.setCanceled(true);
                ItemStack drop = colony.m_7397_((BlockGetter)level, pos, state);
                if (!FarmhandEvents.tryInsertToHandbasket(player, drop)) {
                    player.m_36176_(drop, false);
                }
                level.m_5594_(null, pos, SoundEvents.f_12075_, SoundSource.BLOCKS, 1.0f, 1.0f);
                level.m_7731_(pos, (BlockState)state.m_61124_((Property)MushroomColonyBlock.COLONY_AGE, (Comparable)Integer.valueOf((Integer)state.m_61143_((Property)MushroomColonyBlock.COLONY_AGE) - 1)), 3);
                tool.m_41622_(1, (LivingEntity)player, p -> p.m_21190_(InteractionHand.MAIN_HAND));
            }
        }
    }
}

