/*
 * Decompiled with CFR 0.152.
 */
package com.tiomadre.foragersinsight.core.other.toolevents;

import com.tiomadre.foragersinsight.common.item.HandbasketItem;
import com.tiomadre.foragersinsight.data.server.tags.FITags;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

@Mod.EventBusSubscriber(modid="foragersinsight", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class HandbasketItemPickup {
    @SubscribeEvent
    public static void onItemPickup(EntityItemPickupEvent ev) {
        ItemStack stack2;
        Player player = ev.getEntity();
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer server = (ServerPlayer)player;
        ItemStack selectedBasket = null;
        IItemHandler selectedHandler = null;
        int minRemainingSpace = Integer.MAX_VALUE;
        for (ItemStack stack2 : server.m_150109_().f_35974_) {
            IItemHandler handler;
            if (!(stack2.m_41720_() instanceof HandbasketItem) || (handler = (IItemHandler)stack2.getCapability(ForgeCapabilities.ITEM_HANDLER).orElse(null)) == null) continue;
            int totalSlots = handler.getSlots();
            int usedSlots = 0;
            for (int i = 0; i < totalSlots; ++i) {
                if (handler.getStackInSlot(i).m_41619_()) continue;
                ++usedSlots;
            }
            int remainingSpace = totalSlots - usedSlots;
            if (remainingSpace >= minRemainingSpace) continue;
            minRemainingSpace = remainingSpace;
            selectedBasket = stack2;
            selectedHandler = handler;
        }
        if (selectedBasket == null) {
            return;
        }
        ItemEntity entity = ev.getItem();
        stack2 = entity.m_32055_();
        if (!stack2.m_204117_(FITags.ItemTag.HANDBASKET_ALLOWED)) {
            return;
        }
        ItemStack rem = ItemHandlerHelper.insertItem(selectedHandler, (ItemStack)stack2.m_41777_(), (boolean)false);
        if (rem.m_41619_()) {
            ev.setCanceled(true);
            entity.m_146870_();
            player.m_20193_().m_5594_(null, player.m_20183_(), SoundEvents.f_144058_, SoundSource.PLAYERS, 1.0f, 1.0f);
        } else if (rem.m_41613_() < stack2.m_41613_()) {
            entity.m_32045_(rem);
            ev.setCanceled(true);
            player.m_20193_().m_5594_(null, player.m_20183_(), SoundEvents.f_144058_, SoundSource.PLAYERS, 1.0f, 1.0f);
        }
    }
}

