/*
 * Decompiled with CFR 0.152.
 */
package com.tiomadre.foragersinsight.core.other.toolevents;

import com.tiomadre.foragersinsight.common.block.BountifulLeavesBlock;
import com.tiomadre.foragersinsight.common.block.SpruceTipBlock;
import com.tiomadre.foragersinsight.common.utility.TextUtils;
import com.tiomadre.foragersinsight.core.registry.FIItems;
import java.util.ArrayDeque;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Chicken;
import net.minecraft.world.entity.animal.Sheep;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.ShearsItem;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SweetBerryBushBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import vectorwing.farmersdelight.common.block.MushroomColonyBlock;
import vectorwing.farmersdelight.common.block.TomatoVineBlock;
import vectorwing.farmersdelight.common.registry.ModItems;
import vectorwing.farmersdelight.common.registry.ModSounds;

@Mod.EventBusSubscriber(modid="foragersinsight", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class ShearsSnipInteractions {
    private static final long CHICKEN_SHEAR_COOLDOWN = 2400L;
    private static final float FORTUNE_PROC_CHANCE = 0.2f;

    private static int getFortuneLevel(ItemStack tool) {
        return EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44987_, (ItemStack)tool);
    }

    private static int rollFortuneExtras(RandomSource rand, int fortuneLevels) {
        int extra = 0;
        for (int i = 0; i < fortuneLevels; ++i) {
            if (!(rand.m_188501_() < 0.2f)) continue;
            ++extra;
        }
        return extra;
    }

    private static void play(Level level, BlockPos pos, SoundEvent sound) {
        level.m_5594_(null, pos, sound, SoundSource.BLOCKS, 1.0f, 1.0f);
    }

    private static void damageTool(ItemStack tool, Player player, InteractionHand hand) {
        tool.m_41622_(1, (LivingEntity)player, p -> p.m_21190_(hand));
    }

    private static int harvestVerticalTop(Level level, BlockPos basePos, Predicate<BlockState> isSameCrop, int maxBreak) {
        int broken;
        ArrayDeque<BlockPos> stack = new ArrayDeque<BlockPos>();
        BlockPos.MutableBlockPos cursor = basePos.m_122032_();
        while (isSameCrop.test(level.m_8055_((BlockPos)cursor))) {
            stack.addLast(cursor.m_7949_());
            cursor.m_122173_(Direction.UP);
        }
        if (stack.size() <= 1) {
            return 0;
        }
        stack.removeFirst();
        for (broken = 0; broken < maxBreak && !stack.isEmpty(); ++broken) {
            BlockPos top = (BlockPos)stack.removeLast();
            level.m_46961_(top, false);
        }
        return broken;
    }

    public static void dropItemInFront(Level level, Player player, ItemStack stack) {
        ShearsSnipInteractions.dropItemInFront(level, player, stack, 3.25, 0.6);
    }

    public static void dropItemInFront(Level level, Player player, ItemStack stack, double distance) {
        ShearsSnipInteractions.dropItemInFront(level, player, stack, distance, 0.6);
    }

    public static void dropItemInFront(Level level, Player player, ItemStack stack, double distance, double heightOffset) {
        Vec3 look = player.m_20154_().m_82541_();
        distance = Math.max(2.0, Math.min(distance, 4.5));
        double x = player.m_20185_() + look.f_82479_ * distance;
        double y = player.m_20186_() + heightOffset;
        double z = player.m_20189_() + look.f_82481_ * distance;
        ItemEntity drop = new ItemEntity(level, x, y, z, stack);
        drop.m_32010_(5);
        if (!level.m_45772_(drop.m_20191_())) {
            double fallback = 2.5;
            drop.m_6034_(player.m_20185_() + look.f_82479_ * fallback, y, player.m_20189_() + look.f_82481_ * fallback);
        }
        level.m_7967_((Entity)drop);
    }

    @SubscribeEvent
    public static void onShearCrop(PlayerInteractEvent.RightClickBlock event) {
        ItemStack drop;
        InteractionHand hand;
        Level level = event.getLevel();
        if (level.m_5776_()) {
            return;
        }
        Player player = event.getEntity();
        ItemStack tool = player.m_21120_(hand = event.getHand());
        if (!(tool.m_41720_() instanceof ShearsItem)) {
            return;
        }
        BlockPos pos = event.getPos();
        BlockState state = level.m_8055_(pos);
        RandomSource rand = level.m_213780_();
        Block block = state.m_60734_();
        if (block instanceof BountifulLeavesBlock) {
            SpruceTipBlock tip;
            BountifulLeavesBlock leavesBlock = (BountifulLeavesBlock)block;
            int age = (Integer)state.m_61143_((Property)BountifulLeavesBlock.AGE);
            if (age >= 3) {
                event.setCanceled(true);
                int extraDrops = ShearsSnipInteractions.rollFortuneExtras(rand, ShearsSnipInteractions.getFortuneLevel(tool));
                Item bountyItem = leavesBlock.getBounty();
                ItemStack drop2 = new ItemStack((ItemLike)bountyItem, 2 + extraDrops);
                ShearsSnipInteractions.dropItemInFront(level, player, drop2);
                BlockState updatedState = (BlockState)state.m_61124_((Property)BountifulLeavesBlock.AGE, (Comparable)Integer.valueOf(0));
                level.m_7731_(pos, updatedState, 2);
                ShearsSnipInteractions.play(level, pos, SoundEvents.f_12344_);
                ShearsSnipInteractions.play(level, pos, SoundEvents.f_12457_);
                ShearsSnipInteractions.damageTool(tool, player, hand);
                return;
            }
            Block bountyItem = state.m_60734_();
            if (bountyItem instanceof SpruceTipBlock && (tip = (SpruceTipBlock)bountyItem).m_6724_(state) && (age = ((Integer)state.m_61143_((Property)SpruceTipBlock.AGE)).intValue()) >= 3) {
                event.setCanceled(true);
                int fortune = ShearsSnipInteractions.getFortuneLevel(tool);
                int extra = fortune > 0 ? rand.m_188503_(fortune + 1) : 0;
                ItemStack drop3 = new ItemStack((ItemLike)FIItems.SPRUCE_TIPS.get(), 2 + extra);
                ShearsSnipInteractions.dropItemInFront(level, player, drop3);
                level.m_7731_(pos, (BlockState)state.m_61124_((Property)SpruceTipBlock.AGE, (Comparable)Integer.valueOf(0)), 3);
                ShearsSnipInteractions.play(level, pos, SoundEvents.f_12344_);
                ShearsSnipInteractions.play(level, pos, SoundEvents.f_12457_);
                ShearsSnipInteractions.damageTool(tool, player, hand);
                return;
            }
        }
        if (state.m_60713_(Blocks.f_50575_) || state.m_60713_(Blocks.f_50576_)) {
            event.setCanceled(true);
            int broken = ShearsSnipInteractions.harvestVerticalTop(level, pos, bs -> bs.m_60713_(Blocks.f_50575_) || bs.m_60713_(Blocks.f_50576_), 2);
            if (broken <= 0) {
                return;
            }
            int extraDrops = ShearsSnipInteractions.rollFortuneExtras(rand, ShearsSnipInteractions.getFortuneLevel(tool));
            for (int i = 0; i < broken; ++i) {
                ItemStack kelpDrop = new ItemStack((ItemLike)Items.f_41910_, 1 + extraDrops);
                ShearsSnipInteractions.dropItemInFront(level, player, kelpDrop);
            }
            ShearsSnipInteractions.play(level, pos, SoundEvents.f_12344_);
            ShearsSnipInteractions.play(level, pos, SoundEvents.f_12540_);
            ShearsSnipInteractions.damageTool(tool, player, hand);
            return;
        }
        Block extraDrops = state.m_60734_();
        if (extraDrops instanceof MushroomColonyBlock) {
            MushroomColonyBlock mushroomColony = (MushroomColonyBlock)extraDrops;
            int age = (Integer)state.m_61143_((Property)MushroomColonyBlock.COLONY_AGE);
            if (age > 0) {
                event.setCanceled(true);
                int extraDrops2 = ShearsSnipInteractions.rollFortuneExtras(rand, ShearsSnipInteractions.getFortuneLevel(tool));
                drop = new ItemStack((ItemLike)mushroomColony.mushroomType.get(), 1 + extraDrops2);
                ShearsSnipInteractions.dropItemInFront(level, player, drop);
                level.m_7731_(pos, (BlockState)state.m_61124_((Property)MushroomColonyBlock.COLONY_AGE, (Comparable)Integer.valueOf(age - 1)), 3);
                ShearsSnipInteractions.play(level, pos, SoundEvents.f_12075_);
                ShearsSnipInteractions.damageTool(tool, player, hand);
            }
            return;
        }
        if (state.m_60713_(Blocks.f_50130_)) {
            int broken = ShearsSnipInteractions.harvestVerticalTop(level, pos, bs -> bs.m_60713_(Blocks.f_50130_), 1);
            if (broken > 0) {
                event.setCanceled(true);
                int fortune = ShearsSnipInteractions.getFortuneLevel(tool);
                int extra = fortune > 0 ? rand.m_188503_(fortune + 1) : 0;
                drop = new ItemStack((ItemLike)Items.f_41909_, 1 + extra);
                ShearsSnipInteractions.dropItemInFront(level, player, drop);
                ShearsSnipInteractions.play(level, pos, SoundEvents.f_12344_);
                ShearsSnipInteractions.play(level, pos, SoundEvents.f_11838_);
                ShearsSnipInteractions.damageTool(tool, player, hand);
            }
            return;
        }
        if (state.m_60734_() instanceof SweetBerryBushBlock && (Integer)state.m_61143_((Property)SweetBerryBushBlock.f_57244_) >= 3) {
            event.setCanceled(true);
            int fortune = ShearsSnipInteractions.getFortuneLevel(tool);
            int extra = fortune > 0 ? rand.m_188503_(fortune + 1) : 0;
            ItemStack drop4 = new ItemStack((ItemLike)Items.f_42780_, 3 + extra);
            ShearsSnipInteractions.dropItemInFront(level, player, drop4);
            level.m_7731_(pos, (BlockState)state.m_61124_((Property)SweetBerryBushBlock.f_57244_, (Comparable)Integer.valueOf(1)), 3);
            ShearsSnipInteractions.play(level, pos, SoundEvents.f_12344_);
            ShearsSnipInteractions.play(level, pos, SoundEvents.f_12457_);
            ShearsSnipInteractions.damageTool(tool, player, hand);
            return;
        }
        Block extra = state.m_60734_();
        if (extra instanceof TomatoVineBlock) {
            TomatoVineBlock tomatoVine = (TomatoVineBlock)extra;
            event.setCanceled(true);
            int age = (Integer)state.m_61143_((Property)TomatoVineBlock.VINE_AGE);
            if (age == tomatoVine.m_7419_()) {
                int extraDrops3 = ShearsSnipInteractions.rollFortuneExtras(rand, ShearsSnipInteractions.getFortuneLevel(tool));
                ItemStack tomatoDrop = new ItemStack((ItemLike)ModItems.TOMATO.get(), 2 + extraDrops3);
                ShearsSnipInteractions.dropItemInFront(level, player, tomatoDrop);
                if (rand.m_188501_() < 0.05f) {
                    ItemStack rotten = new ItemStack((ItemLike)ModItems.ROTTEN_TOMATO.get());
                    ShearsSnipInteractions.dropItemInFront(level, player, rotten);
                }
                level.m_7731_(pos, (BlockState)state.m_61124_((Property)TomatoVineBlock.VINE_AGE, (Comparable)Integer.valueOf(0)), 3);
                ShearsSnipInteractions.play(level, pos, SoundEvents.f_12344_);
                level.m_5594_(null, pos, (SoundEvent)ModSounds.ITEM_TOMATO_PICK_FROM_BUSH.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
                ShearsSnipInteractions.damageTool(tool, player, hand);
            }
        }
    }

    @SubscribeEvent
    public static void onShearChicken(PlayerInteractEvent.EntityInteract event) {
        CompoundTag data;
        long last;
        InteractionHand hand;
        if (event.getLevel().m_5776_()) {
            return;
        }
        Entity entity = event.getTarget();
        if (!(entity instanceof Chicken)) {
            return;
        }
        Chicken chicken = (Chicken)entity;
        if (chicken.m_6162_()) {
            event.getEntity().m_5661_((Component)TextUtils.getTranslation("tool_interaction.shears.baby_chicken", new Object[0]), true);
            event.setCanceled(true);
            return;
        }
        Player player = event.getEntity();
        ItemStack tool = player.m_21120_(hand = event.getHand());
        if (!(tool.m_41720_() instanceof ShearsItem)) {
            return;
        }
        long now = event.getLevel().m_46467_();
        long elapsed = now - (last = (data = chicken.getPersistentData()).m_128454_("ShearFeatherTime"));
        if (elapsed < 2400L) {
            int secondsLeft = (int)Math.ceil((double)(2400L - elapsed) / 20.0);
            player.m_5661_((Component)TextUtils.getTranslation("tool_interaction.shears.chicken", secondsLeft), true);
            event.setCanceled(true);
            return;
        }
        data.m_128356_("ShearFeatherTime", now);
        event.setCanceled(true);
        RandomSource rand = event.getLevel().m_213780_();
        int baseCount = 2 + rand.m_188503_(3);
        int extraFeathers = ShearsSnipInteractions.rollFortuneExtras(rand, ShearsSnipInteractions.getFortuneLevel(tool));
        ItemStack drop = new ItemStack((ItemLike)Items.f_42402_, baseCount + extraFeathers);
        ShearsSnipInteractions.dropItemInFront(event.getLevel(), player, drop);
        event.getLevel().m_5594_(null, chicken.m_20183_(), SoundEvents.f_12344_, SoundSource.PLAYERS, 1.0f, 1.0f);
        event.getLevel().m_5594_(null, chicken.m_20183_(), SoundEvents.f_11750_, SoundSource.PLAYERS, 1.0f, 1.0f);
        ShearsSnipInteractions.damageTool(tool, player, hand);
    }

    private static Item getWoolItemByColor(DyeColor color) {
        return switch (color) {
            default -> throw new IncompatibleClassChangeError();
            case DyeColor.WHITE -> Items.f_41870_;
            case DyeColor.LIGHT_GRAY -> Items.f_41878_;
            case DyeColor.GRAY -> Items.f_41877_;
            case DyeColor.BLACK -> Items.f_41938_;
            case DyeColor.BROWN -> Items.f_41935_;
            case DyeColor.RED -> Items.f_41937_;
            case DyeColor.ORANGE -> Items.f_41871_;
            case DyeColor.YELLOW -> Items.f_41874_;
            case DyeColor.LIME -> Items.f_41875_;
            case DyeColor.GREEN -> Items.f_41936_;
            case DyeColor.CYAN -> Items.f_41932_;
            case DyeColor.MAGENTA -> Items.f_41872_;
            case DyeColor.LIGHT_BLUE -> Items.f_41873_;
            case DyeColor.BLUE -> Items.f_41934_;
            case DyeColor.PURPLE -> Items.f_41933_;
            case DyeColor.PINK -> Items.f_41876_;
        };
    }

    @SubscribeEvent
    public static void onShearSheep(PlayerInteractEvent.EntityInteract event) {
        if (event.getLevel().m_5776_()) {
            return;
        }
        Entity entity = event.getTarget();
        if (!(entity instanceof Sheep)) {
            return;
        }
        Sheep sheep = (Sheep)entity;
        Player player = event.getEntity();
        InteractionHand hand = event.getHand();
        ItemStack tool = player.m_21120_(hand);
        if (!(tool.m_41720_() instanceof ShearsItem)) {
            return;
        }
        if (!sheep.m_6084_() || sheep.m_29875_() || sheep.m_6162_()) {
            return;
        }
        event.setCanceled(true);
        sheep.m_29878_(true);
        Level level = event.getLevel();
        RandomSource rand = level.m_213780_();
        int baseWoolCount = 2 + rand.m_188503_(3);
        int extraWool = ShearsSnipInteractions.rollFortuneExtras(rand, ShearsSnipInteractions.getFortuneLevel(tool));
        ItemStack woolDrop = new ItemStack((ItemLike)ShearsSnipInteractions.getWoolItemByColor(sheep.m_29874_()), baseWoolCount + extraWool);
        ShearsSnipInteractions.dropItemInFront(level, player, woolDrop);
        level.m_6269_(null, (Entity)sheep, SoundEvents.f_12344_, SoundSource.PLAYERS, 1.0f, 1.0f);
        ShearsSnipInteractions.damageTool(tool, player, hand);
    }
}

