/*
 * Decompiled with CFR 0.152.
 */
package com.tiomadre.foragersinsight.core.registry;

import com.teamabnormals.blueprint.core.annotations.ConfigKey;
import net.minecraft.util.RandomSource;
import net.minecraftforge.common.ForgeConfigSpec;
import org.apache.commons.lang3.tuple.Pair;

public class FIConfig {
    public static final ForgeConfigSpec COMMON_SPEC;
    public static final Common COMMON;

    public static boolean shouldGrowBountifulTree(RandomSource rand) {
        double chance = (Double)FIConfig.COMMON.chanceToGrowBountifulTree.get();
        if (chance < 0.0) {
            return false;
        }
        return rand.m_188500_() < chance;
    }

    public static boolean shouldGrowSappyBirch(RandomSource rand) {
        double chance = (Double)FIConfig.COMMON.chanceToGrowSappyBirch.get();
        if (chance < 0.0) {
            return false;
        }
        return rand.m_188500_() < chance;
    }

    public static boolean isFlavorTextEnabled() {
        return (Boolean)FIConfig.COMMON.enableFlavorText.get();
    }

    static {
        Pair commonSpecPair = new ForgeConfigSpec.Builder().configure(Common::new);
        COMMON_SPEC = (ForgeConfigSpec)commonSpecPair.getRight();
        COMMON = (Common)commonSpecPair.getLeft();
    }

    public static class Common {
        @ConfigKey(value="config")
        public final ForgeConfigSpec.DoubleValue chanceToGrowBountifulTree;
        public final ForgeConfigSpec.DoubleValue chanceToGrowSappyBirch;
        public final ForgeConfigSpec.BooleanValue enableFlavorText;

        public Common(ForgeConfigSpec.Builder builder) {
            builder.push("Bountiful Trees");
            this.chanceToGrowBountifulTree = builder.comment("Chance for a tree's vanilla saplings to grow into its bountiful version. -1 to disable").defineInRange("Bountiful Mutations", 0.025, -1.5, 1.0);
            builder.pop();
            builder.push("Sappy Birch");
            this.chanceToGrowSappyBirch = builder.comment("Chance for birch saplings to grow into Sappy Variant. -1 to disable").defineInRange("Sappy Birch Mutations", 0.25, -1.5, 1.0);
            builder.pop();
            builder.push("Flavor Text");
            this.enableFlavorText = builder.comment("Enable Flavor Text tooltips.").define("Flavor Text", false);
            builder.pop();
        }
    }
}

